#
# @(#) $Id: FBSProcTypeInfo.py,v 1.15 2003/08/20 18:58:57 ivm Exp $
#
# $Log: FBSProcTypeInfo.py,v $
# Revision 1.15  2003/08/20 18:58:57  ivm
# Implemented CPU power, round-robin-over-users scheduling inside queuei,
# other minor things.
#
# Revision 1.14  2001/11/26 17:56:37  ivm
# Implemented ptype.timelimits, ptype.maxnodes in API, NetIF, SectParam, UI
# Other minor improvements
#
# Revision 1.13  2001/11/20 19:42:14  ivm
# Implemented CPU and real time limits for proc. type
# Fixed launcher reconfiguration bug
#
# Revision 1.12  2001/06/01 14:45:38  ivm
# Fixed some bugs
#
# Revision 1.11  2001/03/13 15:59:00  ivm
# Fixed bugs in object ownership
#
# Revision 1.10  2000/08/18 21:15:39  ivm
# Implemented dynamic re-configuration
#
# Revision 1.9  2000/06/15 18:30:55  ivm
# Generate KeyError if requested things are not found
#
# Revision 1.8  2000/04/25 16:22:07  ivm
# Fixed bugs
#
# Revision 1.4  2000/04/10 14:48:02  ivm
# Added MaxPrioInc
#
# Revision 1.3  2000/03/24 21:30:32  ivm
# Fixed syntax errors
#
# Revision 1.2  2000/03/24 17:10:21  ivm
# Use correct cfg field names
#
# Revision 1.1  2000/03/24 16:52:57  ivm
# Added ProcTypeInfo
#
#

import fbs_misc
import serialize

class	FBSProcTypeInfo:
	def __init__(self, fc, cfg, ptname):
		self.Client = fc
		self.Cfg = cfg
		self.Name = ptname
		self.ProcRsrcDefaults = {}
		self.SectRsrcDefaults = {}
		self.RsrcUsage = {}
		self.RsrcQuota = {}
		self.MaxPrioInc = None
		self.Users = ['*']
		self.NodesAllow = ['*']
		self.NodesDisallow = []
		self.MaxNodeCount = None
		self.CurrentNodeCount = 0
		self.CPUTimeLimit = -1
		self.RealTimeLimit = -1
		self.MinNice = 0
		
	def refresh(self):
		str = self.Client._getProcTypeInfo(self.Name)
		dict, rest = serialize.deserialize(str)
		self.ProcRsrcDefaults = 	dict['pdef']
		self.SectRsrcDefaults = 	dict['sdef']
		self.RsrcUsage = 			dict['usage']
		self.RsrcQuota = 			dict['quota']
		self.Users = 				dict['users']
		self.NodesAllow = 			dict['nodesa']
		self.NodesDisallow = 		dict['nodesd']
		self.MaxPrioInc = 			dict['maxpi']
		self.MinNice =  			dict['nice']
		if dict.has_key('maxnodes'):
			self.MaxNodeCount = 	dict['maxnodes']
		if dict.has_key('ncount'):
			self.CurrentNodeCount = dict['ncount']
		if dict.has_key('cputime'):
			self.CPUTimeLimit = dict['cputime']
		if dict.has_key('realtime'):
			self.RealTimeLimit = dict['realtime']
		

	def ___junk(self):
		# get defaults
		if not self.Name in self.Cfg.ids('proc_type'):
			raise KeyError, 'Process type <%s> not found' % self.Name

		d = self.Cfg.getValueDict('proc_type', 
				self.Name, 'proc_rsrc_defaults',
				defValue = None)
		if d == None:	d = {}
		self.ProcRsrcDefaults = d

		d = self.Cfg.getValueDict('proc_type', 
				self.Name, 'sect_rsrc_defaults',
				defValue = None)
		if d == None:	d = {}
		self.SectRsrcDefaults = d

		ulst = self.Client._getProcTypeUsage(self.Name)
		#print 'pt.refresh: ulst=' , ulst
		udict = fbs_misc.deserializeDict(ulst)
		#print 'pt.refresh: dict=' , udict

		self.RsrcUsage = {}
		self.RsrcQuota = {}

		for k, v in udict.items():
			usg, qta = v
			if usg or qta:
				self.RsrcUsage[k], self.RsrcQuota[k] = usg, qta
			
		# get max prio inc
		self.MaxPrioInc = self.Cfg.getValue(
				'proc_type', self.Name, 'max_prio_inc')
		
	def setSectRsrcDefs(self, dct):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'SRDEF', dct)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		
	
	def setProcRsrcDefs(self, dct):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'PRDEF', dct)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		
	
	def setRsrcQuota(self, dct):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'QUOTA', dct)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		

	def setMaxPrioInc(self, val):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'MAXPI', val)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		

	def setUsers(self, lst):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'USERS', lst)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		
				
	def allowNodes(self, lst):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'NODESA', lst)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		
				
	def disallowNodes(self, lst):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'NODESD', lst)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		
				
	def setMaxNodeCount(self, n):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'MAXNODES', n)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		
		
	def setRealTimeLimit(self, t):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'REALTIME', t)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		
		
	def setCPUTimeLimit(self, t):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'CPUTIME', t)
		if not sts:
			return 0, reason
		self.refresh()
		return 1, 'OK'		
		
	def setMinNice(self, v):
		sts, reason = self.Client._updateProcTypeInfo(self.Name,
				'NICE', v)
