#
# @(#) $Id: FBSNodeInfo.py,v 1.12 2003/01/14 22:05:02 ivm Exp $
#
# $Log: FBSNodeInfo.py,v $
# Revision 1.12  2003/01/14 22:05:02  ivm
# Implemented node class power
#
# Revision 1.11  2001/05/25 21:39:36  ivm
# Implemented hold node and disconnect
#
# Revision 1.10  2000/10/11 19:36:57  ivm
# Added FBSNodeInfo.holdNode()
# Implemented credentials creation by Launcher
#
# Revision 1.9  2000/09/06 15:18:40  ivm
# Send up/down node status too
#
# Revision 1.7  2000/09/05 16:12:13  ivm
# Fixed bug in farm_config
# Use serialize module to send node info
#
# Revision 1.6  2000/08/29 17:29:45  ivm
# Removed debug output, v1_1_2
#
# Revision 1.5  2000/08/18 21:15:39  ivm
# Implemented dynamic re-configuration
#
# Revision 1.4  2000/08/02 16:36:04  ivm
# Fixed numerous bugs
#
# Revision 1.3  2000/04/06 15:21:42  ivm
# Added Class to NodeInfo
#
# Revision 1.2  2000/03/14 16:36:47  ivm
# Fixed, tested
#
#

import serialize
import string

class	FBSNodeInfo:
	def __init__(self, fc, nname):
		self.Name = nname
		self.IsUp = 0
		self.IsHeld = 0
		self.HoldReason = ''
		self.Processes = []
		self.Resources = {}
		self.Client = fc
		self.Class = ''
		self._rsrc_str = ''
		
	def refresh(self):
		str = self.Client._getNodeInfo(self.Name)
		tup, rest = serialize.deserialize(str)
		self.Class, self.IsUp, self.IsHeld, self.HoldReason, \
			self.Resources, self.Processes = tup

	def hold(self, reason = 'reason unknown', disconnect = 0):
		return self.Client.holdNode(self.Name, reason, disconnect)
		
	def release(self):
		return self.Client.release(self.Name)
		
