#
# @(#) $Id: FBSNodeClassInfo.py,v 1.8 2003/01/14 22:05:02 ivm Exp $
#
# $Log: FBSNodeClassInfo.py,v $
# Revision 1.8  2003/01/14 22:05:02  ivm
# Implemented node class power
#
# Revision 1.7  2000/09/15 18:10:17  ivm
# Sort node names and job ids
#
# Revision 1.6  2000/09/07 17:54:52  ivm
# Implemented dynamic modification of local scratch disk mapping
#
# Revision 1.5  2000/08/18 21:15:38  ivm
# Implemented dynamic re-configuration
#
# Revision 1.4  2000/08/02 16:36:04  ivm
# Fixed numerous bugs
#
# Revision 1.3  2000/06/15 18:30:54  ivm
# Generate KeyError if requested things are not found
#
# Revision 1.2  2000/06/08 18:36:49  ivm
# Sort queue names, node names and node class names
#
# Revision 1.1  2000/03/21 20:11:00  ivm
# Implemented get*Resources, NodeClassInfo
#
#

import serialize

class	FBSNodeClassInfo:
	def __init__(self, cl, cname):
		self.Client = cl
		self.Name = cname
		self.Nodes = []
		self.ResourceCap = {}
		self.LocalDisks = {}
		self.Power = 1.0
		#self.Cfg = cfg
		
	def refresh(self):
		str = self.Client._getNodeClassInfo(self.Name)
		(self.ResourceCap, self.Nodes, 
			self.LocalDisks, self.Power), rest = serialize.deserialize(str)
		self.Nodes.sort()

	def ___junk_refresh(self):
		self.ResourceCap = self.Cfg.getValueDict('node_class', 
				self.Name, 'resources', defValue=None)
		if self.ResourceCap == None:
			raise KeyError, 'Node class <%s> not found' % self.Name
		self.Nodes = []
		for nn in self.Cfg.names('node_list', '*'):
			nc = self.Cfg.getValue('node_list', '*', nn)
			if nc == self.Name:
				self.Nodes.append(nn)
		self.Nodes.sort()

	def setRsrcCap(self, dict):
		sts, reason = self.Client._updateNodeClassInfo(self.Name,
				'RSRC', dict)
		if not sts:
			return sts, reason
		self.refresh()
		return 1,'OK'

	def setLocalDisks(self, dict):
		sts, reason = self.Client._updateNodeClassInfo(self.Name,
				'LDSK', dict)
		if not sts:
			return sts, reason
		self.refresh()
		return 1,'OK'

	def setPower(self, pwr):
		sts, reason = self.Client._updateNodeClassInfo(self.Name,
				'POWER', pwr)
		if not sts:
			return sts, reason
		self.refresh()
		return 1,'OK'
			
		
	def addNode(self, nn):
		sts, reason = self.Client._addNode(self.Name, nn)
		if not sts:
			return sts, reason
		self.refresh()
		return 1,'OK'
		
	
	def removeNode(self, nn):
		sts, reason = self.Client._removeNode(nn)
		if not sts:
			return sts, reason
		self.refresh()
		return 1,'OK'
		
