#!/bin/sh

root="`cat /proc/cmdline | sed -n 's@.*\<root\>=\([^ ]*\).*@\1@p'`"
if grep -q "UUID=" <<< $root ; then
  # root=PARTUUID=<your partition UUID>
  # root=UUID=<your partition UUID>
  root_part=`blkid | tr -d '"' | grep $root | cut -d: -f1 | sed 's@/dev/@@'`
else
  if grep -q "^/dev/" <<< $root ; then
    # root=/dev/sda1 (grub)
    root_part=${root#/dev/}
  else
    # root=801 (lilo)
    maj=$((`printf "%d" 0x$root` / 256))
    min=$((`printf "%d" 0x$root` % 256))
    root_part=`cat /proc/partitions \
        | sed -n "/ $maj *$min /s@.* \([^ ]*\)@\1@p"`
  fi
fi
ln -sf $root_part /dev/root

if [ -f /etc/mtab ]; then 
    rm -rf /etc/mtab
fi
ln -sf /proc/self/mounts /etc/mtab

