// This file is generated by kconfig_compiler from kopeteappearancesettings.kcfg.
// All changes you do to this file will be lost.
#ifndef KOPETE_APPEARANCESETTINGS_H
#define KOPETE_APPEARANCESETTINGS_H

#include <kopete_export.h>

#include <kconfigskeleton.h>
#include <kdebug.h>

#include <kstandarddirs.h>
#include <kglobalsettings.h>
#include <kcolorscheme.h>
namespace Kopete {

class KOPETE_EXPORT AppearanceSettings : public KConfigSkeleton
{
  Q_OBJECT
  public:
    class EnumContactListDisplayMode
    {
      public:
      enum type { Classic, RightAligned, Detailed, COUNT };
    };
    class EnumContactListIconMode
    {
      public:
      enum type { IconPic, IconPhoto, COUNT };
    };
    class EnumContactListResizeAnchor
    {
      public:
      enum type { Top, Bottom, COUNT };
    };

    enum {
      signalAppearanceChanged = 0x1,
      signalMessageOverridesChanged = 0x2,
      signalContactListAppearanceChanged = 0x4
 };

    static AppearanceSettings *self();
    ~AppearanceSettings();

    /**
      Set Enable emoticon support in Kopete.
    */
    static
    void setUseEmoticons( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "useEmoticons" ) )) {
        self()->mUseEmoticons = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
        self()->mSettingsChanged |= signalMessageOverridesChanged;
      }
    }

    /**
      Get Enable emoticon support in Kopete.
    */
    static
    bool useEmoticons()
    {
      return self()->mUseEmoticons;
    }

    /**
      Get Item object corresponding to useEmoticons()
    */
    ItemBool *useEmoticonsItem()
    {
      return mUseEmoticonsItem;
    }

    /**
      Set Text color used when hightlighting
    */
    static
    void setHighlightForegroundColor( const QColor & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "highlightForegroundColor" ) )) {
        self()->mHighlightForegroundColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Text color used when hightlighting
    */
    static
    QColor highlightForegroundColor()
    {
      return self()->mHighlightForegroundColor;
    }

    /**
      Get Item object corresponding to highlightForegroundColor()
    */
    ItemColor *highlightForegroundColorItem()
    {
      return mHighlightForegroundColorItem;
    }

    /**
      Set Background color used when hightlighting.
    */
    static
    void setHighlightBackgroundColor( const QColor & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "highlightBackgroundColor" ) )) {
        self()->mHighlightBackgroundColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Background color used when hightlighting.
    */
    static
    QColor highlightBackgroundColor()
    {
      return self()->mHighlightBackgroundColor;
    }

    /**
      Get Item object corresponding to highlightBackgroundColor()
    */
    ItemColor *highlightBackgroundColorItem()
    {
      return mHighlightBackgroundColorItem;
    }

    /**
      Set Disable custom text color set by users.
    */
    static
    void setChatBgOverride( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "chatBgOverride" ) )) {
        self()->mChatBgOverride = v;
        self()->mSettingsChanged |= signalMessageOverridesChanged;
      }
    }

    /**
      Get Disable custom text color set by users.
    */
    static
    bool chatBgOverride()
    {
      return self()->mChatBgOverride;
    }

    /**
      Get Item object corresponding to chatBgOverride()
    */
    ItemBool *chatBgOverrideItem()
    {
      return mChatBgOverrideItem;
    }

    /**
      Set Disable custom background color set by users.
    */
    static
    void setChatFgOverride( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "chatFgOverride" ) )) {
        self()->mChatFgOverride = v;
        self()->mSettingsChanged |= signalMessageOverridesChanged;
      }
    }

    /**
      Get Disable custom background color set by users.
    */
    static
    bool chatFgOverride()
    {
      return self()->mChatFgOverride;
    }

    /**
      Get Item object corresponding to chatFgOverride()
    */
    ItemBool *chatFgOverrideItem()
    {
      return mChatFgOverrideItem;
    }

    /**
      Set Disable rich text set by users.
    */
    static
    void setChatRtfOverride( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "chatRtfOverride" ) )) {
        self()->mChatRtfOverride = v;
        self()->mSettingsChanged |= signalMessageOverridesChanged;
      }
    }

    /**
      Get Disable rich text set by users.
    */
    static
    bool chatRtfOverride()
    {
      return self()->mChatRtfOverride;
    }

    /**
      Get Item object corresponding to chatRtfOverride()
    */
    ItemBool *chatRtfOverrideItem()
    {
      return mChatRtfOverrideItem;
    }

    /**
      Set Chat text color.
    */
    static
    void setChatTextColor( const QColor & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "chatTextColor" ) )) {
        self()->mChatTextColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Chat text color.
    */
    static
    QColor chatTextColor()
    {
      return self()->mChatTextColor;
    }

    /**
      Get Item object corresponding to chatTextColor()
    */
    ItemColor *chatTextColorItem()
    {
      return mChatTextColorItem;
    }

    /**
      Set Chat background color.
    */
    static
    void setChatBackgroundColor( const QColor & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "chatBackgroundColor" ) )) {
        self()->mChatBackgroundColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Chat background color.
    */
    static
    QColor chatBackgroundColor()
    {
      return self()->mChatBackgroundColor;
    }

    /**
      Get Item object corresponding to chatBackgroundColor()
    */
    ItemColor *chatBackgroundColorItem()
    {
      return mChatBackgroundColorItem;
    }

    /**
      Set Chat link color.
    */
    static
    void setChatLinkColor( const QColor & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "chatLinkColor" ) )) {
        self()->mChatLinkColor = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Chat link color.
    */
    static
    QColor chatLinkColor()
    {
      return self()->mChatLinkColor;
    }

    /**
      Get Item object corresponding to chatLinkColor()
    */
    ItemColor *chatLinkColorItem()
    {
      return mChatLinkColorItem;
    }

    /**
      Set Chat font.
    */
    static
    void setChatFont( const QFont & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "chatFont" ) )) {
        self()->mChatFont = v;
        self()->mSettingsChanged |= signalAppearanceChanged;
      }
    }

    /**
      Get Chat font.
    */
    static
    QFont chatFont()
    {
      return self()->mChatFont;
    }

    /**
      Get Item object corresponding to chatFont()
    */
    ItemFont *chatFontItem()
    {
      return mChatFontItem;
    }

    /**
      Set Color used to identity idle contacts.
    */
    static
    void setIdleContactColor( const QColor & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "idleContactColor" ) )) {
        self()->mIdleContactColor = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Color used to identity idle contacts.
    */
    static
    QColor idleContactColor()
    {
      return self()->mIdleContactColor;
    }

    /**
      Get Item object corresponding to idleContactColor()
    */
    ItemColor *idleContactColorItem()
    {
      return mIdleContactColorItem;
    }

    /**
      Set Display a different color for idle contact.
    */
    static
    void setGreyIdleMetaContacts( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "greyIdleMetaContacts" ) )) {
        self()->mGreyIdleMetaContacts = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Display a different color for idle contact.
    */
    static
    bool greyIdleMetaContacts()
    {
      return self()->mGreyIdleMetaContacts;
    }

    /**
      Get Item object corresponding to greyIdleMetaContacts()
    */
    ItemBool *greyIdleMetaContactsItem()
    {
      return mGreyIdleMetaContactsItem;
    }

    /**
      Set Contact properties that contact tooltip will show.
    */
    static
    void setToolTipContents( const QStringList & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "toolTipContents" ) ))
        self()->mToolTipContents = v;
    }

    /**
      Get Contact properties that contact tooltip will show.
    */
    static
    QStringList toolTipContents()
    {
      return self()->mToolTipContents;
    }

    /**
      Get Item object corresponding to toolTipContents()
    */
    ItemStringList *toolTipContentsItem()
    {
      return mToolTipContentsItem;
    }

    /**
      Set Contact list display mode
    */
    static
    void setContactListDisplayMode( int v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListDisplayMode" ) )) {
        self()->mContactListDisplayMode = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Contact list display mode
    */
    static
    int contactListDisplayMode()
    {
      return self()->mContactListDisplayMode;
    }

    /**
      Get Item object corresponding to contactListDisplayMode()
    */
    ItemEnum *contactListDisplayModeItem()
    {
      return mContactListDisplayModeItem;
    }

    /**
      Set Contact list icon display mode. Either the protocol icon or the contact photo.
    */
    static
    void setContactListIconMode( int v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListIconMode" ) )) {
        self()->mContactListIconMode = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Contact list icon display mode. Either the protocol icon or the contact photo.
    */
    static
    int contactListIconMode()
    {
      return self()->mContactListIconMode;
    }

    /**
      Get Item object corresponding to contactListIconMode()
    */
    ItemEnum *contactListIconModeItem()
    {
      return mContactListIconModeItem;
    }

    /**
      Set Show contact list as a tree view.
    */
    static
    void setContactListTreeView( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListTreeView" ) )) {
        self()->mContactListTreeView = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Show contact list as a tree view.
    */
    static
    bool contactListTreeView()
    {
      return self()->mContactListTreeView;
    }

    /**
      Get Item object corresponding to contactListTreeView()
    */
    ItemBool *contactListTreeViewItem()
    {
      return mContactListTreeViewItem;
    }

    /**
      Set Indent contacts if you don't show tree lines.
    */
    static
    void setContactListIndentContact( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListIndentContact" ) )) {
        self()->mContactListIndentContact = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Indent contacts if you don't show tree lines.
    */
    static
    bool contactListIndentContact()
    {
      return self()->mContactListIndentContact;
    }

    /**
      Get Item object corresponding to contactListIndentContact()
    */
    ItemBool *contactListIndentContactItem()
    {
      return mContactListIndentContactItem;
    }

    /**
      Set Hide the vertical scroll bar.
    */
    static
    void setContactListHideVerticalScrollBar( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListHideVerticalScrollBar" ) )) {
        self()->mContactListHideVerticalScrollBar = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Hide the vertical scroll bar.
    */
    static
    bool contactListHideVerticalScrollBar()
    {
      return self()->mContactListHideVerticalScrollBar;
    }

    /**
      Get Item object corresponding to contactListHideVerticalScrollBar()
    */
    ItemBool *contactListHideVerticalScrollBarItem()
    {
      return mContactListHideVerticalScrollBarItem;
    }

    /**
      Set Group contacts by group.
    */
    static
    void setGroupContactByGroup( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "groupContactByGroup" ) )) {
        self()->mGroupContactByGroup = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Group contacts by group.
    */
    static
    bool groupContactByGroup()
    {
      return self()->mGroupContactByGroup;
    }

    /**
      Get Item object corresponding to groupContactByGroup()
    */
    ItemBool *groupContactByGroupItem()
    {
      return mGroupContactByGroupItem;
    }

    /**
      Set Use custom fonts for contact list.
    */
    static
    void setContactListUseCustomFont( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListUseCustomFont" ) )) {
        self()->mContactListUseCustomFont = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Use custom fonts for contact list.
    */
    static
    bool contactListUseCustomFont()
    {
      return self()->mContactListUseCustomFont;
    }

    /**
      Get Item object corresponding to contactListUseCustomFont()
    */
    ItemBool *contactListUseCustomFontItem()
    {
      return mContactListUseCustomFontItem;
    }

    /**
      Set Automatically resize the main window.
    */
    static
    void setContactListAutoResize( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListAutoResize" ) )) {
        self()->mContactListAutoResize = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Automatically resize the main window.
    */
    static
    bool contactListAutoResize()
    {
      return self()->mContactListAutoResize;
    }

    /**
      Get Item object corresponding to contactListAutoResize()
    */
    ItemBool *contactListAutoResizeItem()
    {
      return mContactListAutoResizeItem;
    }

    /**
      Set Corner at which to anchor main window when auto-resizing.
    */
    static
    void setContactListResizeAnchor( int v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListResizeAnchor" ) )) {
        self()->mContactListResizeAnchor = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Corner at which to anchor main window when auto-resizing.
    */
    static
    int contactListResizeAnchor()
    {
      return self()->mContactListResizeAnchor;
    }

    /**
      Get Item object corresponding to contactListResizeAnchor()
    */
    ItemEnum *contactListResizeAnchorItem()
    {
      return mContactListResizeAnchorItem;
    }

    /**
      Set Normal font for contact list
    */
    static
    void setContactListNormalFont( const QFont & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListNormalFont" ) )) {
        self()->mContactListNormalFont = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Normal font for contact list
    */
    static
    QFont contactListNormalFont()
    {
      return self()->mContactListNormalFont;
    }

    /**
      Get Item object corresponding to contactListNormalFont()
    */
    ItemFont *contactListNormalFontItem()
    {
      return mContactListNormalFontItem;
    }

    /**
      Set Small font for contact list (for status message)
    */
    static
    void setContactListSmallFont( const QFont & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListSmallFont" ) )) {
        self()->mContactListSmallFont = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Small font for contact list (for status message)
    */
    static
    QFont contactListSmallFont()
    {
      return self()->mContactListSmallFont;
    }

    /**
      Get Item object corresponding to contactListSmallFont()
    */
    ItemFont *contactListSmallFontItem()
    {
      return mContactListSmallFontItem;
    }

    /**
      Set Color for group name.
    */
    static
    void setGroupNameColor( const QColor & v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "groupNameColor" ) )) {
        self()->mGroupNameColor = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Color for group name.
    */
    static
    QColor groupNameColor()
    {
      return self()->mGroupNameColor;
    }

    /**
      Get Item object corresponding to groupNameColor()
    */
    ItemColor *groupNameColorItem()
    {
      return mGroupNameColorItem;
    }

    /**
      Set Animate contact list on contactlist changes.
    */
    static
    void setContactListAnimateChange( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListAnimateChange" ) )) {
        self()->mContactListAnimateChange = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Animate contact list on contactlist changes.
    */
    static
    bool contactListAnimateChange()
    {
      return self()->mContactListAnimateChange;
    }

    /**
      Get Item object corresponding to contactListAnimateChange()
    */
    ItemBool *contactListAnimateChangeItem()
    {
      return mContactListAnimateChangeItem;
    }

    /**
      Set Fade-in/Fade-out on contact status change.
    */
    static
    void setContactListFading( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListFading" ) )) {
        self()->mContactListFading = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Fade-in/Fade-out on contact status change.
    */
    static
    bool contactListFading()
    {
      return self()->mContactListFading;
    }

    /**
      Get Item object corresponding to contactListFading()
    */
    ItemBool *contactListFadingItem()
    {
      return mContactListFadingItem;
    }

    /**
      Set Fold-in/Fold-out on contact status change.
    */
    static
    void setContactListFolding( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListFolding" ) )) {
        self()->mContactListFolding = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Fold-in/Fold-out on contact status change.
    */
    static
    bool contactListFolding()
    {
      return self()->mContactListFolding;
    }

    /**
      Get Item object corresponding to contactListFolding()
    */
    ItemBool *contactListFoldingItem()
    {
      return mContactListFoldingItem;
    }

    /**
      Set Auto-hide contact list after a while.
    */
    static
    void setContactListAutoHide( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListAutoHide" ) )) {
        self()->mContactListAutoHide = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Auto-hide contact list after a while.
    */
    static
    bool contactListAutoHide()
    {
      return self()->mContactListAutoHide;
    }

    /**
      Get Item object corresponding to contactListAutoHide()
    */
    ItemBool *contactListAutoHideItem()
    {
      return mContactListAutoHideItem;
    }

    /**
      Set Auto-hide vertical scrollbar in contact list after a while.
    */
    static
    void setContactListAutoHideVScroll( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListAutoHideVScroll" ) )) {
        self()->mContactListAutoHideVScroll = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Auto-hide vertical scrollbar in contact list after a while.
    */
    static
    bool contactListAutoHideVScroll()
    {
      return self()->mContactListAutoHideVScroll;
    }

    /**
      Get Item object corresponding to contactListAutoHideVScroll()
    */
    ItemBool *contactListAutoHideVScrollItem()
    {
      return mContactListAutoHideVScrollItem;
    }

    /**
      Set Auto-hide timeout
    */
    static
    void setContactListAutoHideTimeout( uint v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "contactListAutoHideTimeout" ) )) {
        self()->mContactListAutoHideTimeout = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Auto-hide timeout
    */
    static
    uint contactListAutoHideTimeout()
    {
      return self()->mContactListAutoHideTimeout;
    }

    /**
      Get Item object corresponding to contactListAutoHideTimeout()
    */
    ItemUInt *contactListAutoHideTimeoutItem()
    {
      return mContactListAutoHideTimeoutItem;
    }

    /**
      Set Show offline users in contact list.
    */
    static
    void setShowOfflineUsers( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "showOfflineUsers" ) )) {
        self()->mShowOfflineUsers = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Show offline users in contact list.
    */
    static
    bool showOfflineUsers()
    {
      return self()->mShowOfflineUsers;
    }

    /**
      Get Item object corresponding to showOfflineUsers()
    */
    ItemBool *showOfflineUsersItem()
    {
      return mShowOfflineUsersItem;
    }

    /**
      Set Show empty groups in contact list.
    */
    static
    void setShowEmptyGroups( bool v )
    {
      if (!self()->isImmutable( QString::fromLatin1 ( "showEmptyGroups" ) )) {
        self()->mShowEmptyGroups = v;
        self()->mSettingsChanged |= signalContactListAppearanceChanged;
      }
    }

    /**
      Get Show empty groups in contact list.
    */
    static
    bool showEmptyGroups()
    {
      return self()->mShowEmptyGroups;
    }

    /**
      Get Item object corresponding to showEmptyGroups()
    */
    ItemBool *showEmptyGroupsItem()
    {
      return mShowEmptyGroupsItem;
    }


  Q_SIGNALS:
    /**
      Emited when the font and colors settings has changed.
    */
    void appearanceChanged();

    /**
      Emited when the message overrides settings has changed.
    */
    void messageOverridesChanged();

    /**
      Emited when the contact list appearance has changed.
    */
    void contactListAppearanceChanged();

  protected:
    AppearanceSettings();
    friend class AppearanceSettingsHelper;

    virtual void usrWriteConfig();

    // Appearance
    bool mUseEmoticons;
    QColor mHighlightForegroundColor;
    QColor mHighlightBackgroundColor;
    bool mChatBgOverride;
    bool mChatFgOverride;
    bool mChatRtfOverride;
    QColor mChatTextColor;
    QColor mChatBackgroundColor;
    QColor mChatLinkColor;
    QFont mChatFont;
    QColor mIdleContactColor;
    bool mGreyIdleMetaContacts;
    QStringList mToolTipContents;

    // ContactList
    int mContactListDisplayMode;
    int mContactListIconMode;
    bool mContactListTreeView;
    bool mContactListIndentContact;
    bool mContactListHideVerticalScrollBar;
    bool mGroupContactByGroup;
    bool mContactListUseCustomFont;
    bool mContactListAutoResize;
    int mContactListResizeAnchor;
    QFont mContactListNormalFont;
    QFont mContactListSmallFont;
    QColor mGroupNameColor;
    bool mContactListAnimateChange;
    bool mContactListFading;
    bool mContactListFolding;
    bool mContactListAutoHide;
    bool mContactListAutoHideVScroll;
    uint mContactListAutoHideTimeout;
    bool mShowOfflineUsers;
    bool mShowEmptyGroups;

  private:
    ItemBool *mUseEmoticonsItem;
    ItemColor *mHighlightForegroundColorItem;
    ItemColor *mHighlightBackgroundColorItem;
    ItemBool *mChatBgOverrideItem;
    ItemBool *mChatFgOverrideItem;
    ItemBool *mChatRtfOverrideItem;
    ItemColor *mChatTextColorItem;
    ItemColor *mChatBackgroundColorItem;
    ItemColor *mChatLinkColorItem;
    ItemFont *mChatFontItem;
    ItemColor *mIdleContactColorItem;
    ItemBool *mGreyIdleMetaContactsItem;
    ItemStringList *mToolTipContentsItem;
    ItemEnum *mContactListDisplayModeItem;
    ItemEnum *mContactListIconModeItem;
    ItemBool *mContactListTreeViewItem;
    ItemBool *mContactListIndentContactItem;
    ItemBool *mContactListHideVerticalScrollBarItem;
    ItemBool *mGroupContactByGroupItem;
    ItemBool *mContactListUseCustomFontItem;
    ItemBool *mContactListAutoResizeItem;
    ItemEnum *mContactListResizeAnchorItem;
    ItemFont *mContactListNormalFontItem;
    ItemFont *mContactListSmallFontItem;
    ItemColor *mGroupNameColorItem;
    ItemBool *mContactListAnimateChangeItem;
    ItemBool *mContactListFadingItem;
    ItemBool *mContactListFoldingItem;
    ItemBool *mContactListAutoHideItem;
    ItemBool *mContactListAutoHideVScrollItem;
    ItemUInt *mContactListAutoHideTimeoutItem;
    ItemBool *mShowOfflineUsersItem;
    ItemBool *mShowEmptyGroupsItem;
    uint mSettingsChanged;
};

}

#endif

