#!/bin/bash
# textsearch_ja	(http://textsearch-ja.projects.postgresql.org/index-ja.html)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-07-16
# require:
#	postgresql-8.3.x
#
SRC_URI=http://pgfoundry.org/frs/download.php/1655/textsearch_ja-8.3.1.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}
#VERSION=${PAC_NAME##*-}
VERSION=8.3.5
DIR_NAME=textsearch_ja
echo $DIR_NAME $VERSION
POSTGRESQL=postgresql-$VERSION


REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
#SRC_DIR=$PLAMO/Archive/%category%
PAC_DIR=$PLAMO/Packages/4.5/09_webdb/01_PostgreSQL.tgz
BUILD_DIR=$PLAMO/pgfoundry
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=


if ! `which pg_config > /dev/null 2>&1`; then
  export PATH=/opt/pgsql/bin:$PATH
  #. ~postgres/.bashrc
fi


if [ ! -f $SRC_FILE ]; then
  wget -N $SRC_URI
fi


SRC_DIR=`pwd`

rm -f $POSTGRESQL
ln -sf ../postgresql/$POSTGRESQL
cd $POSTGRESQL/contrib/
tar xvfz  $SRC_DIR/$SRC_FILE
cd $DIR_NAME
make
make install
mkdir -p work
 cd work/
(tar cf - -C / \
  opt/$POSTGRESQL/lib/textsearch_ja.so \
  opt/$POSTGRESQL/share/contrib/ \
  opt/$POSTGRESQL/share/contrib/textsearch_ja.sql \
  opt/$POSTGRESQL/share/contrib/uninstall_textsearch_ja.sql \
  opt/$POSTGRESQL/doc/contrib/README.textsearch_ja \
  usr/share/doc/textsearch_ja/ \
	| tar xvf - )

 mkdir -p opt/$POSTGRESQL/doc/contrib/
 cp usr/share/doc/textsearch_ja/README.textsearch_ja opt/$POSTGRESQL/doc/contrib/
 cp -a ../doc ../dict ../test usr/share/doc/textsearch_ja/
 mv usr/share/doc/textsearch_ja/ usr/share/doc/$PAC_NAME
 cp -p $SRC_DIR/`basename $0`   usr/share/doc/$PAC_NAME

 mkdir -p install
 cat >> install/doinst.sh<<_EOF_
#%% begin initialize ${PAC_NAME}-${VERSION}-${SYS_NAME}
/bin/chown postgres:pgsql $ROOT/opt/$POSTGRESQL/lib/textsearch_ja.so
/bin/chown postgres:pgsql $ROOT/opt/$POSTGRESQL/share/contrib/textsearch_ja.sql
/bin/chown postgres:pgsql $ROOT/opt/$POSTGRESQL/share/contrib/uninstall_textsearch_ja.sql
/bin/chown postgres:pgsql $ROOT/opt/$POSTGRESQL/doc/contrib/README.textsearch_ja 
#%% end
_EOF_

tar cvfz ../${PAC_NAME}-i386-1.tgz  `find opt -type f` usr/share/doc/${PAC_NAME}/ install/doinst.sh

mv -v ../${PAC_NAME}-i386-1.tgz  ${PAC_DIR}/${PAC_NAME}-${VERSION}-${SYS_NAME}.tgz
