<?php
/**
 * This is the default English localisation file
 *
 * END USERS: DO NOT EDIT THIS FILE DIRECTLY!
 *
 * Changes in this file will be lost during software upgrades.
 * You can make your customizations on the wiki.
 * While logged in as a sysop user, go to [[Special:AllMessages]]
 * and edit the MediaWiki:* pages listed there.
 */


/**
 * Fallback language, used for all unspecified messages and behaviour. This
 * is English by default, for all files other than this one.
 *
 * Do NOT set this to false in any other message file! Leave the line out to
 * accept the default fallback to "en".
 */
$fallback = false;

/**
 * Is the language written right-to-left?
 * Note that right-to-left languages generally also specify
 *    $defaultUserOptionOverrides = array( 'quickbar' => 2 );
 */
$rtl = false;

/**
 * Optional array mapping ASCII digits 0-9 to local digits.
 */
$digitTransformTable = null;

/**
 * Transform table for decimal point '.' and thousands separator ','
 */
$separatorTransformTable = null;

/**
 * Overrides for the default user options. This is mainly used by RTL languages.
 */
$defaultUserOptionOverrides = array();

/**
 * Extra user preferences which will be shown in Special:Preferences as
 * checkboxes. Extra settings in derived languages will automatically be
 * appended to the array of the fallback languages.
 */
$extraUserToggles = array();

/**
 * URLs do not specify their encoding. UTF-8 is used by default, but if the
 * URL is not a valid UTF-8 sequence, we have to try to guess what the real
 * encoding is. The encoding used in this case is defined below, and must be
 * supported by iconv().
 */
$fallback8bitEncoding = 'windows-1252';

/**
 * To allow "foo[[bar]]" to extend the link over the whole word "foobar"
 */
$linkPrefixExtension = false;

/**
 * Namespace names. NS_PROJECT is always set to $wgMetaNamespace after the
 * settings are loaded, it will be ignored even if you specify it here.
 *
 * NS_PROJECT_TALK will be set to $wgMetaNamespaceTalk if that variable is
 * set, otherwise the string specified here will be used. The string may
 * contain "$1", which will be replaced by the name of NS_PROJECT. It may
 * also contain a grammatical transformation, e.g.
 *
 *     NS_PROJECT_TALK => 'Keskustelu_{{grammar:elative|$1}}'
 *
 * Only one grammatical transform may be specified in the string. For
 * performance reasons, this transformation is done locally by the language
 * module rather than by the full wikitext parser. As a result, no other
 * parser features are available.
 */
$namespaceNames = array(
	NS_MEDIA            => 'Media',
	NS_SPECIAL          => 'Special',
	NS_MAIN	            => '',
	NS_TALK	            => 'Talk',
	NS_USER             => 'User',
	NS_USER_TALK        => 'User_talk',
	# NS_PROJECT set by $wgMetaNamespace
	NS_PROJECT_TALK     => '$1_talk',
	NS_IMAGE            => 'Image',
	NS_IMAGE_TALK       => 'Image_talk',
	NS_MEDIAWIKI        => 'MediaWiki',
	NS_MEDIAWIKI_TALK   => 'MediaWiki_talk',
	NS_TEMPLATE         => 'Template',
	NS_TEMPLATE_TALK    => 'Template_talk',
	NS_HELP             => 'Help',
	NS_HELP_TALK        => 'Help_talk',
	NS_CATEGORY         => 'Category',
	NS_CATEGORY_TALK    => 'Category_talk',
);

/**
 * Array of namespace aliases, mapping from name to NS_xxx index
 */
$namespaceAliases = array();

/**
 * Skin names. If any key is not specified, the English one will be used.
 */
$skinNames = array(
	'standard'    => 'Classic',
	'nostalgia'   => 'Nostalgia',
	'cologneblue' => 'Cologne Blue',
	'monobook'    => 'MonoBook',
	'myskin'      => 'MySkin',
	'chick'       => 'Chick',
	'simple'      => 'Simple',
	'modern'      => 'Modern',
);

/**
 * Deprecated, use the message array
 */
$mathNames = array(
	MW_MATH_PNG => 'mw_math_png',
	MW_MATH_SIMPLE => 'mw_math_simple',
	MW_MATH_HTML => 'mw_math_html',
	MW_MATH_SOURCE => 'mw_math_source',
	MW_MATH_MODERN => 'mw_math_modern',
	MW_MATH_MATHML => 'mw_math_mathml'
);

/**
 * A list of date format preference keys which can be selected in user
 * preferences. New preference keys can be added, provided they are supported
 * by the language class's timeanddate(). Only the 5 keys listed below are
 * supported by the wikitext converter (DateFormatter.php).
 *
 * The special key "default" is an alias for either dmy or mdy depending on
 * $wgAmericanDates
 */
$datePreferences = array(
	'default',
	'mdy',
	'dmy',
	'ymd',
	'ISO 8601',
);

/**
 * The date format to use for generated dates in the user interface.
 * This may be one of the above date preferences, or the special value
 * "dmy or mdy", which uses mdy if $wgAmericanDates is true, and dmy
 * if $wgAmericanDates is false.
 */
$defaultDateFormat = 'dmy or mdy';

/**
 * Associative array mapping old numeric date formats, which may still be
 * stored in user preferences, to the new string formats.
 */
$datePreferenceMigrationMap = array(
	'default',
	'mdy',
	'dmy',
	'ymd'
);

/**
 * These are formats for dates generated by MediaWiki (as opposed to the wikitext
 * DateFormatter). Documentation for the format string can be found in
 * Language.php, search for sprintfDate.
 *
 * This array is automatically inherited by all subclasses. Individual keys can be
 * overridden.
 */
$dateFormats = array(
	'mdy time' => 'H:i',
	'mdy date' => 'F j, Y',
	'mdy both' => 'H:i, F j, Y',

	'dmy time' => 'H:i',
	'dmy date' => 'j F Y',
	'dmy both' => 'H:i, j F Y',

	'ymd time' => 'H:i',
	'ymd date' => 'Y F j',
	'ymd both' => 'H:i, Y F j',

	'ISO 8601 time' => 'xnH:xni:xns',
	'ISO 8601 date' => 'xnY-xnm-xnd',
	'ISO 8601 both' => 'xnY-xnm-xnd"T"xnH:xni:xns',
);

/**
 * Default list of book sources
 */
$bookstoreList = array(
	'AddALL' => 'http://www.addall.com/New/Partner.cgi?query=$1&type=ISBN',
	'PriceSCAN' => 'http://www.pricescan.com/books/bookDetail.asp?isbn=$1',
	'Barnes & Noble' => 'http://search.barnesandnoble.com/bookSearch/isbnInquiry.asp?isbn=$1',
	'Amazon.com' => 'http://www.amazon.com/exec/obidos/ISBN=$1'
);

/**
 * Magic words
 * Customisable syntax for wikitext and elsewhere.
 *
 * IDs must be valid identifiers, they cannot contain hyphens.
 *
 * Note to translators:
 *   Please include the English words as synonyms.  This allows people
 *   from other wikis to contribute more easily.
 *
 * This array can be modified at runtime with the LanguageGetMagic hook
 */
$magicWords = array(
#   ID                                 CASE  SYNONYMS
	'redirect'               => array( 0,    '#REDIRECT'              ),
	'notoc'                  => array( 0,    '__NOTOC__'              ),
	'nogallery'              => array( 0,    '__NOGALLERY__'          ),
	'forcetoc'               => array( 0,    '__FORCETOC__'           ),
	'toc'                    => array( 0,    '__TOC__'                ),
	'noeditsection'          => array( 0,    '__NOEDITSECTION__'      ),
	'currentmonth'           => array( 1,    'CURRENTMONTH'           ),
	'currentmonthname'       => array( 1,    'CURRENTMONTHNAME'       ),
	'currentmonthnamegen'    => array( 1,    'CURRENTMONTHNAMEGEN'    ),
	'currentmonthabbrev'     => array( 1,    'CURRENTMONTHABBREV'     ),
	'currentday'             => array( 1,    'CURRENTDAY'             ),
	'currentday2'            => array( 1,    'CURRENTDAY2'            ),
	'currentdayname'         => array( 1,    'CURRENTDAYNAME'         ),
	'currentyear'            => array( 1,    'CURRENTYEAR'            ),
	'currenttime'            => array( 1,    'CURRENTTIME'            ),
	'currenthour'            => array( 1,    'CURRENTHOUR'            ),
	'localmonth'             => array( 1,    'LOCALMONTH'             ),
	'localmonthname'         => array( 1,    'LOCALMONTHNAME'         ),
	'localmonthnamegen'      => array( 1,    'LOCALMONTHNAMEGEN'      ),
	'localmonthabbrev'       => array( 1,    'LOCALMONTHABBREV'       ),
	'localday'               => array( 1,    'LOCALDAY'               ),
	'localday2'              => array( 1,    'LOCALDAY2'              ),
	'localdayname'           => array( 1,    'LOCALDAYNAME'           ),
	'localyear'              => array( 1,    'LOCALYEAR'              ),
	'localtime'              => array( 1,    'LOCALTIME'              ),
	'localhour'              => array( 1,    'LOCALHOUR'              ),
	'numberofpages'          => array( 1,    'NUMBEROFPAGES'          ),
	'numberofarticles'       => array( 1,    'NUMBEROFARTICLES'       ),
	'numberoffiles'          => array( 1,    'NUMBEROFFILES'          ),
	'numberofusers'          => array( 1,    'NUMBEROFUSERS'          ),
	'numberofedits'          => array( 1,    'NUMBEROFEDITS'          ),
	'pagename'               => array( 1,    'PAGENAME'               ),
	'pagenamee'              => array( 1,    'PAGENAMEE'              ),
	'namespace'              => array( 1,    'NAMESPACE'              ),
	'namespacee'             => array( 1,    'NAMESPACEE'             ),
	'talkspace'              => array( 1,    'TALKSPACE'              ),
	'talkspacee'             => array( 1,    'TALKSPACEE'              ),
	'subjectspace'           => array( 1,    'SUBJECTSPACE', 'ARTICLESPACE' ),
	'subjectspacee'          => array( 1,    'SUBJECTSPACEE', 'ARTICLESPACEE' ),
	'fullpagename'           => array( 1,    'FULLPAGENAME'           ),
	'fullpagenamee'          => array( 1,    'FULLPAGENAMEE'          ),
	'subpagename'            => array( 1,    'SUBPAGENAME'            ),
	'subpagenamee'           => array( 1,    'SUBPAGENAMEE'           ),
	'basepagename'           => array( 1,    'BASEPAGENAME'           ),
	'basepagenamee'          => array( 1,    'BASEPAGENAMEE'          ),
	'talkpagename'           => array( 1,    'TALKPAGENAME'           ),
	'talkpagenamee'          => array( 1,    'TALKPAGENAMEE'          ),
	'subjectpagename'        => array( 1,    'SUBJECTPAGENAME', 'ARTICLEPAGENAME' ),
	'subjectpagenamee'       => array( 1,    'SUBJECTPAGENAMEE', 'ARTICLEPAGENAMEE' ),
	'msg'                    => array( 0,    'MSG:'                   ),
	'subst'                  => array( 0,    'SUBST:'                 ),
	'msgnw'                  => array( 0,    'MSGNW:'                 ),
	'img_thumbnail'          => array( 1,    'thumbnail', 'thumb'     ),
	'img_manualthumb'        => array( 1,    'thumbnail=$1', 'thumb=$1'),
	'img_right'              => array( 1,    'right'                  ),
	'img_left'               => array( 1,    'left'                   ),
	'img_none'               => array( 1,    'none'                   ),
	'img_width'              => array( 1,    '$1px'                   ),
	'img_center'             => array( 1,    'center', 'centre'       ),
	'img_framed'             => array( 1,    'framed', 'enframed', 'frame' ),
	'img_frameless'          => array( 1,    'frameless'              ),
	'img_page'               => array( 1,    'page=$1', 'page $1'     ),
	'img_upright'            => array( 1,    'upright', 'upright=$1', 'upright $1'  ),
	'img_border'             => array( 1,    'border'                 ),
	'img_baseline'           => array( 1,    'baseline'               ),
	'img_sub'                => array( 1,    'sub'                    ),
	'img_super'              => array( 1,    'super', 'sup'           ),
	'img_top'                => array( 1,    'top'                    ),
	'img_text_top'           => array( 1,    'text-top'               ),
	'img_middle'             => array( 1,    'middle'                 ),
	'img_bottom'             => array( 1,    'bottom'                 ),
	'img_text_bottom'        => array( 1,    'text-bottom'            ),
	'int'                    => array( 0,    'INT:'                   ),
	'sitename'               => array( 1,    'SITENAME'               ),
	'ns'                     => array( 0,    'NS:'                    ),
	'localurl'               => array( 0,    'LOCALURL:'              ),
	'localurle'              => array( 0,    'LOCALURLE:'             ),
	'server'                 => array( 0,    'SERVER'                 ),
	'servername'             => array( 0,    'SERVERNAME'             ),
	'scriptpath'             => array( 0,    'SCRIPTPATH'             ),
	'grammar'                => array( 0,    'GRAMMAR:'               ),
	'notitleconvert'         => array( 0,    '__NOTITLECONVERT__', '__NOTC__'),
	'nocontentconvert'       => array( 0,    '__NOCONTENTCONVERT__', '__NOCC__'),
	'currentweek'            => array( 1,    'CURRENTWEEK'            ),
	'currentdow'             => array( 1,    'CURRENTDOW'             ),
	'localweek'              => array( 1,    'LOCALWEEK'              ),
	'localdow'               => array( 1,    'LOCALDOW'               ),
	'revisionid'             => array( 1,    'REVISIONID'             ),
	'revisionday'            => array( 1,    'REVISIONDAY'            ),
	'revisionday2'           => array( 1,    'REVISIONDAY2'           ),
	'revisionmonth'          => array( 1,    'REVISIONMONTH'          ),
	'revisionyear'           => array( 1,    'REVISIONYEAR'           ),
	'revisiontimestamp'      => array( 1,    'REVISIONTIMESTAMP'      ),
	'plural'                 => array( 0,    'PLURAL:'                ),
	'fullurl'                => array( 0,    'FULLURL:'               ),
	'fullurle'               => array( 0,    'FULLURLE:'              ),
	'lcfirst'                => array( 0,    'LCFIRST:'               ),
	'ucfirst'                => array( 0,    'UCFIRST:'               ),
	'lc'                     => array( 0,    'LC:'                    ),
	'uc'                     => array( 0,    'UC:'                    ),
	'raw'                    => array( 0,    'RAW:'                   ),
	'displaytitle'           => array( 1,    'DISPLAYTITLE'           ),
	'rawsuffix'              => array( 1,    'R'                      ),
	'newsectionlink'         => array( 1,    '__NEWSECTIONLINK__'     ),
	'currentversion'         => array( 1,    'CURRENTVERSION'         ),
	'urlencode'              => array( 0,    'URLENCODE:'             ),
	'anchorencode'           => array( 0,    'ANCHORENCODE'           ),
	'currenttimestamp'       => array( 1,    'CURRENTTIMESTAMP'       ),
	'localtimestamp'         => array( 1,    'LOCALTIMESTAMP'         ),
	'directionmark'          => array( 1,    'DIRECTIONMARK', 'DIRMARK' ),
	'language'               => array( 0,    '#LANGUAGE:'             ),
	'contentlanguage'        => array( 1,    'CONTENTLANGUAGE', 'CONTENTLANG' ),
	'pagesinnamespace'       => array( 1,    'PAGESINNAMESPACE:', 'PAGESINNS:' ),
	'numberofadmins'         => array( 1,    'NUMBEROFADMINS'         ),
	'formatnum'              => array( 0,    'FORMATNUM'              ),
	'padleft'                => array( 0,    'PADLEFT'                ),
	'padright'               => array( 0,    'PADRIGHT'               ),
	'special'                => array( 0,    'special',               ),
	'defaultsort'            => array( 1,    'DEFAULTSORT:', 'DEFAULTSORTKEY:', 'DEFAULTCATEGORYSORT:' ),
	'filepath'               => array( 0,    'FILEPATH:'              ),
	'tag'                    => array( 0,    'tag'                    ),
	'hiddencat'              => array( 1,    '__HIDDENCAT__'          ),
	'pagesincategory'        => array( 1,    'PAGESINCATEGORY', 'PAGESINCAT' ),
	'pagesize'               => array( 1,    'PAGESIZE'               ),
	'staticredirect'         => array( 1,    '__STATICREDIRECT__'     ),
);

/**
 * Alternate names of special pages. All names are case-insensitive. The first
 * listed alias will be used as the default. Aliases from the fallback
 * localisation (usually English) will be included by default.
 *
 * This array may be altered at runtime using the LanguageGetSpecialPageAliases
 * hook.
 */
$specialPageAliases = array(
	'DoubleRedirects'           => array( 'DoubleRedirects' ),
	'BrokenRedirects'           => array( 'BrokenRedirects' ),
	'Disambiguations'           => array( 'Disambiguations' ),
	'Userlogin'                 => array( 'UserLogin' ),
	'Userlogout'                => array( 'UserLogout' ),
	'CreateAccount'             => array( 'CreateAccount' ),
	'Preferences'               => array( 'Preferences' ),
	'Watchlist'                 => array( 'Watchlist' ),
	'Recentchanges'             => array( 'RecentChanges' ),
	'Upload'                    => array( 'Upload' ),
	'Imagelist'                 => array( 'ImageList' ),
	'Newimages'                 => array( 'NewImages' ),
	'Listusers'                 => array( 'ListUsers', 'UserList' ),
	'Listgrouprights'           => array( 'ListGroupRights' ),
	'Statistics'                => array( 'Statistics' ),
	'Randompage'                => array( 'Random', 'RandomPage' ),
	'Lonelypages'               => array( 'LonelyPages', 'OrphanedPages' ),
	'Uncategorizedpages'        => array( 'UncategorizedPages' ),
	'Uncategorizedcategories'   => array( 'UncategorizedCategories' ),
	'Uncategorizedimages'       => array( 'UncategorizedImages' ),
	'Uncategorizedtemplates'    => array( 'UncategorizedTemplates' ),
	'Unusedcategories'          => array( 'UnusedCategories' ),
	'Unusedimages'              => array( 'UnusedImages' ),
	'Wantedpages'               => array( 'WantedPages', 'BrokenLinks' ),
	'Wantedcategories'          => array( 'WantedCategories' ),
	'Missingfiles'              => array( 'MissingFiles', 'MissingImages' ),
	'Mostlinked'                => array( 'MostLinked' ),
	'Mostlinkedcategories'      => array( 'MostLinkedCategories', 'MostUsedCategories' ),
	'Mostlinkedtemplates'       => array( 'MostLinkedTemplates', 'MostUsedTemplates' ),
	'Mostcategories'            => array( 'MostCategories' ),
	'Mostimages'                => array( 'MostImages' ),
	'Mostrevisions'             => array( 'MostRevisions' ),
	'Fewestrevisions'           => array( 'FewestRevisions' ),
	'Shortpages'                => array( 'ShortPages' ),
	'Longpages'                 => array( 'LongPages' ),
	'Newpages'                  => array( 'NewPages' ),
	'Ancientpages'              => array( 'AncientPages' ),
	'Deadendpages'              => array( 'DeadendPages' ),
	'Protectedpages'            => array( 'ProtectedPages' ),
	'Protectedtitles'           => array( 'ProtectedTitles' ),
	'Allpages'                  => array( 'AllPages' ),
	'Prefixindex'               => array( 'PrefixIndex' ) ,
	'Ipblocklist'               => array( 'IPBlockList' ),
	'Specialpages'              => array( 'SpecialPages' ),
	'Contributions'             => array( 'Contributions' ),
	'Emailuser'                 => array( 'EmailUser' ),
	'Confirmemail'              => array( 'ConfirmEmail' ),
	'Whatlinkshere'             => array( 'WhatLinksHere' ),
	'Recentchangeslinked'       => array( 'RecentChangesLinked', 'RelatedChanges' ),
	'Movepage'                  => array( 'MovePage' ),
	'Blockme'                   => array( 'BlockMe' ),
	'Booksources'               => array( 'BookSources' ),
	'Categories'                => array( 'Categories' ),
	'Export'                    => array( 'Export' ),
	'Version'                   => array( 'Version' ),
	'Allmessages'               => array( 'AllMessages' ),
	'Log'                       => array( 'Log', 'Logs' ),
	'Blockip'                   => array( 'BlockIP' ),
	'Undelete'                  => array( 'Undelete' ),
	'Import'                    => array( 'Import' ),
	'Lockdb'                    => array( 'LockDB' ),
	'Unlockdb'                  => array( 'UnlockDB' ),
	'Userrights'                => array( 'UserRights' ),
	'MIMEsearch'                => array( 'MIMESearch' ),
	'FileDuplicateSearch'       => array( 'FileDuplicateSearch' ),
	'Unwatchedpages'            => array( 'UnwatchedPages' ),
	'Listredirects'             => array( 'ListRedirects' ),
	'Revisiondelete'            => array( 'RevisionDelete' ),
	'Unusedtemplates'           => array( 'UnusedTemplates' ),
	'Randomredirect'            => array( 'RandomRedirect' ),
	'Mypage'                    => array( 'MyPage' ),
	'Mytalk'                    => array( 'MyTalk' ),
	'Mycontributions'           => array( 'MyContributions' ),
	'Listadmins'                => array( 'ListAdmins' ),
	'Listbots'                  => array( 'ListBots' ),
	'Popularpages'              => array( 'PopularPages' ),
	'Search'                    => array( 'Search' ),
	'Resetpass'                 => array( 'ResetPass', 'ResetPassword' ),
	'Withoutinterwiki'          => array( 'WithoutInterwiki' ),
	'MergeHistory'              => array( 'MergeHistory' ),
	'Filepath'                  => array( 'FilePath' ),
	'Invalidateemail'           => array( 'InvalidateEmail' ),
	'Blankpage'                 => array( 'BlankPage' ),
);

/**
 * Regular expression matching the "link trail", e.g. "ed" in [[Toast]]ed, as
 * the first group, and the remainder of the string as the second group.
 */
$linkTrail = '/^([a-z]+)(.*)$/sD';

/**
 * List of filenames for some ui images that can be overridden per language
 * basis if needed.
*/
$imageFiles = array(
	'button-bold'     => 'button_bold.png',
	'button-italic'   => 'button_italic.png',
	'button-link'     => 'button_link.png',
	'button-extlink'  => 'button_extlink.png',
	'button-headline' => 'button_headline.png',
	'button-image'    => 'button_image.png',
	'button-media'    => 'button_media.png',
	'button-math'     => 'button_math.png',
	'button-nowiki'   => 'button_nowiki.png',
	'button-sig'      => 'button_sig.png',
	'button-hr'       => 'button_hr.png',
);

#-------------------------------------------------------------------
# Default messages
#-------------------------------------------------------------------
# Allowed characters in keys are: A-Z, a-z, 0-9, underscore (_) and
# hyphen (-). If you need more characters, you may be able to change
# the regex in MagicWord::initRegex

$messages = array(
/*
The sidebar for MonoBook is generated from this message, lines that do not
begin with * or ** are discarded, furthermore lines that do begin with ** and
do not contain | are also discarded, but do not depend on this behaviour for
future releases. Also note that since each list value is wrapped in a unique
XHTML id it should only appear once and include characters that are legal
XHTML id names.
*/
'sidebar' => '
* navigation
** mainpage|mainpage-description
** portal-url|portal
** currentevents-url|currentevents
** recentchanges-url|recentchanges
** randompage-url|randompage
** helppage|help
* SEARCH
* TOOLBOX
* LANGUAGES', # do not translate or duplicate this message to other languages

# User preference toggles
'tog-underline'               => 'Underline links:',
'tog-highlightbroken'         => 'Format broken links <a href="" class="new">like this</a> (alternative: like this<a href="" class="internal">?</a>).',
'tog-justify'                 => 'Justify paragraphs',
'tog-hideminor'               => 'Hide minor edits in recent changes',
'tog-extendwatchlist'         => 'Expand watchlist to show all applicable changes',
'tog-usenewrc'                => 'Enhanced recent changes (JavaScript)',
'tog-numberheadings'          => 'Auto-number headings',
'tog-showtoolbar'             => 'Show edit toolbar (JavaScript)',
'tog-editondblclick'          => 'Edit pages on double click (JavaScript)',
'tog-editsection'             => 'Enable section editing via [edit] links',
'tog-editsectiononrightclick' => 'Enable section editing by right clicking on section titles (JavaScript)',
'tog-showtoc'                 => 'Show table of contents (for pages with more than 3 headings)',
'tog-rememberpassword'        => 'Remember my login on this computer',
'tog-editwidth'               => 'Edit box has full width',
'tog-watchcreations'          => 'Add pages I create to my watchlist',
'tog-watchdefault'            => 'Add pages I edit to my watchlist',
'tog-watchmoves'              => 'Add pages I move to my watchlist',
'tog-watchdeletion'           => 'Add pages I delete to my watchlist',
'tog-minordefault'            => 'Mark all edits minor by default',
'tog-previewontop'            => 'Show preview before edit box',
'tog-previewonfirst'          => 'Show preview on first edit',
'tog-nocache'                 => 'Disable page caching',
'tog-enotifwatchlistpages'    => 'E-mail me when a page on my watchlist is changed',
'tog-enotifusertalkpages'     => 'E-mail me when my user talk page is changed',
'tog-enotifminoredits'        => 'E-mail me also for minor edits of pages',
'tog-enotifrevealaddr'        => 'Reveal my e-mail address in notification e-mails',
'tog-shownumberswatching'     => 'Show the number of watching users',
'tog-fancysig'                => 'Raw signatures (without automatic link)',
'tog-externaleditor'          => 'Use external editor by default (for experts only, needs special settings on your computer)',
'tog-externaldiff'            => 'Use external diff by default (for experts only, needs special settings on your computer)',
'tog-showjumplinks'           => 'Enable "jump to" accessibility links',
'tog-uselivepreview'          => 'Use live preview (JavaScript) (Experimental)',
'tog-forceeditsummary'        => 'Prompt me when entering a blank edit summary',
'tog-watchlisthideown'        => 'Hide my edits from the watchlist',
'tog-watchlisthidebots'       => 'Hide bot edits from the watchlist',
'tog-watchlisthideminor'      => 'Hide minor edits from the watchlist',
'tog-nolangconversion'        => 'Disable variants conversion', # only translate this message to other languages if you have to change it
'tog-ccmeonemails'            => 'Send me copies of e-mails I send to other users',
'tog-diffonly'                => 'Do not show page content below diffs',
'tog-showhiddencats'          => 'Show hidden categories',

'underline-always'  => 'Always',
'underline-never'   => 'Never',
'underline-default' => 'Browser default',

'skinpreview' => '(Preview)',

# Dates
'sunday'        => 'Sunday',
'monday'        => 'Monday',
'tuesday'       => 'Tuesday',
'wednesday'     => 'Wednesday',
'thursday'      => 'Thursday',
'friday'        => 'Friday',
'saturday'      => 'Saturday',
'sun'           => 'Sun',
'mon'           => 'Mon',
'tue'           => 'Tue',
'wed'           => 'Wed',
'thu'           => 'Thu',
'fri'           => 'Fri',
'sat'           => 'Sat',
'january'       => 'January',
'february'      => 'February',
'march'         => 'March',
'april'         => 'April',
'may_long'      => 'May',
'june'          => 'June',
'july'          => 'July',
'august'        => 'August',
'september'     => 'September',
'october'       => 'October',
'november'      => 'November',
'december'      => 'December',
'january-gen'   => 'January',
'february-gen'  => 'February',
'march-gen'     => 'March',
'april-gen'     => 'April',
'may-gen'       => 'May',
'june-gen'      => 'June',
'july-gen'      => 'July',
'august-gen'    => 'August',
'september-gen' => 'September',
'october-gen'   => 'October',
'november-gen'  => 'November',
'december-gen'  => 'December',
'jan'           => 'Jan',
'feb'           => 'Feb',
'mar'           => 'Mar',
'apr'           => 'Apr',
'may'           => 'May',
'jun'           => 'Jun',
'jul'           => 'Jul',
'aug'           => 'Aug',
'sep'           => 'Sep',
'oct'           => 'Oct',
'nov'           => 'Nov',
'dec'           => 'Dec',

# Categories related messages
'pagecategories'                 => '{{PLURAL:$1|Category|Categories}}',
'pagecategorieslink'             => 'Special:Categories', # do not translate or duplicate this message to other languages
'category_header'                => 'Pages in category "$1"',
'subcategories'                  => 'Subcategories',
'category-media-header'          => 'Media in category "$1"',
'category-empty'                 => "''This category currently contains no pages or media.''",
'hidden-categories'              => '{{PLURAL:$1|Hidden category|Hidden categories}}',
'hidden-category-category'       => 'Hidden categories', # Name of the category where hidden categories will be listed
'category-subcat-count'          => '{{PLURAL:$2|This category has only the following subcategory.|This category has the following {{PLURAL:$1|subcategory|$1 subcategories}}, out of $2 total.}}',
'category-subcat-count-limited'  => 'This category has the following {{PLURAL:$1|subcategory|$1 subcategories}}.',
'category-article-count'         => '{{PLURAL:$2|This category contains only the following page.|The following {{PLURAL:$1|page is|$1 pages are}} in this category, out of $2 total.}}',
'category-article-count-limited' => 'The following {{PLURAL:$1|page is|$1 pages are}} in the current category.',
'category-file-count'            => '{{PLURAL:$2|This category contains only the following file.|The following {{PLURAL:$1|file is|$1 files are}} in this category, out of $2 total.}}',
'category-file-count-limited'    => 'The following {{PLURAL:$1|file is|$1 files are}} in the current category.',
'listingcontinuesabbrev'         => 'cont.',

'linkprefix'        => '/^(.*?)([a-zA-Z\\x80-\\xff]+)$/sD', # only translate this message to other languages if you have to change it
'mainpagetext'      => "<big>'''MediaWiki has been successfully installed.'''</big>",
'mainpagedocfooter' => "Consult the [http://meta.wikimedia.org/wiki/Help:Contents User's Guide] for information on using the wiki software.

== Getting started ==
* [http://www.mediawiki.org/wiki/Manual:Configuration_settings Configuration settings list]
* [http://www.mediawiki.org/wiki/Manual:FAQ MediaWiki FAQ]
* [http://lists.wikimedia.org/mailman/listinfo/mediawiki-announce MediaWiki release mailing list]",

'about'          => 'About',
'article'        => 'Content page',
'newwindow'      => '(opens in new window)',
'cancel'         => 'Cancel',
'qbfind'         => 'Find',
'qbbrowse'       => 'Browse',
'qbedit'         => 'Edit',
'qbpageoptions'  => 'This page',
'qbpageinfo'     => 'Context',
'qbmyoptions'    => 'My pages',
'qbspecialpages' => 'Special pages',
'moredotdotdot'  => 'More...',
'mypage'         => 'My page',
'mytalk'         => 'My talk',
'anontalk'       => 'Talk for this IP',
'navigation'     => 'Navigation',
'and'            => 'and',

# Metadata in edit box
'metadata_help' => 'Metadata:',

'errorpagetitle'    => 'Error',
'returnto'          => 'Return to $1.',
'tagline'           => 'From {{SITENAME}}',
'help'              => 'Help',
'search'            => 'Search',
'searchbutton'      => 'Search',
'go'                => 'Go',
'searcharticle'     => 'Go',
'history'           => 'Page history',
'history_short'     => 'History',
'updatedmarker'     => 'updated since my last visit',
'info_short'        => 'Information',
'printableversion'  => 'Printable version',
'permalink'         => 'Permanent link',
'print'             => 'Print',
'edit'              => 'Edit',
'create'            => 'Create',
'editthispage'      => 'Edit this page',
'create-this-page'  => 'Create this page',
'delete'            => 'Delete',
'deletethispage'    => 'Delete this page',
'undelete_short'    => 'Undelete {{PLURAL:$1|one edit|$1 edits}}',
'protect'           => 'Protect',
'protect_change'    => 'change protection',
'protectthispage'   => 'Protect this page',
'unprotect'         => 'Unprotect',
'unprotectthispage' => 'Unprotect this page',
'newpage'           => 'New page',
'talkpage'          => 'Discuss this page',
'talkpagelinktext'  => 'Talk',
'specialpage'       => 'Special Page',
'personaltools'     => 'Personal tools',
'postcomment'       => 'Post a comment',
'addsection'        => '+', # do not translate or duplicate this message to other languages
'articlepage'       => 'View content page',
'talk'              => 'Discussion',
'views'             => 'Views',
'toolbox'           => 'Toolbox',
'userpage'          => 'View user page',
'projectpage'       => 'View project page',
'imagepage'         => 'View media page',
'mediawikipage'     => 'View message page',
'templatepage'      => 'View template page',
'viewhelppage'      => 'View help page',
'categorypage'      => 'View category page',
'viewtalkpage'      => 'View discussion',
'otherlanguages'    => 'In other languages',
'redirectedfrom'    => '(Redirected from $1)',
'redirectpagesub'   => 'Redirect page',
'lastmodifiedat'    => 'This page was last modified on $1, at $2.', # $1 date, $2 time
'viewcount'         => 'This page has been accessed {{PLURAL:$1|once|$1 times}}.',
'protectedpage'     => 'Protected page',
'jumpto'            => 'Jump to:',
'jumptonavigation'  => 'navigation',
'jumptosearch'      => 'search',

# All link text and link target definitions of links into project namespace that get used by other message strings, with the exception of user group pages (see grouppage) and the disambiguation template definition (see disambiguations).
'aboutsite'            => 'About {{SITENAME}}',
'aboutpage'            => 'Project:About',
'bugreports'           => 'Bug reports',
'bugreportspage'       => 'Project:Bug reports',
'copyright'            => 'Content is available under $1.',
'copyrightpagename'    => '{{SITENAME}} copyright',
'copyrightpage'        => '{{ns:project}}:Copyrights',
'currentevents'        => 'Current events',
'currentevents-url'    => 'Project:Current events',
'disclaimers'          => 'Disclaimers',
'disclaimerpage'       => 'Project:General disclaimer',
'edithelp'             => 'Editing help',
'edithelppage'         => 'Help:Editing',
'faq'                  => 'FAQ',
'faqpage'              => 'Project:FAQ',
'helppage'             => 'Help:Contents',
'mainpage'             => 'Main Page',
'mainpage-description' => 'Main Page',
'policy-url'           => 'Project:Policy',
'portal'               => 'Community portal',
'portal-url'           => 'Project:Community Portal',
'privacy'              => 'Privacy policy',
'privacypage'          => 'Project:Privacy policy',

'badaccess'        => 'Permission error',
'badaccess-group0' => 'You are not allowed to execute the action you have requested.',
'badaccess-group1' => 'The action you have requested is limited to users in the group $1.',
'badaccess-group2' => 'The action you have requested is limited to users in one of the groups $1.',
'badaccess-groups' => 'The action you have requested is limited to users in one of the groups $1.',

'versionrequired'     => 'Version $1 of MediaWiki required',
'versionrequiredtext' => 'Version $1 of MediaWiki is required to use this page.
See [[Special:Version|version page]].',

'ok'                           => 'OK',
'sitetitle'                    => '{{SITENAME}}', # do not translate or duplicate this message to other languages
'pagetitle'                    => '$1 - {{SITENAME}}', # only translate this message to other languages if you have to change it
'sitesubtitle'                 => '', # do not translate or duplicate this message to other languages
'retrievedfrom'                => 'Retrieved from "$1"',
'youhavenewmessages'           => 'You have $1 ($2).',
'newmessageslink'              => 'new messages',
'newmessagesdifflink'          => 'last change',
'youhavenewmessagesmulti'      => 'You have new messages on $1',
'newtalkseperator'             => ',_', # do not translate or duplicate this message to other languages
'editsection'                  => 'edit',
'editsection-brackets'         => '[$1]', # only translate this message to other languages if you have to change it
'editold'                      => 'edit',
'viewsourceold'                => 'view source',
'editsectionhint'              => 'Edit section: $1',
'toc'                          => 'Contents',
'showtoc'                      => 'show',
'hidetoc'                      => 'hide',
'thisisdeleted'                => 'View or restore $1?',
'viewdeleted'                  => 'View $1?',
'restorelink'                  => '{{PLURAL:$1|one deleted edit|$1 deleted edits}}',
'feedlinks'                    => 'Feed:',
'feed-invalid'                 => 'Invalid subscription feed type.',
'feed-unavailable'             => 'Syndication feeds are not available on {{SITENAME}}',
'site-rss-feed'                => '$1 RSS Feed',
'site-atom-feed'               => '$1 Atom Feed',
'page-rss-feed'                => '"$1" RSS Feed',
'page-atom-feed'               => '"$1" Atom Feed',
'feed-atom'                    => 'Atom', # only translate this message to other languages if you have to change it
'feed-rss'                     => 'RSS', # only translate this message to other languages if you have to change it
'sitenotice'                   => '-', # the equivalent to wgSiteNotice; do not translate or duplicate this message to other languages
'anonnotice'                   => '-', # do not translate or duplicate this message to other languages
'newsectionheaderdefaultlevel' => '== $1 ==', # do not translate or duplicate this message to other languages
'red-link-title'               => '$1 (not yet written)',

# Short words for each namespace, by default used in the namespace tab in monobook
'nstab-main'      => 'Page',
'nstab-user'      => 'User page',
'nstab-media'     => 'Media page',
'nstab-special'   => 'Special',
'nstab-project'   => 'Project page',
'nstab-image'     => 'File',
'nstab-mediawiki' => 'Message',
'nstab-template'  => 'Template',
'nstab-help'      => 'Help page',
'nstab-category'  => 'Category',

# Main script and global functions
'nosuchaction'      => 'No such action',
'nosuchactiontext'  => 'The action specified by the URL is not recognized by the wiki',
'nosuchspecialpage' => 'No such special page',
'nospecialpagetext' => "<big>'''You have requested an invalid special page.'''</big>

A list of valid special pages can be found at [[Special:SpecialPages|{{int:specialpages}}]].",

# General errors
'error'                => 'Error',
'databaseerror'        => 'Database error',
'dberrortext'          => 'A database query syntax error has occurred.
This may indicate a bug in the software.
The last attempted database query was:
<blockquote><tt>$1</tt></blockquote>
from within function "<tt>$2</tt>".
MySQL returned error "<tt>$3: $4</tt>".',
'dberrortextcl'        => 'A database query syntax error has occurred.
The last attempted database query was:
"$1"
from within function "$2".
MySQL returned error "$3: $4"',
'noconnect'            => 'Sorry! The wiki is experiencing some technical difficulties, and cannot contact the database server.<br />
$1',
'nodb'                 => 'Could not select database $1',
'cachederror'          => 'The following is a cached copy of the requested page, and may not be up to date.',
'laggedslavemode'      => 'Warning: Page may not contain recent updates.',
'readonly'             => 'Database locked',
'enterlockreason'      => 'Enter a reason for the lock, including an estimate of when the lock will be released',
'readonlytext'         => 'The database is currently locked to new entries and other modifications, probably for routine database maintenance, after which it will be back to normal.

The administrator who locked it offered this explanation: $1',
'missing-article'      => 'The database did not find the text of a page that it should have found, named "$1" $2.

This is usually caused by following an outdated diff or history link to a page that has been deleted.

If this is not the case, you may have found a bug in the software.
Please report this to an [[Special:ListUsers/sysop|administrator]], making note of the URL.',
'missingarticle-rev'   => '(revision#: $1)',
'missingarticle-diff'  => '(Diff: $1, $2)',
'readonly_lag'         => 'The database has been automatically locked while the slave database servers catch up to the master',
'internalerror'        => 'Internal error',
'internalerror_info'   => 'Internal error: $1',
'filecopyerror'        => 'Could not copy file "$1" to "$2".',
'filerenameerror'      => 'Could not rename file "$1" to "$2".',
'filedeleteerror'      => 'Could not delete file "$1".',
'directorycreateerror' => 'Could not create directory "$1".',
'filenotfound'         => 'Could not find file "$1".',
'fileexistserror'      => 'Unable to write to file "$1": file exists',
'unexpected'           => 'Unexpected value: "$1"="$2".',
'formerror'            => 'Error: could not submit form',
'badarticleerror'      => 'This action cannot be performed on this page.',
'cannotdelete'         => 'Could not delete the page or file specified.
It may have already been deleted by someone else.',
'badtitle'             => 'Bad title',
'badtitletext'         => 'The requested page title was invalid, empty, or an incorrectly linked inter-language or inter-wiki title.
It may contain one or more characters which cannot be used in titles.',
'perfdisabled'         => 'Sorry! This feature has been temporarily disabled because it slows the database down to the point that no one can use the wiki.',
'perfcached'           => 'The following data is cached and may not be up to date.',
'perfcachedts'         => 'The following data is cached, and was last updated $1.',
'querypage-no-updates' => 'Updates for this page are currently disabled.
Data here will not presently be refreshed.',
'wrong_wfQuery_params' => 'Incorrect parameters to wfQuery()<br />
Function: $1<br />
Query: $2',
'viewsource'           => 'View source',
'viewsourcefor'        => 'for $1',
'actionthrottled'      => 'Action throttled',
'actionthrottledtext'  => 'As an anti-spam measure, you are limited from performing this action too many times in a short space of time, and you have exceeded this limit.
Please try again in a few minutes.',
'protectedpagetext'    => 'This page has been locked to prevent editing.',
'viewsourcetext'       => 'You can view and copy the source of this page:',
'protectedinterface'   => 'This page provides interface text for the software, and is locked to prevent abuse.',
'editinginterface'     => "'''Warning:''' You are editing a page which is used to provide interface text for the software.
Changes to this page will affect the appearance of the user interface for other users.
For translations, please consider using [http://translatewiki.net/wiki/Main_Page?setlang=en Betawiki], the MediaWiki localisation project.",
'sqlhidden'            => '(SQL query hidden)',
'cascadeprotected'     => 'This page has been protected from editing, because it is included in the following {{PLURAL:$1|page, which is|pages, which are}} protected with the "cascading" option turned on:
$2',
'namespaceprotected'   => "You do not have permission to edit pages in the '''$1''' namespace.",
'customcssjsprotected' => "You do not have permission to edit this page, because it contains another user's personal settings.",
'ns-specialprotected'  => 'Special pages cannot be edited.',
'titleprotected'       => "This title has been protected from creation by [[User:$1|$1]].
The reason given is ''$2''.",

# Virus scanner
'virus-badscanner'     => 'Bad configuration: unknown virus scanner: <i>$1</i>',
'virus-scanfailed'     => 'scan failed (code $1)',
'virus-unknownscanner' => 'unknown antivirus:',

# Login and logout pages
'logouttitle'                => 'User logout',
'logouttext'                 => '<strong>You are now logged out.</strong>

You can continue to use {{SITENAME}} anonymously, or you can [[Special:UserLogin|log in again]] as the same or as a different user.
Note that some pages may continue to be displayed as if you were still logged in, until you clear your browser cache.',
'welcomecreation'            => '== Welcome, $1! ==
Your account has been created.
Do not forget to change your [[Special:Preferences|{{SITENAME}} preferences]].',
'loginpagetitle'             => 'User login',
'yourname'                   => 'Username:',
'yourpassword'               => 'Password:',
'yourpasswordagain'          => 'Retype password:',
'remembermypassword'         => 'Remember my login on this computer',
'yourdomainname'             => 'Your domain:',
'externaldberror'            => 'There was either an external authentication database error or you are not allowed to update your external account.',
'loginproblem'               => '<b>There has been a problem with your login.</b><br />Try again!',
'login'                      => 'Log in',
'nav-login-createaccount'    => 'Log in / create account',
'loginprompt'                => 'You must have cookies enabled to log in to {{SITENAME}}.',
'userlogin'                  => 'Log in / create account',
'logout'                     => 'Log out',
'userlogout'                 => 'Log out',
'notloggedin'                => 'Not logged in',
'nologin'                    => "Don't have a login? $1.",
'nologinlink'                => 'Create an account',
'createaccount'              => 'Create account',
'gotaccount'                 => 'Already have an account? $1.',
'gotaccountlink'             => 'Log in',
'createaccountmail'          => 'by e-mail',
'badretype'                  => 'The passwords you entered do not match.',
'userexists'                 => 'Username entered already in use.
Please choose a different name.',
'youremail'                  => 'E-mail:',
'username'                   => 'Username:',
'uid'                        => 'User ID:',
'prefs-memberingroups'       => 'Member of {{PLURAL:$1|group|groups}}:',
'yourrealname'               => 'Real name:',
'yourlanguage'               => 'Language:',
'yourvariant'                => 'Variant:', # only translate this message to other languages if you have to change it
'yournick'                   => 'Signature:',
'badsig'                     => 'Invalid raw signature; check HTML tags.',
'badsiglength'               => 'The signature is too long.
It must be under $1 {{PLURAL:$1|character|characters}}.',
'email'                      => 'E-mail',
'prefs-help-realname'        => 'Real name is optional.
If you choose to provide it, this will be used for giving you attribution for your work.',
'loginerror'                 => 'Login error',
'prefs-help-email'           => 'E-mail address is optional, but it enables others to contact you through your user or user_talk page without needing to reveal your identity.',
'prefs-help-email-required'  => 'E-mail address is required.',
'nocookiesnew'               => 'The user account was created, but you are not logged in.
{{SITENAME}} uses cookies to log in users.
You have cookies disabled.
Please enable them, then log in with your new username and password.',
'nocookieslogin'             => '{{SITENAME}} uses cookies to log in users.
You have cookies disabled.
Please enable them and try again.',
'noname'                     => 'You have not specified a valid user name.',
'loginsuccesstitle'          => 'Login successful',
'loginsuccess'               => "'''You are now logged in to {{SITENAME}} as \"\$1\".'''",
'nosuchuser'                 => 'There is no user by the name "$1".
Check your spelling, or create a new account.',
'nosuchusershort'            => 'There is no user by the name "<nowiki>$1</nowiki>".
Check your spelling.',
'nouserspecified'            => 'You have to specify a username.',
'wrongpassword'              => 'Incorrect password entered.
Please try again.',
'wrongpasswordempty'         => 'Password entered was blank.
Please try again.',
'passwordtooshort'           => 'Your password is invalid or too short.
It must have at least {{PLURAL:$1|1 character|$1 characters}} and be different from your username.',
'mailmypassword'             => 'E-mail password',
'passwordremindertitle'      => 'New temporary password for {{SITENAME}}',
'passwordremindertext'       => 'Someone (probably you, from IP address $1)
requested that we send you a new password for {{SITENAME}} ($4).
The password for user "$2" is now "$3".
You should log in and change your password now.

If someone else made this request or if you have remembered your password and you no longer wish to change it, you may ignore this message and continue using your old password.',
'noemail'                    => 'There is no e-mail address recorded for user "$1".',
'passwordsent'               => 'A new password has been sent to the e-mail address registered for "$1".
Please log in again after you receive it.',
'blocked-mailpassword'       => 'Your IP address is blocked from editing, and so is not allowed to use the password recovery function to prevent abuse.',
'eauthentsent'               => 'A confirmation e-mail has been sent to the nominated e-mail address.
Before any other e-mail is sent to the account, you will have to follow the instructions in the e-mail, to confirm that the account is actually yours.',
'throttled-mailpassword'     => 'A password reminder has already been sent, within the last {{PLURAL:$1|hour|$1 hours}}.
To prevent abuse, only one password reminder will be sent per {{PLURAL:$1|hour|$1 hours}}.',
'loginstart'                 => '', # do not translate or duplicate this message to other languages
'loginend'                   => '', # do not translate or duplicate this message to other languages
'signupend'                  => '{{int:loginend}}', # do not translate or duplicate this message to other languages
'mailerror'                  => 'Error sending mail: $1',
'acct_creation_throttle_hit' => 'Sorry, you have already created $1 accounts.
You cannot make any more.',
'emailauthenticated'         => 'Your e-mail address was authenticated on $1.',
'emailnotauthenticated'      => 'Your e-mail address is not yet authenticated.
No e-mail will be sent for any of the following features.',
'noemailprefs'               => 'Specify an e-mail address for these features to work.',
'emailconfirmlink'           => 'Confirm your e-mail address',
'invalidemailaddress'        => 'The e-mail address cannot be accepted as it appears to have an invalid format.
Please enter a well-formatted address or empty that field.',
'accountcreated'             => 'Account created',
'accountcreatedtext'         => 'The user account for $1 has been created.',
'createaccount-title'        => 'Account creation for {{SITENAME}}',
'createaccount-text'         => 'Someone created an account for your e-mail address on {{SITENAME}} ($4) named "$2", with password "$3".
You should log in and change your password now.

You may ignore this message, if this account was created in error.',
'loginlanguagelabel'         => 'Language: $1',
'loginlanguagelinks'         => '* Deutsch|de
* English|en
* Esperanto|eo
* Français|fr
* Español|es
* Italiano|it
* Nederlands|nl', # do not translate or duplicate this message to other languages

# Password reset dialog
'resetpass'               => 'Reset account password',
'resetpass_announce'      => 'You logged in with a temporary e-mailed code.
To finish logging in, you must set a new password here:',
'resetpass_text'          => '<!-- Add text here -->', # only translate this message to other languages if you have to change it
'resetpass_header'        => 'Reset password',
'resetpass_submit'        => 'Set password and log in',
'resetpass_success'       => 'Your password has been changed successfully! Now logging you in...',
'resetpass_bad_temporary' => 'Invalid temporary password.
You may have already successfully changed your password or requested a new temporary password.',
'resetpass_forbidden'     => 'Passwords cannot be changed on {{SITENAME}}',
'resetpass_missing'       => 'No form data.',

# Edit page toolbar
'bold_sample'     => 'Bold text',
'bold_tip'        => 'Bold text',
'italic_sample'   => 'Italic text',
'italic_tip'      => 'Italic text',
'link_sample'     => 'Link title',
'link_tip'        => 'Internal link',
'extlink_sample'  => 'http://www.example.com link title',
'extlink_tip'     => 'External link (remember http:// prefix)',
'headline_sample' => 'Headline text',
'headline_tip'    => 'Level 2 headline',
'math_sample'     => 'Insert formula here',
'math_tip'        => 'Mathematical formula (LaTeX)',
'nowiki_sample'   => 'Insert non-formatted text here',
'nowiki_tip'      => 'Ignore wiki formatting',
'image_sample'    => 'Example.jpg', # only translate this message to other languages if you have to change it
'image_tip'       => 'Embedded file',
'media_sample'    => 'Example.ogg', # only translate this message to other languages if you have to change it
'media_tip'       => 'File link',
'sig_tip'         => 'Your signature with timestamp',
'hr_tip'          => 'Horizontal line (use sparingly)',

# Edit pages
'summary'                          => 'Summary',
'subject'                          => 'Subject/headline',
'minoredit'                        => 'This is a minor edit',
'watchthis'                        => 'Watch this page',
'savearticle'                      => 'Save page',
'preview'                          => 'Preview',
'showpreview'                      => 'Show preview',
'showlivepreview'                  => 'Live preview',
'showdiff'                         => 'Show changes',
'anoneditwarning'                  => "'''Warning:''' You are not logged in.
Your IP address will be recorded in this page's edit history.",
'missingsummary'                   => "'''Reminder:''' You have not provided an edit summary.
If you click Save again, your edit will be saved without one.",
'missingcommenttext'               => 'Please enter a comment below.',
'missingcommentheader'             => "'''Reminder:''' You have not provided a subject/headline for this comment.
If you click Save again, your edit will be saved without one.",
'summary-preview'                  => 'Summary preview',
'subject-preview'                  => 'Subject/headline preview',
'blockedtitle'                     => 'User is blocked',
'blockedtext'                      => "<big>'''Your user name or IP address has been blocked.'''</big>

The block was made by $1.
The reason given is ''$2''.

* Start of block: $8
* Expiry of block: $6
* Intended blockee: $7

You can contact $1 or another [[{{MediaWiki:Grouppage-sysop}}|administrator]] to discuss the block.
You cannot use the 'e-mail this user' feature unless a valid e-mail address is specified in your [[Special:Preferences|account preferences]] and you have not been blocked from using it.
Your current IP address is $3, and the block ID is #$5.
Please include all above details in any queries you make.",
'autoblockedtext'                  => 'Your IP address has been automatically blocked because it was used by another user, who was blocked by $1.
The reason given is this:

:\'\'$2\'\'

* Start of block: $8
* Expiry of block: $6
* Intended blockee: $7

You may contact $1 or one of the other [[{{MediaWiki:Grouppage-sysop}}|administrators]] to discuss the block.

Note that you may not use the "e-mail this user" feature unless you have a valid e-mail address registered in your [[Special:Preferences|user preferences]] and you have not been blocked from using it.

Your current IP address is $3, and the block ID is #$5.
Please include all above details in any queries you make.',
'blockednoreason'                  => 'no reason given',
'blockedoriginalsource'            => "The source of '''$1''' is shown below:",
'blockededitsource'                => "The text of '''your edits''' to '''$1''' is shown below:",
'whitelistedittitle'               => 'Login required to edit',
'whitelistedittext'                => 'You have to $1 to edit pages.',
'confirmedittitle'                 => 'E-mail confirmation required to edit',
'confirmedittext'                  => 'You must confirm your e-mail address before editing pages.
Please set and validate your e-mail address through your [[Special:Preferences|user preferences]].',
'nosuchsectiontitle'               => 'No such section',
'nosuchsectiontext'                => 'You tried to edit a section that does not exist.
Since there is no section $1, there is no place to save your edit.',
'loginreqtitle'                    => 'Login Required',
'loginreqlink'                     => 'log in',
'loginreqpagetext'                 => 'You must $1 to view other pages.',
'accmailtitle'                     => 'Password sent.',
'accmailtext'                      => 'The password for "$1" has been sent to $2.',
'newarticle'                       => '(New)',
'newarticletext'                   => "You have followed a link to a page that does not exist yet.
To create the page, start typing in the box below (see the [[{{MediaWiki:Helppage}}|help page]] for more info).
If you are here by mistake, click your browser's '''back''' button.",
'newarticletextanon'               => '{{int:newarticletext}}', # do not translate or duplicate this message to other languages
'talkpagetext'                     => '<!-- MediaWiki:talkpagetext -->', # do not translate or duplicate this message to other languages
'anontalkpagetext'                 => "----''This is the discussion page for an anonymous user who has not created an account yet, or who does not use it.
We therefore have to use the numerical IP address to identify him/her.
Such an IP address can be shared by several users.
If you are an anonymous user and feel that irrelevant comments have been directed at you, please [[Special:UserLogin/signup|create an account]] or [[Special:UserLogin|log in]] to avoid future confusion with other anonymous users.''",
'noarticletext'                    => 'There is currently no text in this page, you can [[Special:Search/{{PAGENAME}}|search for this page title]] in other pages or [{{fullurl:{{FULLPAGENAME}}|action=edit}} edit this page].',
'noarticletextanon'                => '{{int:noarticletext}}', # do not translate or duplicate this message to other languages
'userpage-userdoesnotexist'        => 'User account "$1" is not registered.
Please check if you want to create/edit this page.',
'clearyourcache'                   => "'''Note - After saving, you may have to bypass your browser's cache to see the changes.''' '''Mozilla / Firefox / Safari:''' hold ''Shift'' while clicking ''Reload,'' or press either ''Ctrl-F5'' or ''Ctrl-R'' (''Command-R'' on a Macintosh); '''Konqueror: '''click ''Reload'' or press ''F5;'' '''Opera:''' clear the cache in ''Tools → Preferences;'' '''Internet Explorer:''' hold ''Ctrl'' while clicking ''Refresh,'' or press ''Ctrl-F5.''",
'usercssjsyoucanpreview'           => "<strong>Tip:</strong> Use the 'Show preview' button to test your new CSS/JS before saving.",
'usercsspreview'                   => "'''Remember that you are only previewing your user CSS, it has not yet been saved!'''",
'userjspreview'                    => "'''Remember that you are only testing/previewing your user JavaScript, it has not yet been saved!'''",
'userinvalidcssjstitle'            => "'''Warning:''' There is no skin \"\$1\".
Remember that custom .css and .js pages use a lowercase title, e.g. {{ns:user}}:Foo/monobook.css as opposed to {{ns:user}}:Foo/Monobook.css.",
'updated'                          => '(Updated)',
'note'                             => '<strong>Note:</strong>',
'previewnote'                      => '<strong>This is only a preview;
changes have not yet been saved!</strong>',
'previewconflict'                  => 'This preview reflects the text in the upper text editing area as it will appear if you choose to save.',
'session_fail_preview'             => '<strong>Sorry! We could not process your edit due to a loss of session data.
Please try again.
If it still does not work, try [[Special:UserLogout|logging out]] and logging back in.</strong>',
'session_fail_preview_html'        => "<strong>Sorry! We could not process your edit due to a loss of session data.</strong>

''Because {{SITENAME}} has raw HTML enabled, the preview is hidden as a precaution against JavaScript attacks.''

<strong>If this is a legitimate edit attempt, please try again.
If it still does not work, try [[Special:UserLogout|logging out]] and logging back in.</strong>",
'token_suffix_mismatch'            => '<strong>Your edit has been rejected because your client mangled the punctuation characters in the edit token.
The edit has been rejected to prevent corruption of the page text.
This sometimes happens when you are using a buggy web-based anonymous proxy service.</strong>',
'editing'                          => 'Editing $1',
'editingsection'                   => 'Editing $1 (section)',
'editingcomment'                   => 'Editing $1 (comment)',
'editconflict'                     => 'Edit conflict: $1',
'explainconflict'                  => "Someone else has changed this page since you started editing it.
The upper text area contains the page text as it currently exists.
Your changes are shown in the lower text area.
You will have to merge your changes into the existing text.
'''Only''' the text in the upper text area will be saved when you press \"Save page\".",
'yourtext'                         => 'Your text',
'storedversion'                    => 'Stored version',
'nonunicodebrowser'                => '<strong>WARNING: Your browser is not unicode compliant.
A workaround is in place to allow you to safely edit pages: non-ASCII characters will appear in the edit box as hexadecimal codes.</strong>',
'editingold'                       => '<strong>WARNING: You are editing an out-of-date revision of this page.
If you save it, any changes made since this revision will be lost.</strong>',
'yourdiff'                         => 'Differences',
'copyrightwarning'                 => 'Please note that all contributions to {{SITENAME}} are considered to be released under the $2 (see $1 for details).
If you do not want your writing to be edited mercilessly and redistributed at will, then do not submit it here.<br />
You are also promising us that you wrote this yourself, or copied it from a public domain or similar free resource.
<strong>DO NOT SUBMIT COPYRIGHTED WORK WITHOUT PERMISSION!</strong>',
'copyrightwarning2'                => 'Please note that all contributions to {{SITENAME}} may be edited, altered, or removed by other contributors.
If you do not want your writing to be edited mercilessly, then do not submit it here.<br />
You are also promising us that you wrote this yourself, or copied it from a public domain or similar free resource (see $1 for details).
<strong>DO NOT SUBMIT COPYRIGHTED WORK WITHOUT PERMISSION!</strong>',
'longpagewarning'                  => '<strong>WARNING: This page is $1 kilobytes long;
some browsers may have problems editing pages approaching or longer than 32kb.
Please consider breaking the page into smaller sections.</strong>',
'longpageerror'                    => '<strong>ERROR: The text you have submitted is $1 kilobytes long, which is longer than the maximum of $2 kilobytes.
It cannot be saved.</strong>',
'readonlywarning'                  => '<strong>WARNING: The database has been locked for maintenance, so you will not be able to save your edits right now.
You may wish to cut-n-paste the text into a text file and save it for later.</strong>',
'protectedpagewarning'             => '<strong>WARNING: This page has been locked so that only users with sysop privileges can edit it.</strong>',
'semiprotectedpagewarning'         => "'''Note:''' This page has been locked so that only registered users can edit it.",
'cascadeprotectedwarning'          => "'''Warning:''' This page has been locked so that only users with sysop privileges can edit it, because it is included in the following cascade-protected {{PLURAL:$1|page|pages}}:",
'titleprotectedwarning'            => '<strong>WARNING:  This page has been locked so that only some users can create it.</strong>',
'templatesused'                    => 'Templates used on this page:',
'templatesusedpreview'             => 'Templates used in this preview:',
'templatesusedsection'             => 'Templates used in this section:',
'template-protected'               => '(protected)',
'template-semiprotected'           => '(semi-protected)',
'hiddencategories'                 => 'This page is a member of {{PLURAL:$1|1 hidden category|$1 hidden categories}}:',
'edittools'                        => '<!-- Text here will be shown below edit and upload forms. -->', # only translate this message to other languages if you have to change it
'nocreatetitle'                    => 'Page creation limited',
'nocreatetext'                     => '{{SITENAME}} has restricted the ability to create new pages.
You can go back and edit an existing page, or [[Special:UserLogin|log in or create an account]].',
'nocreate-loggedin'                => 'You do not have permission to create new pages on {{SITENAME}}.',
'permissionserrors'                => 'Permissions Errors',
'permissionserrorstext'            => 'You do not have permission to do that, for the following {{PLURAL:$1|reason|reasons}}:',
'permissionserrorstext-withaction' => 'You do not have permission to $2, for the following {{PLURAL:$1|reason|reasons}}:',
'recreate-deleted-warn'            => "'''Warning: You are recreating a page that was previously deleted.'''

You should consider whether it is appropriate to continue editing this page.
The deletion log for this page is provided here for convenience:",

# Parser/template warnings
'expensive-parserfunction-warning'        => 'Warning: This page contains too many expensive parser function calls.

It should have less than $2, there are now $1.',
'expensive-parserfunction-category'       => 'Pages with too many expensive parser function calls',
'post-expand-template-inclusion-warning'  => 'Warning: Template include size is too large.
Some templates will not be included.',
'post-expand-template-inclusion-category' => 'Pages where template include size is exceeded',
'post-expand-template-argument-warning'   => 'Warning: This page contains at least one template argument which has a too large expansion size.
These arguments have been omitted.',
'post-expand-template-argument-category'  => 'Pages containing omitted template arguments',

# "Undo" feature
'undo-success' => 'The edit can be undone.
Please check the comparison below to verify that this is what you want to do, and then save the changes below to finish undoing the edit.',
'undo-failure' => 'The edit could not be undone due to conflicting intermediate edits.',
'undo-norev'   => 'The edit could not be undone because it does not exist or was deleted.',
'undo-summary' => 'Undo revision $1 by [[Special:Contributions/$2|$2]] ([[User talk:$2|Talk]])',

# Account creation failure
'cantcreateaccounttitle'          => 'Cannot create account',
'cantcreateaccount-text'          => "Account creation from this IP address ('''$1''') has been blocked by [[User:$3|$3]].

The reason given by $3 is ''$2''",
'cantcreateaccount-nonblock-text' => '', # do not translate or duplicate this message to other languages

# History pages
'viewpagelogs'          => 'View logs for this page',
'nohistory'             => 'There is no edit history for this page.',
'revnotfound'           => 'Revision not found',
'revnotfoundtext'       => 'The old revision of the page you asked for could not be found.
Please check the URL you used to access this page.',
'currentrev'            => 'Current revision',
'revisionasof'          => 'Revision as of $1',
'revision-info'         => 'Revision as of $1 by $2',
'revision-info-current' => '-', # do not translate or duplicate this message to other languages
'revision-nav'          => '($1) $2 | $3 ($4) | $5 ($6)', # do not translate or duplicate this message to other languages
'previousrevision'      => '←Older revision',
'nextrevision'          => 'Newer revision→',
'currentrevisionlink'   => 'Current revision',
'cur'                   => 'cur',
'next'                  => 'next',
'last'                  => 'last',
'page_first'            => 'first',
'page_last'             => 'last',
'histlegend'            => 'Diff selection: mark the radio boxes of the versions to compare and hit enter or the button at the bottom.<br />
Legend: (cur) = difference with current version,
(last) = difference with preceding version, M = minor edit.',
'history_copyright'     => '-', # do not translate or duplicate this message to other languages
'deletedrev'            => '[deleted]',
'histfirst'             => 'Earliest',
'histlast'              => 'Latest',
'historysize'           => '({{PLURAL:$1|1 byte|$1 bytes}})',
'historyempty'          => '(empty)',

# Revision feed
'history-feed-title'          => 'Revision history',
'history-feed-description'    => 'Revision history for this page on the wiki',
'history-feed-item-nocomment' => '$1 at $2', # user at time
'history-feed-empty'          => 'The requested page does not exist.
It may have been deleted from the wiki, or renamed.
Try [[Special:Search|searching on the wiki]] for relevant new pages.',

# Revision deletion
'rev-deleted-comment'         => '(comment removed)',
'rev-deleted-user'            => '(username removed)',
'rev-deleted-event'           => '(log action removed)',
'rev-deleted-text-permission' => '<div class="mw-warning plainlinks">
This page revision has been removed from the public archives.
There may be details in the [{{fullurl:Special:Log/delete|page={{FULLPAGENAMEE}}}} deletion log].</div>',
'rev-deleted-text-view'       => '<div class="mw-warning plainlinks">
This page revision has been removed from the public archives.
As an administrator on {{SITENAME}} you can view it;
there may be details in the [{{fullurl:Special:Log/delete|page={{FULLPAGENAMEE}}}} deletion log].</div>',
'rev-delundel'                => 'show/hide',
'revisiondelete'              => 'Delete/undelete revisions',
'revdelete-nooldid-title'     => 'Invalid target revision',
'revdelete-nooldid-text'      => 'You have either not specified a target revision(s) to perform this
function, the specified revision does not exist, or you are attempting to hide the current revision.',
'revdelete-selected'          => '{{PLURAL:$2|Selected revision|Selected revisions}} of [[:$1]]:',
'logdelete-selected'          => '{{PLURAL:$1|Selected log event|Selected log events}}:',
'revdelete-text'              => 'Deleted revisions and events will still appear in the page history and logs, but parts of their content will be inaccessible to the public.

Other admins on {{SITENAME}} will still be able to access the hidden content and can undelete it again through this same interface, unless additional restrictions are set.',
'revdelete-legend'            => 'Set visibility restrictions',
'revdelete-hide-text'         => 'Hide revision text',
'revdelete-hide-name'         => 'Hide action and target',
'revdelete-hide-comment'      => 'Hide edit comment',
'revdelete-hide-user'         => "Hide editor's username/IP",
'revdelete-hide-restricted'   => 'Apply these restrictions to Sysops and lock this interface',
'revdelete-suppress'          => 'Suppress data from Sysops as well as others',
'revdelete-hide-image'        => 'Hide file content',
'revdelete-unsuppress'        => 'Remove restrictions on restored revisions',
'revdelete-log'               => 'Log comment:',
'revdelete-submit'            => 'Apply to selected revision',
'revdelete-logentry'          => 'changed revision visibility of [[$1]]',
'logdelete-logentry'          => 'changed event visibility of [[$1]]',
'revdelete-success'           => "'''Revision visibility successfully set.'''",
'logdelete-success'           => "'''Log visibility successfully set.'''",
'revdel-restore'              => 'Change visibility',
'pagehist'                    => 'Page history',
'deletedhist'                 => 'Deleted history',
'revdelete-content'           => 'content',
'revdelete-summary'           => 'edit summary',
'revdelete-uname'             => 'username',
'revdelete-restricted'        => 'applied restrictions to sysops',
'revdelete-unrestricted'      => 'removed restrictions for sysops',
'revdelete-hid'               => 'hid $1',
'revdelete-unhid'             => 'unhid $1',
'revdelete-log-message'       => '$1 for $2 {{PLURAL:$2|revision|revisions}}',
'logdelete-log-message'       => '$1 for $2 {{PLURAL:$2|event|events}}',

# Suppression log
'suppressionlog'     => 'Suppression log',
'suppressionlogtext' => 'Below is a list of deletions and blocks involving content hidden from sysops.
See the [[Special:IPBlockList|IP block list]] for the list of currently operational bans and blocks.',

# History merging
'mergehistory'                     => 'Merge page histories',
'mergehistory-header'              => 'This page lets you merge revisions of the history of one source page into a newer page.
Make sure that this change will maintain historical page continuity.',
'mergehistory-box'                 => 'Merge revisions of two pages:',
'mergehistory-from'                => 'Source page:',
'mergehistory-into'                => 'Destination page:',
'mergehistory-list'                => 'Mergeable edit history',
'mergehistory-merge'               => 'The following revisions of [[:$1]] can be merged into [[:$2]].
Use the radio button column to merge in only the revisions created at and before the specified time.
Note that using the navigation links will reset this column.',
'mergehistory-go'                  => 'Show mergeable edits',
'mergehistory-submit'              => 'Merge revisions',
'mergehistory-empty'               => 'No revisions can be merged.',
'mergehistory-success'             => '$3 {{PLURAL:$3|revision|revisions}} of [[:$1]] successfully merged into [[:$2]].',
'mergehistory-fail'                => 'Unable to perform history merge, please recheck the page and time parameters.',
'mergehistory-no-source'           => 'Source page $1 does not exist.',
'mergehistory-no-destination'      => 'Destination page $1 does not exist.',
'mergehistory-invalid-source'      => 'Source page must be a valid title.',
'mergehistory-invalid-destination' => 'Destination page must be a valid title.',
'mergehistory-autocomment'         => 'Merged [[:$1]] into [[:$2]]',
'mergehistory-comment'             => 'Merged [[:$1]] into [[:$2]]: $3',

# Merge log
'mergelog'           => 'Merge log',
'pagemerge-logentry' => 'merged [[$1]] into [[$2]] (revisions up to $3)',
'revertmerge'        => 'Unmerge',
'mergelogpagetext'   => 'Below is a list of the most recent merges of one page history into another.',

# Diffs
'history-title'           => 'Revision history of "$1"',
'difference'              => '(Difference between revisions)',
'lineno'                  => 'Line $1:',
'compareselectedversions' => 'Compare selected versions',
'editundo'                => 'undo',
'diff-multi'              => '({{PLURAL:$1|One intermediate revision|$1 intermediate revisions}} not shown.)',

# Search results
'searchresults'             => 'Search results',
'searchresulttext'          => 'For more information about searching {{SITENAME}}, see [[{{MediaWiki:Helppage}}|{{int:help}}]].',
'searchsubtitle'            => 'You searched for \'\'\'[[:$1]]\'\'\' ([[Special:Prefixindex/$1|all pages starting with "$1"]] | [[Special:WhatLinksHere/$1|all pages that link to "$1"]])',
'searchsubtitleinvalid'     => "You searched for '''$1'''",
'noexactmatch'              => "'''There is no page titled \"\$1\".'''
You can [[:\$1|create this page]].",
'noexactmatch-nocreate'     => "'''There is no page titled \"\$1\".'''",
'toomanymatches'            => 'Too many matches were returned, please try a different query',
'titlematches'              => 'Page title matches',
'notitlematches'            => 'No page title matches',
'textmatches'               => 'Page text matches',
'notextmatches'             => 'No page text matches',
'prevn'                     => 'previous $1',
'nextn'                     => 'next $1',
'viewprevnext'              => 'View ($1) ($2) ($3)',
'search-result-size'        => '$1 ({{PLURAL:$2|1 word|$2 words}})',
'search-result-score'       => 'Relevance: $1%',
'search-redirect'           => '(redirect $1)',
'search-section'            => '(section $1)',
'search-suggest'            => 'Did you mean: $1',
'search-interwiki-caption'  => 'Sister projects',
'search-interwiki-default'  => '$1 results:',
'search-interwiki-custom'   => '', # do not translate or duplicate this message to other languages
'search-interwiki-more'     => '(more)',
'search-mwsuggest-enabled'  => 'with suggestions',
'search-mwsuggest-disabled' => 'no suggestions',
'search-relatedarticle'     => 'Related',
'mwsuggest-disable'         => 'Disable AJAX suggestions',
'searchrelated'             => 'related',
'searchall'                 => 'all',
'showingresults'            => "Showing below up to {{PLURAL:$1|'''1''' result|'''$1''' results}} starting with #'''$2'''.",
'showingresultsnum'         => "Showing below {{PLURAL:$3|'''1''' result|'''$3''' results}} starting with #'''$2'''.",
'showingresultstotal'       => "Showing below {{PLURAL:$3|result '''$1''' of '''$3'''|results '''$1 - $2''' of '''$3'''}}",
'nonefound'                 => "'''Note''': Only some namespaces are searched by default.
Try prefixing your query with ''all:'' to search all content (including talk pages, templates, etc), or use the desired namespace as prefix.",
'powersearch'               => 'Advanced search',
'powersearch-legend'        => 'Advanced search',
'powersearch-ns'            => 'Search in namespaces:',
'powersearch-redir'         => 'List redirects',
'powersearch-field'         => 'Search for',
'search-external'           => 'External search',
'searchdisabled'            => '{{SITENAME}} search is disabled.
You can search via Google in the meantime.
Note that their indexes of {{SITENAME}} content may be out of date.',
'googlesearch'              => '<form method="get" action="http://www.google.com/search" id="googlesearch">
    <input type="hidden" name="domains" value="{{SERVER}}" />
    <input type="hidden" name="num" value="50" />
    <input type="hidden" name="ie" value="$2" />
    <input type="hidden" name="oe" value="$2" />

    <input type="text" name="q" size="31" maxlength="255" value="$1" />
    <input type="submit" name="btnG" value="$3" />
  <div>
    <input type="radio" name="sitesearch" id="gwiki" value="{{SERVER}}" checked="checked" /><label for="gwiki">{{SITENAME}}</label>
    <input type="radio" name="sitesearch" id="gWWW" value="" /><label for="gWWW">WWW</label>
  </div>
</form>', # do not translate or duplicate this message to other languages

# OpenSearch description
'opensearch-desc' => '{{SITENAME}} ({{CONTENTLANGUAGE}})', # do not translate or duplicate this message to other languages

# Preferences page
'preferences'              => 'Preferences',
'preferences-summary'      => '', # do not translate or duplicate this message to other languages
'mypreferences'            => 'My preferences',
'prefs-edits'              => 'Number of edits:',
'prefsnologin'             => 'Not logged in',
'prefsnologintext'         => 'You must be [[Special:UserLogin|logged in]] to set user preferences.',
'prefsreset'               => 'Preferences have been reset from storage.',
'qbsettings'               => 'Quickbar',
'qbsettings-none'          => 'None',
'qbsettings-fixedleft'     => 'Fixed left',
'qbsettings-fixedright'    => 'Fixed right',
'qbsettings-floatingleft'  => 'Floating left',
'qbsettings-floatingright' => 'Floating right',
'changepassword'           => 'Change password',
'skin'                     => 'Skin',
'math'                     => 'Math',
'dateformat'               => 'Date format',
'datedefault'              => 'No preference',
'datetime'                 => 'Date and time',
'math_failure'             => 'Failed to parse',
'math_unknown_error'       => 'unknown error',
'math_unknown_function'    => 'unknown function',
'math_lexing_error'        => 'lexing error',
'math_syntax_error'        => 'syntax error',
'math_image_error'         => 'PNG conversion failed;
check for correct installation of latex, dvips, gs, and convert',
'math_bad_tmpdir'          => 'Cannot write to or create math temp directory',
'math_bad_output'          => 'Cannot write to or create math output directory',
'math_notexvc'             => 'Missing texvc executable;
please see math/README to configure.',
'prefs-personal'           => 'User profile',
'prefs-rc'                 => 'Recent changes',
'prefs-watchlist'          => 'Watchlist',
'prefs-watchlist-days'     => 'Days to show in watchlist:',
'prefs-watchlist-edits'    => 'Maximum number of changes to show in expanded watchlist:',
'prefs-misc'               => 'Misc',
'saveprefs'                => 'Save',
'resetprefs'               => 'Clear unsaved changes',
'oldpassword'              => 'Old password:',
'newpassword'              => 'New password:',
'retypenew'                => 'Retype new password:',
'textboxsize'              => 'Editing',
'rows'                     => 'Rows:',
'columns'                  => 'Columns:',
'searchresultshead'        => 'Search',
'resultsperpage'           => 'Hits per page:',
'contextlines'             => 'Lines per hit:',
'contextchars'             => 'Context per line:',
'stub-threshold'           => 'Threshold for <a href="#" class="stub">stub link</a> formatting (bytes):',
'recentchangesdays'        => 'Days to show in recent changes:',
'recentchangescount'       => 'Number of edits to show in recent changes, history and log pages:',
'savedprefs'               => 'Your preferences have been saved.',
'timezonelegend'           => 'Time zone',
'timezonetext'             => '¹The number of hours your local time differs from server time (UTC).',
'localtime'                => 'Local time',
'timezoneoffset'           => 'Offset¹',
'servertime'               => 'Server time',
'guesstimezone'            => 'Fill in from browser',
'allowemail'               => 'Enable e-mail from other users',
'prefs-searchoptions'      => 'Search options',
'prefs-namespaces'         => 'Namespaces',
'defaultns'                => 'Search in these namespaces by default:',
'default'                  => 'default',
'files'                    => 'Files',

# User rights
'userrights'                     => 'User rights management', # Not used as normal message but as header for the special page itself
'userrights-summary'             => '', # do not translate or duplicate this message to other languages
'userrights-lookup-user'         => 'Manage user groups',
'userrights-user-editname'       => 'Enter a username:',
'editusergroup'                  => 'Edit user groups',
'editinguser'                    => "Changing user rights of user '''[[User:$1|$1]]''' ([[User talk:$1|{{int:talkpagelinktext}}]] | [[Special:Contributions/$1|{{int:contribslink}}]])",
'userrights-editusergroup'       => 'Edit user groups',
'saveusergroups'                 => 'Save user groups',
'userrights-groupsmember'        => 'Member of:',
'userrights-groups-help'         => 'You may alter the groups this user is in:
* A checked box means the user is in that group.
* An unchecked box means the user is not in that group.
* A * indicates that you cannot remove the group once you have added it, or vice versa.',
'userrights-reason'              => 'Reason for change:',
'userrights-no-interwiki'        => 'You do not have permission to edit user rights on other wikis.',
'userrights-nodatabase'          => 'Database $1 does not exist or is not local.',
'userrights-nologin'             => 'You must [[Special:UserLogin|log in]] with an administrator account to assign user rights.',
'userrights-notallowed'          => 'Your account does not have permission to assign user rights.',
'userrights-changeable-col'      => 'Groups you can change',
'userrights-unchangeable-col'    => 'Groups you cannot change',
'userrights-irreversible-marker' => '$1*', # only translate this message to other languages if you have to change it

# Groups
'group'               => 'Group:',
'group-user'          => 'Users',
'group-autoconfirmed' => 'Autoconfirmed users',
'group-bot'           => 'Bots',
'group-sysop'         => 'Sysops',
'group-bureaucrat'    => 'Bureaucrats',
'group-suppress'      => 'Oversights',
'group-all'           => '(all)',

'group-user-member'          => 'User',
'group-autoconfirmed-member' => 'Autoconfirmed user',
'group-bot-member'           => 'Bot',
'group-sysop-member'         => 'Sysop',
'group-bureaucrat-member'    => 'Bureaucrat',
'group-suppress-member'      => 'Oversight',

'grouppage-user'          => '{{ns:project}}:Users',
'grouppage-autoconfirmed' => '{{ns:project}}:Autoconfirmed users',
'grouppage-bot'           => '{{ns:project}}:Bots',
'grouppage-sysop'         => '{{ns:project}}:Administrators',
'grouppage-bureaucrat'    => '{{ns:project}}:Bureaucrats',
'grouppage-suppress'      => '{{ns:project}}:Oversight',

# Rights
'right-read'                 => 'Read pages',
'right-edit'                 => 'Edit pages',
'right-createpage'           => 'Create pages (which are not discussion pages)',
'right-createtalk'           => 'Create discussion pages',
'right-createaccount'        => 'Create new user accounts',
'right-minoredit'            => 'Mark edits as minor',
'right-move'                 => 'Move pages',
'right-move-subpages'        => 'Move pages with their subpages',
'right-suppressredirect'     => 'Not create a redirect from the old name when moving a page',
'right-upload'               => 'Upload files',
'right-reupload'             => 'Overwrite an existing file',
'right-reupload-own'         => 'Overwrite an existing file uploaded by oneself',
'right-reupload-shared'      => 'Override files on the shared media repository locally',
'right-upload_by_url'        => 'Upload a file from a URL address',
'right-purge'                => 'Purge the site cache for a page without confirmation',
'right-autoconfirmed'        => 'Edit semi-protected pages',
'right-bot'                  => 'Be treated as an automated process',
'right-nominornewtalk'       => 'Not have minor edits to discussion pages trigger the new messages prompt',
'right-apihighlimits'        => 'Use higher limits in API queries',
'right-writeapi'             => 'Use of the write API',
'right-delete'               => 'Delete pages',
'right-bigdelete'            => 'Delete pages with large histories',
'right-deleterevision'       => 'Delete and undelete specific revisions of pages',
'right-deletedhistory'       => 'View deleted history entries, without their associated text',
'right-browsearchive'        => 'Search deleted pages',
'right-undelete'             => 'Undelete a page',
'right-suppressrevision'     => 'Review and restore revisions hidden from Sysops',
'right-suppressionlog'       => 'View private logs',
'right-block'                => 'Block other users from editing',
'right-blockemail'           => 'Block a user from sending email',
'right-hideuser'             => 'Block a username, hiding it from the public',
'right-ipblock-exempt'       => 'Bypass IP blocks, auto-blocks and range blocks',
'right-proxyunbannable'      => 'Bypass automatic blocks of proxies',
'right-protect'              => 'Change protection levels and edit protected pages',
'right-editprotected'        => 'Edit protected pages (without cascading protection)',
'right-editinterface'        => 'Edit the user interface',
'right-editusercssjs'        => "Edit other users' CSS and JS files",
'right-rollback'             => 'Quickly rollback the edits of the last user who edited a particular page',
'right-markbotedits'         => 'Mark rolled-back edits as bot edits',
'right-noratelimit'          => 'Not be affected by rate limits',
'right-import'               => 'Import pages from other wikis',
'right-importupload'         => 'Import pages from a file upload',
'right-patrol'               => "Mark others' edits as patrolled",
'right-autopatrol'           => "Have one's own edits automatically marked as patrolled",
'right-patrolmarks'          => 'View recent changes patrol marks',
'right-unwatchedpages'       => 'View a list of unwatched pages',
'right-trackback'            => 'Submit a trackback',
'right-mergehistory'         => 'Merge the history of pages',
'right-userrights'           => 'Edit all user rights',
'right-userrights-interwiki' => 'Edit user rights of users on other wikis',
'right-siteadmin'            => 'Lock and unlock the database',

# User rights log
'rightslog'      => 'User rights log',
'rightslogtext'  => 'This is a log of changes to user rights.',
'rightslogentry' => 'changed group membership for $1 from $2 to $3',
'rightsnone'     => '(none)',

# Recent changes
'nchanges'                          => '$1 {{PLURAL:$1|change|changes}}',
'recentchanges'                     => 'Recent changes',
'recentchanges-url'                 => 'Special:Recentchanges', # do not translate or duplicate this message to other languages
'recentchangestext'                 => 'Track the most recent changes to the wiki on this page.',
'recentchanges-feed-description'    => 'Track the most recent changes to the wiki in this feed.',
'rcnote'                            => "Below {{PLURAL:$1|is '''1''' change|are the last '''$1''' changes}} in the last {{PLURAL:$2|day|'''$2''' days}}, as of $5, $4.",
'rcnotefrom'                        => "Below are the changes since '''$2''' (up to '''$1''' shown).",
'rclistfrom'                        => 'Show new changes starting from $1',
'rcshowhideminor'                   => '$1 minor edits',
'rcshowhidebots'                    => '$1 bots',
'rcshowhideliu'                     => '$1 logged-in users',
'rcshowhideanons'                   => '$1 anonymous users',
'rcshowhidepatr'                    => '$1 patrolled edits',
'rcshowhidemine'                    => '$1 my edits',
'rclinks'                           => 'Show last $1 changes in last $2 days<br />$3',
'diff'                              => 'diff',
'hist'                              => 'hist',
'hide'                              => 'Hide',
'show'                              => 'Show',
'minoreditletter'                   => 'm',
'newpageletter'                     => 'N',
'boteditletter'                     => 'b',
'sectionlink'                       => '→', # only translate this message to other languages if you have to change it
'number_of_watching_users_RCview'   => '[$1]', # do not translate or duplicate this message to other languages
'number_of_watching_users_pageview' => '[$1 watching {{PLURAL:$1|user|users}}]',
'rc_categories'                     => 'Limit to categories (separate with "|")',
'rc_categories_any'                 => 'Any',
'rc-change-size'                    => '$1', # only translate this message to other languages if you have to change it
'newsectionsummary'                 => '/* $1 */ new section',

# Recent changes linked
'recentchangeslinked'          => 'Related changes',
'recentchangeslinked-title'    => 'Changes related to "$1"',
'recentchangeslinked-noresult' => 'No changes on linked pages during the given period.',
'recentchangeslinked-summary'  => "This is a list of changes made recently to pages linked from a specified page (or to members of a specified category).
Pages on [[Special:Watchlist|your watchlist]] are '''bold'''.",
'recentchangeslinked-page'     => 'Page name:',
'recentchangeslinked-to'       => 'Show changes to pages linked to the given page instead',

# Upload
'upload'                      => 'Upload file',
'uploadbtn'                   => 'Upload file',
'reupload'                    => 'Re-upload',
'reuploaddesc'                => 'Cancel upload and return to the upload form',
'uploadnologin'               => 'Not logged in',
'uploadnologintext'           => 'You must be [[Special:UserLogin|logged in]] to upload files.',
'upload_directory_missing'    => 'The upload directory ($1) is missing and could not be created by the webserver.',
'upload_directory_read_only'  => 'The upload directory ($1) is not writable by the webserver.',
'uploaderror'                 => 'Upload error',
'upload-summary'              => '', # do not translate or duplicate this message to other languages
'uploadtext'                  => "Use the form below to upload files.
To view or search previously uploaded files go to the [[Special:ImageList|list of uploaded files]], (re)uploads are also logged in the [[Special:Log/upload|upload log]], deletions in the [[Special:Log/delete|deletion log]].

To include a file in a page, use a link in one of the following forms:
* '''<tt><nowiki>[[</nowiki>{{ns:image}}<nowiki>:File.jpg]]</nowiki></tt>''' to use the full version of the file
* '''<tt><nowiki>[[</nowiki>{{ns:image}}<nowiki>:File.png|200px|thumb|left|alt text]]</nowiki></tt>''' to use a 200 pixel wide rendition in a box in the left margin with 'alt text' as description
* '''<tt><nowiki>[[</nowiki>{{ns:media}}<nowiki>:File.ogg]]</nowiki></tt>''' for directly linking to the file without displaying the file",
'upload-permitted'            => 'Permitted file types: $1.',
'upload-preferred'            => 'Preferred file types: $1.',
'upload-prohibited'           => 'Prohibited file types: $1.',
'uploadfooter'                => '-', # do not translate or duplicate this message to other languages
'uploadlog'                   => 'upload log',
'uploadlogpage'               => 'Upload log',
'uploadlogpagetext'           => 'Below is a list of the most recent file uploads.
See the [[Special:NewImages|gallery of new files]] for a more visual overview.',
'filename'                    => 'Filename',
'filedesc'                    => 'Summary',
'fileuploadsummary'           => 'Summary:',
'filestatus'                  => 'Copyright status:',
'filesource'                  => 'Source:',
'uploadedfiles'               => 'Uploaded files',
'ignorewarning'               => 'Ignore warning and save file anyway',
'ignorewarnings'              => 'Ignore any warnings',
'minlength1'                  => 'File names must be at least one letter.',
'illegalfilename'             => 'The filename "$1" contains characters that are not allowed in page titles.
Please rename the file and try uploading it again.',
'badfilename'                 => 'File name has been changed to "$1".',
'filetype-badmime'            => 'Files of the MIME type "$1" are not allowed to be uploaded.',
'filetype-unwanted-type'      => "'''\".\$1\"''' is an unwanted file type.
Preferred {{PLURAL:\$3|file type is|file types are}} \$2.",
'filetype-banned-type'        => "'''\".\$1\"''' is not a permitted file type.
Permitted {{PLURAL:\$3|file type is|file types are}} \$2.",
'filetype-missing'            => 'The file has no extension (like ".jpg").',
'large-file'                  => 'It is recommended that files are no larger than $1;
this file is $2.',
'largefileserver'             => 'This file is bigger than the server is configured to allow.',
'emptyfile'                   => 'The file you uploaded seems to be empty.
This might be due to a typo in the file name.
Please check whether you really want to upload this file.',
'fileexists'                  => 'A file with this name exists already, please check <strong><tt>$1</tt></strong> if you are not sure if you want to change it.',
'filepageexists'              => 'The description page for this file has already been created at <strong><tt>$1</tt></strong>, but no file with this name currently exists.
The summary you enter will not appear on the description page.
To make your summary appear there, you will need to manually edit it',
'fileexists-extension'        => 'A file with a similar name exists:<br />
Name of the uploading file: <strong><tt>$1</tt></strong><br />
Name of the existing file: <strong><tt>$2</tt></strong><br />
Please choose a different name.',
'fileexists-thumb'            => "<center>'''Existing file'''</center>",
'fileexists-thumbnail-yes'    => 'The file seems to be an image of reduced size <i>(thumbnail)</i>.
Please check the file <strong><tt>$1</tt></strong>.<br />
If the checked file is the same image of original size it is not necessary to upload an extra thumbnail.',
'file-thumbnail-no'           => 'The filename begins with <strong><tt>$1</tt></strong>.
It seems to be an image of reduced size <i>(thumbnail)</i>.
If you have this image in full resolution upload this one, otherwise change the file name please.',
'fileexists-forbidden'        => 'A file with this name exists already;
please go back and upload this file under a new name. [[Image:$1|thumb|center|$1]]',
'fileexists-shared-forbidden' => 'A file with this name exists already in the shared file repository;
please go back and upload this file under a new name. [[Image:$1|thumb|center|$1]]',
'file-exists-duplicate'       => 'This file is a duplicate of the following {{PLURAL:$1|file|files}}:',
'successfulupload'            => 'Successful upload',
'uploadwarning'               => 'Upload warning',
'savefile'                    => 'Save file',
'uploadedimage'               => 'uploaded "[[$1]]"',
'overwroteimage'              => 'uploaded a new version of "[[$1]]"',
'uploaddisabled'              => 'Uploads disabled',
'uploaddisabledtext'          => 'File uploads are disabled on {{SITENAME}}.',
'uploadscripted'              => 'This file contains HTML or script code that may be erroneously interpreted by a web browser.',
'uploadcorrupt'               => 'The file is corrupt or has an incorrect extension.
Please check the file and upload again.',
'uploadvirus'                 => 'The file contains a virus! Details: $1',
'sourcefilename'              => 'Source filename:',
'destfilename'                => 'Destination filename:',
'upload-maxfilesize'          => 'Maximum file size: $1',
'watchthisupload'             => 'Watch this page',
'filewasdeleted'              => 'A file of this name has been previously uploaded and subsequently deleted.
You should check the $1 before proceeding to upload it again.',
'upload-wasdeleted'           => "'''Warning: You are uploading a file that was previously deleted.'''

You should consider whether it is appropriate to continue uploading this file.
The deletion log for this file is provided here for convenience:",
'filename-bad-prefix'         => 'The name of the file you are uploading begins with <strong>"$1"</strong>, which is a non-descriptive name typically assigned automatically by digital cameras.
Please choose a more descriptive name for your file.',
'filename-prefix-blacklist'   => ' #<!-- leave this line exactly as it is --> <pre>
# Syntax is as follows:
#   * Everything from a "#" character to the end of the line is a comment
#   * Every non-blank line is a prefix for typical file names assigned automatically by digital cameras
CIMG # Casio
DSC_ # Nikon
DSCF # Fuji
DSCN # Nikon
DUW # some mobile phones
IMG # generic
JD # Jenoptik
MGP # Pentax
PICT # misc.
 #</pre> <!-- leave this line exactly as it is -->', # only translate this message to other languages if you have to change it

'upload-proto-error'      => 'Incorrect protocol',
'upload-proto-error-text' => 'Remote upload requires URLs beginning with <code>http://</code> or <code>ftp://</code>.',
'upload-file-error'       => 'Internal error',
'upload-file-error-text'  => 'An internal error occurred when attempting to create a temporary file on the server.
Please contact an [[Special:ListUsers/sysop|administrator]].',
'upload-misc-error'       => 'Unknown upload error',
'upload-misc-error-text'  => 'An unknown error occurred during the upload.
Please verify that the URL is valid and accessible and try again.
If the problem persists, contact an [[Special:ListUsers/sysop|administrator]].',

# Some likely curl errors. More could be added from <http://curl.haxx.se/libcurl/c/libcurl-errors.html>
'upload-curl-error6'       => 'Could not reach URL',
'upload-curl-error6-text'  => 'The URL provided could not be reached.
Please double-check that the URL is correct and the site is up.',
'upload-curl-error28'      => 'Upload timeout',
'upload-curl-error28-text' => 'The site took too long to respond.
Please check the site is up, wait a short while and try again.
You may want to try at a less busy time.',

'license'            => 'Licensing:',
'nolicense'          => 'None selected',
'licenses'           => '-', # do not translate or duplicate this message to other languages
'license-nopreview'  => '(Preview not available)',
'upload_source_url'  => ' (a valid, publicly accessible URL)',
'upload_source_file' => ' (a file on your computer)',

# Special:ImageList
'imagelist-summary'     => 'This special page shows all uploaded files.
By default the last uploaded files are shown at top of the list.
A click on a column header changes the sorting.',
'imagelist_search_for'  => 'Search for media name:',
'imgfile'               => 'file',
'imagelist'             => 'File list',
'imagelist_date'        => 'Date',
'imagelist_name'        => 'Name',
'imagelist_user'        => 'User',
'imagelist_size'        => 'Size',
'imagelist_description' => 'Description',

# Image description page
'filehist'                       => 'File history',
'filehist-help'                  => 'Click on a date/time to view the file as it appeared at that time.',
'filehist-deleteall'             => 'delete all',
'filehist-deleteone'             => 'delete',
'filehist-revert'                => 'revert',
'filehist-current'               => 'current',
'filehist-datetime'              => 'Date/Time',
'filehist-user'                  => 'User',
'filehist-dimensions'            => 'Dimensions',
'filehist-filesize'              => 'File size',
'filehist-comment'               => 'Comment',
'imagelinks'                     => 'Links',
'linkstoimage'                   => 'The following {{PLURAL:$1|page links|$1 pages link}} to this file:',
'nolinkstoimage'                 => 'There are no pages that link to this file.',
'morelinkstoimage'               => 'View [[Special:WhatLinksHere/$1|more links]] to this file.',
'redirectstofile'                => 'The following {{PLURAL:$1|file redirects|$1 files redirect}} to this file:',
'duplicatesoffile'               => 'The following {{PLURAL:$1|file is a duplicate|$1 files are duplicates}} of this file:',
'sharedupload'                   => 'This file is a shared upload and may be used by other projects.',
'shareduploadwiki'               => 'Please see the $1 for further information.',
'shareduploadwiki-desc'          => 'The description on its $1 on the shared repository is shown below.',
'shareduploadwiki-linktext'      => 'file description page',
'shareddescriptionfollows'       => '-', # do not translate or duplicate this message to other languages
'shareduploadduplicate'          => 'This file is a duplicate of $1 from shared repository.',
'shareduploadduplicate-linktext' => 'another file',
'shareduploadconflict'           => 'This file has the same name as $1 from the shared repository.',
'shareduploadconflict-linktext'  => 'another file',
'noimage'                        => 'No file by this name exists, you can $1.',
'noimage-linktext'               => 'upload it',
'uploadnewversion-linktext'      => 'Upload a new version of this file',
'imagepage-searchdupe'           => 'Search for duplicate files',

# File reversion
'filerevert'                => 'Revert $1',
'filerevert-backlink'       => '← $1', # only translate this message to other languages if you have to change it
'filerevert-legend'         => 'Revert file',
'filerevert-intro'          => "You are reverting '''[[Media:$1|$1]]''' to the [$4 version as of $3, $2].",
'filerevert-comment'        => 'Comment:',
'filerevert-defaultcomment' => 'Reverted to version as of $2, $1',
'filerevert-submit'         => 'Revert',
'filerevert-success'        => "'''[[Media:$1|$1]]''' has been reverted to the [$4 version as of $3, $2].",
'filerevert-badversion'     => 'There is no previous local version of this file with the provided timestamp.',

# File deletion
'filedelete'                  => 'Delete $1',
'filedelete-backlink'         => '← $1', # only translate this message to other languages if you have to change it
'filedelete-legend'           => 'Delete file',
'filedelete-intro'            => "You are deleting '''[[Media:$1|$1]]'''.",
'filedelete-intro-old'        => "You are deleting the version of '''[[Media:$1|$1]]''' as of [$4 $3, $2].",
'filedelete-comment'          => 'Reason for deletion:',
'filedelete-submit'           => 'Delete',
'filedelete-success'          => "'''$1''' has been deleted.",
'filedelete-success-old'      => "The version of '''[[Media:$1|$1]]''' as of $3, $2 has been deleted.",
'filedelete-nofile'           => "'''$1''' does not exist on {{SITENAME}}.",
'filedelete-nofile-old'       => "There is no archived version of '''$1''' with the specified attributes.",
'filedelete-iscurrent'        => 'You are attempting to delete the most recent version of this file.
Please revert to an older version first.',
'filedelete-otherreason'      => 'Other/additional reason:',
'filedelete-reason-otherlist' => 'Other reason',
'filedelete-reason-dropdown'  => '*Common delete reasons
** Copyright violation
** Duplicated file',
'filedelete-edit-reasonlist'  => 'Edit delete reasons',

# MIME search
'mimesearch'         => 'MIME search',
'mimesearch-summary' => 'This page enables the filtering of files for its MIME-type.
Input: contenttype/subtype, e.g. <tt>image/jpeg</tt>.',
'mimetype'           => 'MIME type:',
'download'           => 'download',

# Unwatched pages
'unwatchedpages'         => 'Unwatched pages',
'unwatchedpages-summary' => '', # do not translate or duplicate this message to other languages

# List redirects
'listredirects'         => 'List redirects',
'listredirects-summary' => '', # do not translate or duplicate this message to other languages

# Unused templates
'unusedtemplates'         => 'Unused templates',
'unusedtemplates-summary' => '', # do not translate or duplicate this message to other languages
'unusedtemplatestext'     => 'This page lists all pages in the template namespace which are not included in another page.
Remember to check for other links to the templates before deleting them.',
'unusedtemplateswlh'      => 'other links',

# Random page
'randompage'         => 'Random page',
'randompage-nopages' => 'There are no pages in this namespace.',
'randompage-url'     => 'Special:Random', # do not translate or duplicate this message to other languages

# Random redirect
'randomredirect'         => 'Random redirect',
'randomredirect-nopages' => 'There are no redirects in this namespace.',

# Statistics
'statistics'             => 'Statistics',
'sitestats'              => '{{SITENAME}} statistics',
'userstats'              => 'User statistics',
'sitestatstext'          => "There {{PLURAL:\$1|is '''1''' page|are '''\$1''' total pages}} in the database.
This includes \"talk\" pages, pages about {{SITENAME}}, minimal \"stub\" pages, redirects, and others that probably do not qualify as content pages.
Excluding those, there {{PLURAL:\$2|is '''1''' page that is a|are '''\$2''' pages that are}} probably legitimate content {{PLURAL:\$2|page|pages}}.

'''\$8''' {{PLURAL:\$8|file has|files have}} been uploaded.

There have been a total of '''\$3''' {{PLURAL:\$3|page view|page views}}, and '''\$4''' {{PLURAL:\$4|page edit|page edits}} since {{SITENAME}} was setup.
That comes to '''\$5''' average edits per page, and '''\$6''' views per edit.

The [http://www.mediawiki.org/wiki/Manual:Job_queue job queue] length is '''\$7'''.",
'userstatstext'          => "There {{PLURAL:$1|is '''1''' registered [[Special:ListUsers|user]]|are '''$1''' registered [[Special:ListUsers|users]]}}, of which '''$2''' (or '''$4%''') {{PLURAL:$2|has|have}} $5 rights.",
'statistics-mostpopular' => 'Most viewed pages',
'statistics-footer'      => '', # do not translate or duplicate this message to other languages

'disambiguations'         => 'Disambiguation pages',
'disambiguations-summary' => '', # do not translate or duplicate this message to other languages
'disambiguationspage'     => 'Template:disambig',
'disambiguations-text'    => "The following pages link to a '''disambiguation page'''.
They should link to the appropriate topic instead.<br />
A page is treated as disambiguation page if it uses a template which is linked from [[MediaWiki:Disambiguationspage]]",

'doubleredirects'            => 'Double redirects',
'doubleredirects-summary'    => '', # do not translate or duplicate this message to other languages
'doubleredirectstext'        => 'This page lists pages which redirect to other redirect pages.
Each row contains links to the first and second redirect, as well as the target of the second redirect, which is usually "real" target page, which the first redirect should point to.',
'double-redirect-fixed-move' => '[[$1]] has been moved, it is now a redirect to [[$2]]',
'double-redirect-fixer'      => 'Redirect fixer',

'brokenredirects'         => 'Broken redirects',
'brokenredirects-summary' => '', # do not translate or duplicate this message to other languages
'brokenredirectstext'     => 'The following redirects link to non-existent pages.',
'brokenredirects-edit'    => '(edit)',
'brokenredirects-delete'  => '(delete)',

'withoutinterwiki'         => 'Pages without language links',
'withoutinterwiki-summary' => 'The following pages do not link to other language versions.',
'withoutinterwiki-legend'  => 'Prefix',
'withoutinterwiki-submit'  => 'Show',

'fewestrevisions'         => 'Pages with the fewest revisions',
'fewestrevisions-summary' => '', # do not translate or duplicate this message to other languages

# Miscellaneous special pages
'nbytes'                          => '$1 {{PLURAL:$1|byte|bytes}}',
'ncategories'                     => '$1 {{PLURAL:$1|category|categories}}',
'nlinks'                          => '$1 {{PLURAL:$1|link|links}}',
'nmembers'                        => '$1 {{PLURAL:$1|member|members}}',
'nrevisions'                      => '$1 {{PLURAL:$1|revision|revisions}}',
'nviews'                          => '$1 {{PLURAL:$1|view|views}}',
'specialpage-empty'               => 'There are no results for this report.',
'lonelypages'                     => 'Orphaned pages',
'lonelypages-summary'             => '', # do not translate or duplicate this message to other languages
'lonelypagestext'                 => 'The following pages are not linked from other pages in {{SITENAME}}.',
'uncategorizedpages'              => 'Uncategorized pages',
'uncategorizedpages-summary'      => '', # do not translate or duplicate this message to other languages
'uncategorizedcategories'         => 'Uncategorized categories',
'uncategorizedcategories-summary' => '', # do not translate or duplicate this message to other languages
'uncategorizedimages'             => 'Uncategorized files',
'uncategorizedimages-summary'     => '', # do not translate or duplicate this message to other languages
'uncategorizedtemplates'          => 'Uncategorized templates',
'uncategorizedtemplates-summary'  => '', # do not translate or duplicate this message to other languages
'unusedcategories'                => 'Unused categories',
'unusedimages'                    => 'Unused files',
'popularpages'                    => 'Popular pages',
'popularpages-summary'            => '', # do not translate or duplicate this message to other languages
'wantedcategories'                => 'Wanted categories',
'wantedcategories-summary'        => '', # do not translate or duplicate this message to other languages
'wantedpages'                     => 'Wanted pages',
'wantedpages-summary'             => '', # do not translate or duplicate this message to other languages
'missingfiles'                    => 'Missing files',
'missingfiles-summary'            => '', # do not translate or duplicate this message to other languages
'mostlinked'                      => 'Most linked-to pages',
'mostlinked-summary'              => '', # do not translate or duplicate this message to other languages
'mostlinkedcategories'            => 'Most linked-to categories',
'mostlinkedcategories-summary'    => '', # do not translate or duplicate this message to other languages
'mostlinkedtemplates'             => 'Most linked-to templates',
'mostlinkedtemplates-summary'     => '', # do not translate or duplicate this message to other languages
'mostcategories'                  => 'Pages with the most categories',
'mostcategories-summary'          => '', # do not translate or duplicate this message to other languages
'mostimages'                      => 'Most linked-to files',
'mostimages-summary'              => '', # do not translate or duplicate this message to other languages
'mostrevisions'                   => 'Pages with the most revisions',
'mostrevisions-summary'           => '', # do not translate or duplicate this message to other languages
'prefixindex'                     => 'Prefix index',
'prefixindex-summary'             => '', # do not translate or duplicate this message to other languages
'shortpages'                      => 'Short pages',
'shortpages-summary'              => '', # do not translate or duplicate this message to other languages
'longpages'                       => 'Long pages',
'longpages-summary'               => '', # do not translate or duplicate this message to other languages
'deadendpages'                    => 'Dead-end pages',
'deadendpages-summary'            => '', # do not translate or duplicate this message to other languages
'deadendpagestext'                => 'The following pages do not link to other pages in {{SITENAME}}.',
'protectedpages'                  => 'Protected pages',
'protectedpages-indef'            => 'Indefinite protections only',
'protectedpages-summary'          => '', # do not translate or duplicate this message to other languages
'protectedpagestext'              => 'The following pages are protected from moving or editing',
'protectedpagesempty'             => 'No pages are currently protected with these parameters.',
'protectedtitles'                 => 'Protected titles',
'protectedtitles-summary'         => '', # do not translate or duplicate this message to other languages
'protectedtitlestext'             => 'The following titles are protected from creation',
'protectedtitlesempty'            => 'No titles are currently protected with these parameters.',
'listusers'                       => 'User list',
'listusers-summary'               => '', # do not translate or duplicate this message to other languages
'newpages'                        => 'New pages',
'newpages-summary'                => '', # do not translate or duplicate this message to other languages
'newpages-username'               => 'Username:',
'ancientpages'                    => 'Oldest pages',
'ancientpages-summary'            => '', # do not translate or duplicate this message to other languages
'move'                            => 'Move',
'movethispage'                    => 'Move this page',
'unusedimagestext'                => 'Please note that other web sites may link to a file with a direct URL, and so may still be listed here despite being in active use.',
'unusedcategoriestext'            => 'The following category pages exist although no other page or category make use of them.',
'notargettitle'                   => 'No target',
'notargettext'                    => 'You have not specified a target page or user to perform this function on.',
'nopagetitle'                     => 'No such target page',
'nopagetext'                      => 'The target page you have specified does not exist.',
'pager-newer-n'                   => '{{PLURAL:$1|newer 1|newer $1}}',
'pager-older-n'                   => '{{PLURAL:$1|older 1|older $1}}',
'suppress'                        => 'Oversight',

# Book sources
'booksources'               => 'Book sources',
'booksources-summary'       => '', # do not translate or duplicate this message to other languages
'booksources-search-legend' => 'Search for book sources',
'booksources-isbn'          => 'ISBN:', # only translate this message to other languages if you have to change it
'booksources-go'            => 'Go',
'booksources-text'          => 'Below is a list of links to other sites that sell new and used books, and may also have further information about books you are looking for:',

# Magic words
'rfcurl'    => 'http://tools.ietf.org/html/rfc$1', # do not translate or duplicate this message to other languages
'pubmedurl' => 'http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&db=pubmed&dopt=Abstract&list_uids=$1', # do not translate or duplicate this message to other languages

# Special:Log
'specialloguserlabel'  => 'User:',
'speciallogtitlelabel' => 'Title:',
'log'                  => 'Logs',
'all-logs-page'        => 'All logs',
'log-search-legend'    => 'Search for logs',
'log-search-submit'    => 'Go',
'alllogstext'          => 'Combined display of all available logs of {{SITENAME}}.
You can narrow down the view by selecting a log type, the user name, or the affected page.',
'logempty'             => 'No matching items in log.',
'log-title-wildcard'   => 'Search titles starting with this text',

# Special:AllPages
'allpages'          => 'All pages',
'allpages-summary'  => '', # do not translate or duplicate this message to other languages
'alphaindexline'    => '$1 to $2',
'nextpage'          => 'Next page ($1)',
'prevpage'          => 'Previous page ($1)',
'allpagesfrom'      => 'Display pages starting at:',
'allarticles'       => 'All pages',
'allinnamespace'    => 'All pages ($1 namespace)',
'allnotinnamespace' => 'All pages (not in $1 namespace)',
'allpagesprev'      => 'Previous',
'allpagesnext'      => 'Next',
'allpagessubmit'    => 'Go',
'allpagesprefix'    => 'Display pages with prefix:',
'allpagesbadtitle'  => 'The given page title was invalid or had an inter-language or inter-wiki prefix.
It may contain one or more characters which cannot be used in titles.',
'allpages-bad-ns'   => '{{SITENAME}} does not have namespace "$1".',

# Special:Categories
'categories'                    => 'Categories',
'categories-summary'            => '', # do not translate or duplicate this message to other languages
'categoriespagetext'            => 'The following categories contain pages or media.',
'categoriesfrom'                => 'Display categories starting at:',
'special-categories-sort-count' => 'sort by count',
'special-categories-sort-abc'   => 'sort alphabetically',

# Special:ListUsers
'listusersfrom'      => 'Display users starting at:',
'listusers-submit'   => 'Show',
'listusers-noresult' => 'No user found.',

# Special:ListGroupRights
'listgrouprights'               => 'User group rights',
'listgrouprights-summary'       => 'The following is a list of user groups defined on this wiki, with their associated access rights.
There may be [[{{MediaWiki:Listgrouprights-helppage}}|additional information]] about individual rights.',
'listgrouprights-group'         => 'Group',
'listgrouprights-rights'        => 'Rights',
'listgrouprights-helppage'      => 'Help:Group rights',
'listgrouprights-members'       => '(list of members)',
'listgrouprights-right-display' => '$1 ($2)', # only translate this message to other languages if you have to change it

# E-mail user
'mailnologin'     => 'No send address',
'mailnologintext' => 'You must be [[Special:UserLogin|logged in]] and have a valid e-mail address in your [[Special:Preferences|preferences]] to send e-mail to other users.',
'emailuser'       => 'E-mail this user',
'emailpage'       => 'E-mail user',
'emailpagetext'   => 'If this user has entered a valid e-mail address in his or her user preferences, the form below will send a single message.
The e-mail address you entered in [[Special:Preferences|your user preferences]] will appear as the "From" address of the e-mail, so the recipient will be able to reply.',
'usermailererror' => 'Mail object returned error:',
'defemailsubject' => '{{SITENAME}} e-mail',
'noemailtitle'    => 'No e-mail address',
'noemailtext'     => 'This user has not specified a valid e-mail address, or has chosen not to receive e-mail from other users.',
'emailfrom'       => 'From:',
'emailto'         => 'To:',
'emailsubject'    => 'Subject:',
'emailmessage'    => 'Message:',
'emailsend'       => 'Send',
'emailccme'       => 'E-mail me a copy of my message.',
'emailccsubject'  => 'Copy of your message to $1: $2',
'emailsent'       => 'E-mail sent',
'emailsenttext'   => 'Your e-mail message has been sent.',
'emailuserfooter' => 'This e-mail was sent by $1 to $2 by the "Email user" function at {{SITENAME}}.',

# Watchlist
'watchlist'            => 'My watchlist',
'mywatchlist'          => 'My watchlist',
'watchlistfor'         => "(for '''$1''')",
'nowatchlist'          => 'You have no items on your watchlist.',
'watchlistanontext'    => 'Please $1 to view or edit items on your watchlist.',
'watchnologin'         => 'Not logged in',
'watchnologintext'     => 'You must be [[Special:UserLogin|logged in]] to modify your watchlist.',
'addedwatch'           => 'Added to watchlist',
'addedwatchtext'       => "The page \"[[:\$1]]\" has been added to your [[Special:Watchlist|watchlist]].
Future changes to this page and its associated talk page will be listed there, and the page will appear '''bolded''' in the [[Special:RecentChanges|list of recent changes]] to make it easier to pick out.",
'removedwatch'         => 'Removed from watchlist',
'removedwatchtext'     => 'The page "[[:$1]]" has been removed from [[Special:Watchlist|your watchlist]].',
'watch'                => 'Watch',
'watchthispage'        => 'Watch this page',
'unwatch'              => 'Unwatch',
'unwatchthispage'      => 'Stop watching',
'notanarticle'         => 'Not a content page',
'notvisiblerev'        => 'Revision has been deleted',
'watchnochange'        => 'None of your watched items were edited in the time period displayed.',
'watchlist-details'    => '{{PLURAL:$1|$1 page|$1 pages}} watched not counting talk pages.',
'wlheader-enotif'      => '* E-mail notification is enabled.',
'wlheader-showupdated' => "* Pages which have been changed since you last visited them are shown in '''bold'''",
'watchmethod-recent'   => 'checking recent edits for watched pages',
'watchmethod-list'     => 'checking watched pages for recent edits',
'watchlistcontains'    => 'Your watchlist contains $1 {{PLURAL:$1|page|pages}}.',
'iteminvalidname'      => "Problem with item '$1', invalid name...",
'wlnote'               => "Below {{PLURAL:$1|is the last change|are the last '''$1''' changes}} in the last {{PLURAL:$2|hour|'''$2''' hours}}.",
'wlshowlast'           => 'Show last $1 hours $2 days $3',
'watchlist-show-bots'  => 'Show bot edits',
'watchlist-hide-bots'  => 'Hide bot edits',
'watchlist-show-own'   => 'Show my edits',
'watchlist-hide-own'   => 'Hide my edits',
'watchlist-show-minor' => 'Show minor edits',
'watchlist-hide-minor' => 'Hide minor edits',

# Displayed when you click the "watch" button and it is in the process of watching
'watching'   => 'Watching...',
'unwatching' => 'Unwatching...',

'enotif_mailer'                => '{{SITENAME}} Notification Mailer',
'enotif_reset'                 => 'Mark all pages visited',
'enotif_newpagetext'           => 'This is a new page.',
'enotif_impersonal_salutation' => '{{SITENAME}} user',
'changed'                      => 'changed',
'created'                      => 'created',
'enotif_subject'               => '{{SITENAME}} page $PAGETITLE has been $CHANGEDORCREATED by $PAGEEDITOR',
'enotif_lastvisited'           => 'See $1 for all changes since your last visit.',
'enotif_lastdiff'              => 'See $1 to view this change.',
'enotif_anon_editor'           => 'anonymous user $1',
'enotif_body'                  => 'Dear $WATCHINGUSERNAME,


The {{SITENAME}} page $PAGETITLE has been $CHANGEDORCREATED on $PAGEEDITDATE by $PAGEEDITOR, see $PAGETITLE_URL for the current version.

$NEWPAGE

Editor\'s summary: $PAGESUMMARY $PAGEMINOREDIT

Contact the editor:
mail: $PAGEEDITOR_EMAIL
wiki: $PAGEEDITOR_WIKI

There will be no other notifications in case of further changes unless you visit this page.
You could also reset the notification flags for all your watched pages on your watchlist.

             Your friendly {{SITENAME}} notification system

--
To change your watchlist settings, visit
{{fullurl:{{ns:special}}:Watchlist/edit}}

Feedback and further assistance:
{{fullurl:{{MediaWiki:Helppage}}}}',

# Delete/protect/revert
'deletepage'                  => 'Delete page',
'confirm'                     => 'Confirm',
'excontent'                   => "content was: '$1'",
'excontentauthor'             => "content was: '$1' (and the only contributor was '[[Special:Contributions/$2|$2]]')",
'exbeforeblank'               => "content before blanking was: '$1'",
'exblank'                     => 'page was empty',
'delete-confirm'              => 'Delete "$1"',
'delete-backlink'             => '← $1', # only translate this message to other languages if you have to change it
'delete-legend'               => 'Delete',
'historywarning'              => 'Warning: The page you are about to delete has a history:',
'confirmdeletetext'           => 'You are about to delete a page along with all of its history.
Please confirm that you intend to do this, that you understand the consequences, and that you are doing this in accordance with [[{{MediaWiki:Policy-url}}|the policy]].',
'actioncomplete'              => 'Action complete',
'deletedtext'                 => '"<nowiki>$1</nowiki>" has been deleted.
See $2 for a record of recent deletions.',
'deletedarticle'              => 'deleted "[[$1]]"',
'suppressedarticle'           => 'suppressed "[[$1]]"',
'dellogpage'                  => 'Deletion log',
'dellogpagetext'              => 'Below is a list of the most recent deletions.',
'deletionlog'                 => 'deletion log',
'reverted'                    => 'Reverted to earlier revision',
'deletecomment'               => 'Reason for deletion:',
'deleteotherreason'           => 'Other/additional reason:',
'deletereasonotherlist'       => 'Other reason',
'deletereason-dropdown'       => '*Common delete reasons
** Author request
** Copyright violation
** Vandalism',
'delete-edit-reasonlist'      => 'Edit delete reasons',
'delete-toobig'               => 'This page has a large edit history, over $1 {{PLURAL:$1|revision|revisions}}.
Deletion of such pages has been restricted to prevent accidental disruption of {{SITENAME}}.',
'delete-warning-toobig'       => 'This page has a large edit history, over $1 {{PLURAL:$1|revision|revisions}}.
Deleting it may disrupt database operations of {{SITENAME}};
proceed with caution.',
'rollback'                    => 'Roll back edits',
'rollback_short'              => 'Rollback',
'rollbacklink'                => 'rollback',
'rollbackfailed'              => 'Rollback failed',
'cantrollback'                => 'Cannot revert edit;
last contributor is only author of this page.',
'alreadyrolled'               => 'Cannot rollback last edit of [[:$1]] by [[User:$2|$2]] ([[User talk:$2|Talk]] | [[Special:Contributions/$2|{{int:contribslink}}]]);
someone else has edited or rolled back the page already.

The last edit to the page was by [[User:$3|$3]] ([[User talk:$3|Talk]] | [[Special:Contributions/$3|{{int:contribslink}}]]).',
'editcomment'                 => 'The edit comment was: "<i>$1</i>".', # only shown if there is an edit comment
'revertpage'                  => 'Reverted edits by [[Special:Contributions/$2|$2]] ([[User talk:$2|Talk]]) to last version by [[User:$1|$1]]', # Additional available: $3: revid of the revision reverted to, $4: timestamp of the revision reverted to, $5: revid of the revision reverted from, $6: timestamp of the revision reverted from
'rollback-success'            => 'Reverted edits by $1;
changed back to last version by $2.',
'sessionfailure'              => 'There seems to be a problem with your login session;
this action has been canceled as a precaution against session hijacking.
Please hit "back" and reload the page you came from, then try again.',
'protectlogpage'              => 'Protection log',
'protectlogtext'              => 'Below is a list of page locks and unlocks.
See the [[Special:ProtectedPages|protected pages list]] for the list of currently operational page protections.',
'protectedarticle'            => 'protected "[[$1]]"',
'modifiedarticleprotection'   => 'changed protection level for "[[$1]]"',
'unprotectedarticle'          => 'unprotected "[[$1]]"',
'protect-title'               => 'Change protection level for "$1"',
'protect-backlink'            => '← $1', # only translate this message to other languages if you have to change it
'protect-legend'              => 'Confirm protection',
'protectcomment'              => 'Comment:',
'protectexpiry'               => 'Expires:',
'protect_expiry_invalid'      => 'Expiry time is invalid.',
'protect_expiry_old'          => 'Expiry time is in the past.',
'protect-unchain'             => 'Unlock move permissions',
'protect-text'                => 'You may view and change the protection level here for the page <strong><nowiki>$1</nowiki></strong>.',
'protect-locked-blocked'      => 'You cannot change protection levels while blocked.
Here are the current settings for the page <strong>$1</strong>:',
'protect-locked-dblock'       => 'Protection levels cannot be changed due to an active database lock.
Here are the current settings for the page <strong>$1</strong>:',
'protect-locked-access'       => 'Your account does not have permission to change page protection levels.
Here are the current settings for the page <strong>$1</strong>:',
'protect-cascadeon'           => "This page is currently protected because it is included in the following {{PLURAL:$1|page, which has|pages, which have}} cascading protection turned on.
You can change this page's protection level, but it will not affect the cascading protection.",
'protect-default'             => '(default)',
'protect-fallback'            => 'Require "$1" permission',
'protect-level-autoconfirmed' => 'Block unregistered users',
'protect-level-sysop'         => 'Sysops only',
'protect-summary-cascade'     => 'cascading',
'protect-expiring'            => 'expires $1 (UTC)',
'protect-cascade'             => 'Protect pages included in this page (cascading protection)',
'protect-cantedit'            => 'You cannot change the protection levels of this page, because you do not have permission to edit it.',
'restriction-type'            => 'Permission:',
'restriction-level'           => 'Restriction level:',
'minimum-size'                => 'Min size',
'maximum-size'                => 'Max size:',
'pagesize'                    => '(bytes)',

# Restrictions (nouns)
'restriction-edit'   => 'Edit',
'restriction-move'   => 'Move',
'restriction-create' => 'Create',
'restriction-upload' => 'Upload',

# Restriction levels
'restriction-level-sysop'         => 'full protected',
'restriction-level-autoconfirmed' => 'semi protected',
'restriction-level-all'           => 'any level',

# Undelete
'undelete'                     => 'View deleted pages',
'undeletepage'                 => 'View and restore deleted pages',
'undeletepagetitle'            => "'''The following consists of deleted revisions of [[:$1|$1]]'''.",
'viewdeletedpage'              => 'View deleted pages',
'undeletepagetext'             => 'The following pages have been deleted but are still in the archive and can be restored.
The archive may be periodically cleaned out.',
'undelete-fieldset-title'      => 'Restore revisions',
'undeleteextrahelp'            => "To restore the entire page, leave all checkboxes deselected and click '''''Restore'''''.
To perform a selective restoration, check the boxes corresponding to the revisions to be restored, and click '''''Restore'''''.
Clicking '''''Reset''''' will clear the comment field and all checkboxes.",
'undeleterevisions'            => '$1 {{PLURAL:$1|revision|revisions}} archived',
'undeletehistory'              => 'If you restore the page, all revisions will be restored to the history.
If a new page with the same name has been created since the deletion, the restored revisions will appear in the prior history.',
'undeleterevdel'               => 'Undeletion will not be performed if it will result in the top page or file revision being partially deleted.
In such cases, you must uncheck or unhide the newest deleted revision.',
'undeletehistorynoadmin'       => 'This page has been deleted.
The reason for deletion is shown in the summary below, along with details of the users who had edited this page before deletion.
The actual text of these deleted revisions is only available to administrators.',
'undelete-revision'            => 'Deleted revision of $1 (as of $2) by $3:',
'undeleterevision-missing'     => 'Invalid or missing revision.
You may have a bad link, or the revision may have been restored or removed from the archive.',
'undelete-nodiff'              => 'No previous revision found.',
'undeletebtn'                  => 'Restore',
'undeletelink'                 => 'restore',
'undeletereset'                => 'Reset',
'undeletecomment'              => 'Comment:',
'undeletedarticle'             => 'restored "[[$1]]"',
'undeletedrevisions'           => '{{PLURAL:$1|1 revision|$1 revisions}} restored',
'undeletedrevisions-files'     => '{{PLURAL:$1|1 revision|$1 revisions}} and {{PLURAL:$2|1 file|$2 files}} restored',
'undeletedfiles'               => '{{PLURAL:$1|1 file|$1 files}} restored',
'cannotundelete'               => 'Undelete failed;
someone else may have undeleted the page first.',
'undeletedpage'                => "<big>'''$1 has been restored'''</big>

Consult the [[Special:Log/delete|deletion log]] for a record of recent deletions and restorations.",
'undelete-header'              => 'See [[Special:Log/delete|the deletion log]] for recently deleted pages.',
'undelete-search-box'          => 'Search deleted pages',
'undelete-search-prefix'       => 'Show pages starting with:',
'undelete-search-submit'       => 'Search',
'undelete-no-results'          => 'No matching pages found in the deletion archive.',
'undelete-filename-mismatch'   => 'Cannot undelete file revision with timestamp $1: filename mismatch',
'undelete-bad-store-key'       => 'Cannot undelete file revision with timestamp $1: file was missing before deletion.',
'undelete-cleanup-error'       => 'Error deleting unused archive file "$1".',
'undelete-missing-filearchive' => 'Unable to restore file archive ID $1 because it is not in the database.
It may have already been undeleted.',
'undelete-error-short'         => 'Error undeleting file: $1',
'undelete-error-long'          => 'Errors were encountered while undeleting the file:

$1',

# Namespace form on various pages
'namespace'      => 'Namespace:',
'invert'         => 'Invert selection',
'blanknamespace' => '(Main)',

# Contributions
'contributions' => 'User contributions',
'mycontris'     => 'My contributions',
'contribsub2'   => 'For $1 ($2)',
'nocontribs'    => 'No changes were found matching these criteria.',
'uctop'         => '(top)',
'month'         => 'From month (and earlier):',
'year'          => 'From year (and earlier):',

'sp-contributions-newbies'     => 'Show contributions of new accounts only',
'sp-contributions-newbies-sub' => 'For new accounts',
'sp-contributions-blocklog'    => 'Block log',
'sp-contributions-search'      => 'Search for contributions',
'sp-contributions-username'    => 'IP Address or username:',
'sp-contributions-submit'      => 'Search',
'sp-contributions-explain'     => '', # only translate this message to other languages if you have to change it
'sp-contributions-footer'      => '-', # do not translate or duplicate this message to other languages
'sp-contributions-footer-anon' => '-', # do not translate or duplicate this message to other languages

# What links here
'whatlinkshere'            => 'What links here',
'whatlinkshere-title'      => 'Pages that link to "$1"',
'whatlinkshere-summary'    => '', # do not translate or duplicate this message to other languages
'whatlinkshere-page'       => 'Page:',
'whatlinkshere-barrow'     => '>', # only translate this message to other languages if you have to change it
'linklistsub'              => '(List of links)',
'linkshere'                => "The following pages link to '''[[:$1]]''':",
'nolinkshere'              => "No pages link to '''[[:$1]]'''.",
'nolinkshere-ns'           => "No pages link to '''[[:$1]]''' in the chosen namespace.",
'isredirect'               => 'redirect page',
'istemplate'               => 'inclusion',
'isimage'                  => 'image link',
'whatlinkshere-prev'       => '{{PLURAL:$1|previous|previous $1}}',
'whatlinkshere-next'       => '{{PLURAL:$1|next|next $1}}',
'whatlinkshere-links'      => '← links',
'whatlinkshere-hideredirs' => '$1 redirects',
'whatlinkshere-hidetrans'  => '$1 transclusions',
'whatlinkshere-hidelinks'  => '$1 links',
'whatlinkshere-hideimages' => '$1 image links',
'whatlinkshere-filters'    => 'Filters',

# Block/unblock
'blockip'                         => 'Block user',
'blockip-legend'                  => 'Block user',
'blockiptext'                     => 'Use the form below to block write access from a specific IP address or username.
This should be done only to prevent vandalism, and in accordance with [[{{MediaWiki:Policy-url}}|policy]].
Fill in a specific reason below (for example, citing particular pages that were vandalized).',
'ipaddress'                       => 'IP Address:',
'ipadressorusername'              => 'IP Address or username:',
'ipbexpiry'                       => 'Expiry:',
'ipbreason'                       => 'Reason:',
'ipbreasonotherlist'              => 'Other reason',
'ipbreason-dropdown'              => '*Common block reasons
** Inserting false information
** Removing content from pages
** Spamming links to external sites
** Inserting nonsense/gibberish into pages
** Intimidating behaviour/harassment
** Abusing multiple accounts
** Unacceptable username',
'ipbanononly'                     => 'Block anonymous users only',
'ipbcreateaccount'                => 'Prevent account creation',
'ipbemailban'                     => 'Prevent user from sending e-mail',
'ipbenableautoblock'              => 'Automatically block the last IP address used by this user, and any subsequent IPs they try to edit from',
'ipbsubmit'                       => 'Block this user',
'ipbother'                        => 'Other time:',
'ipboptions'                      => '2 hours:2 hours,1 day:1 day,3 days:3 days,1 week:1 week,2 weeks:2 weeks,1 month:1 month,3 months:3 months,6 months:6 months,1 year:1 year,infinite:infinite', # display1:time1,display2:time2,...
'ipbotheroption'                  => 'other',
'ipbotherreason'                  => 'Other/additional reason:',
'ipbhidename'                     => 'Hide username from the block log, active block list and user list',
'ipbwatchuser'                    => "Watch this user's user and talk pages",
'badipaddress'                    => 'Invalid IP address',
'blockipsuccesssub'               => 'Block succeeded',
'blockipsuccesstext'              => '[[Special:Contributions/$1|$1]] has been blocked.<br />
See [[Special:IPBlockList|IP block list]] to review blocks.',
'ipb-edit-dropdown'               => 'Edit block reasons',
'ipb-unblock-addr'                => 'Unblock $1',
'ipb-unblock'                     => 'Unblock a username or IP address',
'ipb-blocklist-addr'              => 'View existing blocks for $1',
'ipb-blocklist'                   => 'View existing blocks',
'unblockip'                       => 'Unblock user',
'unblockiptext'                   => 'Use the form below to restore write access to a previously blocked IP address or username.',
'ipusubmit'                       => 'Unblock this address',
'unblocked'                       => '[[User:$1|$1]] has been unblocked',
'unblocked-id'                    => 'Block $1 has been removed',
'ipblocklist'                     => 'Blocked IP addresses and usernames',
'ipblocklist-legend'              => 'Find a blocked user',
'ipblocklist-username'            => 'Username or IP address:',
'ipblocklist-summary'             => '', # do not translate or duplicate this message to other languages
'ipblocklist-submit'              => 'Search',
'blocklistline'                   => '$1, $2 blocked $3 ($4)',
'infiniteblock'                   => 'infinite',
'expiringblock'                   => 'expires $1',
'anononlyblock'                   => 'anon. only',
'noautoblockblock'                => 'autoblock disabled',
'createaccountblock'              => 'account creation blocked',
'emailblock'                      => 'e-mail blocked',
'ipblocklist-empty'               => 'The blocklist is empty.',
'ipblocklist-no-results'          => 'The requested IP address or username is not blocked.',
'blocklink'                       => 'block',
'unblocklink'                     => 'unblock',
'contribslink'                    => 'contribs',
'autoblocker'                     => 'Autoblocked because your IP address has been recently used by "[[User:$1|$1]]".
The reason given for $1\'s block is: "$2"',
'blocklogpage'                    => 'Block log',
'blocklogentry'                   => 'blocked [[$1]] with an expiry time of $2 $3',
'blocklogtext'                    => 'This is a log of user blocking and unblocking actions.
Automatically blocked IP addresses are not listed.
See the [[Special:IPBlockList|IP block list]] for the list of currently operational bans and blocks.',
'unblocklogentry'                 => 'unblocked $1',
'block-log-flags-anononly'        => 'anonymous users only',
'block-log-flags-nocreate'        => 'account creation disabled',
'block-log-flags-noautoblock'     => 'autoblock disabled',
'block-log-flags-noemail'         => 'e-mail blocked',
'block-log-flags-angry-autoblock' => 'enhanced autoblock enabled',
'range_block_disabled'            => 'The sysop ability to create range blocks is disabled.',
'ipb_expiry_invalid'              => 'Expiry time invalid.',
'ipb_expiry_temp'                 => 'Hidden username blocks must be permanent.',
'ipb_already_blocked'             => '"$1" is already blocked',
'ipb_cant_unblock'                => 'Error: Block ID $1 not found.
It may have been unblocked already.',
'ipb_blocked_as_range'            => 'Error: The IP $1 is not blocked directly and cannot be unblocked.
It is, however, blocked as part of the range $2, which can be unblocked.',
'ip_range_invalid'                => 'Invalid IP range.',
'blockme'                         => 'Block me',
'proxyblocker'                    => 'Proxy blocker',
'proxyblocker-disabled'           => 'This function is disabled.',
'proxyblockreason'                => 'Your IP address has been blocked because it is an open proxy.
Please contact your Internet service provider or tech support and inform them of this serious security problem.',
'proxyblocksuccess'               => 'Done.',
'sorbs'                           => 'DNSBL', # only translate this message to other languages if you have to change it
'sorbsreason'                     => 'Your IP address is listed as an open proxy in the DNSBL used by {{SITENAME}}.',
'sorbs_create_account_reason'     => 'Your IP address is listed as an open proxy in the DNSBL used by {{SITENAME}}.
You cannot create an account',

# Developer tools
'lockdb'              => 'Lock database',
'unlockdb'            => 'Unlock database',
'lockdbtext'          => 'Locking the database will suspend the ability of all users to edit pages, change their preferences, edit their watchlists, and other things requiring changes in the database.
Please confirm that this is what you intend to do, and that you will unlock the database when your maintenance is done.',
'unlockdbtext'        => 'Unlocking the database will restore the ability of all users to edit pages, change their preferences, edit their watchlists, and other things requiring changes in the database.
Please confirm that this is what you intend to do.',
'lockconfirm'         => 'Yes, I really want to lock the database.',
'unlockconfirm'       => 'Yes, I really want to unlock the database.',
'lockbtn'             => 'Lock database',
'unlockbtn'           => 'Unlock database',
'locknoconfirm'       => 'You did not check the confirmation box.',
'lockdbsuccesssub'    => 'Database lock succeeded',
'unlockdbsuccesssub'  => 'Database lock removed',
'lockdbsuccesstext'   => 'The database has been locked.<br />
Remember to [[Special:UnlockDB|remove the lock]] after your maintenance is complete.',
'unlockdbsuccesstext' => 'The database has been unlocked.',
'lockfilenotwritable' => 'The database lock file is not writable.
To lock or unlock the database, this needs to be writable by the web server.',
'databasenotlocked'   => 'The database is not locked.',

# Move page
'move-page'               => 'Move $1',
'move-page-backlink'      => '← $1', # only translate this message to other languages if you have to change it
'move-page-legend'        => 'Move page',
'movepagetext'            => "Using the form below will rename a page, moving all of its history to the new name.
The old title will become a redirect page to the new title.
You can update redirects that point to the original title automatically.
If you choose not to, be sure to check for [[Special:DoubleRedirects|double]] or [[Special:BrokenRedirects|broken redirects]].
You are responsible for making sure that links continue to point where they are supposed to go.

Note that the page will '''not''' be moved if there is already a page at the new title, unless it is empty or a redirect and has no past edit history.
This means that you can rename a page back to where it was renamed from if you make a mistake, and you cannot overwrite an existing page.

'''WARNING!'''
This can be a drastic and unexpected change for a popular page;
please be sure you understand the consequences of this before proceeding.",
'movepagetalktext'        => "The associated talk page will be automatically moved along with it '''unless:'''
*A non-empty talk page already exists under the new name, or
*You uncheck the box below.

In those cases, you will have to move or merge the page manually if desired.",
'movearticle'             => 'Move page:',
'movenotallowed'          => 'You do not have permission to move pages on {{SITENAME}}.',
'newtitle'                => 'To new title:',
'move-watch'              => 'Watch this page',
'movepagebtn'             => 'Move page',
'pagemovedsub'            => 'Move succeeded',
'movepage-moved'          => '<big>\'\'\'"$1" has been moved to "$2"\'\'\'</big>', # The two titles are passed in plain text as $3 and $4 to allow additional goodies in the message.
'articleexists'           => 'A page of that name already exists, or the name you have chosen is not valid.
Please choose another name.',
'cantmove-titleprotected' => 'You cannot move a page to this location, because the new title has been protected from creation',
'talkexists'              => "'''The page itself was moved successfully, but the talk page could not be moved because one already exists at the new title.
Please merge them manually.'''",
'movedto'                 => 'moved to',
'movetalk'                => 'Move associated talk page',
'move-subpages'           => 'Move all subpages, if applicable',
'move-talk-subpages'      => 'Move all subpages of talk page, if applicable',
'movepage-page-exists'    => 'The page $1 already exists and cannot be automatically overwritten.',
'movepage-page-moved'     => 'The page $1 has been moved to $2.',
'movepage-page-unmoved'   => 'The page $1 could not be moved to $2.',
'movepage-max-pages'      => 'The maximum of $1 {{PLURAL:$1|page|pages}} has been moved and no more will be moved automatically.',
'1movedto2'               => '[[$1]] moved to [[$2]]',
'1movedto2_redir'         => '[[$1]] moved to [[$2]] over redirect',
'movelogpage'             => 'Move log',
'movelogpagetext'         => 'Below is a list of pages moved.',
'movereason'              => 'Reason:',
'revertmove'              => 'revert',
'delete_and_move'         => 'Delete and move',
'delete_and_move_text'    => '==Deletion required==
The destination page "[[:$1]]" already exists.
Do you want to delete it to make way for the move?',
'delete_and_move_confirm' => 'Yes, delete the page',
'delete_and_move_reason'  => 'Deleted to make way for move',
'selfmove'                => 'Source and destination titles are the same;
cannot move a page over itself.',
'immobile_namespace'      => 'Source or destination title is of a special type;
cannot move pages from and into that namespace.',
'imagenocrossnamespace'   => 'Cannot move file to non-file namespace',
'imagetypemismatch'       => 'The new file extension does not match its type',
'imageinvalidfilename'    => 'The target file name is invalid',
'fix-double-redirects'    => 'Update any redirects that point to the original title',

# Export
'export'            => 'Export pages',
'exporttext'        => 'You can export the text and editing history of a particular page or set of pages wrapped in some XML.
This can be imported into another wiki using MediaWiki via the [[Special:Import|import page]].

To export pages, enter the titles in the text box below, one title per line, and select whether you want the current version as well as all old versions, with the page history lines, or the current version with the info about the last edit.

In the latter case you can also use a link, e.g. [[{{ns:special}}:Export/{{MediaWiki:Mainpage}}]] for the page "[[{{MediaWiki:Mainpage}}]]".',
'exportcuronly'     => 'Include only the current revision, not the full history',
'exportnohistory'   => "----
'''Note:''' Exporting the full history of pages through this form has been disabled due to performance reasons.",
'export-submit'     => 'Export',
'export-addcattext' => 'Add pages from category:',
'export-addcat'     => 'Add',
'export-download'   => 'Save as file',
'export-templates'  => 'Include templates',

# Namespace 8 related
'allmessages'               => 'System messages',
'allmessagesname'           => 'Name',
'allmessagesdefault'        => 'Default text',
'allmessagescurrent'        => 'Current text',
'allmessagestext'           => 'This is a list of system messages available in the MediaWiki namespace.
Please visit [http://www.mediawiki.org/wiki/Localisation MediaWiki Localisation] and [http://translatewiki.net Betawiki] if you wish to contribute to the generic MediaWiki localisation.',
'allmessagesnotsupportedDB' => "This page cannot be used because '''\$wgUseDatabaseMessages''' has been disabled.",
'allmessagesfilter'         => 'Message name filter:',
'allmessagesmodified'       => 'Show only modified',

# Thumbnails
'thumbnail-more'           => 'Enlarge',
'filemissing'              => 'File missing',
'thumbnail_error'          => 'Error creating thumbnail: $1',
'djvu_page_error'          => 'DjVu page out of range',
'djvu_no_xml'              => 'Unable to fetch XML for DjVu file',
'thumbnail_invalid_params' => 'Invalid thumbnail parameters',
'thumbnail_dest_directory' => 'Unable to create destination directory',

# Special:Import
'import'                     => 'Import pages',
'importinterwiki'            => 'Transwiki import',
'import-interwiki-text'      => "Select a wiki and page title to import.
Revision dates and editors' names will be preserved.
All transwiki import actions are logged at the [[Special:Log/import|import log]].",
'import-interwiki-history'   => 'Copy all history versions for this page',
'import-interwiki-submit'    => 'Import',
'import-interwiki-namespace' => 'Transfer pages into namespace:',
'importtext'                 => 'Please export the file from the source wiki using the [[Special:Export|export utility]].
Save it to your computer and upload it here.',
'importstart'                => 'Importing pages...',
'import-revision-count'      => '$1 {{PLURAL:$1|revision|revisions}}',
'importnopages'              => 'No pages to import.',
'importfailed'               => 'Import failed: <nowiki>$1</nowiki>',
'importunknownsource'        => 'Unknown import source type',
'importcantopen'             => 'Could not open import file',
'importbadinterwiki'         => 'Bad interwiki link',
'importnotext'               => 'Empty or no text',
'importsuccess'              => 'Import finished!',
'importhistoryconflict'      => 'Conflicting history revision exists (may have imported this page before)',
'importnosources'            => 'No transwiki import sources have been defined and direct history uploads are disabled.',
'importnofile'               => 'No import file was uploaded.',
'importuploaderrorsize'      => 'Upload of import file failed.
The file is bigger than the allowed upload size.',
'importuploaderrorpartial'   => 'Upload of import file failed.
The file was only partially uploaded.',
'importuploaderrortemp'      => 'Upload of import file failed.
A temporary folder is missing.',
'import-parse-failure'       => 'XML import parse failure',
'import-noarticle'           => 'No page to import!',
'import-nonewrevisions'      => 'All revisions were previously imported.',
'xml-error-string'           => '$1 at line $2, col $3 (byte $4): $5',
'import-upload'              => 'Upload XML data',

# Import log
'importlogpage'                    => 'Import log',
'importlogpagetext'                => 'Administrative imports of pages with edit history from other wikis.',
'import-logentry-upload'           => 'imported [[$1]] by file upload',
'import-logentry-upload-detail'    => '$1 {{PLURAL:$1|revision|revisions}}',
'import-logentry-interwiki'        => 'transwikied $1',
'import-logentry-interwiki-detail' => '$1 {{PLURAL:$1|revision|revisions}} from $2',

# Keyboard access keys for power users
'accesskey-pt-userpage'             => '.', # do not translate or duplicate this message to other languages
'accesskey-pt-anonuserpage'         => '.', # do not translate or duplicate this message to other languages
'accesskey-pt-mytalk'               => 'n', # do not translate or duplicate this message to other languages
'accesskey-pt-anontalk'             => 'n', # do not translate or duplicate this message to other languages
'accesskey-pt-preferences'          => '', # do not translate or duplicate this message to other languages
'accesskey-pt-watchlist'            => 'l', # do not translate or duplicate this message to other languages
'accesskey-pt-mycontris'            => 'y', # do not translate or duplicate this message to other languages
'accesskey-pt-login'                => 'o', # do not translate or duplicate this message to other languages
'accesskey-pt-anonlogin'            => 'o', # do not translate or duplicate this message to other languages
'accesskey-pt-logout'               => '', # do not translate or duplicate this message to other languages
'accesskey-ca-talk'                 => 't', # do not translate or duplicate this message to other languages
'accesskey-ca-edit'                 => 'e', # do not translate or duplicate this message to other languages
'accesskey-ca-addsection'           => '+', # do not translate or duplicate this message to other languages
'accesskey-ca-viewsource'           => 'e', # do not translate or duplicate this message to other languages
'accesskey-ca-history'              => 'h', # do not translate or duplicate this message to other languages
'accesskey-ca-protect'              => '=', # do not translate or duplicate this message to other languages
'accesskey-ca-delete'               => 'd', # do not translate or duplicate this message to other languages
'accesskey-ca-undelete'             => 'd', # do not translate or duplicate this message to other languages
'accesskey-ca-move'                 => 'm', # do not translate or duplicate this message to other languages
'accesskey-ca-watch'                => 'w', # do not translate or duplicate this message to other languages
'accesskey-ca-unwatch'              => 'w', # do not translate or duplicate this message to other languages
'accesskey-search'                  => 'f', # do not translate or duplicate this message to other languages
'accesskey-search-go'               => '', # do not translate or duplicate this message to other languages
'accesskey-search-fulltext'         => '', # do not translate or duplicate this message to other languages
'accesskey-p-logo'                  => '', # do not translate or duplicate this message to other languages
'accesskey-n-mainpage'              => 'z', # do not translate or duplicate this message to other languages
'accesskey-n-portal'                => '', # do not translate or duplicate this message to other languages
'accesskey-n-currentevents'         => '', # do not translate or duplicate this message to other languages
'accesskey-n-recentchanges'         => 'r', # do not translate or duplicate this message to other languages
'accesskey-n-randompage'            => 'x', # do not translate or duplicate this message to other languages
'accesskey-n-help'                  => '', # do not translate or duplicate this message to other languages
'accesskey-t-whatlinkshere'         => 'j', # do not translate or duplicate this message to other languages
'accesskey-t-recentchangeslinked'   => 'k', # do not translate or duplicate this message to other languages
'accesskey-feed-rss'                => '', # do not translate or duplicate this message to other languages
'accesskey-feed-atom'               => '', # do not translate or duplicate this message to other languages
'accesskey-t-contributions'         => '', # do not translate or duplicate this message to other languages
'accesskey-t-emailuser'             => '', # do not translate or duplicate this message to other languages
'accesskey-t-permalink'             => '', # do not translate or duplicate this message to other languages
'accesskey-t-print'                 => 'p', # do not translate or duplicate this message to other languages
'accesskey-t-upload'                => 'u', # do not translate or duplicate this message to other languages
'accesskey-t-specialpages'          => 'q', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-main'           => 'c', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-user'           => 'c', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-media'          => 'c', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-special'        => '', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-project'        => 'a', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-image'          => 'c', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-mediawiki'      => 'c', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-template'       => 'c', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-help'           => 'c', # do not translate or duplicate this message to other languages
'accesskey-ca-nstab-category'       => 'c', # do not translate or duplicate this message to other languages
'accesskey-minoredit'               => 'i', # do not translate or duplicate this message to other languages
'accesskey-save'                    => 's', # do not translate or duplicate this message to other languages
'accesskey-preview'                 => 'p', # do not translate or duplicate this message to other languages
'accesskey-diff'                    => 'v', # do not translate or duplicate this message to other languages
'accesskey-compareselectedversions' => 'v', # do not translate or duplicate this message to other languages
'accesskey-watch'                   => 'w', # do not translate or duplicate this message to other languages
'accesskey-upload'                  => 's', # do not translate or duplicate this message to other languages

# Tooltip help for the actions
'tooltip-pt-userpage'             => 'My user page',
'tooltip-pt-anonuserpage'         => "The user page for the ip you're editing as",
'tooltip-pt-mytalk'               => 'My talk page',
'tooltip-pt-anontalk'             => 'Discussion about edits from this ip address',
'tooltip-pt-preferences'          => 'My preferences',
'tooltip-pt-watchlist'            => "The list of pages you're monitoring for changes",
'tooltip-pt-mycontris'            => 'List of my contributions',
'tooltip-pt-login'                => 'You are encouraged to log in, it is not mandatory however.',
'tooltip-pt-anonlogin'            => 'You are encouraged to log in, it is not mandatory however.',
'tooltip-pt-logout'               => 'Log out',
'tooltip-ca-talk'                 => 'Discussion about the content page',
'tooltip-ca-edit'                 => 'You can edit this page.
Please use the preview button before saving.',
'tooltip-ca-addsection'           => 'Add a comment to this discussion.',
'tooltip-ca-viewsource'           => 'This page is protected.
You can view its source.',
'tooltip-ca-history'              => 'Past versions of this page.',
'tooltip-ca-protect'              => 'Protect this page',
'tooltip-ca-delete'               => 'Delete this page',
'tooltip-ca-undelete'             => 'Restore the edits done to this page before it was deleted',
'tooltip-ca-move'                 => 'Move this page',
'tooltip-ca-watch'                => 'Add this page to your watchlist',
'tooltip-ca-unwatch'              => 'Remove this page from your watchlist',
'tooltip-search'                  => 'Search {{SITENAME}}',
'tooltip-search-go'               => 'Go to a page with this exact name if exists',
'tooltip-search-fulltext'         => 'Search the pages for this text',
'tooltip-p-logo'                  => 'Main Page',
'tooltip-n-mainpage'              => 'Visit the Main Page',
'tooltip-n-portal'                => 'About the project, what you can do, where to find things',
'tooltip-n-currentevents'         => 'Find background information on current events',
'tooltip-n-recentchanges'         => 'The list of recent changes in the wiki.',
'tooltip-n-randompage'            => 'Load a random page',
'tooltip-n-help'                  => 'The place to find out.',
'tooltip-t-whatlinkshere'         => 'List of all wiki pages that link here',
'tooltip-t-recentchangeslinked'   => 'Recent changes in pages linked from this page',
'tooltip-feed-rss'                => 'RSS feed for this page',
'tooltip-feed-atom'               => 'Atom feed for this page',
'tooltip-t-contributions'         => 'View the list of contributions of this user',
'tooltip-t-emailuser'             => 'Send an e-mail to this user',
'tooltip-t-upload'                => 'Upload files',
'tooltip-t-specialpages'          => 'List of all special pages',
'tooltip-t-print'                 => 'Printable version of this page',
'tooltip-t-permalink'             => 'Permanent link to this version of the page',
'tooltip-ca-nstab-main'           => 'View the content page',
'tooltip-ca-nstab-user'           => 'View the user page',
'tooltip-ca-nstab-media'          => 'View the media page',
'tooltip-ca-nstab-special'        => 'This is a special page, you cannot edit the page itself',
'tooltip-ca-nstab-project'        => 'View the project page',
'tooltip-ca-nstab-image'          => 'View the file page',
'tooltip-ca-nstab-mediawiki'      => 'View the system message',
'tooltip-ca-nstab-template'       => 'View the template',
'tooltip-ca-nstab-help'           => 'View the help page',
'tooltip-ca-nstab-category'       => 'View the category page',
'tooltip-minoredit'               => 'Mark this as a minor edit',
'tooltip-save'                    => 'Save your changes',
'tooltip-preview'                 => 'Preview your changes, please use this before saving!',
'tooltip-diff'                    => 'Show which changes you made to the text.',
'tooltip-compareselectedversions' => 'See the differences between the two selected versions of this page.',
'tooltip-watch'                   => 'Add this page to your watchlist',
'tooltip-recreate'                => 'Recreate the page despite it having been deleted',
'tooltip-upload'                  => 'Start upload',

# Stylesheets
'common.css'      => '/* CSS placed here will be applied to all skins */', # only translate this message to other languages if you have to change it
'standard.css'    => '/* CSS placed here will affect users of the Standard skin */', # only translate this message to other languages if you have to change it
'nostalgia.css'   => '/* CSS placed here will affect users of the Nostalgia skin */', # only translate this message to other languages if you have to change it
'cologneblue.css' => '/* CSS placed here will affect users of the Cologne Blue skin */', # only translate this message to other languages if you have to change it
'monobook.css'    => '/* CSS placed here will affect users of the Monobook skin */', # only translate this message to other languages if you have to change it
'myskin.css'      => '/* CSS placed here will affect users of the Myskin skin */', # only translate this message to other languages if you have to change it
'chick.css'       => '/* CSS placed here will affect users of the Chick skin */', # only translate this message to other languages if you have to change it
'simple.css'      => '/* CSS placed here will affect users of the Simple skin */', # only translate this message to other languages if you have to change it
'modern.css'      => '/* CSS placed here will affect users of the Modern skin */', # only translate this message to other languages if you have to change it

# Scripts
'common.js'      => '/* Any JavaScript here will be loaded for all users on every page load. */', # only translate this message to other languages if you have to change it
'standard.js'    => '/* Any JavaScript here will be loaded for users using the Standard skin */', # only translate this message to other languages if you have to change it
'nostalgia.js'   => '/* Any JavaScript here will be loaded for users using the Nostalgia skin */', # only translate this message to other languages if you have to change it
'cologneblue.js' => '/* Any JavaScript here will be loaded for users using the Cologne Blue skin */', # only translate this message to other languages if you have to change it
'monobook.js'    => '/* Any JavaScript here will be loaded for users using the MonoBook skin */', # only translate this message to other languages if you have to change it
'myskin.js'      => '/* Any JavaScript here will be loaded for users using the Myskin skin */', # only translate this message to other languages if you have to change it
'chick.js'       => '/* Any JavaScript here will be loaded for users using the Chick skin */', # only translate this message to other languages if you have to change it
'simple.js'      => '/* Any JavaScript here will be loaded for users using the Simple skin */', # only translate this message to other languages if you have to change it
'modern.js'      => '/* Any JavaScript here will be loaded for users using the Modern skin */', # only translate this message to other languages if you have to change it

# Metadata
'nodublincore'      => 'Dublin Core RDF metadata disabled for this server.',
'nocreativecommons' => 'Creative Commons RDF metadata disabled for this server.',
'notacceptable'     => 'The wiki server cannot provide data in a format your client can read.',

# Attribution
'anonymous'        => 'Anonymous user(s) of {{SITENAME}}',
'siteuser'         => '{{SITENAME}} user $1',
'lastmodifiedatby' => 'This page was last modified $2, $1 by $3.', # $1 date, $2 time, $3 user
'othercontribs'    => 'Based on work by $1.',
'others'           => 'others',
'siteusers'        => '{{SITENAME}} user(s) $1',
'creditspage'      => 'Page credits',
'nocredits'        => 'There is no credits info available for this page.',

# Spam protection
'spamprotectiontitle' => 'Spam protection filter',
'spamprotectiontext'  => 'The page you wanted to save was blocked by the spam filter.
This is probably caused by a link to an external site.',
'spamprotectionmatch' => 'The following text is what triggered our spam filter: $1',
'spambot_username'    => 'MediaWiki spam cleanup',
'spam_reverting'      => 'Reverting to last version not containing links to $1',
'spam_blanking'       => 'All revisions contained links to $1, blanking',

# Info page
'infosubtitle'   => 'Information for page',
'numedits'       => 'Number of edits (page): $1',
'numtalkedits'   => 'Number of edits (discussion page): $1',
'numwatchers'    => 'Number of watchers: $1',
'numauthors'     => 'Number of distinct authors (page): $1',
'numtalkauthors' => 'Number of distinct authors (discussion page): $1',

# Math options
'mw_math_png'    => 'Always render PNG',
'mw_math_simple' => 'HTML if very simple or else PNG',
'mw_math_html'   => 'HTML if possible or else PNG',
'mw_math_source' => 'Leave it as TeX (for text browsers)',
'mw_math_modern' => 'Recommended for modern browsers',
'mw_math_mathml' => 'MathML if possible (experimental)',

# Patrolling
'markaspatrolleddiff'                 => 'Mark as patrolled',
'markaspatrolledlink'                 => '[$1]', # do not translate or duplicate this message to other languages
'markaspatrolledtext'                 => 'Mark this page as patrolled',
'markedaspatrolled'                   => 'Marked as patrolled',
'markedaspatrolledtext'               => 'The selected revision has been marked as patrolled.',
'rcpatroldisabled'                    => 'Recent Changes Patrol disabled',
'rcpatroldisabledtext'                => 'The Recent Changes Patrol feature is currently disabled.',
'markedaspatrollederror'              => 'Cannot mark as patrolled',
'markedaspatrollederrortext'          => 'You need to specify a revision to mark as patrolled.',
'markedaspatrollederror-noautopatrol' => 'You are not allowed to mark your own changes as patrolled.',

# Patrol log
'patrol-log-page'   => 'Patrol log',
'patrol-log-header' => 'This is a log of patrolled revisions.',
'patrol-log-line'   => 'marked $1 of $2 patrolled $3',
'patrol-log-auto'   => '(automatic)',
'patrol-log-diff'   => 'r$1', # only translate this message to other languages if you have to change it

# Image deletion
'deletedrevision'                 => 'Deleted old revision $1',
'filedeleteerror-short'           => 'Error deleting file: $1',
'filedeleteerror-long'            => 'Errors were encountered while deleting the file:

$1',
'filedelete-missing'              => 'The file "$1" cannot be deleted, because it does not exist.',
'filedelete-old-unregistered'     => 'The specified file revision "$1" is not in the database.',
'filedelete-current-unregistered' => 'The specified file "$1" is not in the database.',
'filedelete-archive-read-only'    => 'The archive directory "$1" is not writable by the webserver.',

# Browsing diffs
'previousdiff' => '← Previous diff',
'nextdiff'     => 'Next diff →',

# Media information
'mediawarning'         => "'''Warning''': This file may contain malicious code, by executing it your system may be compromised.<hr />",
'imagemaxsize'         => 'Limit images on file description pages to:',
'thumbsize'            => 'Thumbnail size:',
'widthheight'          => '$1×$2', # only translate this message to other languages if you have to change it
'widthheightpage'      => '$1×$2, $3 {{PLURAL:$3|page|pages}}',
'file-info'            => '(file size: $1, MIME type: $2)',
'file-info-size'       => '($1 × $2 pixel, file size: $3, MIME type: $4)',
'file-nohires'         => '<small>No higher resolution available.</small>',
'svg-long-desc'        => '(SVG file, nominally $1 × $2 pixels, file size: $3)',
'show-big-image'       => 'Full resolution',
'show-big-image-thumb' => '<small>Size of this preview: $1 × $2 pixels</small>',

# Special:NewImages
'newimages'             => 'Gallery of new files',
'imagelisttext'         => "Below is a list of '''$1''' {{PLURAL:$1|file|files}} sorted $2.",
'newimages-summary'     => 'This special page shows the last uploaded files.',
'showhidebots'          => '($1 bots)',
'noimages'              => 'Nothing to see.',
'ilsubmit'              => 'Search',
'bydate'                => 'by date',
'sp-newimages-showfrom' => 'Show new files starting from $2, $1',

# Video information, used by Language::formatTimePeriod() to format lengths in the above messages
'video-dims'     => '$1, $2×$3', # only translate this message to other languages if you have to change it
'seconds-abbrev' => 's', # only translate this message to other languages if you have to change it
'minutes-abbrev' => 'm', # only translate this message to other languages if you have to change it
'hours-abbrev'   => 'h', # only translate this message to other languages if you have to change it

# Bad image list
'bad_image_list' => 'The format is as follows:

Only list items (lines starting with *) are considered.
The first link on a line must be a link to a bad file.
Any subsequent links on the same line are considered to be exceptions, i.e. pages where the file may occur inline.',

/*
Short names for language variants used for language conversion links.
To disable showing a particular link, set it to 'disable', e.g.
'variantname-zh-sg' => 'disable',
Variants for Chinese language
*/
'variantname-zh-hans' => 'hans', # only translate this message to other languages if you have to change it
'variantname-zh-hant' => 'hant', # only translate this message to other languages if you have to change it
'variantname-zh-cn'   => 'cn', # only translate this message to other languages if you have to change it
'variantname-zh-tw'   => 'tw', # only translate this message to other languages if you have to change it
'variantname-zh-hk'   => 'hk', # only translate this message to other languages if you have to change it
'variantname-zh-mo'   => 'mo', # only translate this message to other languages if you have to change it
'variantname-zh-sg'   => 'sg', # only translate this message to other languages if you have to change it
'variantname-zh-my'   => 'my', # only translate this message to other languages if you have to change it
'variantname-zh'      => 'zh', # only translate this message to other languages if you have to change it

# Variants for Serbian language
'variantname-sr-ec' => 'sr-ec', # only translate this message to other languages if you have to change it
'variantname-sr-el' => 'sr-el', # only translate this message to other languages if you have to change it
'variantname-sr'    => 'sr', # only translate this message to other languages if you have to change it

# Variants for Kazakh language
'variantname-kk-kz'   => 'kk-kz', # only translate this message to other languages if you have to change it
'variantname-kk-tr'   => 'kk-tr', # only translate this message to other languages if you have to change it
'variantname-kk-cn'   => 'kk-cn', # only translate this message to other languages if you have to change it
'variantname-kk-cyrl' => 'kk-cyrl', # only translate this message to other languages if you have to change it
'variantname-kk-latn' => 'kk-latn', # only translate this message to other languages if you have to change it
'variantname-kk-arab' => 'kk-arab', # only translate this message to other languages if you have to change it
'variantname-kk'      => 'kk', # only translate this message to other languages if you have to change it

# Variants for Kurdish language
'variantname-ku-arab' => 'ku-Arab', # only translate this message to other languages if you have to change it
'variantname-ku-latn' => 'ku-Latn', # only translate this message to other languages if you have to change it
'variantname-ku'      => 'ku', # only translate this message to other languages if you have to change it

# Variants for Tajiki language
'variantname-tg-cyrl' => 'tg-Cyrl', # only translate this message to other languages if you have to change it
'variantname-tg-latn' => 'tg-Latn', # only translate this message to other languages if you have to change it
'variantname-tg'      => 'tg', # only translate this message to other languages if you have to change it

# Metadata
'metadata'          => 'Metadata',
'metadata-help'     => 'This file contains additional information, probably added from the digital camera or scanner used to create or digitize it.
If the file has been modified from its original state, some details may not fully reflect the modified file.',
'metadata-expand'   => 'Show extended details',
'metadata-collapse' => 'Hide extended details',
'metadata-fields'   => 'EXIF metadata fields listed in this message will be included on image page display when the metadata table is collapsed.
Others will be hidden by default.
* make
* model
* datetimeoriginal
* exposuretime
* fnumber
* focallength', # Do not translate list items

# EXIF tags
'exif-imagewidth'                  => 'Width',
'exif-imagelength'                 => 'Height',
'exif-bitspersample'               => 'Bits per component',
'exif-compression'                 => 'Compression scheme',
'exif-photometricinterpretation'   => 'Pixel composition',
'exif-orientation'                 => 'Orientation',
'exif-samplesperpixel'             => 'Number of components',
'exif-planarconfiguration'         => 'Data arrangement',
'exif-ycbcrsubsampling'            => 'Subsampling ratio of Y to C',
'exif-ycbcrpositioning'            => 'Y and C positioning',
'exif-xresolution'                 => 'Horizontal resolution',
'exif-yresolution'                 => 'Vertical resolution',
'exif-resolutionunit'              => 'Unit of X and Y resolution',
'exif-stripoffsets'                => 'Image data location',
'exif-rowsperstrip'                => 'Number of rows per strip',
'exif-stripbytecounts'             => 'Bytes per compressed strip',
'exif-jpeginterchangeformat'       => 'Offset to JPEG SOI',
'exif-jpeginterchangeformatlength' => 'Bytes of JPEG data',
'exif-transferfunction'            => 'Transfer function',
'exif-whitepoint'                  => 'White point chromaticity',
'exif-primarychromaticities'       => 'Chromaticities of primarities',
'exif-ycbcrcoefficients'           => 'Color space transformation matrix coefficients',
'exif-referenceblackwhite'         => 'Pair of black and white reference values',
'exif-datetime'                    => 'File change date and time',
'exif-imagedescription'            => 'Image title',
'exif-make'                        => 'Camera manufacturer',
'exif-model'                       => 'Camera model',
'exif-software'                    => 'Software used',
'exif-artist'                      => 'Author',
'exif-copyright'                   => 'Copyright holder',
'exif-exifversion'                 => 'Exif version',
'exif-flashpixversion'             => 'Supported Flashpix version',
'exif-colorspace'                  => 'Color space',
'exif-componentsconfiguration'     => 'Meaning of each component',
'exif-compressedbitsperpixel'      => 'Image compression mode',
'exif-pixelydimension'             => 'Valid image width',
'exif-pixelxdimension'             => 'Valid image height',
'exif-makernote'                   => 'Manufacturer notes',
'exif-usercomment'                 => 'User comments',
'exif-relatedsoundfile'            => 'Related audio file',
'exif-datetimeoriginal'            => 'Date and time of data generation',
'exif-datetimedigitized'           => 'Date and time of digitizing',
'exif-subsectime'                  => 'DateTime subseconds',
'exif-subsectimeoriginal'          => 'DateTimeOriginal subseconds',
'exif-subsectimedigitized'         => 'DateTimeDigitized subseconds',
'exif-exposuretime'                => 'Exposure time',
'exif-exposuretime-format'         => '$1 sec ($2)',
'exif-fnumber'                     => 'F Number',
'exif-fnumber-format'              => 'f/$1', # only translate this message to other languages if you have to change it
'exif-exposureprogram'             => 'Exposure Program',
'exif-spectralsensitivity'         => 'Spectral sensitivity',
'exif-isospeedratings'             => 'ISO speed rating',
'exif-oecf'                        => 'Optoelectronic conversion factor',
'exif-shutterspeedvalue'           => 'Shutter speed',
'exif-aperturevalue'               => 'Aperture',
'exif-brightnessvalue'             => 'Brightness',
'exif-exposurebiasvalue'           => 'Exposure bias',
'exif-maxaperturevalue'            => 'Maximum land aperture',
'exif-subjectdistance'             => 'Subject distance',
'exif-meteringmode'                => 'Metering mode',
'exif-lightsource'                 => 'Light source',
'exif-flash'                       => 'Flash',
'exif-focallength'                 => 'Lens focal length',
'exif-focallength-format'          => '$1 mm', # only translate this message to other languages if you have to change it
'exif-subjectarea'                 => 'Subject area',
'exif-flashenergy'                 => 'Flash energy',
'exif-spatialfrequencyresponse'    => 'Spatial frequency response',
'exif-focalplanexresolution'       => 'Focal plane X resolution',
'exif-focalplaneyresolution'       => 'Focal plane Y resolution',
'exif-focalplaneresolutionunit'    => 'Focal plane resolution unit',
'exif-subjectlocation'             => 'Subject location',
'exif-exposureindex'               => 'Exposure index',
'exif-sensingmethod'               => 'Sensing method',
'exif-filesource'                  => 'File source',
'exif-scenetype'                   => 'Scene type',
'exif-cfapattern'                  => 'CFA pattern',
'exif-customrendered'              => 'Custom image processing',
'exif-exposuremode'                => 'Exposure mode',
'exif-whitebalance'                => 'White Balance',
'exif-digitalzoomratio'            => 'Digital zoom ratio',
'exif-focallengthin35mmfilm'       => 'Focal length in 35 mm film',
'exif-scenecapturetype'            => 'Scene capture type',
'exif-gaincontrol'                 => 'Scene control',
'exif-contrast'                    => 'Contrast',
'exif-saturation'                  => 'Saturation',
'exif-sharpness'                   => 'Sharpness',
'exif-devicesettingdescription'    => 'Device settings description',
'exif-subjectdistancerange'        => 'Subject distance range',
'exif-imageuniqueid'               => 'Unique image ID',
'exif-gpsversionid'                => 'GPS tag version',
'exif-gpslatituderef'              => 'North or South Latitude',
'exif-gpslatitude'                 => 'Latitude',
'exif-gpslongituderef'             => 'East or West Longitude',
'exif-gpslongitude'                => 'Longitude',
'exif-gpsaltituderef'              => 'Altitude reference',
'exif-gpsaltitude'                 => 'Altitude',
'exif-gpstimestamp'                => 'GPS time (atomic clock)',
'exif-gpssatellites'               => 'Satellites used for measurement',
'exif-gpsstatus'                   => 'Receiver status',
'exif-gpsmeasuremode'              => 'Measurement mode',
'exif-gpsdop'                      => 'Measurement precision',
'exif-gpsspeedref'                 => 'Speed unit',
'exif-gpsspeed'                    => 'Speed of GPS receiver',
'exif-gpstrackref'                 => 'Reference for direction of movement',
'exif-gpstrack'                    => 'Direction of movement',
'exif-gpsimgdirectionref'          => 'Reference for direction of image',
'exif-gpsimgdirection'             => 'Direction of image',
'exif-gpsmapdatum'                 => 'Geodetic survey data used',
'exif-gpsdestlatituderef'          => 'Reference for latitude of destination',
'exif-gpsdestlatitude'             => 'Latitude destination',
'exif-gpsdestlongituderef'         => 'Reference for longitude of destination',
'exif-gpsdestlongitude'            => 'Longitude of destination',
'exif-gpsdestbearingref'           => 'Reference for bearing of destination',
'exif-gpsdestbearing'              => 'Bearing of destination',
'exif-gpsdestdistanceref'          => 'Reference for distance to destination',
'exif-gpsdestdistance'             => 'Distance to destination',
'exif-gpsprocessingmethod'         => 'Name of GPS processing method',
'exif-gpsareainformation'          => 'Name of GPS area',
'exif-gpsdatestamp'                => 'GPS date',
'exif-gpsdifferential'             => 'GPS differential correction',

# Make & model, can be wikified in order to link to the camera and model name
'exif-make-value'     => '$1', # do not translate or duplicate this message to other languages
'exif-model-value'    => '$1', # do not translate or duplicate this message to other languages
'exif-software-value' => '$1', # do not translate or duplicate this message to other languages

# EXIF attributes
'exif-compression-1' => 'Uncompressed',
'exif-compression-6' => 'JPEG', # only translate this message to other languages if you have to change it

'exif-photometricinterpretation-2' => 'RGB', # only translate this message to other languages if you have to change it
'exif-photometricinterpretation-6' => 'YCbCr', # only translate this message to other languages if you have to change it

'exif-unknowndate' => 'Unknown date',

'exif-orientation-1' => 'Normal', # 0th row: top; 0th column: left
'exif-orientation-2' => 'Flipped horizontally', # 0th row: top; 0th column: right
'exif-orientation-3' => 'Rotated 180°', # 0th row: bottom; 0th column: right
'exif-orientation-4' => 'Flipped vertically', # 0th row: bottom; 0th column: left
'exif-orientation-5' => 'Rotated 90° CCW and flipped vertically', # 0th row: left; 0th column: top
'exif-orientation-6' => 'Rotated 90° CW', # 0th row: right; 0th column: top
'exif-orientation-7' => 'Rotated 90° CW and flipped vertically', # 0th row: right; 0th column: bottom
'exif-orientation-8' => 'Rotated 90° CCW', # 0th row: left; 0th column: bottom

'exif-planarconfiguration-1' => 'chunky format',
'exif-planarconfiguration-2' => 'planar format',

'exif-xyresolution-i' => '$1 dpi', # only translate this message to other languages if you have to change it
'exif-xyresolution-c' => '$1 dpc', # only translate this message to other languages if you have to change it

'exif-colorspace-1'      => 'sRGB', # only translate this message to other languages if you have to change it
'exif-colorspace-ffff.h' => 'FFFF.H', # only translate this message to other languages if you have to change it

'exif-componentsconfiguration-0' => 'does not exist',
'exif-componentsconfiguration-1' => 'Y', # only translate this message to other languages if you have to change it
'exif-componentsconfiguration-2' => 'Cb', # only translate this message to other languages if you have to change it
'exif-componentsconfiguration-3' => 'Cr', # only translate this message to other languages if you have to change it
'exif-componentsconfiguration-4' => 'R', # only translate this message to other languages if you have to change it
'exif-componentsconfiguration-5' => 'G', # only translate this message to other languages if you have to change it
'exif-componentsconfiguration-6' => 'B', # only translate this message to other languages if you have to change it

'exif-exposureprogram-0' => 'Not defined',
'exif-exposureprogram-1' => 'Manual',
'exif-exposureprogram-2' => 'Normal program',
'exif-exposureprogram-3' => 'Aperture priority',
'exif-exposureprogram-4' => 'Shutter priority',
'exif-exposureprogram-5' => 'Creative program (biased toward depth of field)',
'exif-exposureprogram-6' => 'Action program (biased toward fast shutter speed)',
'exif-exposureprogram-7' => 'Portrait mode (for closeup photos with the background out of focus)',
'exif-exposureprogram-8' => 'Landscape mode (for landscape photos with the background in focus)',

'exif-subjectdistance-value' => '$1 metres',

'exif-meteringmode-0'   => 'Unknown',
'exif-meteringmode-1'   => 'Average',
'exif-meteringmode-2'   => 'CenterWeightedAverage',
'exif-meteringmode-3'   => 'Spot',
'exif-meteringmode-4'   => 'MultiSpot',
'exif-meteringmode-5'   => 'Pattern',
'exif-meteringmode-6'   => 'Partial',
'exif-meteringmode-255' => 'Other',

'exif-lightsource-0'   => 'Unknown',
'exif-lightsource-1'   => 'Daylight',
'exif-lightsource-2'   => 'Fluorescent',
'exif-lightsource-3'   => 'Tungsten (incandescent light)',
'exif-lightsource-4'   => 'Flash',
'exif-lightsource-9'   => 'Fine weather',
'exif-lightsource-10'  => 'Cloudy weather',
'exif-lightsource-11'  => 'Shade',
'exif-lightsource-12'  => 'Daylight fluorescent (D 5700 – 7100K)',
'exif-lightsource-13'  => 'Day white fluorescent (N 4600 – 5400K)',
'exif-lightsource-14'  => 'Cool white fluorescent (W 3900 – 4500K)',
'exif-lightsource-15'  => 'White fluorescent (WW 3200 – 3700K)',
'exif-lightsource-17'  => 'Standard light A',
'exif-lightsource-18'  => 'Standard light B',
'exif-lightsource-19'  => 'Standard light C',
'exif-lightsource-20'  => 'D55', # only translate this message to other languages if you have to change it
'exif-lightsource-21'  => 'D65', # only translate this message to other languages if you have to change it
'exif-lightsource-22'  => 'D75', # only translate this message to other languages if you have to change it
'exif-lightsource-23'  => 'D50', # only translate this message to other languages if you have to change it
'exif-lightsource-24'  => 'ISO studio tungsten',
'exif-lightsource-255' => 'Other light source',

'exif-focalplaneresolutionunit-2' => 'inches',

'exif-sensingmethod-1' => 'Undefined',
'exif-sensingmethod-2' => 'One-chip color area sensor',
'exif-sensingmethod-3' => 'Two-chip color area sensor',
'exif-sensingmethod-4' => 'Three-chip color area sensor',
'exif-sensingmethod-5' => 'Color sequential area sensor',
'exif-sensingmethod-7' => 'Trilinear sensor',
'exif-sensingmethod-8' => 'Color sequential linear sensor',

'exif-filesource-3' => 'DSC', # only translate this message to other languages if you have to change it

'exif-scenetype-1' => 'A directly photographed image',

'exif-customrendered-0' => 'Normal process',
'exif-customrendered-1' => 'Custom process',

'exif-exposuremode-0' => 'Auto exposure',
'exif-exposuremode-1' => 'Manual exposure',
'exif-exposuremode-2' => 'Auto bracket',

'exif-whitebalance-0' => 'Auto white balance',
'exif-whitebalance-1' => 'Manual white balance',

'exif-scenecapturetype-0' => 'Standard',
'exif-scenecapturetype-1' => 'Landscape',
'exif-scenecapturetype-2' => 'Portrait',
'exif-scenecapturetype-3' => 'Night scene',

'exif-gaincontrol-0' => 'None',
'exif-gaincontrol-1' => 'Low gain up',
'exif-gaincontrol-2' => 'High gain up',
'exif-gaincontrol-3' => 'Low gain down',
'exif-gaincontrol-4' => 'High gain down',

'exif-contrast-0' => 'Normal',
'exif-contrast-1' => 'Soft',
'exif-contrast-2' => 'Hard',

'exif-saturation-0' => 'Normal',
'exif-saturation-1' => 'Low saturation',
'exif-saturation-2' => 'High saturation',

'exif-sharpness-0' => 'Normal',
'exif-sharpness-1' => 'Soft',
'exif-sharpness-2' => 'Hard',

'exif-subjectdistancerange-0' => 'Unknown',
'exif-subjectdistancerange-1' => 'Macro',
'exif-subjectdistancerange-2' => 'Close view',
'exif-subjectdistancerange-3' => 'Distant view',

# Pseudotags used for GPSLatitudeRef and GPSDestLatitudeRef
'exif-gpslatitude-n' => 'North latitude',
'exif-gpslatitude-s' => 'South latitude',

# Pseudotags used for GPSLongitudeRef and GPSDestLongitudeRef
'exif-gpslongitude-e' => 'East longitude',
'exif-gpslongitude-w' => 'West longitude',

'exif-gpsstatus-a' => 'Measurement in progress',
'exif-gpsstatus-v' => 'Measurement interoperability',

'exif-gpsmeasuremode-2' => '2-dimensional measurement',
'exif-gpsmeasuremode-3' => '3-dimensional measurement',

# Pseudotags used for GPSSpeedRef and GPSDestDistanceRef
'exif-gpsspeed-k' => 'Kilometres per hour',
'exif-gpsspeed-m' => 'Miles per hour',
'exif-gpsspeed-n' => 'Knots',

# Pseudotags used for GPSTrackRef, GPSImgDirectionRef and GPSDestBearingRef
'exif-gpsdirection-t' => 'True direction',
'exif-gpsdirection-m' => 'Magnetic direction',

# External editor support
'edit-externally'      => 'Edit this file using an external application',
'edit-externally-help' => 'See the [http://www.mediawiki.org/wiki/Manual:External_editors setup instructions] for more information.',

# 'all' in various places, this might be different for inflected languages
'recentchangesall' => 'all',
'imagelistall'     => 'all',
'watchlistall2'    => 'all',
'namespacesall'    => 'all',
'monthsall'        => 'all',

# E-mail address confirmation
'confirmemail'             => 'Confirm e-mail address',
'confirmemail_noemail'     => 'You do not have a valid e-mail address set in your [[Special:Preferences|user preferences]].',
'confirmemail_text'        => '{{SITENAME}} requires that you validate your e-mail address before using e-mail features.
Activate the button below to send a confirmation mail to your address.
The mail will include a link containing a code;
load the link in your browser to confirm that your e-mail address is valid.',
'confirmemail_pending'     => '<div class="error">A confirmation code has already been e-mailed to you;
if you recently created your account, you may wish to wait a few minutes for it to arrive before trying to request a new code.</div>',
'confirmemail_send'        => 'Mail a confirmation code',
'confirmemail_sent'        => 'Confirmation e-mail sent.',
'confirmemail_oncreate'    => 'A confirmation code was sent to your e-mail address.
This code is not required to log in, but you will need to provide it before enabling any e-mail-based features in the wiki.',
'confirmemail_sendfailed'  => 'Could not send confirmation mail.
Check address for invalid characters.

Mailer returned: $1',
'confirmemail_invalid'     => 'Invalid confirmation code.
The code may have expired.',
'confirmemail_needlogin'   => 'You need to $1 to confirm your e-mail address.',
'confirmemail_success'     => 'Your e-mail address has been confirmed.
You may now [[Special:UserLogin|log in]] and enjoy the wiki.',
'confirmemail_loggedin'    => 'Your e-mail address has now been confirmed.',
'confirmemail_error'       => 'Something went wrong saving your confirmation.',
'confirmemail_subject'     => '{{SITENAME}} e-mail address confirmation',
'confirmemail_body'        => 'Someone, probably you, from IP address $1,
has registered an account "$2" with this e-mail address on {{SITENAME}}.

To confirm that this account really does belong to you and activate
e-mail features on {{SITENAME}}, open this link in your browser:

$3

If you did *not* register the account, follow this link
to cancel the e-mail address confirmation:

$5

This confirmation code will expire at $4.',
'confirmemail_invalidated' => 'E-mail address confirmation canceled',
'invalidateemail'          => 'Cancel e-mail confirmation',

# Scary transclusion
'scarytranscludedisabled' => '[Interwiki transcluding is disabled]',
'scarytranscludefailed'   => '[Template fetch failed for $1; sorry]',
'scarytranscludetoolong'  => '[URL is too long; sorry]',

# Trackbacks
'trackbackbox'      => '<div id="mw_trackbacks">Trackbacks for this page:<br />
$1
</div>',
'trackback'         => '; $4$5 : [$2 $1]', # do not translate or duplicate this message to other languages
'trackbackexcerpt'  => '; $4$5 : [$2 $1]: <nowiki>$3</nowiki>', # do not translate or duplicate this message to other languages
'trackbackremove'   => ' ([$1 Delete])',
'trackbacklink'     => 'Trackback',
'trackbackdeleteok' => 'The trackback was successfully deleted.',

# Delete conflict
'deletedwhileediting' => 'Warning: This page has been deleted after you started editing!',
'confirmrecreate'     => "User [[User:$1|$1]] ([[User talk:$1|talk]]) deleted this page after you started editing with reason:
: ''$2''
Please confirm that you really want to recreate this page.",
'recreate'            => 'Recreate',

'unit-pixel' => 'px', # only translate this message to other languages if you have to change it

# HTML dump
'redirectingto' => 'Redirecting to [[:$1]]...',

# action=purge
'confirm_purge'        => 'Clear the cache of this page?

$1',
'confirm_purge_button' => 'OK',

# AJAX search
'searchcontaining' => "Search for pages containing ''$1''.",
'searchnamed'      => "Search for pages named ''$1''.",
'articletitles'    => "Pages starting with ''$1''",
'hideresults'      => 'Hide results',
'useajaxsearch'    => 'Use AJAX search',

# Separators for various lists, etc.
'catseparator'        => '|', # only translate this message to other languages if you have to change it
'semicolon-separator' => ';', # only translate this message to other languages if you have to change it
'comma-separator'     => ',&#32;', # only translate this message to other languages if you have to change it
'colon-separator'     => ':&#32;', # only translate this message to other languages if you have to change it
'autocomment-prefix'  => '- ', # only translate this message to other languages if you have to change it

# Multipage image navigation
'imgmultipageprev' => '← previous page',
'imgmultipagenext' => 'next page →',
'imgmultigo'       => 'Go!',
'imgmultigoto'     => 'Go to page $1',

# Table pager
'ascending_abbrev'         => 'asc',
'descending_abbrev'        => 'desc',
'table_pager_next'         => 'Next page',
'table_pager_prev'         => 'Previous page',
'table_pager_first'        => 'First page',
'table_pager_last'         => 'Last page',
'table_pager_limit'        => 'Show $1 items per page',
'table_pager_limit_submit' => 'Go',
'table_pager_empty'        => 'No results',

# Auto-summaries
'autosumm-blank'   => 'Removing all content from page',
'autosumm-replace' => "Replacing page with '$1'",
'autoredircomment' => 'Redirecting to [[$1]]',
'autosumm-new'     => 'New page: $1',

# Autoblock whitelist
'autoblock_whitelist' => 'AOL http://webmaster.info.aol.com/proxyinfo.html
*64.12.96.0/19
*149.174.160.0/20
*152.163.240.0/21
*152.163.248.0/22
*152.163.252.0/23
*152.163.96.0/22
*152.163.100.0/23
*195.93.32.0/22
*195.93.48.0/22
*195.93.64.0/19
*195.93.96.0/19
*195.93.16.0/20
*198.81.0.0/22
*198.81.16.0/20
*198.81.8.0/23
*202.67.64.128/25
*205.188.192.0/20
*205.188.208.0/23
*205.188.112.0/20
*205.188.146.144/30
*207.200.112.0/21', # do not translate or duplicate this message to other languages

# Size units
'size-bytes'     => '$1 B', # only translate this message to other languages if you have to change it
'size-kilobytes' => '$1 KB', # only translate this message to other languages if you have to change it
'size-megabytes' => '$1 MB', # only translate this message to other languages if you have to change it
'size-gigabytes' => '$1 GB', # only translate this message to other languages if you have to change it

# Live preview
'livepreview-loading' => 'Loading…',
'livepreview-ready'   => 'Loading… Ready!',
'livepreview-failed'  => 'Live preview failed! Try normal preview.',
'livepreview-error'   => 'Failed to connect: $1 "$2".
Try normal preview.',

# Friendlier slave lag warnings
'lag-warn-normal' => 'Changes newer than $1 {{PLURAL:$1|second|seconds}} may not be shown in this list.',
'lag-warn-high'   => 'Due to high database server lag, changes newer than $1 {{PLURAL:$1|second|seconds}} may not be shown in this list.',

# Watchlist editor
'watchlistedit-numitems'       => 'Your watchlist contains {{PLURAL:$1|1 title|$1 titles}}, excluding talk pages.',
'watchlistedit-noitems'        => 'Your watchlist contains no titles.',
'watchlistedit-normal-title'   => 'Edit watchlist',
'watchlistedit-normal-legend'  => 'Remove titles from watchlist',
'watchlistedit-normal-explain' => 'Titles on your watchlist are shown below.
To remove a title, check the box next to it, and click Remove Titles.
You can also [[Special:Watchlist/raw|edit the raw list]].',
'watchlistedit-normal-submit'  => 'Remove Titles',
'watchlistedit-normal-done'    => '{{PLURAL:$1|1 title was|$1 titles were}} removed from your watchlist:',
'watchlistedit-raw-title'      => 'Edit raw watchlist',
'watchlistedit-raw-legend'     => 'Edit raw watchlist',
'watchlistedit-raw-explain'    => 'Titles on your watchlist are shown below, and can be edited by adding to and removing from the list;
one title per line.
When finished, click Update Watchlist.
You can also [[Special:Watchlist/edit|use the standard editor]].',
'watchlistedit-raw-titles'     => 'Titles:',
'watchlistedit-raw-submit'     => 'Update Watchlist',
'watchlistedit-raw-done'       => 'Your watchlist has been updated.',
'watchlistedit-raw-added'      => '{{PLURAL:$1|1 title was|$1 titles were}} added:',
'watchlistedit-raw-removed'    => '{{PLURAL:$1|1 title was|$1 titles were}} removed:',

# Watchlist editing tools
'watchlisttools-view' => 'View relevant changes',
'watchlisttools-edit' => 'View and edit watchlist',
'watchlisttools-raw'  => 'Edit raw watchlist',

# Iranian month names
'iranian-calendar-m1'  => 'Farvardin', # only translate this message to other languages if you have to change it
'iranian-calendar-m2'  => 'Ordibehesht', # only translate this message to other languages if you have to change it
'iranian-calendar-m3'  => 'Khordad', # only translate this message to other languages if you have to change it
'iranian-calendar-m4'  => 'Tir', # only translate this message to other languages if you have to change it
'iranian-calendar-m5'  => 'Mordad', # only translate this message to other languages if you have to change it
'iranian-calendar-m6'  => 'Shahrivar', # only translate this message to other languages if you have to change it
'iranian-calendar-m7'  => 'Mehr', # only translate this message to other languages if you have to change it
'iranian-calendar-m8'  => 'Aban', # only translate this message to other languages if you have to change it
'iranian-calendar-m9'  => 'Azar', # only translate this message to other languages if you have to change it
'iranian-calendar-m10' => 'Dey', # only translate this message to other languages if you have to change it
'iranian-calendar-m11' => 'Bahman', # only translate this message to other languages if you have to change it
'iranian-calendar-m12' => 'Esfand', # only translate this message to other languages if you have to change it

# Hijri month names
'hijri-calendar-m1'  => 'Muharram', # only translate this message to other languages if you have to change it
'hijri-calendar-m2'  => 'Safar', # only translate this message to other languages if you have to change it
'hijri-calendar-m3'  => "Rabi' al-awwal", # only translate this message to other languages if you have to change it
'hijri-calendar-m4'  => "Rabi' al-thani", # only translate this message to other languages if you have to change it
'hijri-calendar-m5'  => 'Jumada al-awwal', # only translate this message to other languages if you have to change it
'hijri-calendar-m6'  => 'Jumada al-thani', # only translate this message to other languages if you have to change it
'hijri-calendar-m7'  => 'Rajab', # only translate this message to other languages if you have to change it
'hijri-calendar-m8'  => "Sha'aban", # only translate this message to other languages if you have to change it
'hijri-calendar-m9'  => 'Ramadan', # only translate this message to other languages if you have to change it
'hijri-calendar-m10' => 'Shawwal', # only translate this message to other languages if you have to change it
'hijri-calendar-m11' => "Dhu al-Qi'dah", # only translate this message to other languages if you have to change it
'hijri-calendar-m12' => 'Dhu al-Hijjah', # only translate this message to other languages if you have to change it

# Hebrew month names
'hebrew-calendar-m1'      => 'Tishrei', # only translate this message to other languages if you have to change it
'hebrew-calendar-m2'      => 'Cheshvan', # only translate this message to other languages if you have to change it
'hebrew-calendar-m3'      => 'Kislev', # only translate this message to other languages if you have to change it
'hebrew-calendar-m4'      => 'Tevet', # only translate this message to other languages if you have to change it
'hebrew-calendar-m5'      => 'Shevat', # only translate this message to other languages if you have to change it
'hebrew-calendar-m6'      => 'Adar', # only translate this message to other languages if you have to change it
'hebrew-calendar-m6a'     => 'Adar I', # only translate this message to other languages if you have to change it
'hebrew-calendar-m6b'     => 'Adar II', # only translate this message to other languages if you have to change it
'hebrew-calendar-m7'      => 'Nisan', # only translate this message to other languages if you have to change it
'hebrew-calendar-m8'      => 'Iyar', # only translate this message to other languages if you have to change it
'hebrew-calendar-m9'      => 'Sivan', # only translate this message to other languages if you have to change it
'hebrew-calendar-m10'     => 'Tamuz', # only translate this message to other languages if you have to change it
'hebrew-calendar-m11'     => 'Av', # only translate this message to other languages if you have to change it
'hebrew-calendar-m12'     => 'Elul', # only translate this message to other languages if you have to change it
'hebrew-calendar-m1-gen'  => 'Tishrei', # only translate this message to other languages if you have to change it
'hebrew-calendar-m2-gen'  => 'Cheshvan', # only translate this message to other languages if you have to change it
'hebrew-calendar-m3-gen'  => 'Kislev', # only translate this message to other languages if you have to change it
'hebrew-calendar-m4-gen'  => 'Tevet', # only translate this message to other languages if you have to change it
'hebrew-calendar-m5-gen'  => 'Shevat', # only translate this message to other languages if you have to change it
'hebrew-calendar-m6-gen'  => 'Adar', # only translate this message to other languages if you have to change it
'hebrew-calendar-m6a-gen' => 'Adar I', # only translate this message to other languages if you have to change it
'hebrew-calendar-m6b-gen' => 'Adar II', # only translate this message to other languages if you have to change it
'hebrew-calendar-m7-gen'  => 'Nisan', # only translate this message to other languages if you have to change it
'hebrew-calendar-m8-gen'  => 'Iyar', # only translate this message to other languages if you have to change it
'hebrew-calendar-m9-gen'  => 'Sivan', # only translate this message to other languages if you have to change it
'hebrew-calendar-m10-gen' => 'Tamuz', # only translate this message to other languages if you have to change it
'hebrew-calendar-m11-gen' => 'Av', # only translate this message to other languages if you have to change it
'hebrew-calendar-m12-gen' => 'Elul', # only translate this message to other languages if you have to change it

# Signatures
'signature'      => '[[{{ns:user}}:$1|$2]]', # do not translate or duplicate this message to other languages
'signature-anon' => '[[{{#special:Contributions}}/$1|$2]]', # do not translate or duplicate this message to other languages
'timezone-utc'   => 'UTC', # only translate this message to other languages if you have to change it

# Core parser functions
'unknown_extension_tag' => 'Unknown extension tag "$1"',

# Special:Version
'version'                          => 'Version', # Not used as normal message but as header for the special page itself
'version-extensions'               => 'Installed extensions',
'version-specialpages'             => 'Special pages',
'version-parserhooks'              => 'Parser hooks',
'version-variables'                => 'Variables',
'version-other'                    => 'Other',
'version-mediahandlers'            => 'Media handlers',
'version-hooks'                    => 'Hooks',
'version-extension-functions'      => 'Extension functions',
'version-parser-extensiontags'     => 'Parser extension tags',
'version-parser-function-hooks'    => 'Parser function hooks',
'version-skin-extension-functions' => 'Skin extension functions',
'version-hook-name'                => 'Hook name',
'version-hook-subscribedby'        => 'Subscribed by',
'version-version'                  => 'Version',
'version-license'                  => 'License',
'version-software'                 => 'Installed software',
'version-software-product'         => 'Product',
'version-software-version'         => 'Version',

# Special:FilePath
'filepath'         => 'File path',
'filepath-page'    => 'File:',
'filepath-submit'  => 'Path',
'filepath-summary' => 'This special page returns the complete path for a file.
Images are shown in full resolution, other file types are started with their associated program directly.

Enter the file name without the "{{ns:image}}:" prefix.',

# Special:FileDuplicateSearch
'fileduplicatesearch'          => 'Search for duplicate files',
'fileduplicatesearch-summary'  => 'Search for duplicate files on base of its hash value.

Enter the filename without the "{{ns:image}}:" prefix.',
'fileduplicatesearch-legend'   => 'Search for a duplicate',
'fileduplicatesearch-filename' => 'Filename:',
'fileduplicatesearch-submit'   => 'Search',
'fileduplicatesearch-info'     => '$1 × $2 pixel<br />File size: $3<br />MIME type: $4',
'fileduplicatesearch-result-1' => 'The file "$1" has no identical duplication.',
'fileduplicatesearch-result-n' => 'The file "$1" has {{PLURAL:$2|1 identical duplication|$2 identical duplications}}.',

# Special:SpecialPages
'specialpages'                   => 'Special pages',
'specialpages-summary'           => '', # do not translate or duplicate this message to other languages
'specialpages-note'              => '----
* Normal special pages.
* <span class="mw-specialpagerestricted">Restricted special pages.</span>',
'specialpages-group-maintenance' => 'Maintenance reports',
'specialpages-group-other'       => 'Other special pages',
'specialpages-group-login'       => 'Login / sign up',
'specialpages-group-changes'     => 'Recent changes and logs',
'specialpages-group-media'       => 'Media reports and uploads',
'specialpages-group-users'       => 'Users and rights',
'specialpages-group-highuse'     => 'High use pages',
'specialpages-group-pages'       => 'List of pages',
'specialpages-group-pagetools'   => 'Page tools',
'specialpages-group-wiki'        => 'Wiki data and tools',
'specialpages-group-redirects'   => 'Redirecting special pages',
'specialpages-group-spam'        => 'Spam tools',

# Special:BlankPage
'blankpage'              => 'Blank page',
'intentionallyblankpage' => 'This page is intentionally left blank',

);
