#!/bin/bash
# pam-krb5 	(http://www.eyrie.org/~eagle/software/pam-krb5/)
# PAM module for Heimdal Kerberos5 authenticatoin
#	BuildScript for Plamo Linux 4.51
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-02-15
# require:
#	heimdal-1.2
#
VERSION=3.13
SRC_URI=http://archives.eyrie.org/software/kerberos/pam-krb5-$VERSION.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/secure
PAC_DIR=$PLAMO/Packages/4.5.1a/03_ext
BLD_DIR=$PLAMO/pam-krb5
CUSTOM_DIR=$BLD_DIR/Custom

umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p  $WORK
export LANG=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin

if [ ! -f $SRC_DIR/$SRC_FILE ]; then
    (cd $SRC_DIR; \
	wget -N $SRC_URI ; \
	);
fi;

tar xvfz $SRC_DIR/$SRC_FILE
cd  $PAC_NAME
./configure --prefix=/usr --with-krb5=/usr/heimdal
make
DESTDIR=$WORK make install

DOC_DIR=$WORK/usr/share/doc/pam-krb5-$VERSION
mkdir -p $DOC_DIR
cp -p LICENSE NEWS README TODO   $DOC_DIR
cp $BLD_DIR/`basename $0` $DOC_DIR
chown -R root.root $DOC_DIR

cd $WORK
mv usr/lib  ./

PACKAGE=pam_krb5-${VERSION}-${SYS_NAME}.tgz
makepkg ../$PACKAGE
mv -v  ../$PACKAGE  $PAC_DIR/
cd $CWD

