( cd opt ; if [ -d httpd ]; then mv httpd httpd.bak ; fi )
( cd opt ; rm -rf httpd )
( cd opt ; ln -sf httpd-2.2.11 httpd )
if [ -f opt/httpd-2.2.11/bin/apr-1-config ]; then
( cd opt/httpd-2.2.11/lib ; rm -rf libaprutil-1.so )
( cd opt/httpd-2.2.11/lib ; ln -sf libaprutil-1.so. libaprutil-1.so )
( cd opt/httpd-2.2.11/lib ; rm -rf libapr-1.so )
( cd opt/httpd-2.2.11/lib ; ln -sf libapr-1.so. libapr-1.so )
( cd opt/httpd-2.2.11/lib ; rm -rf libapr-1.so.0 )
( cd opt/httpd-2.2.11/lib ; ln -sf libapr-1.so. libapr-1.so.0 )
( cd opt/httpd-2.2.11/lib ; rm -rf libaprutil-1.so.0 )
( cd opt/httpd-2.2.11/lib ; ln -sf libaprutil-1.so. libaprutil-1.so.0 )
fi

#%% begin initialize httpd-2.2.11-i586-P1
# Apache httpd-2.2 web server installer
export PATH=/bin:/usr/bin:/sbin:/usr/sbin
export LANG=C
export LC_ALL=C

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

APACI_DIR=$ROOT/opt/httpd-2.2.11
HTTPD=httpd

#if [ -d $ROOT/opt/$HTTPD ] ; then
#  mv $ROOT/opt/$HTTPD $ROOT/opt/$HTTPD.bak
#fi
#ln -sf $APACI_DIR $ROOT/opt/$HTTPD

/usr/sbin/groupadd apache
/usr/sbin/useradd -g apache wadm
/usr/sbin/useradd -g apache www
mkdir -p             $APACI_DIR/conf/conf.d
chown -R root:apache $APACI_DIR
chmod -R go+rX       $APACI_DIR
mkdir -p             $APACI_DIR/proxy
chown -R www:apache  $APACI_DIR/proxy
mkdir -p             $APACI_DIR/var
chown -R www:apache  $APACI_DIR/var
mkdir -p             $APACI_DIR/uploads
chown -R www:apache  $APACI_DIR/uploads
chown -R wadm:apache $ROOT/opt/htdocs
chmod -R u+w         $ROOT/opt/htdocs

#mkdir -p $ROOT/var/log/$HTTPD
#(cd $APACI_DIR/; ln -sf /var/log/$HTTPD logs)
mkdir -p $APACI_DIR/logs
if [ -f $ROOT/var/log/$HTTPD ]; then
  echo "Warning! Moving $ROOT/var/log/$HTTPD to $ROOT/var/log/$HTTPD.bak"
  mv $ROOT/var/log/$HTTPD to $ROOT/var/log/$HTTPD.bak
fi
(cd $ROOT/var/log; ln -sf $APACI_DIR/logs $HTTPD)

if [ -d $ROOT/etc/logrotate.d ]; then  
  if [ ! -f $ROOT/etc/logrotate.d/$HTTPD ]; then
    cp $APACI_DIR/logs/logrotate.$HTTPD $ROOT/etc/logrotate.d/$HTTPD  
  fi
else  
  if ! fgrep "/opt/$HTTPD/logs/" $ROOT/etc/logrotate.conf 1> /dev/null 2>&1; then     
    cat $APACI_DIR/logs/logrotate.$HTTPD >> $ROOT/etc/logrotate.conf  
  fi  
fi


cd $ROOT/

#NNAME=`hostname -f`
#for Plamo 4.2 or lator version
NNAME=`cat /etc/HOSTNAME`
if [ ".$NNAME" = "." ]; then
  NNAME=`hostname`
  if [ ".$NNAME" = "." ]; then
    NNAME=localhost
  fi
fi

if [ ! -d $APACI_DIR/conf/extra ]; then
    rm -f $APACI_DIR/conf/extra
    cp -a $APACI_DIR/conf/extra.template  $APACI_DIR/conf/extra
fi

if [ "$NNAME" != "" ] ; then
    if [ ! -f $APACI_DIR/conf/httpd.conf ]; then
	sed -e "s/LOCALHOST/$NNAME/" \
	$APACI_DIR/conf/httpd.conf.template \
	> $APACI_DIR/conf/httpd.conf
    fi
    if [ ! -f $APACI_DIR/conf/extra/httpd-ssl.conf ]; then
	sed -e "s/LOCALHOST/$NNAME/" \
	$APACI_DIR/conf/httpd-ssl.conf.template \
	> $APACI_DIR/conf/extra/httpd-ssl.conf
    fi
    mkdir -p $ROOT/opt/htdocs/new
    (cd $ROOT/opt/htdocs/;
	 for f in index.html* ;
		do sed -e "s/domain/$NNAME/" $f > new/$f ;
	 done;
	 mv new/index.html* .;
	 rmdir new;
    )
fi

# Warning, ServerTokens should be "PROD" for production
if ! `grep "^ServerTokens" $APACI_DIR/conf/extra/httpd-default.conf | grep -i PROD >/dev/null 2>&1`; then
  grep "^ServerTokens" $APACI_DIR/conf/extra/httpd-default.conf
  echo "Edit conf/extra/httpd-default.conf, ServerTokens should be \"PROD\" for production!"
fi


# Create new RSA key for SSL.
if [ "$NNAME" != "" ] ; then
        sed -e "s/LOCALHOST/$NNAME/" \
        $APACI_DIR/bin/mkrsakey.sh.template \
        > $APACI_DIR/bin/mkrsakey.sh
        chmod +x $APACI_DIR/bin/mkrsakey.sh
fi
sh $APACI_DIR/bin/mkrsakey.sh
echo "Enter password for admin to access WebDAV(DAV-upload) area."
echo "(https://localhost/uploads)"
$APACI_DIR/bin/htdigest -c "/opt/httpd/digest.passwd" DAV-upload admin

#
# symbolic links
#
cd $ROOT/

if [ -f ./opt/$HTTPD/bin/apr-1-config ]; then
( cd ./opt/$HTTPD/lib ; rm -rf libapr-1.so )
( cd ./opt/$HTTPD/lib ; ln -sf libapr-1.so. libapr-1.so )
( cd ./opt/$HTTPD/lib ; rm -rf libapr-1.so.0 )
( cd ./opt/$HTTPD/lib ; ln -sf libapr-1.so. libapr-1.so.0 )
( cd ./opt/$HTTPD/lib ; rm -rf libaprutil-1.so )
( cd ./opt/$HTTPD/lib ; ln -sf libaprutil-1.so. libaprutil-1.so )
( cd ./opt/$HTTPD/lib ; rm -rf libaprutil-1.so.0 )
( cd ./opt/$HTTPD/lib ; ln -sf libaprutil-1.so. libaprutil-1.so.0 )
fi

if [ -x $ROOT/usr/libexec/namazu.cgi ] ; then
  cp -p $ROOT/usr/libexec/namazu.cgi  $ROOT/opt/$HTTPD/cgi-bin/
fi
if [ -f $ROOT/usr/share/namazu/etc/namazu.png ] ; then
  cp -p $ROOT/usr/share/namazu/etc/namazu.png $ROOT/opt/htdocs
fi


if [ "$ROOT" = "" ]; then
  /opt/$HTTPD/bin/apachectl start
fi

#%% end
