<?php

require_once 'PHPUnit.php';
require_once 'File/Passwd.php';

$GLOBALS['_EXT_'] = array('Unix', 'Cvs', 'Smb', 'Authbasic', 'Authdigest');

/**
 * TestCase for File_PasswdTest class
 * Generated by PHPEdit.XUnit Plugin
 * 
 */
class File_PasswdTest extends PHPUnit_TestCase{
    /**
     * Constructor
     * @param string $name The name of the test.
     * @access protected
     */
    function File_PasswdTest($name){
        $this->PHPUnit_TestCase($name);
    }
    
    /**
     * Called before the test functions will be executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function setUp(){
        
    }
    
    /**
     * Called after the test functions are executed this function is defined in PHPUnit_TestCase and overwritten here
     * @access protected
     */
    function tearDown(){
        
    }
    
    /**
     * Regression test for File_Passwd.apiVersion method
     * @access public
     */
    function testapiVersion(){
        $this->assertEquals('1.0.0', File_Passwd::apiVersion());
    }
    
    /**
     * Regression test for File_Passwd.salt method
     * @access public
     */
    function testsalt(){
        $this->assertEquals(strlen(File_Passwd::salt()), strlen(File_Passwd::salt(2)));
        $regex = '/^[' . preg_quote($GLOBALS['_FILE_PASSWD_64'], '/') . ']+$/';
        $this->assertTrue(preg_match($regex, File_Passwd::salt(20)));
    }
    
    /**
     * Regression test for File_Passwd.crypt_des method
     * @access public
     */
    function testcrypt_des(){
        $this->assertEquals(crypt('a','ab'), File_Passwd::crypt_des('a', 'ab'));
    }
    
    /**
     * Regression test for File_Passwd.crypt_md5 method
     * @access public
     */
    function testcrypt_md5(){
        $this->assertEquals(crypt('a','$1$ab'), File_Passwd::crypt_des('a', '$1$ab'));
    }
    
    /**
     * Regression test for File_Passwd.crypt_sha method
     * @access public
     */
    function testcrypt_sha(){
        $sha = '{SHA}2iNhTgJGmg18e9G9q1ycR0sZBNw=';
        $this->assertEquals($sha, File_Passwd::crypt_sha('ab'));
    }
    
    /**
     * Regression test for File_Passwd.crypt_apr_md5 method
     * @access public
     */
    function testcrypt_apr_md5(){
        $apr = '$apr1$ab$KfzLTsXi6eQkfErEn8CHY.';
        $this->assertEquals($apr, File_Passwd::crypt_apr_md5('ab', 'ab'));
    }
    
    /**
     * Regression test for File_Passwd.factory method
     * @access public
     */
    function testfactory(){
        foreach($GLOBALS['_EXT_'] as $ext){
            $o = File_Passwd::factory($ext);
            $this->assertTrue(is_a($o, "File_Passwd_$ext"));
        }
    }
    
    /**
     * Regression test for File_Passwd.staticAuth method
     * @access public
     */
    function teststaticAuth(){
        foreach($GLOBALS['_EXT_'] as $ext){
            $pwfile = 'passwd.' . strToLower($ext) . '.txt';
            $option = (($ext == 'Authdigest') ? 'realm1' : (($ext == 'Smb') ? 'nt' : 'des'));
            $error = File_Passwd::staticAuth($ext, $pwfile, 'mike', 123, $option);
            $this->assertTrue($error);
            if (PEAR::isError($error)) {
                echo "File_Passwd_$ext::staticAuth() ". $error->getMessage() . "\n";
            }
        }
        
    }
    
}

?>