#!/bin/sh

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

ORIGVER=0.5.6
PKGVER=P1
PACKAGE=hal-$ORIGVER-i386-$PKGVER.tgz

SRCURL1=http://freedesktop.org/~david/dist/hal-0.5.6.tar.gz
SRC1=hal-$ORIGVER.tar.gz
SRCDIR1=hal-$ORIGVER
PATCH11=patches/hal-0.5.4-mntopt-plamo.diff

SRC2=patches/rc.hal
SRC3=patches/10-usb-card-readers.fdi
SRC4=patches/10-usb-music-players.fdi
SRC5=patches/90-hal.rules

INITSCRIPTS=

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar zxf $SRCROOT/$SRC1

cd $SRCDIR1
cat $SRCROOT/$PATCH11 | patch -sp1
./configure --prefix=$PREFIX --localstatedir=/var --with-pid-file=/var/run/hald.pid --with-hal-user=nobody --with-hal-group=nogroup --enable-fstab-sync --enable-pcmcia-support --with-stab-file=/var/run/stab --with-expat=/usr/X11R6 || exit 1
make || exit 1
make install DESTDIR=$PKGROOT udevrulesdir=/etc/udev/rules.d || exit 1
#make install DESTDIR=$PKGROOT udevrulesdir=/etc/udev/rules.d || exit 1

rm -rf $PKGROOT/etc/hotplug.d

mkdir -p $PKGROOT/etc/rc.d/init.d
install -c -o0 -g0 -m0755 $SRCROOT/$SRC2 $PKGROOT/etc/rc.d/init.d/hal

install -c -o0 -g0 -m0755 $SRCROOT/$SRC3 $SRCROOT/$SRC4 $PKGROOT$PREFIX/share/hal/fdi/information/20thirdparty

mkdir -p $PKGROOT/etc/udev/rules.d
install -c -o0 -g0 -m0644 $SRCROOT/$SRC5 $PKGROOT/etc/udev/rules.d

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1
cp AUTHORS COPYING ChangeLog HACKING INSTALL NEWS README $PKGROOT$DOCPREFIX/$SRCDIR1

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE

cp -f $PACKAGE $SRCROOT
cd $SRCROOT
rm -rf $BUILDROOT
