#!/bin/sh -x

wget -q --no-check-certificate https://www.kernel.org/pub/linux/kernel/v3.x/linux-3.12.tar.xz
tar xpJf linux-3.12.tar.xz

wget --no-check-certificate https://www.kernel.org/pub/linux/kernel/v3.x/patch-3.12.4.xz
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/UNICON/vd_unicon-kernel-20131109-3.12.patch
wget http://vdlinux.sourceforge.jp/dists/UNICON/vd_unicon-kernel-fonts-20040205.patch.bz2
git clone git://git.code.sf.net/p/aufs/aufs3-standalone.git
( cd aufs3-standalone ; git checkout origin/aufs3.12 ; git reset --hard 4a7364f )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.12-panic_beep.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.12-morse_code_panics.patch
git clone git://github.com/NigelCunningham/tuxonice-kernel.git
( cd tuxonice-kernel ; git checkout origin/tuxonice-3.12 ; git reset --hard baafdd6
  git diff 81605d3 | bzip2 > ../current-tuxonice-for-3.12.3.patch.bz2 )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/misc/3.12-fork.c-CLONE_PARENT.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/misc/3.12-nl80211.c-nla_put_flag.patch

cd linux-3.12
unxz -c ../patch-3.12.4.xz | patch -Np1 -i -
patch -Np1 -i ../vd_unicon-kernel-20131109-3.12.patch
bunzip2 -c ../vd_unicon-kernel-fonts-20040205.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../aufs3-standalone/aufs3-kbuild.patch
patch -Np1 -i ../aufs3-standalone/aufs3-base.patch
patch -Np1 -i ../aufs3-standalone/aufs3-mmap.patch
patch -Np1 -i ../aufs3-standalone/aufs3-standalone.patch
cp -av ../aufs3-standalone/Documentation .
cp -av ../aufs3-standalone/fs .
cp -pv ../aufs3-standalone/include/uapi/linux/aufs_type.h include/uapi/linux
patch -Np1 -i ../3.12-panic_beep.patch
patch -Np1 -i ../3.12-morse_code_panics.patch
bunzip2 -c ../current-tuxonice-for-3.12.3.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../3.12-fork.c-CLONE_PARENT.patch
patch -Np1 -i ../3.12-nl80211.c-nla_put_flag.patch
find . -name "*.orig" -ls -exec rm {} \;
