#!/bin/sh -x

wget -q http://www.kernel.org/pub/linux/kernel/v3.x/linux-3.0.tar.xz
tar xpJf linux-3.0.tar.xz

wget http://www.kernel.org/pub/linux/kernel/v3.x/patch-3.0.9.xz
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/UNICON/vd_unicon-kernel-20110730-3.0.patch
wget http://vdlinux.sourceforge.jp/dists/UNICON/vd_unicon-kernel-fonts-20040205.patch.bz2
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/misc/2.6.31-export-init_mm.patch
git clone git://aufs.git.sourceforge.net/gitroot/aufs/aufs3-standalone.git
( cd aufs3-standalone ; git checkout origin/aufs3.0 ; git reset --hard 517b276 )
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/sqlzma/2.6.38-sqlzma.tar.gz
tar xvpzf 2.6.38-sqlzma.tar.gz
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/sqlzma/2.6.38-sqlzma_decompress_unxz.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.0-panic_beep.patch
wget ftp://plamo.linet.gr.jp/pub/Plamo-test/kernelsrc_patches/mcp/3.0-morse_code_panics.patch
wget http://tuxonice.net/files/current-tuxonice-for-3.0.patch.bz2

cd linux-3.0
unxz -c ../patch-3.0.9.xz | patch -Np1 -i -
patch -Np1 -i ../vd_unicon-kernel-20110730-3.0.patch
bunzip2 -c ../vd_unicon-kernel-fonts-20040205.patch.bz2 | patch -Np1 -i -
patch -Np1 -i ../2.6.31-export-init_mm.patch
patch -Np1 -i ../aufs3-standalone/aufs3-kbuild.patch
patch -Np1 -i ../aufs3-standalone/aufs3-base.patch
patch -Np1 -i ../aufs3-standalone/aufs3-proc_map.patch
patch -Np1 -i ../aufs3-standalone/aufs3-standalone.patch
cp -av ../aufs3-standalone/Documentation .
cp -av ../aufs3-standalone/fs .
cp -pv ../aufs3-standalone/include/linux/aufs_type.h include/linux
sqlzma_pdir=2.6.38-sqlzma/patches
patch -Np1 -i ../$sqlzma_pdir/0001-Squashfs-add-support-for-LZMA-compressed-filesystems.patch
patch -Np1 -i ../$sqlzma_pdir/0002-lzma-Make-lzma-available-to-non-initramfs-initrd-cod.patch
patch -Np1 -i ../$sqlzma_pdir/0003-Squashfs-select-DECOMPRESS_LZMA_NEEDED-when-includin.patch
patch -Np1 -i ../$sqlzma_pdir/0004-lzma-make-lzma-reentrant.patch
patch -Np1 -i ../$sqlzma_pdir/0005-libs-force-lzma_wrapper-to-be-retained.patch
patch -Np1 -i ../$sqlzma_pdir/0006-squashfs-add-missing-slab.h-include-in-lzma_wrapper.patch
patch -Np1 -i ../2.6.38-sqlzma_decompress_unxz.patch
patch -Np1 -i ../3.0-panic_beep.patch
patch -Np1 -i ../3.0-morse_code_panics.patch
bunzip2 -c ../current-tuxonice-for-3.0.patch.bz2 | patch -Np1 -i -
find . -name "*.orig" -ls -exec rm {} \;
