/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmic;

import gnu.classpath.tools.rmic.RMICException;
import gnu.classpath.tools.rmic.RmicBackend;
import gnu.classpath.tools.rmic.Variables;
import gnu.java.rmi.server.RMIHashes;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnexpectedException;
import java.rmi.UnmarshalException;
import java.rmi.server.Operation;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonMismatchException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ClassRmicCompiler
implements RmicBackend {
    private String[] args;
    private int next;
    private List errors = new ArrayList();
    private boolean keep = false;
    private boolean need11Stubs = true;
    private boolean need12Stubs = true;
    private boolean compile = true;
    private boolean verbose;
    private boolean noWrite;
    private String destination;
    private String classpath;
    private ClassLoader loader;
    private int errorCount = 0;
    private Class clazz;
    private String classname;
    private String classInternalName;
    private String fullclassname;
    private MethodRef[] remotemethods;
    private String stubname;
    private String skelname;
    private List mRemoteInterfaces;
    private static final String forName = "class$";

    public boolean run(String[] inputFiles) {
        this.args = inputFiles;
        if (this.next >= this.args.length) {
            return false;
        }
        int i = this.next;
        while (i < this.args.length) {
            try {
                if (this.verbose) {
                    System.out.println("[Processing class " + this.args[i] + ".class]");
                }
                this.processClass(this.args[i].replace(File.separatorChar, '.'));
            }
            catch (IOException e) {
                this.errors.add(e);
            }
            catch (RMICException e) {
                this.errors.add(e);
            }
            ++i;
        }
        if (this.errors.size() > 0) {
            for (Exception ex : this.errors) {
                this.logError(ex);
            }
        }
        return this.errorCount == 0;
    }

    private void processClass(String cls) throws IOException, RMICException {
        this.clazz = null;
        this.classname = null;
        this.classInternalName = null;
        this.fullclassname = null;
        this.remotemethods = null;
        this.stubname = null;
        this.skelname = null;
        this.mRemoteInterfaces = new ArrayList();
        this.analyzeClass(cls);
        this.generateStub();
        if (this.need11Stubs) {
            this.generateSkel();
        }
    }

    private void analyzeClass(String cname) throws RMICException {
        int p;
        if (this.verbose) {
            System.out.println("[analyze class " + cname + "]");
        }
        this.classname = (p = cname.lastIndexOf(46)) != -1 ? cname.substring(p + 1) : cname;
        this.fullclassname = cname;
        this.findClass();
        this.findRemoteMethods();
    }

    public Exception getException() {
        return this.errors.size() == 0 ? null : (Exception)this.errors.get(0);
    }

    private void findClass() throws RMICException {
        ClassLoader cl = this.loader == null ? ClassLoader.getSystemClassLoader() : this.loader;
        try {
            this.clazz = Class.forName(this.fullclassname, false, cl);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RMICException("Class " + this.fullclassname + " not found in classpath", cnfe);
        }
        if (!Remote.class.isAssignableFrom(this.clazz)) {
            throw new RMICException("Class " + this.clazz.getName() + " does not implement a remote interface.");
        }
    }

    private static Type[] typeArray(Class[] cls) {
        Type[] t = new Type[cls.length];
        int i = 0;
        while (i < cls.length) {
            t[i] = Type.getType(cls[i]);
            ++i;
        }
        return t;
    }

    private static String[] internalNameArray(Type[] t) {
        String[] s = new String[t.length];
        int i = 0;
        while (i < t.length) {
            s[i] = t[i].getInternalName();
            ++i;
        }
        return s;
    }

    private static String[] internalNameArray(Class[] c) {
        return ClassRmicCompiler.internalNameArray(ClassRmicCompiler.typeArray(c));
    }

    private static Object param(Method m, int argIndex) {
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(m);
        l.add(new Integer(argIndex));
        return l;
    }

    private static void generateClassForNamer(ClassVisitor cls) {
        MethodVisitor cv = cls.visitMethod(4106, forName, Type.getMethodDescriptor(Type.getType(Class.class), new Type[]{Type.getType(String.class)}), null, null);
        Label start = new Label();
        cv.visitLabel(start);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(184, Type.getInternalName(Class.class), "forName", Type.getMethodDescriptor(Type.getType(Class.class), new Type[]{Type.getType(String.class)}));
        cv.visitInsn(176);
        Label handler = new Label();
        cv.visitLabel(handler);
        cv.visitVarInsn(58, 1);
        cv.visitTypeInsn(187, ClassRmicCompiler.typeArg(NoClassDefFoundError.class));
        cv.visitInsn(89);
        cv.visitVarInsn(25, 1);
        cv.visitMethodInsn(182, Type.getInternalName(ClassNotFoundException.class), "getMessage", Type.getMethodDescriptor(Type.getType(String.class), new Type[0]));
        cv.visitMethodInsn(183, Type.getInternalName(NoClassDefFoundError.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
        cv.visitInsn(191);
        cv.visitTryCatchBlock(start, handler, handler, Type.getInternalName(ClassNotFoundException.class));
        cv.visitMaxs(-1, -1);
    }

    private void generateClassConstant(MethodVisitor cv, Class cls) {
        if (cls.isPrimitive()) {
            Class boxCls;
            if (cls.equals(Boolean.TYPE)) {
                boxCls = Boolean.class;
            } else if (cls.equals(Character.TYPE)) {
                boxCls = Character.class;
            } else if (cls.equals(Byte.TYPE)) {
                boxCls = Byte.class;
            } else if (cls.equals(Short.TYPE)) {
                boxCls = Short.class;
            } else if (cls.equals(Integer.TYPE)) {
                boxCls = Integer.class;
            } else if (cls.equals(Long.TYPE)) {
                boxCls = Long.class;
            } else if (cls.equals(Float.TYPE)) {
                boxCls = Float.class;
            } else if (cls.equals(Double.TYPE)) {
                boxCls = Double.class;
            } else if (cls.equals(Void.TYPE)) {
                boxCls = Void.class;
            } else {
                throw new IllegalArgumentException("unknown primitive type " + cls);
            }
            cv.visitFieldInsn(178, Type.getInternalName(boxCls), "TYPE", Type.getDescriptor(Class.class));
            return;
        }
        cv.visitLdcInsn(cls.getName());
        cv.visitMethodInsn(184, this.classInternalName, forName, Type.getMethodDescriptor(Type.getType(Class.class), new Type[]{Type.getType(String.class)}));
    }

    private void generateClassArray(MethodVisitor code, Class[] classes) {
        code.visitLdcInsn(new Integer(classes.length));
        code.visitTypeInsn(189, ClassRmicCompiler.typeArg(Class.class));
        int i = 0;
        while (i < classes.length) {
            code.visitInsn(89);
            code.visitLdcInsn(new Integer(i));
            this.generateClassConstant(code, classes[i]);
            code.visitInsn(83);
            ++i;
        }
    }

    private void fillOperationArray(MethodVisitor clinit) {
        clinit.visitLdcInsn(new Integer(this.remotemethods.length));
        clinit.visitTypeInsn(189, ClassRmicCompiler.typeArg(Operation.class));
        clinit.visitFieldInsn(179, this.classInternalName, "operations", Type.getDescriptor(Operation[].class));
        int i = 0;
        while (i < this.remotemethods.length) {
            Method m = this.remotemethods[i].meth;
            StringBuilder desc = new StringBuilder();
            desc.append(String.valueOf(ClassRmicCompiler.getPrettyName(m.getReturnType())) + " ");
            desc.append(String.valueOf(m.getName()) + "(");
            Class<?>[] sig = m.getParameterTypes();
            int j = 0;
            while (j < sig.length) {
                desc.append(ClassRmicCompiler.getPrettyName(sig[j]));
                if (j + 1 < sig.length) {
                    desc.append(", ");
                }
                ++j;
            }
            clinit.visitFieldInsn(178, this.classInternalName, "operations", Type.getDescriptor(Operation[].class));
            clinit.visitLdcInsn(new Integer(i));
            clinit.visitTypeInsn(187, ClassRmicCompiler.typeArg(Operation.class));
            clinit.visitInsn(89);
            clinit.visitLdcInsn(desc.toString());
            clinit.visitMethodInsn(183, Type.getInternalName(Operation.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
            clinit.visitInsn(83);
            ++i;
        }
    }

    private void generateStaticMethodObjs(MethodVisitor clinit) {
        int i = 0;
        while (i < this.remotemethods.length) {
            Method m = this.remotemethods[i].meth;
            String methodVar = "$method_" + m.getName() + "_" + i;
            this.generateClassConstant(clinit, m.getDeclaringClass());
            clinit.visitLdcInsn(m.getName());
            this.generateClassArray(clinit, m.getParameterTypes());
            clinit.visitMethodInsn(182, Type.getInternalName(Class.class), "getMethod", Type.getMethodDescriptor(Type.getType(Method.class), new Type[]{Type.getType(String.class), Type.getType(Class[].class)}));
            clinit.visitFieldInsn(179, this.classInternalName, methodVar, Type.getDescriptor(Method.class));
            ++i;
        }
    }

    private void generateStub() throws IOException {
        this.stubname = String.valueOf(this.fullclassname) + "_Stub";
        String cfr_ignored_0 = String.valueOf(this.classname) + "_Stub";
        File file = new File(String.valueOf(this.destination == null ? "." : this.destination) + File.separator + this.stubname.replace('.', File.separatorChar) + ".class");
        if (this.verbose) {
            System.out.println("[Generating class " + this.stubname + "]");
        }
        ClassWriter stub = new ClassWriter(true);
        this.classInternalName = this.stubname.replace('.', '/');
        String superInternalName = Type.getType(RemoteStub.class).getInternalName();
        String[] remoteInternalNames = ClassRmicCompiler.internalNameArray(this.mRemoteInterfaces.toArray(new Class[0]));
        stub.visit(46, 17, this.classInternalName, null, superInternalName, remoteInternalNames);
        if (this.need12Stubs) {
            stub.visitField(26, "serialVersionUID", Type.LONG_TYPE.getDescriptor(), null, new Long(2L));
        }
        if (this.need11Stubs) {
            stub.visitField(26, "interfaceHash", Type.LONG_TYPE.getDescriptor(), null, new Long(RMIHashes.getInterfaceHash((Class)this.clazz)));
            if (this.need12Stubs) {
                stub.visitField(10, "useNewInvoke", Type.BOOLEAN_TYPE.getDescriptor(), null, null);
            }
            stub.visitField(26, "operations", Type.getDescriptor(Operation[].class), null, null);
        }
        if (this.need12Stubs) {
            int i = 0;
            while (i < this.remotemethods.length) {
                Method m = this.remotemethods[i].meth;
                String slotName = "$method_" + m.getName() + "_" + i;
                stub.visitField(10, slotName, Type.getDescriptor(Method.class), null, null);
                ++i;
            }
        }
        MethodVisitor clinit = stub.visitMethod(8, "<clinit>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        if (this.need11Stubs) {
            this.fillOperationArray(clinit);
            if (!this.need12Stubs) {
                clinit.visitInsn(177);
            }
        }
        if (this.need12Stubs) {
            Label begin = new Label();
            Label handler = new Label();
            clinit.visitLabel(begin);
            if (this.need11Stubs) {
                this.generateClassConstant(clinit, RemoteRef.class);
                clinit.visitLdcInsn("invoke");
                this.generateClassArray(clinit, new Class[]{Remote.class, Method.class, Object[].class, Long.TYPE});
                clinit.visitMethodInsn(182, Type.getInternalName(Class.class), "getMethod", Type.getMethodDescriptor(Type.getType(Method.class), new Type[]{Type.getType(String.class), Type.getType(Class[].class)}));
                clinit.visitInsn(4);
                clinit.visitFieldInsn(179, this.classInternalName, "useNewInvoke", Type.BOOLEAN_TYPE.getDescriptor());
            }
            this.generateStaticMethodObjs(clinit);
            clinit.visitInsn(177);
            clinit.visitLabel(handler);
            if (this.need11Stubs) {
                clinit.visitInsn(3);
                clinit.visitFieldInsn(179, this.classInternalName, "useNewInvoke", Type.BOOLEAN_TYPE.getDescriptor());
                clinit.visitInsn(177);
            } else {
                clinit.visitTypeInsn(187, ClassRmicCompiler.typeArg(NoSuchMethodError.class));
                clinit.visitInsn(89);
                clinit.visitLdcInsn("stub class initialization failed");
                clinit.visitMethodInsn(183, Type.getInternalName(NoSuchMethodError.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
                clinit.visitInsn(191);
            }
            clinit.visitTryCatchBlock(begin, handler, handler, Type.getInternalName(NoSuchMethodException.class));
        }
        clinit.visitMaxs(-1, -1);
        ClassRmicCompiler.generateClassForNamer(stub);
        if (this.need11Stubs) {
            MethodVisitor code = stub.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
            code.visitVarInsn(25, 0);
            code.visitMethodInsn(183, superInternalName, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
            code.visitInsn(177);
            code.visitMaxs(-1, -1);
        }
        MethodVisitor constructor = stub.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(RemoteRef.class)}), null, null);
        constructor.visitVarInsn(25, 0);
        constructor.visitVarInsn(25, 1);
        constructor.visitMethodInsn(183, superInternalName, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(RemoteRef.class)}));
        constructor.visitInsn(177);
        constructor.visitMaxs(-1, -1);
        int i = 0;
        while (i < this.remotemethods.length) {
            Method m = this.remotemethods[i].meth;
            Class[] sig = m.getParameterTypes();
            Class<Object> returntype = m.getReturnType();
            Class[] except = this.sortExceptions(this.remotemethods[i].exceptions.toArray(new Class[0]));
            MethodVisitor code = stub.visitMethod(1, m.getName(), Type.getMethodDescriptor(Type.getType(returntype), ClassRmicCompiler.typeArray(sig)), null, ClassRmicCompiler.internalNameArray(ClassRmicCompiler.typeArray(except)));
            Variables var = new Variables();
            var.declare("this");
            int j = 0;
            while (j < sig.length) {
                var.declare(ClassRmicCompiler.param(m, j), ClassRmicCompiler.size(sig[j]));
                ++j;
            }
            Label methodTryBegin = new Label();
            code.visitLabel(methodTryBegin);
            if (this.need12Stubs) {
                Label oldInvoke = new Label();
                if (this.need11Stubs) {
                    code.visitFieldInsn(178, this.classInternalName, "useNewInvoke", Type.getDescriptor(Boolean.TYPE));
                    code.visitJumpInsn(153, oldInvoke);
                }
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(180, Type.getInternalName(RemoteObject.class), "ref", Type.getDescriptor(RemoteRef.class));
                code.visitVarInsn(25, var.get("this"));
                String methName = "$method_" + m.getName() + "_" + i;
                code.visitFieldInsn(178, this.classInternalName, methName, Type.getDescriptor(Method.class));
                if (sig.length == 0) {
                    code.visitInsn(1);
                } else {
                    code.visitLdcInsn(new Integer(sig.length));
                    code.visitTypeInsn(189, ClassRmicCompiler.typeArg(Object.class));
                    var.allocate("argArray");
                    code.visitVarInsn(58, var.get("argArray"));
                    int j2 = 0;
                    while (j2 < sig.length) {
                        ClassRmicCompiler.size(sig[j2]);
                        int insn = ClassRmicCompiler.loadOpcode(sig[j2]);
                        Class box = sig[j2].isPrimitive() ? ClassRmicCompiler.box(sig[j2]) : null;
                        code.visitVarInsn(25, var.get("argArray"));
                        code.visitLdcInsn(new Integer(j2));
                        if (box != null) {
                            code.visitTypeInsn(187, ClassRmicCompiler.typeArg(box));
                            code.visitInsn(89);
                            code.visitVarInsn(insn, var.get(ClassRmicCompiler.param(m, j2)));
                            code.visitMethodInsn(183, Type.getInternalName(box), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(sig[j2])}));
                        } else {
                            code.visitVarInsn(insn, var.get(ClassRmicCompiler.param(m, j2)));
                        }
                        code.visitInsn(83);
                        ++j2;
                    }
                    code.visitVarInsn(25, var.deallocate("argArray"));
                }
                code.visitLdcInsn(new Long(this.remotemethods[i].hash));
                code.visitMethodInsn(185, Type.getInternalName(RemoteRef.class), "invoke", Type.getMethodDescriptor(Type.getType(Object.class), new Type[]{Type.getType(Remote.class), Type.getType(Method.class), Type.getType(Object[].class), Type.LONG_TYPE}));
                if (!returntype.equals(Void.TYPE)) {
                    int retcode = ClassRmicCompiler.returnOpcode(returntype);
                    Class<Object> boxCls = returntype.isPrimitive() ? ClassRmicCompiler.box(returntype) : null;
                    code.visitTypeInsn(192, ClassRmicCompiler.typeArg(boxCls == null ? returntype : boxCls));
                    if (returntype.isPrimitive()) {
                        code.visitMethodInsn(182, Type.getType(boxCls).getInternalName(), ClassRmicCompiler.unboxMethod(returntype), Type.getMethodDescriptor(Type.getType(returntype), new Type[0]));
                    }
                    code.visitInsn(retcode);
                } else {
                    code.visitInsn(177);
                }
                if (this.need11Stubs) {
                    code.visitLabel(oldInvoke);
                }
            }
            if (this.need11Stubs) {
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(180, Type.getInternalName(RemoteObject.class), "ref", Type.getDescriptor(RemoteRef.class));
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(178, this.classInternalName, "operations", Type.getDescriptor(Operation[].class));
                code.visitLdcInsn(new Integer(i));
                code.visitFieldInsn(178, this.classInternalName, "interfaceHash", Type.LONG_TYPE.getDescriptor());
                code.visitMethodInsn(185, Type.getInternalName(RemoteRef.class), "newCall", Type.getMethodDescriptor(Type.getType(RemoteCall.class), new Type[]{Type.getType(RemoteObject.class), Type.getType(Operation[].class), Type.INT_TYPE, Type.LONG_TYPE}));
                var.allocate("call");
                code.visitInsn(89);
                code.visitVarInsn(58, var.get("call"));
                Label beginArgumentTryBlock = new Label();
                code.visitLabel(beginArgumentTryBlock);
                code.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "getOutputStream", Type.getMethodDescriptor(Type.getType(ObjectOutput.class), new Type[0]));
                int j3 = 0;
                while (j3 < sig.length) {
                    code.visitInsn(89);
                    code.visitVarInsn(ClassRmicCompiler.loadOpcode(sig[j3]), var.get(ClassRmicCompiler.param(m, j3)));
                    Class argCls = sig[j3].isPrimitive() ? sig[j3] : Object.class;
                    code.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), ClassRmicCompiler.writeMethod(sig[j3]), Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(argCls)}));
                    ++j3;
                }
                code.visitInsn(87);
                Label iohandler = new Label();
                Label endArgumentTryBlock = new Label();
                code.visitJumpInsn(167, endArgumentTryBlock);
                code.visitLabel(iohandler);
                code.visitVarInsn(58, var.allocate("exception"));
                code.visitTypeInsn(187, ClassRmicCompiler.typeArg(MarshalException.class));
                code.visitInsn(89);
                code.visitLdcInsn("error marshalling arguments");
                code.visitVarInsn(25, var.deallocate("exception"));
                code.visitMethodInsn(183, Type.getInternalName(MarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
                code.visitInsn(191);
                code.visitLabel(endArgumentTryBlock);
                code.visitTryCatchBlock(beginArgumentTryBlock, iohandler, iohandler, Type.getInternalName(IOException.class));
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(180, Type.getInternalName(RemoteObject.class), "ref", Type.getDescriptor(RemoteRef.class));
                code.visitVarInsn(25, var.get("call"));
                code.visitMethodInsn(185, Type.getInternalName(RemoteRef.class), "invoke", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(RemoteCall.class)}));
                boolean needcastcheck = false;
                Label beginReturnTryCatch = new Label();
                code.visitLabel(beginReturnTryCatch);
                int returncode = ClassRmicCompiler.returnOpcode(returntype);
                if (!returntype.equals(Void.TYPE)) {
                    code.visitVarInsn(25, var.get("call"));
                    code.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "getInputStream", Type.getMethodDescriptor(Type.getType(ObjectInput.class), new Type[0]));
                    Class<Object> readCls = returntype.isPrimitive() ? returntype : Object.class;
                    code.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), ClassRmicCompiler.readMethod(returntype), Type.getMethodDescriptor(Type.getType(readCls), new Type[0]));
                    boolean castresult = false;
                    if (!returntype.isPrimitive()) {
                        if (!returntype.equals(Object.class)) {
                            castresult = true;
                        } else {
                            needcastcheck = true;
                        }
                    }
                    if (castresult) {
                        code.visitTypeInsn(192, ClassRmicCompiler.typeArg(returntype));
                    }
                }
                code.visitVarInsn(25, var.get("this"));
                code.visitFieldInsn(180, Type.getInternalName(RemoteObject.class), "ref", Type.getDescriptor(RemoteRef.class));
                code.visitVarInsn(25, var.deallocate("call"));
                code.visitMethodInsn(185, Type.getInternalName(RemoteRef.class), "done", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(RemoteCall.class)}));
                code.visitInsn(returncode);
                Label handler = new Label();
                code.visitLabel(handler);
                code.visitVarInsn(58, var.allocate("exception"));
                code.visitTypeInsn(187, ClassRmicCompiler.typeArg(UnmarshalException.class));
                code.visitInsn(89);
                code.visitLdcInsn("error unmarshalling return");
                code.visitVarInsn(25, var.deallocate("exception"));
                code.visitMethodInsn(183, Type.getInternalName(UnmarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
                code.visitInsn(191);
                new Label();
                code.visitTryCatchBlock(beginReturnTryCatch, handler, handler, Type.getInternalName(IOException.class));
                if (needcastcheck) {
                    code.visitTryCatchBlock(beginReturnTryCatch, handler, handler, Type.getInternalName(ClassNotFoundException.class));
                }
            }
            Label rethrowHandler = new Label();
            code.visitLabel(rethrowHandler);
            code.visitInsn(191);
            boolean needgeneral = true;
            int j4 = 0;
            while (j4 < except.length) {
                if (except[j4] == Exception.class) {
                    needgeneral = false;
                }
                ++j4;
            }
            j4 = 0;
            while (j4 < except.length) {
                code.visitTryCatchBlock(methodTryBegin, rethrowHandler, rethrowHandler, Type.getInternalName(except[j4]));
                ++j4;
            }
            if (needgeneral) {
                code.visitTryCatchBlock(methodTryBegin, rethrowHandler, rethrowHandler, Type.getInternalName(RuntimeException.class));
                Label generalHandler = new Label();
                code.visitLabel(generalHandler);
                String msg = "undeclared checked exception";
                code.visitVarInsn(58, var.allocate("exception"));
                code.visitTypeInsn(187, ClassRmicCompiler.typeArg(UnexpectedException.class));
                code.visitInsn(89);
                code.visitLdcInsn(msg);
                code.visitVarInsn(25, var.deallocate("exception"));
                code.visitMethodInsn(183, Type.getInternalName(UnexpectedException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
                code.visitInsn(191);
                code.visitTryCatchBlock(methodTryBegin, rethrowHandler, generalHandler, Type.getInternalName(Exception.class));
            }
            code.visitMaxs(-1, -1);
            ++i;
        }
        stub.visitEnd();
        byte[] classData = stub.toByteArray();
        if (!this.noWrite) {
            if (file.exists()) {
                file.delete();
            }
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(classData);
            fos.flush();
            fos.close();
        }
    }

    private void generateSkel() throws IOException {
        this.skelname = String.valueOf(this.fullclassname) + "_Skel";
        String cfr_ignored_0 = String.valueOf(this.classname) + "_Skel";
        File file = new File(this.destination == null ? "" : String.valueOf(this.destination) + File.separator + this.skelname.replace('.', File.separatorChar) + ".class");
        if (this.verbose) {
            System.out.println("[Generating class " + this.skelname + "]");
        }
        ClassWriter skel = new ClassWriter(true);
        this.classInternalName = this.skelname.replace('.', '/');
        skel.visit(196653, 17, this.classInternalName, Type.getInternalName(Object.class), null, new String[]{Type.getType(Skeleton.class).getInternalName()});
        skel.visitField(26, "interfaceHash", Type.LONG_TYPE.getDescriptor(), null, new Long(RMIHashes.getInterfaceHash((Class)this.clazz)));
        skel.visitField(26, "operations", Type.getDescriptor(Operation[].class), null, null);
        MethodVisitor clinit = skel.visitMethod(8, "<clinit>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        this.fillOperationArray(clinit);
        clinit.visitInsn(177);
        clinit.visitMaxs(-1, -1);
        MethodVisitor init = skel.visitMethod(1, "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]), null, null);
        init.visitVarInsn(25, 0);
        init.visitMethodInsn(183, Type.getInternalName(Object.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        init.visitInsn(177);
        init.visitMaxs(-1, -1);
        MethodVisitor getOp = skel.visitMethod(1, "getOperations", Type.getMethodDescriptor(Type.getType(Operation[].class), new Type[0]), null, null);
        getOp.visitFieldInsn(178, this.classInternalName, "operations", Type.getDescriptor(Operation[].class));
        getOp.visitMethodInsn(182, Type.getInternalName(Object.class), "clone", Type.getMethodDescriptor(Type.getType(Object.class), new Type[0]));
        getOp.visitTypeInsn(192, ClassRmicCompiler.typeArg(Operation[].class));
        getOp.visitInsn(176);
        getOp.visitMaxs(-1, -1);
        MethodVisitor dispatch = skel.visitMethod(1, "dispatch", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(Remote.class), Type.getType(RemoteCall.class), Type.INT_TYPE, Type.LONG_TYPE}), null, new String[]{Type.getInternalName(Exception.class)});
        Variables var = new Variables();
        var.declare("this");
        var.declare("remoteobj");
        var.declare("remotecall");
        var.declare("opnum");
        var.declareWide("hash");
        dispatch.visitVarInsn(21, var.get("opnum"));
        Label nonNegativeOpnum = new Label();
        Label opnumSet = new Label();
        dispatch.visitJumpInsn(156, nonNegativeOpnum);
        int i = 0;
        while (i < this.remotemethods.length) {
            dispatch.visitVarInsn(22, var.get("hash"));
            dispatch.visitLdcInsn(new Long(this.remotemethods[i].hash));
            Label notIt = new Label();
            dispatch.visitInsn(148);
            dispatch.visitJumpInsn(154, notIt);
            dispatch.visitLdcInsn(new Integer(i));
            dispatch.visitVarInsn(54, var.get("opnum"));
            dispatch.visitJumpInsn(167, opnumSet);
            dispatch.visitLabel(notIt);
            ++i;
        }
        Label mismatch = new Label();
        dispatch.visitJumpInsn(167, mismatch);
        dispatch.visitLabel(nonNegativeOpnum);
        dispatch.visitVarInsn(22, var.get("hash"));
        dispatch.visitFieldInsn(178, this.classInternalName, "interfaceHash", Type.LONG_TYPE.getDescriptor());
        dispatch.visitInsn(148);
        dispatch.visitJumpInsn(153, opnumSet);
        dispatch.visitLabel(mismatch);
        dispatch.visitTypeInsn(187, ClassRmicCompiler.typeArg(SkeletonMismatchException.class));
        dispatch.visitInsn(89);
        dispatch.visitLdcInsn("interface hash mismatch");
        dispatch.visitMethodInsn(183, Type.getInternalName(SkeletonMismatchException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
        dispatch.visitInsn(191);
        dispatch.visitLabel(opnumSet);
        dispatch.visitVarInsn(25, var.get("remoteobj"));
        dispatch.visitTypeInsn(192, ClassRmicCompiler.typeArg(this.clazz));
        dispatch.visitVarInsn(58, var.get("remoteobj"));
        Label deflt = new Label();
        Label[] methLabels = new Label[this.remotemethods.length];
        int i2 = 0;
        while (i2 < methLabels.length) {
            methLabels[i2] = new Label();
            ++i2;
        }
        dispatch.visitVarInsn(21, var.get("opnum"));
        dispatch.visitTableSwitchInsn(0, this.remotemethods.length - 1, deflt, methLabels);
        i2 = 0;
        while (i2 < this.remotemethods.length) {
            dispatch.visitLabel(methLabels[i2]);
            Method m = this.remotemethods[i2].meth;
            this.generateMethodSkel(dispatch, m, var);
            ++i2;
        }
        dispatch.visitLabel(deflt);
        dispatch.visitTypeInsn(187, ClassRmicCompiler.typeArg(UnmarshalException.class));
        dispatch.visitInsn(89);
        dispatch.visitLdcInsn("invalid method number");
        dispatch.visitMethodInsn(183, Type.getInternalName(UnmarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class)}));
        dispatch.visitInsn(191);
        dispatch.visitMaxs(-1, -1);
        skel.visitEnd();
        byte[] classData = skel.toByteArray();
        if (!this.noWrite) {
            if (file.exists()) {
                file.delete();
            }
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(classData);
            fos.flush();
            fos.close();
        }
    }

    private void generateMethodSkel(MethodVisitor cv, Method m, Variables var) {
        Class<?>[] sig = m.getParameterTypes();
        Label readArgs = new Label();
        cv.visitLabel(readArgs);
        boolean needcastcheck = false;
        cv.visitVarInsn(25, var.get("remotecall"));
        cv.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "getInputStream", Type.getMethodDescriptor(Type.getType(ObjectInput.class), new Type[0]));
        cv.visitVarInsn(58, var.allocate("objectinput"));
        int i = 0;
        while (i < sig.length) {
            cv.visitVarInsn(25, var.get("objectinput"));
            Class<Object> readCls = sig[i].isPrimitive() ? sig[i] : Object.class;
            cv.visitMethodInsn(185, Type.getInternalName(ObjectInput.class), ClassRmicCompiler.readMethod(sig[i]), Type.getMethodDescriptor(Type.getType(readCls), new Type[0]));
            if (!sig[i].isPrimitive() && !sig[i].equals(Object.class)) {
                needcastcheck = true;
                cv.visitTypeInsn(192, ClassRmicCompiler.typeArg(sig[i]));
            }
            cv.visitVarInsn(ClassRmicCompiler.storeOpcode(sig[i]), var.allocate(ClassRmicCompiler.param(m, i), ClassRmicCompiler.size(sig[i])));
            ++i;
        }
        var.deallocate("objectinput");
        Label doCall = new Label();
        Label closeInput = new Label();
        cv.visitJumpInsn(168, closeInput);
        cv.visitJumpInsn(167, doCall);
        Label handler = new Label();
        cv.visitLabel(handler);
        cv.visitVarInsn(58, var.allocate("exception"));
        cv.visitTypeInsn(187, ClassRmicCompiler.typeArg(UnmarshalException.class));
        cv.visitInsn(89);
        cv.visitLdcInsn("error unmarshalling arguments");
        cv.visitVarInsn(25, var.deallocate("exception"));
        cv.visitMethodInsn(183, Type.getInternalName(UnmarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
        cv.visitVarInsn(58, var.allocate("toThrow"));
        cv.visitJumpInsn(168, closeInput);
        cv.visitVarInsn(25, var.get("toThrow"));
        cv.visitInsn(191);
        cv.visitTryCatchBlock(readArgs, handler, handler, Type.getInternalName(IOException.class));
        if (needcastcheck) {
            cv.visitTryCatchBlock(readArgs, handler, handler, Type.getInternalName(ClassCastException.class));
        }
        cv.visitLabel(closeInput);
        cv.visitVarInsn(58, var.allocate("retAddress"));
        cv.visitVarInsn(25, var.get("remotecall"));
        cv.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "releaseInputStream", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]));
        cv.visitVarInsn(169, var.deallocate("retAddress"));
        var.deallocate("toThrow");
        cv.visitLabel(doCall);
        cv.visitVarInsn(25, var.get("remoteobj"));
        int i2 = 0;
        while (i2 < sig.length) {
            cv.visitVarInsn(ClassRmicCompiler.loadOpcode(sig[i2]), var.deallocate(ClassRmicCompiler.param(m, i2)));
            ++i2;
        }
        cv.visitMethodInsn(182, Type.getInternalName(this.clazz), m.getName(), Type.getMethodDescriptor(m));
        Class<?> returntype = m.getReturnType();
        if (!returntype.equals(Void.TYPE)) {
            cv.visitVarInsn(ClassRmicCompiler.storeOpcode(returntype), var.allocate("result", ClassRmicCompiler.size(returntype)));
        }
        Label writeResult = new Label();
        cv.visitLabel(writeResult);
        cv.visitVarInsn(25, var.get("remotecall"));
        cv.visitInsn(4);
        cv.visitMethodInsn(185, Type.getInternalName(RemoteCall.class), "getResultStream", Type.getMethodDescriptor(Type.getType(ObjectOutput.class), new Type[]{Type.BOOLEAN_TYPE}));
        if (!returntype.equals(Void.TYPE)) {
            cv.visitVarInsn(ClassRmicCompiler.loadOpcode(returntype), var.deallocate("result"));
            Class<Object> writeCls = returntype.isPrimitive() ? returntype : Object.class;
            cv.visitMethodInsn(185, Type.getInternalName(ObjectOutput.class), ClassRmicCompiler.writeMethod(returntype), Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(writeCls)}));
        }
        cv.visitInsn(177);
        Label marshalHandler = new Label();
        cv.visitLabel(marshalHandler);
        cv.visitVarInsn(58, var.allocate("exception"));
        cv.visitTypeInsn(187, ClassRmicCompiler.typeArg(MarshalException.class));
        cv.visitInsn(89);
        cv.visitLdcInsn("error marshalling return");
        cv.visitVarInsn(25, var.deallocate("exception"));
        cv.visitMethodInsn(183, Type.getInternalName(MarshalException.class), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Exception.class)}));
        cv.visitInsn(191);
        cv.visitTryCatchBlock(writeResult, marshalHandler, marshalHandler, Type.getInternalName(IOException.class));
    }

    private static String typeArg(Class cls) {
        if (cls.isArray()) {
            return Type.getDescriptor(cls);
        }
        return Type.getInternalName(cls);
    }

    private static String readMethod(Class cls) {
        if (cls.equals(Void.TYPE)) {
            throw new IllegalArgumentException("can not read void");
        }
        String method = cls.equals(Boolean.TYPE) ? "readBoolean" : (cls.equals(Byte.TYPE) ? "readByte" : (cls.equals(Character.TYPE) ? "readChar" : (cls.equals(Short.TYPE) ? "readShort" : (cls.equals(Integer.TYPE) ? "readInt" : (cls.equals(Long.TYPE) ? "readLong" : (cls.equals(Float.TYPE) ? "readFloat" : (cls.equals(Double.TYPE) ? "readDouble" : "readObject")))))));
        return method;
    }

    private static String writeMethod(Class cls) {
        if (cls.equals(Void.TYPE)) {
            throw new IllegalArgumentException("can not read void");
        }
        String method = cls.equals(Boolean.TYPE) ? "writeBoolean" : (cls.equals(Byte.TYPE) ? "writeByte" : (cls.equals(Character.TYPE) ? "writeChar" : (cls.equals(Short.TYPE) ? "writeShort" : (cls.equals(Integer.TYPE) ? "writeInt" : (cls.equals(Long.TYPE) ? "writeLong" : (cls.equals(Float.TYPE) ? "writeFloat" : (cls.equals(Double.TYPE) ? "writeDouble" : "writeObject")))))));
        return method;
    }

    private static int returnOpcode(Class cls) {
        int returncode = cls.equals(Boolean.TYPE) ? 172 : (cls.equals(Byte.TYPE) ? 172 : (cls.equals(Character.TYPE) ? 172 : (cls.equals(Short.TYPE) ? 172 : (cls.equals(Integer.TYPE) ? 172 : (cls.equals(Long.TYPE) ? 173 : (cls.equals(Float.TYPE) ? 174 : (cls.equals(Double.TYPE) ? 175 : (cls.equals(Void.TYPE) ? 177 : 176))))))));
        return returncode;
    }

    private static int loadOpcode(Class cls) {
        if (cls.equals(Void.TYPE)) {
            throw new IllegalArgumentException("can not load void");
        }
        int loadcode = cls.equals(Boolean.TYPE) ? 21 : (cls.equals(Byte.TYPE) ? 21 : (cls.equals(Character.TYPE) ? 21 : (cls.equals(Short.TYPE) ? 21 : (cls.equals(Integer.TYPE) ? 21 : (cls.equals(Long.TYPE) ? 22 : (cls.equals(Float.TYPE) ? 23 : (cls.equals(Double.TYPE) ? 24 : 25)))))));
        return loadcode;
    }

    private static int storeOpcode(Class cls) {
        if (cls.equals(Void.TYPE)) {
            throw new IllegalArgumentException("can not load void");
        }
        int storecode = cls.equals(Boolean.TYPE) ? 54 : (cls.equals(Byte.TYPE) ? 54 : (cls.equals(Character.TYPE) ? 54 : (cls.equals(Short.TYPE) ? 54 : (cls.equals(Integer.TYPE) ? 54 : (cls.equals(Long.TYPE) ? 55 : (cls.equals(Float.TYPE) ? 56 : (cls.equals(Double.TYPE) ? 57 : 58)))))));
        return storecode;
    }

    private static String unboxMethod(Class primitive) {
        String method;
        if (!primitive.isPrimitive()) {
            throw new IllegalArgumentException("can not unbox nonprimitive");
        }
        if (primitive.equals(Boolean.TYPE)) {
            method = "booleanValue";
        } else if (primitive.equals(Byte.TYPE)) {
            method = "byteValue";
        } else if (primitive.equals(Character.TYPE)) {
            method = "charValue";
        } else if (primitive.equals(Short.TYPE)) {
            method = "shortValue";
        } else if (primitive.equals(Integer.TYPE)) {
            method = "intValue";
        } else if (primitive.equals(Long.TYPE)) {
            method = "longValue";
        } else if (primitive.equals(Float.TYPE)) {
            method = "floatValue";
        } else if (primitive.equals(Double.TYPE)) {
            method = "doubleValue";
        } else {
            throw new IllegalStateException("unknown primitive class " + primitive);
        }
        return method;
    }

    public static Class box(Class cls) {
        Class box;
        if (!cls.isPrimitive()) {
            throw new IllegalArgumentException("can only box primitive");
        }
        if (cls.equals(Boolean.TYPE)) {
            box = Boolean.class;
        } else if (cls.equals(Byte.TYPE)) {
            box = Byte.class;
        } else if (cls.equals(Character.TYPE)) {
            box = Character.class;
        } else if (cls.equals(Short.TYPE)) {
            box = Short.class;
        } else if (cls.equals(Integer.TYPE)) {
            box = Integer.class;
        } else if (cls.equals(Long.TYPE)) {
            box = Long.class;
        } else if (cls.equals(Float.TYPE)) {
            box = Float.class;
        } else if (cls.equals(Double.TYPE)) {
            box = Double.class;
        } else {
            throw new IllegalStateException("unknown primitive type " + cls);
        }
        return box;
    }

    private static int size(Class cls) {
        if (cls.equals(Long.TYPE) || cls.equals(Double.TYPE)) {
            return 2;
        }
        return 1;
    }

    private Class[] sortExceptions(Class[] except) {
        int i = 0;
        while (i < except.length) {
            int j = i + 1;
            while (j < except.length) {
                if (except[i].isAssignableFrom(except[j])) {
                    Class tmp = except[i];
                    except[i] = except[j];
                    except[j] = tmp;
                }
                ++j;
            }
            ++i;
        }
        return except;
    }

    public void setup(boolean keep, boolean need11Stubs, boolean need12Stubs, boolean iiop, boolean poa, boolean debug, boolean warnings, boolean noWrite, boolean verbose, boolean force, String classpath, String bootclasspath, String extdirs, String outputDirectory) {
        this.keep = keep;
        this.need11Stubs = need11Stubs;
        this.need12Stubs = need12Stubs;
        this.verbose = verbose;
        this.noWrite = noWrite;
        this.classpath = classpath;
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        URL[] u = new URL[st.countTokens()];
        int i = 0;
        while (i < u.length) {
            String path = st.nextToken();
            File f = new File(path);
            try {
                u[i] = f.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                this.logError("malformed classpath component " + path);
                return;
            }
            ++i;
        }
        this.loader = new URLClassLoader(u);
        this.destination = outputDirectory;
    }

    private void findRemoteMethods() throws RMICException {
        int j;
        int i;
        ArrayList<Method> rmeths = new ArrayList<Method>();
        Class cur = this.clazz;
        while (cur != null) {
            Class<?>[] interfaces = cur.getInterfaces();
            i = 0;
            while (i < interfaces.length) {
                if (Remote.class.isAssignableFrom(interfaces[i])) {
                    Class<?> remoteInterface = interfaces[i];
                    if (this.verbose) {
                        System.out.println("[implements " + remoteInterface.getName() + "]");
                    }
                    Method[] meths = remoteInterface.getMethods();
                    j = 0;
                    while (j < meths.length) {
                        Method m = meths[j];
                        Class<?>[] exs = m.getExceptionTypes();
                        boolean throwsRemote = false;
                        int k = 0;
                        while (k < exs.length) {
                            if (exs[k].isAssignableFrom(RemoteException.class)) {
                                throwsRemote = true;
                            }
                            ++k;
                        }
                        if (!throwsRemote) {
                            throw new RMICException("Method " + m + " in interface " + remoteInterface + " does not throw a RemoteException");
                        }
                        rmeths.add(m);
                        ++j;
                    }
                    this.mRemoteInterfaces.add(remoteInterface);
                }
                ++i;
            }
            cur = cur.getSuperclass();
        }
        boolean[] skip = new boolean[rmeths.size()];
        int i2 = 0;
        while (i2 < skip.length) {
            skip[i2] = false;
            ++i2;
        }
        ArrayList<MethodRef> methrefs = new ArrayList<MethodRef>();
        i = 0;
        while (i < rmeths.size()) {
            if (!skip[i]) {
                Method current = (Method)rmeths.get(i);
                MethodRef ref = new MethodRef(current);
                j = i + 1;
                while (j < rmeths.size()) {
                    Method other = (Method)rmeths.get(j);
                    if (ref.isMatch(other)) {
                        ref.intersectExceptions(other);
                        skip[j] = true;
                    }
                    ++j;
                }
                methrefs.add(ref);
            }
            ++i;
        }
        this.remotemethods = methrefs.toArray(new MethodRef[methrefs.size()]);
        Arrays.sort(this.remotemethods);
    }

    private void logError(Exception theError) {
        this.logError(theError.getMessage());
        if (this.verbose) {
            theError.printStackTrace(System.err);
        }
    }

    private void logError(String theError) {
        ++this.errorCount;
        System.err.println("error: " + theError);
    }

    private static String getPrettyName(Class cls) {
        StringBuilder str = new StringBuilder();
        int count = 0;
        while (true) {
            if (!cls.isArray()) {
                str.append(cls.getName());
                while (count > 0) {
                    str.append("[]");
                    --count;
                }
                return str.toString();
            }
            cls = cls.getComponentType();
            ++count;
        }
    }

    private static class MethodRef
    implements Comparable {
        Method meth;
        long hash;
        List exceptions;
        private String sig;

        MethodRef(Method m) {
            this.meth = m;
            this.sig = Type.getMethodDescriptor(this.meth);
            this.hash = RMIHashes.getMethodHash((Method)m);
            this.exceptions = MethodRef.removeSubclasses(m.getExceptionTypes());
        }

        public int compareTo(Object obj) {
            MethodRef that = (MethodRef)obj;
            int name = this.meth.getName().compareTo(that.meth.getName());
            if (name == 0) {
                return this.sig.compareTo(that.sig);
            }
            return name;
        }

        public boolean isMatch(Method m) {
            Class<?>[] params2;
            if (!this.meth.getName().equals(m.getName())) {
                return false;
            }
            Class<?>[] params1 = this.meth.getParameterTypes();
            if (params1.length != (params2 = m.getParameterTypes()).length) {
                return false;
            }
            int i = 0;
            while (i < params1.length) {
                if (!params1[i].equals(params2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static List removeSubclasses(Class[] classes) {
            ArrayList<Class> list = new ArrayList<Class>();
            int i = 0;
            while (i < classes.length) {
                Class candidate = classes[i];
                boolean add = true;
                int j = 0;
                while (j < classes.length) {
                    if (!classes[j].equals(candidate) && classes[j].isAssignableFrom(candidate)) {
                        add = false;
                    }
                    ++j;
                }
                if (add) {
                    list.add(candidate);
                }
                ++i;
            }
            return list;
        }

        public void intersectExceptions(Method m) {
            List incoming = MethodRef.removeSubclasses(m.getExceptionTypes());
            ArrayList<Class> updated = new ArrayList<Class>();
            int i = 0;
            while (i < this.exceptions.size()) {
                Class outer = (Class)this.exceptions.get(i);
                boolean addOuter = false;
                int j = 0;
                while (j < incoming.size()) {
                    Class inner = (Class)incoming.get(j);
                    if (inner.equals(outer) || inner.isAssignableFrom(outer)) {
                        addOuter = true;
                    } else if (outer.isAssignableFrom(inner)) {
                        updated.add(inner);
                    }
                    ++j;
                }
                if (addOuter) {
                    updated.add(outer);
                }
                ++i;
            }
            this.exceptions = updated;
        }
    }
}

