/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.java2xhtml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;

public class Java2xhtml {
    private static final String sourceCodeStyle = "source";
    private static final String lineNumberStyle = "line-number even";
    private static final String modulusLineNumberStyle = "line-number odd";
    private static final String keywordStyle = "keyword";
    private static final String methodStyle = "method member";
    private static final String variableStyle = "variable member";
    private static final String singleLineCommentStyle = "line comment";
    private static final String traditionalCommentStyle = "c comment";
    private static final String javadocCommentStyle = "javadoc comment";
    private static final String javadocTagStyle = "javadoc tag";
    private static final String importNameStyle = "import header type";
    private static final String packageNameStyle = "package header type";
    private static final String primitiveTypeStyle = "primitive type";
    private static final String nonPrimitiveTypeStyle = "non-primitive type";
    private static final String constructorStyle = "constructor member";
    private static final String constantStyle = "constant member";
    private static final String doubleQuoteStyle = "double quote";
    private static final String singleQuoteStyle = "single quote";
    private static final String numericLiteralStyle = "numeric literal";
    private static final String primitiveLiteralStyle = "primitive literal";
    private static final String iconStyle = "icon";
    static Collection keywordCollection;
    static Collection primitiveTypeCollection;
    static Collection primitiveLiteralCollection;
    static Collection javadocTagCollection;
    int extraIndentation = 0;
    int tabSize = 4;
    int lineModulus = 5;
    boolean hasLegend = false;
    boolean hasLineNumbers = false;
    boolean hasLineModulusDrawnLines = false;
    boolean hasLineModulusCodeBlocks = false;
    boolean hasFooter = false;
    boolean hasFooterIcons = false;
    boolean hasFooterDate = true;
    boolean isCodeSnippet = false;
    boolean isXHTML_1_1 = true;
    boolean hasTitle = false;
    boolean hasAllBoldSourceCode = false;
    boolean hasInternalStyleSheet = true;
    boolean hasExternalStyleSheet = true;
    String externalStyleSheetName = "style.css";

    static {
        String[] keywordArray = new String[]{"abstract", "default", "if", "private", "do", "implements", "protected", "throws", "break", "import", "public", "transient", "else", "instanceof", "return", "try", "case", "extends", "throw", "static", "catch", "final", "interface", "while", "volatile", "finally", "super", "synchronized", "class", "native", "switch", "package", "const", "for", "new", "goto", "continue", "this", "assert", "strictfp"};
        keywordCollection = new HashSet(Arrays.asList(keywordArray));
        String[] primitiveTypeArray = new String[]{"boolean", "char", "byte", "short", "int", "long", "float", "double", "void"};
        primitiveTypeCollection = new HashSet(Arrays.asList(primitiveTypeArray));
        String[] primitiveLiteralArray = new String[]{"false", "null", "true"};
        primitiveLiteralCollection = new HashSet(Arrays.asList(primitiveLiteralArray));
        String[] javadocTagArray = new String[]{"see", "author", "version", "param", "return", "exception", "deprecated", "throws", "link", "since", "serial", "serialField", "serialData", "beaninfo"};
        javadocTagCollection = new HashSet(Arrays.asList(javadocTagArray));
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 3) {
            System.out.println("Java2xhtml Version 0.9 (C) 2005 Free Software Foundation");
            System.out.println("    Produces an XHTML file of Java source code with syntax highlighting,");
            System.out.println("    includes additional options (line numbering, tab spacing, etc.)");
            System.out.println("    This tool is part of GNU Classpath.");
            System.out.println("    GNU Classpath is free software; you can redistribute it and/or modify");
            System.out.println("    it under the terms of the GNU General Public License as published by");
            System.out.println("    the Free Software Foundation; either version 2, or (at your option)");
            System.out.println("    any later version.");
            System.out.println("    NOTE: Common java naming structure is assumed");
            System.out.println("");
            System.out.println("USAGE:");
            System.out.println("java  [java options]  Java2xhtml  source.java  [options file]  [output file]");
            System.out.println("");
            System.out.println("  - java is the name of the Java interpreter");
            System.out.println("  - [java options] are the optional options of the Java interpreter");
            System.out.println("  - Java2xhtml is the name of this application");
            System.out.println("  - source is a file or the directory to the Java source file(s)");
            System.out.println("  - [options file] is the optional path of a file with");
            System.out.println("    a structure like this:");
            System.out.println("        externalStyleSheetName=file_name (default style.css)");
            System.out.println("        tabSize=integer  (default value is 4)");
            System.out.println("        extraIndentation=integer  (default value is 0)");
            System.out.println("        lineModulus=integer (default value 5)");
            System.out.println("        isCodeSnippet=boolean (default false)");
            System.out.println("        isXHTML_1_1=boolean (default true)");
            System.out.println("        hasInternalStyleSheet=boolean (default true)");
            System.out.println("        hasExternalStyleSheet=boolean (default true)");
            System.out.println("        hasTitle=boolean (default false)");
            System.out.println("        hasLegend=boolean (default false)");
            System.out.println("        hasAllBoldSourceCode=boolean (default false)");
            System.out.println("        hasLineNumbers=boolean (default false)");
            System.out.println("        hasLineModulusDrawnLines=boolean (default false)");
            System.out.println("        hasLineModulusCodeBlocks=boolean (default false)");
            System.out.println("        hasFooter=boolean (default false)");
            System.out.println("        hasFooterIcons=boolean (default false)");
            System.out.println("        hasFooterDate=boolean (default true)");
            System.out.println("    NOTE: filename must end with '.prop'");
            System.out.println("    Default [options file] is options.prop");
            System.out.println("  - [output file] is name of the XHTML file that is produced");
            System.out.println("    Default [output file] is source_java.html");
            System.out.println("");
            System.out.println("Output: source.java --> [output file]");
            System.out.println("    Default Output is ");
            System.out.println("    source.java --> source_java.html");
            System.out.println("");
            System.out.println("Examples of calling the program:");
            System.out.println(" process one file (say Java2xhtml.java):");
            System.out.println("    java  Java2xhtml  Java2xhtml.java");
            System.out.println(" process one directory (say C:\\HOME):");
            System.out.println("    java  Java2xhtml  C:\\HOME");
            System.out.println(" process one directory (say C:\\HOME with a given options file (options.prop)):");
            System.out.println("    java  Java2xhtml  C:\\HOME options.prop");
        } else {
            String sourceName = args[0];
            File sourceFilePath = new File(sourceName);
            if (sourceFilePath.exists()) {
                String propertiesFileName = "options.prop";
                String htmlFileName = String.valueOf(sourceName.replace('.', '_')) + ".html";
                if (args.length == 2 || args.length == 3) {
                    if (args[1].endsWith(".prop")) {
                        propertiesFileName = args[1];
                    } else {
                        htmlFileName = args[1];
                    }
                }
                if (args.length == 3) {
                    if (args[2].endsWith(".prop")) {
                        propertiesFileName = args[2];
                    } else {
                        htmlFileName = args[2];
                    }
                }
                new Java2xhtml(propertiesFileName, sourceFilePath, htmlFileName);
            } else {
                System.out.println("The source parameter must be an existent file or directory");
                System.out.println("Run Java2xHtml without parameters for help");
            }
        }
    }

    public Java2xhtml() {
    }

    Java2xhtml(String propertiesFileName, File sourceFilePath, String htmlFileName) {
        File propertiesFilePath = new File(propertiesFileName);
        if (propertiesFilePath.exists()) {
            try {
                FileInputStream propertiesFile = new FileInputStream(propertiesFileName);
                Properties htmlProperties = new Properties();
                htmlProperties.load(propertiesFile);
                ((InputStream)propertiesFile).close();
                this.setProperties(htmlProperties);
            }
            catch (IOException exception) {
                System.out.println(exception);
            }
        }
        if (sourceFilePath.isFile()) {
            this.processFile(sourceFilePath, htmlFileName);
        } else if (sourceFilePath.isDirectory()) {
            File[] sourceFilePathArray = sourceFilePath.listFiles();
            int i = 0;
            while (i < sourceFilePathArray.length) {
                if (sourceFilePathArray[i].getName().endsWith(".java")) {
                    htmlFileName = String.valueOf(sourceFilePathArray[i].getName().replace('.', '_')) + ".html";
                    this.processFile(sourceFilePathArray[i], htmlFileName);
                }
                ++i;
            }
        }
    }

    public void setProperties(Properties htmlProperties) {
        this.hasLegend = Boolean.valueOf(htmlProperties.getProperty("hasLegend", "false"));
        this.extraIndentation = Integer.parseInt(htmlProperties.getProperty("extraIndentation", "0"));
        this.tabSize = Integer.parseInt(htmlProperties.getProperty("tabSize", "4"));
        this.hasLineNumbers = Boolean.valueOf(htmlProperties.getProperty("hasLineNumbers", "false"));
        this.lineModulus = Integer.parseInt(htmlProperties.getProperty("lineModulus", "5"));
        this.hasLineModulusDrawnLines = Boolean.valueOf(htmlProperties.getProperty("hasLineModulusDrawnLines", "false"));
        this.hasLineModulusCodeBlocks = Boolean.valueOf(htmlProperties.getProperty("hasLineModulusCodeBlocks", "false"));
        this.hasFooter = Boolean.valueOf(htmlProperties.getProperty("hasFooter", "false"));
        this.hasFooterIcons = Boolean.valueOf(htmlProperties.getProperty("hasFooterIcons", "false"));
        this.hasFooterDate = Boolean.valueOf(htmlProperties.getProperty("hasFooterDate", "true"));
        this.isXHTML_1_1 = Boolean.valueOf(htmlProperties.getProperty("isXHTML_1_1", "true"));
        this.isCodeSnippet = Boolean.valueOf(htmlProperties.getProperty("isCodeSnippet", "false"));
        this.hasTitle = Boolean.valueOf(htmlProperties.getProperty("hasTitle", "false"));
        this.hasAllBoldSourceCode = Boolean.valueOf(htmlProperties.getProperty("hasAllBoldSourceCode", "false"));
        this.hasInternalStyleSheet = Boolean.valueOf(htmlProperties.getProperty("hasInternalStyleSheet", "true"));
        this.hasExternalStyleSheet = Boolean.valueOf(htmlProperties.getProperty("hasExternalStyleSheet", "true"));
        this.externalStyleSheetName = htmlProperties.getProperty("externalStyleSheetName", "style.css");
    }

    void processFile(File sourceFilePath, String htmlFileName) {
        try {
            BufferedReader sourceReader = new BufferedReader(new FileReader(sourceFilePath));
            StringBuffer bufferIn = new StringBuffer();
            int readInInt = 0;
            char presentChar = '\u0000';
            while (readInInt != -1) {
                readInInt = sourceReader.read();
                presentChar = readInInt >= 0 ? (char)readInInt : (char)'\u0000';
                bufferIn.append(presentChar);
            }
            sourceReader.close();
            BufferedWriter tempBufferedWriter = new BufferedWriter(new FileWriter(htmlFileName));
            tempBufferedWriter.write(this.makeHTML(bufferIn, sourceFilePath.getName()));
            tempBufferedWriter.close();
            System.out.println(String.valueOf(sourceFilePath.getName()) + " --> " + htmlFileName);
        }
        catch (IOException exception) {
            System.out.println(exception);
        }
    }

    public String makeHTML(StringBuffer bufferIn, String sourceFileName) {
        int codeLineNumber = 0;
        boolean isNewLine = true;
        boolean isNewBlock = true;
        int identifierLength = 0;
        int qualifiedIdentifierLength = 0;
        int presentIndex = -1;
        int spaceLength = 0;
        int saveIndex = 0;
        char presentChar = '\u0000';
        State presentState = State.TEXT;
        StringBuffer bufferOut = new StringBuffer(8192);
        if (!this.isCodeSnippet) {
            bufferOut.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            if (this.isXHTML_1_1) {
                bufferOut.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"\r\n");
                bufferOut.append("    \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">\r\n");
                bufferOut.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\">\r\n");
            } else {
                bufferOut.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\r\n");
                bufferOut.append("    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n");
                bufferOut.append("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\r\n");
            }
            bufferOut.append(" <head>\r\n");
            bufferOut.append("  <title>\r\n");
            bufferOut.append("   " + sourceFileName + "\r\n");
            bufferOut.append("  </title>\r\n");
            bufferOut.append("  <meta name=\"generator\"\r\n");
            bufferOut.append("        content=\"Java2xhtml 0.9\" />\r\n");
            if (this.hasInternalStyleSheet) {
                bufferOut.append("  <style type=\"text/css\">\r\n");
                bufferOut.append("   <!-- /* <![CDATA[ */\r\n");
                bufferOut.append("    .source\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #000000;\r\n");
                bufferOut.append("       background-color: #FFFFFF;\r\n");
                if (this.hasAllBoldSourceCode) {
                    bufferOut.append("       font-weight: bold;\r\n");
                }
                bufferOut.append("     }\r\n");
                bufferOut.append("    .line-number even\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       font-weight: normal;\r\n");
                bufferOut.append("       color: #000000;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                if (this.lineModulus > 0) {
                    bufferOut.append("    .line-number odd\r\n");
                    bufferOut.append("     {\r\n");
                    bufferOut.append("       font-weight: bold;\r\n");
                    bufferOut.append("       color: #000000;\r\n");
                    bufferOut.append("       background-color: ");
                    bufferOut.append("transparent;\r\n");
                    bufferOut.append("     }\r\n");
                    if (this.hasLineModulusDrawnLines) {
                        bufferOut.append("    .modulusLineStyle\r\n");
                        bufferOut.append("     {\r\n");
                        bufferOut.append("       text-decoration: ");
                        bufferOut.append("line-through;\r\n");
                        bufferOut.append("       color: #000000;\r\n");
                        bufferOut.append("       background-color: ");
                        bufferOut.append("transparent;\r\n");
                        bufferOut.append("     }\r\n");
                    }
                    if (this.hasLineModulusCodeBlocks) {
                        bufferOut.append("    .modulusBlockPREStyle\r\n");
                        bufferOut.append("     {\r\n");
                        bufferOut.append("       margin: 0em\r\n");
                        bufferOut.append("     }\r\n");
                        bufferOut.append("    .modulusBlockStyle\r\n");
                        bufferOut.append("     {\r\n");
                        bufferOut.append("       color: #000000;\r\n");
                        bufferOut.append("       background-color: ");
                        bufferOut.append("#CCCCCC;\r\n");
                        bufferOut.append("     }\r\n");
                    }
                }
                bufferOut.append("    .keyword\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #9900FF;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .method member\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #0000FF;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .variable member\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #CC9933;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .line comment\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #CC3333;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .c comment\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #FF0000;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .javadoc comment\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #CC0033;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .javadoc tag\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #0099CC;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .import header type\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #33CCCC;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .package header type\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #339999;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .primitive type\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #009900;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .non-primitive type\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #009966;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .constructor member\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #3300CC;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .constant member\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #666666;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .double quote\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #996633;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("       font-style: italic;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .single quote\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #663333;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("       font-style: oblique;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .numeric literal\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #333300;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                bufferOut.append("    .primitive literal\r\n");
                bufferOut.append("     {\r\n");
                bufferOut.append("       color: #006600;\r\n");
                bufferOut.append("       background-color: transparent;\r\n");
                bufferOut.append("     }\r\n");
                if (this.hasFooterIcons) {
                    bufferOut.append("    .icon\r\n");
                    bufferOut.append("     {\r\n");
                    bufferOut.append("       border-style: none;\r\n");
                    bufferOut.append("     }\r\n");
                }
                if (this.hasTitle) {
                    bufferOut.append("    #title\r\n");
                    bufferOut.append("     {\r\n");
                    bufferOut.append("       text-align: center;\r\n");
                    bufferOut.append("       font-size: xx-large;\r\n");
                    bufferOut.append("     }\r\n");
                }
                if (this.hasLegend) {
                    bufferOut.append("    #legendTitle\r\n");
                    bufferOut.append("     {\r\n");
                    bufferOut.append("       text-align: center;\r\n");
                    bufferOut.append("       font-size: x-large;\r\n");
                    bufferOut.append("     }\r\n");
                    bufferOut.append("    #legend\r\n");
                    bufferOut.append("     {\r\n");
                    bufferOut.append("       font-family: monospace;\r\n");
                    bufferOut.append("       font-size: large;\r\n");
                    bufferOut.append("     }\r\n");
                }
                if (this.hasFooter) {
                    bufferOut.append("    #footer\r\n");
                    bufferOut.append("     {\r\n");
                    bufferOut.append("       font-size: xx-small;\r\n");
                    bufferOut.append("     }\r\n");
                }
                bufferOut.append("   /* ]]> */ -->\r\n");
                bufferOut.append("  </style>\r\n");
            }
            if (this.hasExternalStyleSheet) {
                bufferOut.append("  <link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.externalStyleSheetName + "\" />\r\n");
            }
            bufferOut.append(" </head>\r\n");
            bufferOut.append(" <body>\r\n");
        }
        if (this.hasTitle) {
            bufferOut.append("  <div id=\"title\">\r\n");
            bufferOut.append("   " + sourceFileName + "\r\n");
            bufferOut.append("  </div>\r\n");
            bufferOut.append("  <hr />\r\n");
        }
        if (this.hasLegend) {
            bufferOut.append("  <div id=\"legendTitle\">\r\n");
            bufferOut.append("   Legend\r\n");
            bufferOut.append("  </div>\r\n");
            bufferOut.append("  <div class=\"source\">\r\n");
            bufferOut.append("   <div id=\"legend\">\r\n");
            bufferOut.append("    <span class=\"keyword\">");
            bufferOut.append("keyword</span>\r\n");
            bufferOut.append("    <span class=\"method member\">");
            bufferOut.append("method</span>\r\n");
            bufferOut.append("    <span class=\"variable member\">variable</span>\r\n");
            bufferOut.append("    <span class=\"line comment\">singleLineComment</span>\r\n");
            bufferOut.append("    <span class=\"c comment\">traditionalComment</span>\r\n");
            bufferOut.append("    <span class=\"javadoc comment\">javadocComment</span>\r\n");
            bufferOut.append("    <span class=\"javadoc tag\">javadocTag</span>\r\n");
            bufferOut.append("    <span class=\"import header type\">importName</span>\r\n");
            bufferOut.append("    <span class=\"package header type\">packageName</span>\r\n");
            bufferOut.append("    <span class=\"primitive type\">primitiveType</span>\r\n");
            bufferOut.append("    <span class=\"non-primitive type\">nonPrimitiveType</span>\r\n");
            bufferOut.append("    <span class=\"constructor member\">constructor</span>\r\n");
            bufferOut.append("    <span class=\"constant member\">constant</span>\r\n");
            bufferOut.append("    <span class=\"double quote\">doubleQuote</span>\r\n");
            bufferOut.append("    <span class=\"single quote\">singleQuote</span>\r\n");
            bufferOut.append("    <span class=\"numeric literal\">numericLiteral</span>\r\n");
            bufferOut.append("    <span class=\"primitive literal\">primitiveLiteral</span>\r\n");
            bufferOut.append("   </div>\r\n");
            bufferOut.append("  </div>\r\n");
            bufferOut.append("  <hr />\r\n");
        }
        bufferOut.append("  <div class=\"source\">\r\n");
        if (this.hasLineModulusCodeBlocks) {
            bufferOut.append("<pre class=\"modulusBlockPREStyle\">\r\n");
        } else {
            bufferOut.append("<pre>\r\n");
        }
        while (presentIndex++ < bufferIn.length() - 2) {
            int i = 0;
            while (i < this.extraIndentation) {
                bufferOut.append(" ");
                ++i;
            }
            if ((this.hasLineNumbers || this.hasLineModulusCodeBlocks) && isNewLine) {
                ++codeLineNumber;
                if (this.lineModulus > 0 && this.hasLineModulusCodeBlocks && (codeLineNumber %= 10000) % this.lineModulus == 1) {
                    if (isNewBlock) {
                        if (State.TRADITIONAL_COMMENT == presentState || State.JAVADOC == presentState) {
                            bufferOut.insert(bufferOut.length() - "\r\n".length(), "</span>");
                        }
                        bufferOut.append("</pre>\r\n");
                        bufferOut.append("   <div class=");
                        bufferOut.append("\"modulusBlockStyle\">");
                        bufferOut.append("\r\n<pre class=\"");
                        bufferOut.append("modulusBlockPREStyle\">\r\n");
                        if (State.TRADITIONAL_COMMENT == presentState) {
                            bufferOut.append("<span class=\"c comment\">");
                        }
                        if (State.JAVADOC == presentState) {
                            bufferOut.append("<span class=\"javadoc comment\">");
                        }
                    }
                    boolean bl = isNewBlock = !isNewBlock;
                }
                if (codeLineNumber < 1000) {
                    bufferOut.append(" ");
                }
                if (codeLineNumber < 100) {
                    bufferOut.append(" ");
                }
                if (codeLineNumber < 10) {
                    bufferOut.append(" ");
                }
                bufferOut.append("<a name=\"line.");
                bufferOut.append(codeLineNumber);
                bufferOut.append("\">");
                if (this.hasLineNumbers) {
                    if (this.lineModulus > 0 && codeLineNumber % this.lineModulus == 0) {
                        bufferOut.append("<span class=\"line-number odd\">");
                        bufferOut.append(codeLineNumber);
                        bufferOut.append(": </span>");
                        if (this.hasLineModulusDrawnLines) {
                            while (presentIndex != bufferIn.length() - 1 && (Character.isSpaceChar(bufferIn.charAt(presentIndex)) || bufferIn.charAt(presentIndex) == '\t')) {
                                if (bufferIn.charAt(presentIndex) == '\t') {
                                    i = 0;
                                    while (i < this.tabSize) {
                                        bufferIn.insert(presentIndex + 1, " ");
                                        ++i;
                                    }
                                    ++presentIndex;
                                    continue;
                                }
                                if (' ' == bufferIn.charAt(presentIndex)) {
                                    bufferOut.append(" ");
                                    spaceLength += " ".length();
                                } else {
                                    bufferOut.append(bufferIn.charAt(presentIndex));
                                    ++spaceLength;
                                }
                                ++presentIndex;
                            }
                            if (presentIndex == bufferIn.length() - 1 || Character.isWhitespace(bufferIn.charAt(presentIndex))) {
                                spaceLength = 0;
                            }
                            if (spaceLength > 1) {
                                bufferOut.insert(bufferOut.length() - spaceLength, "<span class=\"modulusLineStyle\">");
                                bufferOut.insert(bufferOut.length() - " ".length(), "</span>");
                            }
                            spaceLength = 0;
                        }
                    } else {
                        bufferOut.append("<span class=\"line-number even\">");
                        bufferOut.append(codeLineNumber);
                        bufferOut.append(":</span> ");
                    }
                }
                isNewLine = false;
                bufferOut.append("</a>");
            }
            if (Character.isJavaIdentifierPart(presentChar = bufferIn.charAt(presentIndex)) || State.IMPORT_NAME == presentState && presentChar == '*') {
                bufferOut.append(presentChar);
                ++identifierLength;
                continue;
            }
            if (identifierLength > 0) {
                qualifiedIdentifierLength += identifierLength;
                if (bufferIn.charAt(presentIndex) == '.') {
                    bufferOut.append(presentChar);
                    ++qualifiedIdentifierLength;
                    identifierLength = 0;
                    continue;
                }
                String identifier = bufferOut.substring(bufferOut.length() - identifierLength);
                if (State.PARAM_VARIABLE == presentState) {
                    bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"variable member\">");
                    bufferOut.append("</span>");
                    presentState = State.JAVADOC;
                } else if (State.JAVADOC == presentState) {
                    if (javadocTagCollection.contains(identifier) && bufferIn.charAt(presentIndex - (identifierLength + 1)) == '@') {
                        bufferOut.insert(bufferOut.length() - identifierLength, "<span class=\"javadoc tag\">");
                        bufferOut.append("</span>");
                        if ("param".equals(identifier)) {
                            presentState = State.PARAM_VARIABLE;
                        }
                    }
                } else if (State.IMPORT_NAME == presentState) {
                    bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"import header type\">");
                    bufferOut.append("</span>");
                    presentState = State.TEXT;
                } else if (State.PACKAGE_NAME == presentState) {
                    bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"package header type\">");
                    bufferOut.append("</span>");
                    presentState = State.TEXT;
                } else if (State.TEXT == presentState) {
                    if (keywordCollection.contains(identifier)) {
                        bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"keyword\">");
                        bufferOut.append("</span>");
                        if ("import".equals(identifier)) {
                            presentState = State.IMPORT_NAME;
                        } else if ("package".equals(identifier)) {
                            presentState = State.PACKAGE_NAME;
                        }
                    } else if (primitiveTypeCollection.contains(identifier)) {
                        bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"primitive type\">");
                        bufferOut.append("</span>");
                    } else if (identifier.equals(identifier.toUpperCase()) && !Character.isDigit(identifier.charAt(0))) {
                        bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"constant member\">");
                        bufferOut.append("</span>");
                    } else if (Character.isUpperCase(identifier.charAt(0))) {
                        saveIndex = presentIndex;
                        while (Character.isWhitespace(bufferIn.charAt(saveIndex++))) {
                        }
                        if (bufferIn.charAt(--saveIndex) == '(') {
                            bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"constructor member\">");
                            bufferOut.append("</span>");
                        } else {
                            bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"non-primitive type\">");
                            bufferOut.append("</span>");
                        }
                    } else if (!Character.isDigit(identifier.charAt(0)) && !primitiveLiteralCollection.contains(identifier)) {
                        saveIndex = presentIndex;
                        while (Character.isWhitespace(bufferIn.charAt(saveIndex++))) {
                        }
                        if (bufferIn.charAt(--saveIndex) == '(') {
                            bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"method member\">");
                            bufferOut.append("</span>");
                        } else if (bufferIn.charAt(saveIndex) == ',') {
                            bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"variable member\">");
                            bufferOut.append("</span>");
                        } else {
                            if (bufferIn.charAt(presentIndex - (qualifiedIdentifierLength + 1)) == '.') {
                                ++qualifiedIdentifierLength;
                            }
                            bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"variable member\">");
                            bufferOut.append("</span>");
                        }
                    } else if (primitiveLiteralCollection.contains(identifier)) {
                        bufferOut.insert(bufferOut.length() - identifierLength, "<span class=\"primitive literal\">");
                        bufferOut.append("</span>");
                    } else {
                        if (presentIndex - (qualifiedIdentifierLength + 1) > 0 && bufferIn.charAt(presentIndex - (qualifiedIdentifierLength + 1)) == '.') {
                            ++qualifiedIdentifierLength;
                        }
                        bufferOut.insert(bufferOut.length() - qualifiedIdentifierLength, "<span class=\"numeric literal\">");
                        bufferOut.append("</span>");
                    }
                }
                qualifiedIdentifierLength = 0;
                identifierLength = 0;
            }
            switch (presentChar) {
                case '&': {
                    bufferOut.append("&amp;");
                    break;
                }
                case '<': {
                    bufferOut.append("&lt;");
                    break;
                }
                case '>': {
                    bufferOut.append("&gt;");
                    break;
                }
                case '\"': {
                    bufferOut.append("&quot;");
                    if (State.TEXT == presentState) {
                        presentState = State.DOUBLE_QUOTE;
                        bufferOut.insert(bufferOut.length() - "&quot;".length(), "<span class=\"double quote\">");
                        break;
                    }
                    if (State.DOUBLE_QUOTE != presentState) break;
                    presentState = State.TEXT;
                    bufferOut.append("</span>");
                    break;
                }
                case '\'': {
                    bufferOut.append("'");
                    if (State.TEXT == presentState) {
                        presentState = State.SINGLE_QUOTE;
                        bufferOut.insert(bufferOut.length() - "'".length(), "<span class=\"single quote\">");
                        break;
                    }
                    if (State.SINGLE_QUOTE != presentState) break;
                    presentState = State.TEXT;
                    bufferOut.append("</span>");
                    break;
                }
                case '\\': {
                    bufferOut.append("\\");
                    if (State.DOUBLE_QUOTE != presentState && State.SINGLE_QUOTE != presentState) break;
                    bufferOut.append(bufferIn.charAt(++presentIndex));
                    break;
                }
                case '\t': {
                    i = 0;
                    while (i < this.tabSize) {
                        bufferOut.append(' ');
                        ++i;
                    }
                    break;
                }
                case '*': {
                    bufferOut.append("*");
                    if (State.TEXT != presentState || bufferIn.charAt(presentIndex - 1) != '/') break;
                    if (bufferIn.length() - 1 > presentIndex && bufferIn.charAt(presentIndex + 1) == '*') {
                        presentState = State.JAVADOC;
                        bufferOut.insert(bufferOut.length() - "/*".length(), "<span class=\"javadoc comment\">");
                        break;
                    }
                    presentState = State.TRADITIONAL_COMMENT;
                    bufferOut.insert(bufferOut.length() - "/*".length(), "<span class=\"c comment\">");
                    break;
                }
                case '/': {
                    bufferOut.append("/");
                    if ((State.TRADITIONAL_COMMENT == presentState || State.JAVADOC == presentState) && bufferIn.charAt(presentIndex - 1) == '*') {
                        bufferOut.append("</span>");
                        presentState = State.TEXT;
                    }
                    if (State.TEXT != presentState || presentIndex <= 0 || bufferIn.charAt(presentIndex - 1) != '/') break;
                    bufferOut.insert(bufferOut.length() - "//".length(), "<span class=\"line comment\">");
                    presentState = State.LINE_COMMENT;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (bufferIn.charAt(presentIndex) == '\r' && bufferIn.length() - 1 > presentIndex && bufferIn.charAt(presentIndex + 1) == '\n') {
                        ++presentIndex;
                    }
                    if (State.LINE_COMMENT == presentState) {
                        bufferOut.append("</span>");
                        presentState = State.TEXT;
                    }
                    if (this.lineModulus > 0 && this.hasLineModulusCodeBlocks && codeLineNumber % this.lineModulus == 0 && !isNewBlock) {
                        if (State.TRADITIONAL_COMMENT == presentState || State.JAVADOC == presentState) {
                            bufferOut.append("</span>");
                        }
                        bufferOut.append("\r\n");
                        bufferOut.append("</pre>\r\n");
                        bufferOut.append("   </div>\r\n");
                        bufferOut.append("<pre class=\"");
                        bufferOut.append("modulusBlockPREStyle\">\r\n");
                        if (State.TRADITIONAL_COMMENT == presentState) {
                            bufferOut.append("<span class=\"c comment\">");
                        }
                        if (State.JAVADOC == presentState) {
                            bufferOut.append("<span class=\"javadoc comment\">");
                        }
                    } else {
                        bufferOut.append("\r\n");
                    }
                    isNewLine = true;
                    break;
                }
                case '\u0000': {
                    if (State.LINE_COMMENT != presentState || presentIndex != bufferIn.length() - 1) break;
                    bufferOut.append("</span>");
                    break;
                }
                default: {
                    bufferOut.append(presentChar);
                }
            }
            qualifiedIdentifierLength = 0;
        }
        if (presentState == State.LINE_COMMENT) {
            bufferOut.append("</span>\r\n");
        }
        bufferOut.append("</pre>\r\n");
        if (this.lineModulus > 0 && this.hasLineModulusCodeBlocks && !isNewBlock && codeLineNumber % this.lineModulus != 0) {
            bufferOut.append("   </div>\r\n");
        }
        bufferOut.append("  </div>\r\n");
        if (!this.isCodeSnippet) {
            if (this.hasFooter) {
                bufferOut.append("  <hr />\r\n");
                bufferOut.append("  <div id=\"footer\">\r\n");
                if (this.hasFooterIcons) {
                    if (this.hasFooterDate) {
                        bufferOut.append("   <script type=\"text/javaScript\"");
                        bufferOut.append(">\r\n");
                        bufferOut.append("    <!-- // <![CDATA[\r\n");
                        bufferOut.append("     document.write(\"Document last");
                        bufferOut.append(" modified on \"");
                        bufferOut.append(" + document.lastModified + ");
                        bufferOut.append("\"<br />\");\r\n");
                        bufferOut.append("    // ]]> -->\r\n");
                        bufferOut.append("   </script>\r\n");
                    }
                    bufferOut.append("   <a href=\"");
                    bufferOut.append("http://validator.w3.org/check/referer");
                    bufferOut.append("\">\r\n");
                    bufferOut.append("    <img class=\"icon\" src=\"");
                    bufferOut.append("http://www.w3.org/Icons/");
                    if (this.isXHTML_1_1) {
                        bufferOut.append("valid-xhtml11\"\r\n");
                        bufferOut.append("         alt=\"Valid XHTML 1.1!\"");
                    } else {
                        bufferOut.append("valid-xhtml10\"\r\n");
                        bufferOut.append("         alt=\"Valid XHTML 1.0!\"");
                    }
                    bufferOut.append(" height=\"31\" ");
                    bufferOut.append("width=\"88\" />\r\n");
                    bufferOut.append("   </a>\r\n");
                    bufferOut.append("   &#160;\r\n");
                    bufferOut.append("   <a href=\"");
                    bufferOut.append("http://jigsaw.w3.org");
                    bufferOut.append("/css-validator/check/referer");
                    bufferOut.append("\">\r\n");
                    bufferOut.append("    <img class=\"icon\" src=\"");
                    bufferOut.append("http://jigsaw.w3.org/");
                    bufferOut.append("css-validator/images/vcss");
                    bufferOut.append("\"\r\n");
                    bufferOut.append("         alt=\"Valid CSS!\"");
                    bufferOut.append(" height=\"31\" width=\"88\" />\r\n");
                    bufferOut.append("   </a>\r\n");
                } else {
                    bufferOut.append("   This is a valid\r\n");
                    bufferOut.append("   <a href=\"http://");
                    bufferOut.append("validator.w3.org/check/referer");
                    if (this.isXHTML_1_1) {
                        bufferOut.append("\">XHTML 1.1</a>\r\n");
                    } else {
                        bufferOut.append("\">XHTML 1.0</a>\r\n");
                    }
                    bufferOut.append("   with\r\n");
                    bufferOut.append("   <a href=\"http://");
                    bufferOut.append("jigsaw.w3.org");
                    bufferOut.append("/css-validator/check/referer");
                    bufferOut.append("\">CSS</a>\r\n");
                    bufferOut.append("   document \r\n");
                    if (this.hasFooterDate) {
                        bufferOut.append("   <script type=\"text/javaScript\"");
                        bufferOut.append(">\r\n");
                        bufferOut.append("    <!-- // <![CDATA[\r\n");
                        bufferOut.append("     document.write(\"last modified");
                        bufferOut.append(" on \" + document.lastModified);");
                        bufferOut.append("\r\n");
                        bufferOut.append("    // ]]> -->\r\n");
                        bufferOut.append("   </script>\r\n");
                    }
                }
                bufferOut.append("  </div>\r\n");
            }
            bufferOut.append(" </body>\r\n");
            bufferOut.append("</html>\r\n");
        }
        return bufferOut.toString();
    }

    public static final class State {
        public static final State TEXT = new State();
        public static final State IMPORT_NAME = new State();
        public static final State PARAM_VARIABLE = new State();
        public static final State JAVADOC = new State();
        public static final State PACKAGE_NAME = new State();
        public static final State DOUBLE_QUOTE = new State();
        public static final State SINGLE_QUOTE = new State();
        public static final State TRADITIONAL_COMMENT = new State();
        public static final State LINE_COMMENT = new State();

        private State() {
        }
    }
}

