/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private transient E[] data;

    public CopyOnWriteArrayList() {
        this.data = new Object[0];
    }

    public CopyOnWriteArrayList(Collection<? extends E> c) {
        this.data = new Object[c.size()];
        int index = 0;
        for (E value : c) {
            this.data[index++] = value;
        }
    }

    public CopyOnWriteArrayList(E[] array) {
        this.data = (Object[])array.clone();
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public boolean contains(Object e) {
        return this.indexOf(e) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> itr = c.iterator();
        int pos = c.size();
        while (--pos >= 0) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int indexOf(Object e) {
        E[] data = this.data;
        int i = 0;
        while (i < data.length) {
            if (CopyOnWriteArrayList.equals(e, data[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(E e, int index) {
        E[] data = this.data;
        int i = index;
        while (i < data.length) {
            if (CopyOnWriteArrayList.equals(e, data[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object e) {
        E[] data = this.data;
        int i = data.length - 1;
        while (i >= 0) {
            if (CopyOnWriteArrayList.equals(e, data[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int lastIndexOf(E e, int index) {
        E[] data = this.data;
        int i = index;
        while (i >= 0) {
            if (CopyOnWriteArrayList.equals(e, data[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Object clone() {
        CopyOnWriteArrayList clone = null;
        try {
            clone = (CopyOnWriteArrayList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    @Override
    public Object[] toArray() {
        E[] data = this.data;
        Object[] array = new Object[data.length];
        System.arraycopy(data, 0, array, 0, data.length);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        E[] data = this.data;
        if (a.length < data.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), data.length);
        } else if (a.length > data.length) {
            a[data.length] = null;
        }
        System.arraycopy(data, 0, a, 0, data.length);
        return a;
    }

    @Override
    public E get(int index) {
        return this.data[index];
    }

    @Override
    public synchronized E set(int index, E e) {
        E result = this.data[index];
        Object[] newData = (Object[])this.data.clone();
        newData[index] = e;
        this.data = newData;
        return result;
    }

    @Override
    public synchronized boolean add(E e) {
        E[] data = this.data;
        Object[] newData = new Object[data.length + 1];
        System.arraycopy(data, 0, newData, 0, data.length);
        newData[data.length] = e;
        this.data = newData;
        return true;
    }

    @Override
    public synchronized void add(int index, E e) {
        E[] data = this.data;
        Object[] newData = new Object[data.length + 1];
        System.arraycopy(data, 0, newData, 0, index);
        newData[index] = e;
        System.arraycopy(data, index, newData, index + 1, data.length - index);
        this.data = newData;
    }

    @Override
    public synchronized E remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        E[] snapshot = this.data;
        Object[] newData = new Object[snapshot.length - 1];
        E result = snapshot[index];
        if (index > 0) {
            System.arraycopy(snapshot, 0, newData, 0, index);
        }
        System.arraycopy(snapshot, index + 1, newData, index, snapshot.length - index - 1);
        this.data = newData;
        return result;
    }

    @Override
    public synchronized boolean remove(Object element) {
        E[] snapshot = this.data;
        Object[] newData = new Object[snapshot.length - 1];
        int elementIndex = -1;
        int i = 0;
        while (i < snapshot.length) {
            if (CopyOnWriteArrayList.equals(element, snapshot[i])) {
                elementIndex = i;
                break;
            }
            if (i < newData.length) {
                newData[i] = snapshot[i];
            }
            ++i;
        }
        if (elementIndex < 0) {
            return false;
        }
        System.arraycopy(snapshot, elementIndex + 1, newData, elementIndex, snapshot.length - elementIndex - 1);
        this.data = newData;
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        if (c.size() == 0) {
            return false;
        }
        E[] snapshot = this.data;
        Object[] storage = new Object[this.data.length];
        boolean changed = false;
        int length = 0;
        E[] EArray = snapshot;
        int n = snapshot.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            if (c.contains(element)) {
                changed = true;
            } else {
                storage[length++] = element;
            }
            ++n2;
        }
        if (!changed) {
            return false;
        }
        Object[] newData = new Object[length];
        System.arraycopy(storage, 0, newData, 0, length);
        this.data = newData;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        if (c.size() == 0) {
            this.clear();
            return true;
        }
        E[] snapshot = this.data;
        Object[] storage = new Object[this.data.length];
        int length = 0;
        E[] EArray = snapshot;
        int n = snapshot.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            if (c.contains(element)) {
                storage[length++] = element;
            }
            ++n2;
        }
        if (length == snapshot.length) {
            return false;
        }
        Object[] newData = new Object[length];
        System.arraycopy(storage, 0, newData, 0, length);
        this.data = newData;
        return true;
    }

    @Override
    public synchronized void clear() {
        this.data = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.data.length, c);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("index = " + index);
        }
        int csize = c.size();
        if (csize == 0) {
            return false;
        }
        E[] data = this.data;
        c.iterator();
        Object[] newData = new Object[data.length + csize];
        if (index != 0) {
            System.arraycopy(data, 0, newData, 0, index);
        }
        int itemsLeft = index;
        for (E value : c) {
            newData[index++] = value;
        }
        System.arraycopy(data, itemsLeft, newData, 0, data.length - itemsLeft);
        this.data = newData;
        return true;
    }

    public synchronized boolean addIfAbsent(E val) {
        if (this.contains(val)) {
            return false;
        }
        this.add(val);
        return true;
    }

    public synchronized int addAllAbsent(Collection<? extends E> c) {
        int size = c.size();
        if (size == 0) {
            return 0;
        }
        E[] snapshot = this.data;
        Object[] storage = new Object[size];
        size = 0;
        for (E val : c) {
            if (this.contains(val)) continue;
            storage[size++] = val;
        }
        if (size == 0) {
            return 0;
        }
        Object[] newData = new Object[snapshot.length + size];
        System.arraycopy(snapshot, 0, newData, 0, snapshot.length);
        System.arraycopy(storage, 0, newData, snapshot.length, size);
        this.data = newData;
        return size;
    }

    public String toString() {
        return Arrays.toString(this.data);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof List) {
            List source = (List)o;
            if (source.size() != this.size()) {
                return false;
            }
            Iterator sourceIterator = source.iterator();
            for (E element : this) {
                if (element.equals(sourceIterator.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashcode = 1;
        for (E element : this) {
            hashcode = 31 * hashcode + (element == null ? 0 : element.hashCode());
        }
        return hashcode;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            E[] iteratorData;
            int currentElement;
            {
                this.iteratorData = CopyOnWriteArrayList.this.data;
                this.currentElement = 0;
            }

            @Override
            public boolean hasNext() {
                return this.currentElement < this.iteratorData.length;
            }

            @Override
            public E next() {
                return this.iteratorData[this.currentElement++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("updating of elements in iterators is not supported by this class");
            }
        };
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        return new ListIterator<E>(index){
            E[] iteratorData;
            int currentElement;
            {
                this.iteratorData = CopyOnWriteArrayList.this.data;
                this.currentElement = n;
            }

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException("updating of elements in iterators is not supported by this class");
            }

            @Override
            public boolean hasNext() {
                return this.currentElement < this.iteratorData.length;
            }

            @Override
            public boolean hasPrevious() {
                return this.currentElement > 0;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.iteratorData[this.currentElement++];
            }

            @Override
            public int nextIndex() {
                return this.currentElement + 1;
            }

            @Override
            public E previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                return this.iteratorData[--this.currentElement];
            }

            @Override
            public int previousIndex() {
                return this.currentElement - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("updating of elements in iterators is not supported by this class");
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException("updating of elements in iterators is not supported by this class");
            }
        };
    }

    @Override
    public synchronized List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(fromIndex) + " > " + toIndex);
        }
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, fromIndex, toIndex);
        }
        return new SubList(this, fromIndex, toIndex);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int len = this.data.length;
        s.writeInt(len);
        int i = 0;
        while (i < this.data.length) {
            s.writeObject(this.data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int capacity = s.readInt();
        this.data = new Object[capacity];
        int i = 0;
        while (i < capacity) {
            this.data[i] = s.readObject();
            ++i;
        }
    }

    static final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    Object[] getArray() {
        return this.data;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RandomAccessSubList<E>
    extends SubList<E>
    implements RandomAccess {
        RandomAccessSubList(CopyOnWriteArrayList<E> backing, int fromIndex, int toIndex) {
            super(backing, fromIndex, toIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubList<E>
    extends AbstractList<E> {
        final CopyOnWriteArrayList<E> backingList;
        final int offset;
        int size;
        E[] data;

        SubList(CopyOnWriteArrayList<E> backing, int fromIndex, int toIndex) {
            this.backingList = backing;
            this.data = ((CopyOnWriteArrayList)backing).data;
            this.offset = fromIndex;
            this.size = toIndex - fromIndex;
        }

        void checkMod() {
            if (this.data != ((CopyOnWriteArrayList)this.backingList).data) {
                throw new ConcurrentModificationException();
            }
        }

        private void checkBoundsInclusive(int index) {
            if (index < 0 || index > this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
            }
        }

        private void checkBoundsExclusive(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                Object[] snapshot = ((CopyOnWriteArrayList)this.backingList).data;
                Object[] newData = new Object[snapshot.length - this.size];
                int toIndex = this.size + this.offset;
                System.arraycopy(snapshot, 0, newData, 0, this.offset);
                System.arraycopy(snapshot, toIndex, newData, this.offset, snapshot.length - toIndex);
                ((CopyOnWriteArrayList)this.backingList).data = newData;
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E o) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsExclusive(index);
                E el = this.backingList.set(index + this.offset, o);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                return el;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsExclusive(index);
                return this.backingList.get(index + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E o) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsInclusive(index);
                this.backingList.add(index + this.offset, o);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsExclusive(index);
                E o = this.backingList.remove(index + this.offset);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                --this.size;
                return o;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                this.checkMod();
                this.checkBoundsInclusive(index);
                int csize = c.size();
                boolean result = this.backingList.addAll(this.offset + index, c);
                this.data = ((CopyOnWriteArrayList)this.backingList).data;
                this.size += csize;
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.backingList;
            synchronized (copyOnWriteArrayList) {
                return this.addAll(this.size, c);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            this.checkMod();
            this.checkBoundsInclusive(index);
            return new ListIterator<E>(this, index){
                private final ListIterator<E> i;
                private int position;
                final /* synthetic */ SubList this$1;
                {
                    this.this$1 = subList;
                    this.i = subList.backingList.listIterator(n + subList.offset);
                    this.position = n;
                }

                public boolean hasNext() {
                    return this.position < this.this$1.size;
                }

                public boolean hasPrevious() {
                    return this.position > 0;
                }

                public E next() {
                    if (this.position == this.this$1.size) {
                        throw new NoSuchElementException();
                    }
                    ++this.position;
                    return this.i.next();
                }

                public E previous() {
                    if (this.position == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.position;
                    return this.i.previous();
                }

                public int nextIndex() {
                    return this.i.nextIndex() - this.this$1.offset;
                }

                public int previousIndex() {
                    return this.i.previousIndex() - this.this$1.offset;
                }

                public void remove() {
                    throw new UnsupportedOperationException("Modification not supported on CopyOnWriteArrayList iterators");
                }

                public void set(E o) {
                    throw new UnsupportedOperationException("Modification not supported on CopyOnWriteArrayList iterators");
                }

                public void add(E o) {
                    throw new UnsupportedOperationException("Modification not supported on CopyOnWriteArrayList iterators");
                }
            };
        }
    }
}

