/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.lang.CPStringBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.SocketPermission;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CodeSource
implements Serializable {
    private static final long serialVersionUID = 4977541819976013951L;
    private final URL location;
    private transient HashSet certs;

    public CodeSource(URL location, Certificate[] certs) {
        this.location = location;
        if (certs != null) {
            this.certs = new HashSet((Collection)Arrays.asList(certs));
        }
    }

    public int hashCode() {
        return (this.location == null ? 0 : this.location.hashCode()) ^ (this.certs == null ? 0 : this.certs.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CodeSource)) {
            return false;
        }
        CodeSource cs = (CodeSource)obj;
        return (this.certs == null ? cs.certs == null : this.certs.equals(cs.certs)) && (this.location == null ? cs.location == null : this.location.equals(cs.location));
    }

    public final URL getLocation() {
        return this.location;
    }

    public final Certificate[] getCertificates() {
        if (this.certs == null) {
            return null;
        }
        Certificate[] c = new Certificate[this.certs.size()];
        this.certs.toArray(c);
        return c;
    }

    public boolean implies(CodeSource cs) {
        String our_file;
        if (cs == null) {
            return false;
        }
        if (!(this.certs == null || cs.certs != null && this.certs.containsAll(cs.certs))) {
            return false;
        }
        if (this.location == null) {
            return true;
        }
        if (cs.location == null || !this.location.getProtocol().equals(cs.location.getProtocol()) || this.location.getPort() != -1 && this.location.getPort() != cs.location.getPort() || this.location.getRef() != null && !this.location.getRef().equals(cs.location.getRef())) {
            return false;
        }
        if (this.location.getHost() != null) {
            SocketPermission their_sockperm;
            String their_host = cs.location.getHost();
            if (their_host == null) {
                return false;
            }
            SocketPermission our_sockperm = new SocketPermission(this.location.getHost(), "accept");
            if (!our_sockperm.implies(their_sockperm = new SocketPermission(their_host, "accept"))) {
                return false;
            }
        }
        if ((our_file = this.location.getFile()) != null) {
            String their_file;
            if (!our_file.endsWith("/")) {
                our_file = String.valueOf(our_file) + "/";
            }
            if ((their_file = cs.location.getFile()) == null || !their_file.startsWith(our_file)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        CPStringBuilder sb = new CPStringBuilder("(").append(this.location);
        if (this.certs == null || this.certs.isEmpty()) {
            sb.append(" <no certificates>");
        } else {
            Iterator iter = this.certs.iterator();
            int i = this.certs.size();
            while (--i >= 0) {
                sb.append(' ').append(iter.next());
            }
        }
        return sb.append(")").toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int count = s.readInt();
        this.certs = new HashSet();
        while (--count >= 0) {
            String type = (String)s.readObject();
            int bytes = s.readInt();
            byte[] encoded = new byte[bytes];
            int i = 0;
            while (i < bytes) {
                encoded[i] = s.readByte();
                ++i;
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(encoded);
            try {
                CertificateFactory factory = CertificateFactory.getInstance(type);
                this.certs.add(factory.generateCertificate(stream));
            }
            catch (CertificateException certificateException) {}
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.certs == null) {
            s.writeInt(0);
        } else {
            int count = this.certs.size();
            s.writeInt(count);
            Iterator iter = this.certs.iterator();
            while (--count >= 0) {
                byte[] encoded;
                Certificate c = (Certificate)iter.next();
                s.writeObject(c.getType());
                try {
                    encoded = c.getEncoded();
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    encoded = null;
                }
                if (encoded == null) {
                    s.writeInt(0);
                    continue;
                }
                s.writeInt(encoded.length);
                int i = 0;
                while (i < encoded.length) {
                    s.writeByte(encoded[i]);
                    ++i;
                }
            }
        }
    }
}

