#!/bin/bash
# Drupal	(http://drupal.org)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2011-05-28
# require:
#	httpd-2.2.x
#	php-5.2.x
#	postgresql-8.4.x
#


wget -N http://ftp.drupal.org/files/projects/drush-All-Versions-HEAD.tar.gz
tar xvfz drush-All-Versions-HEAD.tar.gz 

export PATH=/opt/php5/bin:$PATH

#./drush/drush dl drupal > drush-dl-drupal.log
#VERSION=`head -1 drush-dl-drupal.log | sed -e s'/.*(\(.*\)).*/\1/'`

VERSION=6.22
PAC_NAME=drupal-$VERSION
SRC_NAME=${PAC_NAME}.tar.gz
SRC_URI=http://ftp.drupal.org/files/projects/${SRC_NAME}
wget -N $SRC_URI
tar xvfz $SRC_NAME

(cd $PAC_NAME; ../drush/drush dl ja > drush-dl-ja.log)
JVERS=`sed -e s'/.*(\(.*\)).*/\1/' drush-dl-ja.log`

SRC_FILE=${PAC_NAME}-japanese_${JVERS}.tar.gz
echo $SRC_FILE
tar cvfz $SRC_FILE $PAC_NAME

JAM_URI=http://downloads.sourceforge.net/drupal-jp/jamail-6.x-1.0.tgz
JAM_FILE=${JAM_URI##*/}
# using git:# git  clone  git://github.com/juk/drupal-tsearch.git

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/www/php/appli
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/03_PHP.tgz
BUILD_DIR=$PLAMO/drupal6
CUSTOM_DIR=$BUILD_DIR/Custom

#( cd $CUSTOM_DIR; 
#  wget -N http://drupal.org/files/issues/search-chouonpu-D6.patch )
#PAT_FILE=search-chouonpu-D6.patch

REL=P1
CPU=noarch
SYS_NAME="${CPU}-${REL}"


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p  $WORK
export LANG=C
export CFLAGS="-O2"
export PATH=$PATH:/usr/X11R6/bin

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  #( cd $SRC_DIR; wget $SRC_URI )
  mv -v $SRC_FILE $SRC_DIR/
fi
if [ ! -f $SRC_DIR/$JAM_FILE ]; then
  ( cd $SRC_DIR; wget $JAM_URI )
fi 

( cd $CUSTOM_DIR; 
  git clone git://github.com/juk/drupal-tsearch.git )

SHR_DIR=usr/share/
mkdir -p $WORK/$SHR_DIR | exit
mv drush $WORK/$SHR_DIR/
chown -R root.root $WORK/$SHR_DIR

cd $WORK
mkdir -p install
sed -e "s/VERSION/$VERSION/g" \
    -e "s/_PACKAGE_NAME_/${PAC_NAME}-${SYS_NAME}/g" \
  $CUSTOM_DIR/doinst.sh > install/doinst.sh
#echo "To install japanese package drupal:"
#echo "        % drush dl ja"

mkdir -p opt/htdocs | exit 1
cd opt/htdocs
tar xvfz $SRC_DIR/$SRC_FILE
chmod -R o-w $PAC_NAME
cd $PAC_NAME

if [ -f $CUSTOM_DIR/$PAT_FILE ]; then
  patch -p0 < $CUSTOM_DIR/$PAT_FILE
fi

## patch to use unix domain socket with pgsql
#patch install.php $CUSTOM_DIR/install.php-pg.patch

# insert installtion notation into index.php
head -2 index.php > index.php.new
cat >>index.php.new<<EOF

if ( file_exists("install.php") ) {
  echo "<font color='red'>1.) Please access '<a href='install.php'>install.php</a>' for initial installation!  (You should make sure your mail server working before the installation.)</a></font><br />\n";
  echo "<font color='red'>2.) Please remove 'install.php' after the installation to start setup your site!</font><br />\n";
}

//for php-5.3// error_reporting(E_ALL & ~E_DEPRECATED);

EOF
sed -e '1,2d' index.php >> index.php.new
mv  index.php.new  index.php


mkdir -p files
mkdir -p sites/all/themes
mkdir -p sites/all/modules
(cd sites/all/modules; tar xvfz $SRC_DIR/$JAM_FILE)
(cd sites/all/modules;
  mkdir tsearch;  cp $CUSTOM_DIR/drupal-tsearch/* tsearch/;
  patch tsearch/tsearch.install $CUSTOM_DIR/tsearch.install-pg8.4.patch;
# tar xfz $CUSTOM_DIR/$TS2_FILE;
#  mv $TS2_DIR tsearch;
)


DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR | exit
cp -p $BUILD_DIR/`basename $0`  \
      [A-Z][A-Z]*  \
    $WORK/$DOC_DIR
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX,go-w $WORK/$DOC_DIR

cp -a $CUSTOM_DIR/custom/ .

chown -R root:apache ./


mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=2 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/${TYP}.${PAC_NAME}.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://drupal.org/
DOC	/${DOC_DIR}/
EXE	/drupal6/
REM	content management platform(blog etc.)
__EOCL__



cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}-${SYS_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}-${SYS_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
