/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.server.repository.size;

import info.aduna.webapp.views.SimpleResponseView;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.http.server.ProtocolUtil;
import org.openrdf.http.server.ServerHTTPException;
import org.openrdf.http.server.repository.RepositoryInterceptor;
import org.openrdf.model.Resource;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.springframework.context.ApplicationContextException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;

public class SizeController
extends AbstractController {
    public SizeController() throws ApplicationContextException {
        this.setSupportedMethods(new String[]{"GET"});
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolUtil.logRequestParameters(request);
        Repository repository = RepositoryInterceptor.getRepository(request);
        RepositoryConnection repositoryCon = RepositoryInterceptor.getRepositoryConnection(request);
        ValueFactory vf = repository.getValueFactory();
        Resource[] contexts = ProtocolUtil.parseContextParam(request, "context", vf);
        long size = -1L;
        try {
            size = repositoryCon.size(contexts);
        }
        catch (RepositoryException e) {
            throw new ServerHTTPException("Repository error: " + e.getMessage(), (Throwable)e);
        }
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("content", String.valueOf(size));
        return new ModelAndView((View)SimpleResponseView.getInstance(), model);
    }
}

