/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.IterationWrapper;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimitIteration<E, X extends Exception>
extends IterationWrapper<E, X> {
    private final int limit;
    private int returnCount;

    public LimitIteration(Iteration<? extends E, X> iter, int limit) {
        super(iter);
        assert (iter != null);
        assert (limit >= 0);
        this.limit = limit;
        this.returnCount = 0;
    }

    @Override
    public boolean hasNext() throws X {
        return this.returnCount < this.limit && super.hasNext();
    }

    @Override
    public E next() throws X {
        if (this.returnCount >= this.limit) {
            throw new NoSuchElementException("limit reached");
        }
        ++this.returnCount;
        return super.next();
    }
}

