/* ASB2364 FPGA registers
 */

#ifndef _ASM_UNIT_FPGA_REGS_H
#define _ASM_UNIT_FPGA_REGS_H

#include <asm/cpu-regs.h>

#ifdef __KERNEL__

#define ASB2364_FPGA_REG_RESET_LAN	__SYSREG(0xa9001300, u16)
#define ASB2364_FPGA_REG_RESET_UART	__SYSREG(0xa9001304, u16)
#define ASB2364_FPGA_REG_RESET_I2C	__SYSREG(0xa9001308, u16)
#define ASB2364_FPGA_REG_RESET_USB	__SYSREG(0xa900130c, u16)
#define ASB2364_FPGA_REG_RESET_AV	__SYSREG(0xa9001310, u16)

#define ASB2364_FPGA_REG_IRQ(X)		__SYSREG(0xa9001590+((X)*4), u16)
#define ASB2364_FPGA_REG_IRQ_LAN	ASB2364_FPGA_REG_IRQ(0)
#define ASB2364_FPGA_REG_IRQ_UART	ASB2364_FPGA_REG_IRQ(1)
#define ASB2364_FPGA_REG_IRQ_I2C	ASB2364_FPGA_REG_IRQ(2)
#define ASB2364_FPGA_REG_IRQ_USB	ASB2364_FPGA_REG_IRQ(3)
#define ASB2364_FPGA_REG_IRQ_FPGA	ASB2364_FPGA_REG_IRQ(5)

#define ASB2364_FPGA_REG_MASK(X)	__SYSREG(0xa9001590+((X)*4), u16)
#define ASB2364_FPGA_REG_MASK_LAN	ASB2364_FPGA_REG_MASK(0)
#define ASB2364_FPGA_REG_MASK_UART	ASB2364_FPGA_REG_MASK(1)
#define ASB2364_FPGA_REG_MASK_I2C	ASB2364_FPGA_REG_MASK(2)
#define ASB2364_FPGA_REG_MASK_USB	ASB2364_FPGA_REG_MASK(3)
#define ASB2364_FPGA_REG_MASK_FPGA	ASB2364_FPGA_REG_MASK(5)

#define ASB2364_FPGA_REG_CPLD5_SET1	__SYSREG(0xa9002500, u16)
#define ASB2364_FPGA_REG_CPLD5_SET2	__SYSREG(0xa9002504, u16)
#define ASB2364_FPGA_REG_CPLD6_SET1	__SYSREG(0xa9002600, u16)
#define ASB2364_FPGA_REG_CPLD6_SET2	__SYSREG(0xa9002604, u16)
#define ASB2364_FPGA_REG_CPLD7_SET1	__SYSREG(0xa9002700, u16)
#define ASB2364_FPGA_REG_CPLD7_SET2	__SYSREG(0xa9002704, u16)
#define ASB2364_FPGA_REG_CPLD8_SET1	__SYSREG(0xa9002800, u16)
#define ASB2364_FPGA_REG_CPLD8_SET2	__SYSREG(0xa9002804, u16)
#define ASB2364_FPGA_REG_CPLD9_SET1	__SYSREG(0xa9002900, u16)
#define ASB2364_FPGA_REG_CPLD9_SET2	__SYSREG(0xa9002904, u16)
#define ASB2364_FPGA_REG_CPLD10_SET1	__SYSREG(0xa9002a00, u16)
#define ASB2364_FPGA_REG_CPLD10_SET2	__SYSREG(0xa9002a04, u16)

#define SyncExBus()					\
	do {						\
		unsigned short w;			\
		w = *(volatile short *)0xa9000000;	\
	} while (0)

#endif /* __KERNEL__ */

#endif /* _ASM_UNIT_FPGA_REGS_H */
