# Tamito KAJIYAMA <3 July 2001>
# $Id: prefs.py,v 1.1.1.1 2003/04/11 05:54:31 shy Exp $

import mimetools
import os
import string
import UserDict

import ninix.home

class Preferences(UserDict.UserDict):
    def __init__(self, filename):
        UserDict.UserDict.__init__(self)
        self.filename = filename
    def load(self):
        try:
            file = open(self.filename)
        except IOError:
            return
        prefs = mimetools.Message(file)
        for key, value in prefs.items():
            self[key] = value
        file.close()
    def save(self):
        try:
            os.makedirs(os.path.dirname(self.filename))
        except OSError:
            pass
        file = open(self.filename, "w")
        keys = self.keys()
        keys.sort()
        for key in keys:
            file.write("%s: %s\n" % (key, self[key]))
        file.close()
    def _get(self, name, default, conv):
        value = self.get(name)
        if value:
            try:
                return conv(value)
            except ValueError:
                pass
        return default
    def getint(self, name, default=None):
        return self._get(name, default, string.atoi)
    def getfloat(self, name, default=None):
        return self._get(name, default, string.atof)

def new_prefs():
    filename = ninix.home.get_preferences()
    return Preferences(filename)

def load_prefs():
    prefs = new_prefs()
    prefs.load()
    return prefs
