# -*- coding: UTF-8 -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#  Copyright (C) 2002-2005 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2003 by Shun-ichi TAHARA <jado@flowernet.gr.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import os
import string
import sys
import time
import random
import StringIO
import codecs

if os.environ.has_key("DISPLAY"):
    import gtk ## FIXME
    import gobject

import ninix.makoto
import ninix.update
import ninix.sakura
import ninix.version

class Ghost:

    def __init__(self, app, data, default_path, communicate, debug=0):
        self.app = app
        self.char = 2 # "sakura" and "kero"
        self.__sender = 'ninix-aya'
        self.__sakura  = ninix.sakura.Sakura(debug)
        self.__sakura.set_ghost(self)
        self.__observer = []
        saori_lib = ninix.dll.Library(
            'saori', default_path, ghost=self)
        self.__dll = ninix.dll.Library(
            'shiori', default_path, saori_lib=saori_lib)
        self.debug = debug
        self.__surface = ninix.surface.Surface(self.__sakura, debug)
        self.__sakura.set_surface(self.__surface)
        self.__balloon = ninix.balloon.Balloon(self.__sakura, debug)
        self.__sakura.set_balloon(self.__balloon)
        self.communicate = communicate
        # create vanish dialog
        self.__vanish_dialog = VanishDialog(self)
        self.__running = 0
        self.__temp_mode = 0
        self.__charset = 'Shift_JIS'
        self.top_margin = 0
        self.bottom_margin = 0
        desc, shiori_dir, use_makoto, surface_set, balloon, prefix, shiori_dll, shiori_name = data
        self.new(desc, shiori_dir, use_makoto, surface_set, balloon, prefix, shiori_dll, shiori_name) ## FIXME

    def notify_communicate(self, sender, sentence):
        self.__sakura.enqueue_event("OnCommunicate", sender, sentence)

    def notify_surface_drag(self, side, x_delta, y_delta): ## FIXME
        if self.__sakura.passivemode:
            return
        x, y = self.get_surface_position(side)
        x += x_delta
        if self.__surface.get_alignment(side) == 2:
            y += y_delta
        self.set_surface_position(side, x, y)
        # reset balloon positions
        self.position_balloons()
        self.raise_surface(side) ## FIXME

    def notify_surface_click(self, button, click, side, x, y): ## FIXME
        self.notify_observer('raise', (side)) ## FIXME: automagical raise 
        if button == 1 and self.__sakura.mouse_button1 == ninix.sakura.BUTTON1_RAISE or \
           button == 3 and self.__sakura.mouse_button3 == ninix.sakura.BUTTON3_RAISE:
            self.raise_all()
        elif button == 1 and self.__sakura.mouse_button1 == ninix.sakura.BUTTON1_LOWER or \
             button == 3 and self.__sakura.mouse_button3 == ninix.sakura.BUTTON3_LOWER:
            self.lower_all()
        if self.__sakura.vanished:
            if side == 0 and button == 1:
                if self.__sakura.sstp_request_handler:
                    self.__sakura.sstp_request_handler.send_sstp_break()
                    self.__sakura.sstp_request_handler = None
                self.__sakura.reset_script(1)
                self.__sakura.notify_event("OnVanishButtonHold", default=r"\e")
                self.__sakura.vanished = 0
            return
        if self.updateman.is_active():
            if button == 1 and click == 2:
                self.updateman.interrupt()
            return
        if self.__sakura.time_critical_session:
            return
        elif button == 1 and click == 1:
            if self.__sakura.passivemode and self.__sakura.processed_script != None:
                return
            part = self.__surface.get_touched_region(side, x, y)
            self.__sakura.notify_event("OnMouseClick", x, y, "", side, part)
        elif self.__sakura.passivemode:
            return
        elif button == 3:
            if self.__sakura.sstp_request_handler:
                self.__sakura.sstp_request_handler.send_sstp_break()
                self.__sakura.sstp_request_handler = None
                self.__sakura.reset_script(1)
                self.__sakura.stand_by(0)
            self.__surface.open_popup_menu(button, side)
        elif button == 1 and click == 2:
            if self.__sakura.sstp_request_handler:
                self.__sakura.sstp_request_handler.send_sstp_break()
                self.__sakura.sstp_request_handler = None
            part = self.__surface.get_touched_region(side, x, y)
            self.__sakura.notify_event("OnMouseDoubleClick", x, y, "", side, part)

    def position_all(self): ## FIXME
        self.__surface.reset_position()
        self.position_balloons()
        self.notify_observer('set position')

    def position_balloons(self): ## FIXME
        self.__surface.reset_balloon_position()

    def align_top(self, side): ## FIXME
        self.__surface.set_alignment(side, 1)
        self.position_balloons()

    def align_bottom(self, side): ## FIXME
        self.__surface.set_alignment(side, 0)
        self.position_balloons()

    def align_current(self): ## FIXME
        self.__surface.set_alignment_current()
        self.position_balloons()

    def raise_all(self): ## FIXME
        self.raise_surface_all()
        self.__balloon.raise_all()

    def lower_all(self): ## FIXME
        self.lower_surface_all()
        self.__balloon.lower_all()

    def cantalk(self):
        if self.__sakura.cantalk:
            return 1
        else:
            return 0

    def is_running(self):
        if self.__running:
            return 1
        else:
            return 0

    def set_observer(self, observer):
        if observer not in self.__observer:
            self.__observer.append(observer)

    def notify_observer(self, event, args=()):
        for observer in self.__observer:
            observer.notify_observer(event, args)

    def delete_observer(self, observer):
        for i in range(len(self.__observer)):
            if self.__observer[i] == observer:
                del self.__observer[i]
                break

    def hide_surface_all(self):
        self.__surface.hide_all()
        self.notify_observer('hide')

    def hide_surface(self, side):
        self.__surface.hide(side)
        self.notify_observer('hide')

    def show_surface(self, side):
        self.__surface.show(side)
        self.notify_observer('show')
        self.notify_observer('raise', (side)) ## FIXME

    def raise_surface_all(self):
        self.__surface.raise_all()
        self.notify_observer('raise', (0))
        self.notify_observer('raise', (1))

    def raise_surface(self, side):
        self.__surface.raise_(side)
        self.notify_observer('raise', (side))

    def lower_surface_all(self):
        self.__surface.lower_all()
        self.notify_observer('lower')

    def lower_surface(self, side):
        self.__surface.lower(side)
        self.notify_observer('lower')

    def get_surface_position(self, side):
        result = self.__surface.get_position(side)
        if result is None:
            result = (0, 0)
        return result

    def get_surface_size(self, side):
        result = self.__surface.get_surface_size(side)
        if result is None:
            result = (0, 0)
        return result

    def get_balloon_position(self, side):
        result = self.__balloon.get_position(side)
        if result is None:
            result = (0, 0)
        return result

    def get_balloon_size(self, side):
        result = self.__balloon.get_balloon_size(side)
        if result is None:
            result = (0, 0)
        return result

    def get_kinoko_position(self, baseposition):
        side = 0
        x, y = self.get_surface_position(side)
        w, h = self.__surface.get_surface_size(side)
        if baseposition == 0 or baseposition not in [1, 2, 3]: # AKF
            centerx = self.__surface.get_config_int(side, 'point.kinoko.centerx')
            centery = self.__surface.get_config_int(side, 'point.kinoko.centery')
            if centerx is None or centery is None:
                rect = self.__surface.get_collision_area(side, 'head')
                if rect is not None:
                    x1, y1, x2, y2 = rect
                    return x + (x2 - x1) / 2, y + (y2 - y1) / 2
                else:
                    return x + w / 2, y + h / 8
            ## XXX
            scale = self.get_surface_scale()
            centerx = centerx * scale / 100
            centery = centery * scale / 100
            return x + centerx, y + centery
        elif baseposition == 1:
            rect = self.__surface.get_collision_area(side, 'face')
            if rect is not None:
                x1, y1, x2, y2 = rect
                return x + (x2 - x1) / 2, y + (y2 - y1) / 2
            else:
                return x + w / 2, y + h / 4
        elif baseposition == 2:
            rect = self.__surface.get_collision_area(side, 'bust')
            if rect is not None:
                x1, y1, x2, y2 = rect
                return x + (x2 - x1) / 2, y + (y2 - y1) / 2
            else:
                return x + w / 2, y + h / 2
        elif baseposition == 3:
            centerx = self.__surface.get_config_int(side, 'point.centerx')
            centery = self.__surface.get_config_int(side, 'point.centery')
            ## XXX
            scale = self.get_surface_scale()
            if centerx is None:
                centerx = w / 2
            else:
                centerx = centerx * scale / 100
            if centery is None:
                centery = h / 2
            else:
                centery = centery * scale / 100
            return x + centerx, y + centery

    def notify_surface_change(self, side): ## FIXME
        if side < 2:
            self.notify_observer('set surface')

    def notify_surface_move(self, side, xoffset, yoffset): # animation
        if side < 2:
            args = (side, xoffset, yoffset)
            self.notify_observer('move surface', args)

    def set_surface_default(self):
        self.__surface.set_surface_default()

    def set_surface_id(self, side, id):
        self.__surface.set_surface(side, id)
        ##self.notify_observer('set surface')

    def set_surface_position(self, side, x, y):
        self.__surface.set_position(side, x, y)
        self.notify_observer('set position')

    def get_sakura(self): ## FIXME: this method should be removed
        return self.__sakura

    def is_talking(self):
        if self.__sakura.processed_script or \
           self.__sakura.processed_text:
            return 1
        else:
            return 0

    def set_use_pna(self, flag):
        self.__surface.set_use_pna(flag)
        self.__balloon.set_use_pna(flag)

    def set_sink_after_talk(self, flag):
        self.__sakura.set_sink_after_talk(flag)

    def set_balloon_position(self, side, x, y): ## FIXME
        self.__balloon.set_position(side, x, y)

    def set_balloon_direction(self, side, direction):
        self.__balloon.set_direction(side, direction)

    def set_balloon_scalling(self, flag):
        self.__balloon.set_scalling(flag)

    def get_balloon_scalling(self):
        return self.__balloon.get_scalling()

    def set_surface_scale(self, scale):
        self.__surface.set_scale(scale)
        self.__balloon.set_scale(scale)
        self.notify_observer('set scale')

    def get_helpers(self):
        return self.__sakura.helpers

    def balloon_is_shown(self, side):
        if self.__balloon and self.__balloon.is_shown(side):
            return 1
        else:
            return 0

    def surface_is_shown(self, side):
        if self.__surface and self.__surface.is_shown(side):
            return 1
        else:
            return 0

    def get_surface_id(self, side):
        return self.__surface.get_surface(side)

    def get_surface_scale(self):
        return self.__surface.get_scale()

    def set_debug(self, debug): ## FIXME
        self.debug = debug
        self.__surface.set_debug(debug)

    def get_top_margin(self):
        return self.top_margin

    def set_top_margin(self, margin):
        self.top_margin = margin
        self.align_current()
        self.notify_observer('set top margin')

    def get_bottom_margin(self):
        return self.bottom_margin

    def set_bottom_margin(self, margin):
        self.bottom_margin = margin
        self.align_current()
        self.notify_observer('set bottom margin')

    def set_browser(self, command):
        self.__sakura.set_browser(command)

    def set_helpers(self, list):
        self.__sakura.set_helpers(list)

    def set_script_speed(self, speed):
        self.__sakura.set_script_speed(speed)

    def set_event_kill_list(self, list):
        self.__sakura.set_event_kill_list(list)

    def hide_all(self): ## FIXME
        self.hide_surface_all()
        self.__balloon.hide_all()

    def stop(self):
        if not self.__running:
            return
        self.notify_observer('finalize')
        self.__running = 0
        self.save_history()
        self.communicate.rebuild_ghostdb(self, None)
        self.hide_all()
        self.__sakura.stop()

    def restart(self):
        self.load_history()
        self.__sakura.restart()

    def set_balloon(self, desc, balloon):
        self.__balloon.new(desc, balloon)
        for side in range(2, self.char):
            self.__balloon.add_window(side)

    def set_surface(self, desc, alias, surface, name, dir):
        self.__surface.new(desc, alias, surface, name, dir)
        for side in range(2, self.char):
            default = self.desc.get("char%d.seriko.defaultsurface" % side)
            self.__surface.add_window(side, default)
        icon = self.desc.get("icon", None)
        if icon != None:
            icon_path = os.path.join(self.shiori_dir, icon)
            if not os.path.exists(icon_path):
                icon_path = None
        else:
            icon_path = None
        self.__surface.set_icon(icon_path)

    def busy(self):
        return self.__sakura.busy()

    def set_balloon_fonts(self, fonts):
        self.__balloon.set_balloon_fonts(fonts)

    def get_balloon_fonts(self):
        return self.__balloon.get_balloon_fonts()

    def set_mouse_button1(self, button1):
        self.__sakura.set_mouse_button1(button1)

    def set_mouse_button3(self, button3):
        self.__sakura.set_mouse_button3(button3)

    def finalize(self):
        self.stop()
        if not self.__temp_mode:
            self.unload_shiori()
        self.__surface.finalize()
        self.__balloon.finalize()

    def get_vanished_count(self):
        return self.vanished_count

    def set_vanished_count(self, count):
        self.vanished_count = count

    def get_ghost_time(self):
        return self.ghost_time

    def set_ghost_time(self, clock):
        self.ghost_time = clock

    def increment_ghost_time(self):
        if not self.__temp_mode:
            self.set_ghost_time(self.get_ghost_time() + 1)

    def unload_shiori(self):
        self.shiori.unload()

    def notify_iconified(self):
        self.__sakura.set_cantalk(0)
        if not self.__sakura.passivemode:
            self.__sakura.reset_script(1)
            self.__sakura.stand_by(1)
            self.__sakura.notify_event("OnWindowStateMinimize")
        self.notify_observer('iconified')

    def notify_deiconified(self):
        if self.__sakura.cantalk == 0:
            self.__sakura.set_cantalk(1)
            if not self.__sakura.passivemode:
                self.__sakura.notify_event("OnWindowStateRestore")
        self.notify_observer('deiconified')

    def notify_event(self, event, *arglist, **argdict): ## FIXME
        self.__sakura.notify_event(event, *arglist, **argdict)

    def notify_shell_changing(self, name, proc):
        self.__sakura.notify_shell_changing(name, proc)

    def notify_ghost_changing(self, name, method, proc):
        self.__sakura.notify_ghost_changing(name, method, proc)

    def notify_shell_changed(self, name):
        self.__sakura.notify_shell_changed(name)

    def notify_ghost_changed(self, name, vanished, default):
        self.__sakura.notify_ghost_changed(name, vanished, default)

    def notify_ninix_reloading(self, proc):
        self.__sakura.notify_ninix_reloading(proc)

    def notify_ninix_reloaded(self):
        self.__sakura.notify_ninix_reloaded()

    def notify_vanish_selecting(self):
        self.__sakura.notify_vanish_selecting()

    def notify_vanish_cancel(self):
        self.__sakura.notify_vanish_cancel()

    def notify_vanish_selected(self, proc):
        self.__sakura.notify_vanish_selected(proc)

    def get_own_balloon_name(self):
        if self.own_balloon:
            desc, balloon = self.own_balloon
            name = desc.get('name', unicode(_("Own Balloon"), 'utf-8'))
        else:
            name = None
        return name

    def get_current_balloon_name(self):
        return self.__balloon.get_balloon_name()

    def vanish(self):
        if self.busy():
            gtk.gdk.beep() ## FIXME
            return
        self.notify_vanish_selecting()
        self.__vanish_dialog.show()

    def notify_vanish_confirmation(self, confirmed):
        if not confirmed:
            self.notify_vanish_cancel()
            return
        def proc(self=self):
            count = self.get_vanished_count()
            self.set_vanished_count(count + 1)
            self.set_ghost_time(0)
            apply(gtk.idle_add, (self.app.vanish_sakura, self)) ## FIXME
        self.notify_vanish_selected(proc)

    def load_shiori(self): ##FIXME
        if self.shiori and self.shiori.load(self.shiori_dir):
            if getattr(self.shiori, 'show_description', None):
                self.shiori.show_description()
        else:
            sys.stderr.write("%s cannot load SHIORI(%s)\n" % (self.get_selfname(), self.shiori_name))
        self.__charset = 'Shift_JIS' # default
        charset = self.get_event_response("charset")
        if charset:
            try:
                codecs.lookup(charset)
            except:
                sys.stderr.write("Unsupported charset %s" % repr(charset))
            else:
                self.__charset = charset
        else:
            pass

    def new(self, desc, shiori_dir, use_makoto, surface_set, balloon, prefix, shiori_dll, shiori_name): ## FIXME
        self.shiori = None
        self.desc = desc
        self.shiori_dir = shiori_dir
        self.use_makoto = use_makoto
        self.surface_set = surface_set
        self.own_balloon = balloon
        self.prefix = prefix
        self.shiori_dll = shiori_dll
        self.shiori_name = shiori_name
        name = (shiori_dll, shiori_name)
        self.shiori = self.__dll.request(name)
        self.updateman = ninix.update.NetworkUpdate(self.__sakura)
        char = 2
        while self.desc.get("char%d.seriko.defaultsurface" % char) != None:
            char += 1
        if char > 2:
            self.char = char
        # XXX
        if self.desc.get('name') == "BTH小っちゃいってことは便利だねっ":
            self.set_SSP_mode(1)
        else:
            self.set_SSP_mode(0)

    def notify_start(self, init, vanished, ghost_changed, name):
        if self.__temp_mode:
            default = None
        else:
            default = ninix.version.VERSION_INFO
        if init:
            if self.get_ghost_time() == 0:
                if not self.__sakura.notify_event("OnFirstBoot", self.get_vanished_count()):
                    self.__sakura.notify_event("OnBoot", default=default)
            else:
                self.__sakura.notify_event("OnBoot", default=default)
            self.__sakura.notify_event("OnDisplayChange",
                                       gtk.gdk.visual_get_best_depth(),
                                       gtk.gdk.screen_width(),
                                       gtk.gdk.screen_height(),
                                       type="NOTIFY")
            self.__sakura.enqueue_event(
                "OnDisplayChange",
                gtk.gdk.visual_get_best_depth(),
                gtk.gdk.screen_width(), gtk.gdk.screen_height())
        elif vanished:
            self.notify_ghost_changed(name, vanished, default)
        elif ghost_changed:
            self.notify_ghost_changed(name, vanished, default)
        else:
            self.notify_shell_changed(name)

    def start(self, item, init, temp, vanished, ghost_changed, ignore_default, prev_name):
        if self.is_running():
            if temp:
                self.enter_temp_mode()
            else:
                if self.__temp_mode == 1:
                    self.__temp_mode = 2
                    self.load_shiori()
                    self.notify_start(init, vanished, ghost_changed, prev_name)
            return
        self.set_ghost_time(0)
        self.set_vanished_count(0)
        self.__running = 1
        self.__temp_mode = temp
        self.current = item
        type, i, j = item
        if type == "g":
            print "ghost", item
            if not self.surface_set:
                shell_name, surface_set, balloon = self.app.request_shell(0)
                name, surface_dir, surface_desc, surface_alias, surface = surface_set[0]
                surface_set = None
            else:
                name, surface_dir, surface_desc, surface_alias, surface = self.surface_set[j]
                surface_set = self.surface_set
                balloon = self.own_balloon
        elif type == "s":
            print "shell", item
            shell_name, surface_set, balloon = self.app.request_shell(i)
            name, surface_dir, surface_desc, surface_alias, surface = surface_set[j]
        if not surface_set:
            surface_name = None
        elif len(surface_set) == 1:
            surface_name = unicode(_("Master"), 'utf-8')
        else:
            surface_name = name
        if ghost_changed:
            name = prev_name
        self.set_surface(surface_desc, surface_alias, surface, surface_name, surface_dir)
        if ignore_default or not balloon:
            balloon_name = self.desc.get("balloon", "")
            number = None
            if balloon_name:
                number = self.app.find_balloon_by_name(balloon_name)
            if number == None:
                default_balloon = self.app.get_default_balloon()
                number = self.app.find_balloon_by_name(default_balloon) or 0
            balloon = self.app.request_balloon(number)
        desc, balloon = balloon
        self.set_balloon(desc, balloon)
        if not temp:
            self.load_shiori()
        self.restart()
        self.__sakura.start()
        self.notify_start(init, vanished, ghost_changed, name)
        self.set_timeout()

    def save_history(self):
        path = os.path.join(self.get_prefix(), 'HISTORY')
        try:
            file = open(path, "w")
        except IOError, (code, message):
            sys.stderr.write("cannot write %s\n" % path)
        else:
            time = self.get_ghost_time()
            vanished_count = self.get_vanished_count()
            file.write('time, %s\n' % time)
            file.write('vanished_count, %s\n' % vanished_count)
            file.close()

    def load_history(self):
        path = os.path.join(self.get_prefix(), 'HISTORY')
        if os.path.exists(path):
            ghost_time = 0
            ghost_vanished_count = 0
            try:
                file = open(path, "r")
            except IOError, (code, message):
                sys.stderr.write("cannot read %s\n" % path)
            else:
                for line in file:
                    comma = line.find(',')
                    if comma >= 0:
                        key = line[:comma].strip()
                        value = line[comma+1:].strip()
                    if key == 'time':
                        try:
                            ghost_time = int(value)
                        except:
                            pass
                    elif key == 'vanished_count':
                        try:
                            ghost_vanished_count = int(value)
                        except:
                            pass
                file.close()
            self.set_ghost_time(ghost_time)
            self.set_vanished_count(ghost_vanished_count)
        else:
            self.set_ghost_time(0)
            self.set_vanished_count(0)

    def get_prefix(self):
        return self.prefix

    def translate(self, s):
        if s is not None:
            if self.use_makoto:
                s = ninix.makoto.execute(s)
            else:
                r = self.get_event_response("OnTranslate", s, translate=0)
                if r:
                    s = r
        return s

    def getaistringrandom(self): # obsolete
        result = self.get_event_response("OnAITalk")
        return self.translate(result)

    def getdms(self):
        result = self.get_event_response('dms')
        return self.translate(result)

    def getword(self, type):
        result = self.get_event_response('%s' % type)
        return self.translate(result)

    def getstring(self, name):
        return self.get_event_response(name)

    def get_name(self):
        return self.desc.get("name", unicode(_("Sakura&Unyuu"), 'utf-8'))

    def get_username(self):
        return self.getstring("username") or self.__surface.get_username() or self.desc.get("user.defaultname", unicode(_("User"), 'utf-8'))

    def get_selfname(self):
        return self.__surface.get_selfname() or self.desc.get("sakura.name", unicode(_("Sakura"), 'utf-8'))

    def get_selfname2(self):
        return self.__surface.get_selfname2() or self.desc.get("sakura.name2", unicode(_("Sakura"), 'utf-8'))

    def get_keroname(self):
        return self.__surface.get_keroname() or self.desc.get("kero.name", unicode(_("Unyuu"), 'utf-8'))

    def get_friendname(self):
        return self.__surface.get_friendname() or self.desc.get("sakura.friend.name", unicode(_("Tomoyo"), 'utf-8'))

    def set_SSP_mode(self, flag): # XXX
        if flag:
            self.__sender = 'SSP'
        else:
            self.__sender = 'ninix-aya'

    def get_event_response(self, event, *arglist, **argdict):
        if self.__temp_mode == 1:
            return ''
        for key in argdict.keys():
            assert key in ['type', 'translate'] # trap typo, etc.
        ref = arglist
        type = argdict.get('type', 'GET')
        translate = argdict.get('translate', 1)
        header = '%s SHIORI/3.0\r\n' % type + \
                 'ID: %s\r\n' % event + \
                 'Sender: %s\r\n' % self.__sender + \
                 'SecurityLevel: local\r\n'
        for i in range(len(ref)):
            if ref[i] != None:
                header += 'Reference' + str(i) + ': ' + str(ref[i]) + '\r\n'
        header += '\r\n'
        header = header.encode(self.__charset, 'ignore')
        response = self.shiori.request(header)
        if self.__sakura.cantalk:
            result, to = self.get_value(response)
            if translate:
                result = self.translate(result)
        else:
            result, to = '', None
        if self.__temp_mode == 2 and event != "charset":
            result, to = '', None
        if result == None:
            result = ''
        if to and result:
            self.communicate.send_message(to, self.__sakura.get_selfname(), result)
        return result

    def get_value(self, response):
        header = StringIO.StringIO(response)
        result = {}
        to = None
        for line in header:
            if line[-1] == '\n':
                line = line[:-1]
            line = line.strip()
            if not line:
                continue
            colon = line.find(':')
            if colon >= 0:
                key = line[:colon].strip()
                result[key] = line[colon+1:].strip()
            else:
                continue
        for key in result.keys():
            result[key] = unicode(result[key], self.__charset, 'ignore')
        if result.has_key('Reference0'):
            to = result['Reference0']
        if result.has_key('Value'):
            return result['Value'], to
        else:
            return None, to

    def teach(self, word):
        result = self.get_event_response('OnTeach', word)
        return self.translate(result)

    def update(self):
        if self.updateman.is_active():
            return
        homeurl = self.getstring("homeurl")
        if not homeurl:
            self.__sakura.start_script(r"\t\h\s[0]" + unicode(_("I'm afraid I don't have Network Update yet."), 'utf-8') + r"\e")
            self.__sakura.balloon.hide_sstp_message()
            return
        ghostdir = self.get_prefix()
        print "homeurl =", homeurl
        print "ghostdir =", ghostdir
        self.updateman.start(homeurl, ghostdir)

    def quit(self):
        self.app.stop_sakura(self)

    def edit_preferences(self):
        self.app.edit_preferences()

    def open_ghost_manager(self):
        self.app.open_ghost_manager()

    def select_ghost(self, sequential, event=1):
        self.app.select_ghost(self, sequential, event)

    def select_ghost_by_name(self, name, event=1):
        self.app.select_ghost_by_name(self, name, event)

    def select_balloon(self, widget, item):
        if not widget.active:
            return
        if self.own_balloon:
            desc, balloon = self.own_balloon
            name = self.get_own_balloon_name()
        else:
            name = None
        if item != name:
            desc, balloon = self.app.get_balloon_description(item)
        self.__balloon.hide_all()
        self.set_balloon(desc, balloon)
        self.__sakura.set_balloon(self.__balloon)
        self.__balloon.set_balloon_default()
        print "balloon", item

    def enter_temp_mode(self):
        if not self.__temp_mode:
            self.__temp_mode = 2

    def leave_temp_mode(self):
        self.__temp_mode = 0

    ###   TIMEOUT   ###
    def set_timeout(self): ## FIXME
        gobject.timeout_add(10, self.do_idle_tasks) # 10ms

    reload_event = None

    def do_idle_tasks(self):
        if not self.__running:
            return False
        if self.__temp_mode:
            self.__sakura.update_surface()
            self.__sakura.process_script()
            if not self.__sakura.busy() and \
               not self.__sakura.script_queue and \
               not (self.__sakura.processed_script or self.__sakura.processed_text):
                if self.__temp_mode == 1:
                    time.sleep(1.4)
                    self.finalize()
                    self.app.remove_ghost(self) ## FIXME
                    self.app.reset_sstp_flag() ## FIXME
                    return False
                else:
                    self.app.reset_sstp_flag() ## FIXME                    
                    self.leave_temp_mode()
                    return True
            else:
                return True
        if self.reload_event and not self.__sakura.busy() and \
           not (self.__sakura.processed_script or self.__sakura.processed_text):
            self.hide_all()
            sys.stdout.write('reloading....\n')
            self.shiori.unload() ## FIXME
            self.app.stop_sakura(self, self.app.reload_current_sakura, self) ## FIXME
            self.restart()
            sys.stdout.write('done.\n')
            apply(self.__sakura.enqueue_event, self.reload_event)
            self.reload_event = None
        self.__sakura.update_surface()
        # continue network update (enqueue events)
        if self.updateman.is_active():
            self.updateman.run()
            while 1:
                event = self.updateman.get_event()
                if not event:
                    break
                if event[0] == 'OnUpdateComplete' and event[1] == 'changed':
                    self.reload_event = event
                else:
                    apply(self.__sakura.enqueue_event, event)
        self.__sakura.process_script()
        return True

    def launch_browser(self, event, args): ## FIXME
        title, url = args
        if self.__sakura.is_URL(url):
            self.__sakura.launch_browser(url)
        self.__sakura.enqueue_event("OnRecommandedSiteChoice", title, url)

    def close(self):
        if self.busy():
            gtk.gdk.beep() ## FIXME
            return
        self.__sakura.reset_script(1)
        self.__sakura.enqueue_event("OnClose")

    def about(self):
        if self.__sakura.busy():
            gtk.gdk.beep() ## FIXME
            return
        self.__sakura.notify_about()

    def network_update(self):
        if self.__sakura.busy():
            gtk.gdk.beep() ## FIXME
            return
        self.update()

    def reload(self): ## FIXME
        self.app.reload(self)

    def show_usage(self):
        self.app.show_usage()

class VanishDialog:

    def __init__(self, ghost):
        self.__ghost = ghost
        self.window = gtk.Dialog()
        self.window.connect("delete_event", self.cancel)
        self.window.set_title("Vanish")
        self.window.set_modal(True)
        self.window.set_position(gtk.WIN_POS_CENTER)
        self.label = gtk.Label(unicode(_("Vanish"), 'utf-8'))
        self.window.vbox.pack_start(self.label, padding=10)
        self.label.show()
        box = gtk.HButtonBox()
        box.set_layout(gtk.BUTTONBOX_END)
        self.window.action_area.pack_start(box)
        box.show()
        button = gtk.Button(unicode(_("Yes"), 'utf-8'))
        button.connect("clicked", self.ok)
        box.add(button)
        button.show()
        button = gtk.Button(unicode(_("No"), 'utf-8'))
        button.connect("clicked", self.cancel)
        box.add(button)
        button.show()

    def set_message(self, message):
        self.label.set_text(message)

    def show(self):
        self.window.show()

    def ok(self, widget, event=None):
        self.window.hide()
        self.__ghost.notify_vanish_confirmation(1)
        return True

    def cancel(self, widget, event=None):
        self.window.hide()
        self.__ghost.notify_vanish_confirmation(0)
        return True

def test():
    pass

if __name__ == "__main__":
    test()
