# -*- coding: UTF-8 -*-
#
#  kawari8.py - a (Real) 華和梨 loader for ninix
#  Copyright (C) 2002, 2003 by ABE Hideaki <abe-xx@eos.dricas.com>
#  Copyright (C) 2002-2004 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: kawari8.py,v 1.8 2004/10/10 05:16:47 shy Exp $
#

import os
import sys

try:
    import _kawari8
except:
    _kawari8 = None

class Shiori:
    def __init__(self, dll_name):
        self.dll_name = dll_name
        self.handle = 0
    def use_saori(self, saori):
        self.saori = saori
    def find(self, dir, dll_name):
        result = 0
        if _kawari8:
            if os.path.isfile(os.path.join(dir, 'kawarirc.kis')):
                result = 205
        return result
    def show_description(self):
        sys.stdout.write('Shiori: Real Kawari8 loader for ninix\n'
                         '        Copyright (C) 2002, 2003 by ABE Hideaki\n'
                         '        Copyright (C) 2002-2004 by Shyouzou Sugitani\n'
                         '        Copyright (C) 2002, 2003 by MATSUMURA Namihiko\n')
    def load(self, dir):
        self.dir = dir
        self.saori_list = {}
        if _kawari8:
            reload(_kawari8)
            if self.dir[-1] == os.sep:
                dir = self.dir
            else:
                dir = self.dir + os.sep
            _kawari8.setcallback(self.saori_exist,
                                 self.saori_load,
                                 self.saori_unload,
                                 self.saori_request)
            result = _kawari8.load(dir)
            self.handle = result
            if result != 0:
                return 1
            else:
                return 0
        else:
            return 0
    def unload(self):
        if _kawari8:
            _kawari8.unload(self.handle)
            for name in self.saori_list.keys():
                if self.saori_list[name][1]:
                    self.saori_list[name][0].unload()
                del self.saori_list[name]
    def request(self, req_string):
        if _kawari8:
            return _kawari8.request(self.handle, req_string)
        else:
            return '' # FIXME
    def saori_exist(self, saori):
        module = self.saori.request(saori)
        if module:
            self.saori_list[saori] = [module, 0]
            return len(self.saori_list)
        else:
            return 0
    def saori_load(self, saori, path):
        result = 0
        if self.saori_list.has_key(saori) and self.saori_list[saori][1] == 0:
            result = self.saori_list[saori][0].load(path)
            self.saori_list[saori][1] = result
        return result
    def saori_unload(self, saori):
        result = 0
        if self.saori_list.has_key(saori) and self.saori_list[saori][1] != 0:
            result = self.saori_list[saori][0].unload()
            self.saori_list[saori][1] = 0
        return result
    def saori_request(self, saori, req):
        result = 'SAORI/1.0 500 Internal Server Error'
        if self.saori_list.has_key(saori):
            if self.saori_list[saori][1] == 0:
                head, tail = os.path.split(saori)
                self.saori_list[saori][1] = self.saori_list[saori][0].load(head)
            if self.saori_list[saori][1]:
                result = self.saori_list[saori][0].request(req)
        return result
