#!/bin/sh

# Build script template [20060728]

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

SHORTNAME=mlterm
ORIGVER=2.9.3
PKGVER=P3
PACKAGE=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER.tgz
SRCPKG=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER-Plamosrc.tar.gz

SRCURL1=http://jaist.dl.sourceforge.net/sourceforge/mlterm/mlterm-2.9.3.tar.gz
SRCDIR1=mlterm-$ORIGVER
PATCH11=patches/mlterm-2.9.3-nosamplesb.patch
PATCH12=patches/mlterm-2.9.3-adduimkeys.patch

SRCURL201=http://seiichisato.jp/mlterm-sb-pixmap/Amaranth.tar.gz
SRCURL202=http://seiichisato.jp/mlterm-sb-pixmap/Bluecurve.tar.gz
SRCURL203=http://seiichisato.jp/mlterm-sb-pixmap/BrushedMetal.tar.gz
SRCURL204=http://seiichisato.jp/mlterm-sb-pixmap/Clearlooks.tar.gz
SRCURL205=http://seiichisato.jp/mlterm-sb-pixmap/Crux.tar.gz
SRC206=patches/Glossy-P.tar.gz
SRCURL207=http://seiichisato.jp/mlterm-sb-pixmap/Gorilla.tar.gz
SRCURL208=http://seiichisato.jp/mlterm-sb-pixmap/Industrial.tar.gz
SRCURL209=http://seiichisato.jp/mlterm-sb-pixmap/LighthouseBlue.tar.gz
SRCURL210=http://seiichisato.jp/mlterm-sb-pixmap/Lush.tar.gz
SRCURL211=http://seiichisato.jp/mlterm-sb-pixmap/Metal.tar.gz
SRCURL212=http://seiichisato.jp/mlterm-sb-pixmap/ShinyMetal.tar.gz
SRCURL213=http://seiichisato.jp/mlterm-sb-pixmap/Simple.tar.gz
SRCURL214=http://seiichisato.jp/mlterm-sb-pixmap/Smokey-Blue.tar.gz
SRCURL215=http://seiichisato.jp/mlterm-sb-pixmap/ThinIce.tar.gz

SRC301=patches/main
SRC302=patches/menu
SRC303=patches/font
SRC304=patches/vfont
SRC305=patches/aafont
SRC306=patches/vaafont

SRC4=patches/mlterm.desktop

INITSCRIPTS=

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot

if [ ! -d $SRCROOT/download ]; then
    mkdir -p $SRCROOT/download
fi
for u in ${!SRCURL*}; do
    f=SRC${u#SRCURL}
    if [ -z "${!f}" ]; then
	declare $f=download/${!u##*/}
    fi
    if [ ! -f ${!f} ]; then
	wget -O ${!f} ${!u}
    fi
done

if [ -d $BUILDROOT ]; then
    rm -rf $BUILDROOT
fi
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar zxf $SRCROOT/$SRC1

cd $SRCDIR1
cat $SRCROOT/$PATCH11 | patch -sp1
cat $SRCROOT/$PATCH12 | patch -sp1
PKG_CONFIG_PATH=/usr/X11R6/lib/pkgconfig ./configure --prefix=$PREFIX --enable-utmp --with-imagelib=gdk-pixbuf --with-type-engines=xcore,xft --enable-optimize-redrawing --with-scrollbars=extra,pixmap_engine --enable-uim || exit 1
make || exit 1
make install DESTDIR=$PKGROOT || exit 1

mkdir -p $PKGROOT$PREFIX/share/pixmaps
cp doc/icon/mlterm* contrib/icon/mlterm* $PKGROOT$PREFIX/share/pixmaps

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1
cp ABOUT-NLS ChangeLog LICENCE README $PKGROOT$DOCPREFIX/$SRCDIR1

for f in `find . -mindepth 2 -name README -or -name LICENCE`; do
    d=${f%/*}
    cp $f $PKGROOT$DOCPREFIX/$SRCDIR1/${f##*/}.${d##*/}
done

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/doc/pixmap_engine
cp -R doc/en doc/ja doc/term $PKGROOT$DOCPREFIX/$SRCDIR1/doc
gzip $PKGROOT$DOCPREFIX/$SRCDIR1/doc/en/* $PKGROOT$DOCPREFIX/$SRCDIR1/doc/ja/*
cp -R contrib/scrollbar/pixmap_engine/HOWTO.* $PKGROOT$DOCPREFIX/$SRCDIR1/doc/pixmap_engine

(
    cd $PKGROOT$PREFIX/share/mlterm/scrollbars
    mv sample3 xxx
    mv xxx pixmap
    for s in ${!SRC2*}; do
	tar zxf $SRCROOT/${!s}
    done
    find . -mindepth 2 \( -name '.*' -or -name '*~' \) | xargs rm -rf
    chown -R 0:0 *
)

for f in ${!SRC3*}; do
    cp $SRCROOT/${!f} $PKGROOT$PREFIX/etc/mlterm
done

mkdir -p $PKGROOT$PREFIX/share/applications
cp $SRCROOT/$SRC4 $PKGROOT$PREFIX/share/applications

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE
cp -f $PACKAGE $SRCROOT

cd $PKGROOT$DOCPREFIX/$SRCDIR1
tar zcf $SRCPKG $SHORTNAME-build
cp -f $SRCPKG $SRCROOT

cd $SRCROOT
rm -rf $BUILDROOT
