/*
   +----------------------------------------------------------------------+
   | Hardening-Patch for PHP                                              |
   +----------------------------------------------------------------------+
   | Copyright (c) 2004-2005 Stefan Esser                                 |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Stefan Esser <sesser@hardened-php.net>                       |
   +----------------------------------------------------------------------+
 */

#ifndef HARDENED_GLOBALS_H
#define HARDENED_GLOBALS_H

typedef struct _hardened_globals hardened_globals_struct;

#ifdef ZTS
# define HG(v) TSRMG(hardened_globals_id, hardened_globals_struct *, v)
extern int hardened_globals_id;
#else
# define HG(v) (hardened_globals.v)
extern struct _hardened_globals hardened_globals;
#endif


struct _hardened_globals {
#if HARDENING_PATCH_MM_PROTECT
	unsigned int canary_1;
	unsigned int canary_2;
#endif
#if HARDENING_PATCH_LL_PROTECT
	unsigned int canary_3;
	unsigned int canary_4;
	unsigned int ll_canary_inited;
#endif
	zend_bool hphp_sql_bailout_on_error;
	zend_bool hphp_multiheader;
	unsigned long hphp_mailprotect;
	long hard_memory_limit;
	HashTable *eval_whitelist;
	HashTable *eval_blacklist;
	HashTable *func_whitelist;
	HashTable *func_blacklist;
	HashTable *include_whitelist;
	HashTable *include_blacklist;
	unsigned int dummy;
};


#endif /* HARDENED_GLOBALS_H */

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 */
