
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : kbd-table.scm
;; DESCRIPTION : keyboard shortcuts for tables
;; COPYRIGHT   : (C) 1999  Joris van der Hoeven
;;
;; This software falls under the GNU general public license and comes WITHOUT
;; ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for details.
;; If you don't have this file, write to the Free Software Foundation, Inc.,
;; 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(texmacs-module (keyboard kbd-table)
  (:use (texmacs edit edit-table)))

(kbd-map in-table?
  ("table H" "" "Horizontal table alignment (l: left, c: center, r: right)")
  ("table V" "" "Vertical table alignment: (b: bottom, c: center, t: top)")
  ("table B" "" "Modify table border (options: =, l, r, b, t)")
  ("table P" "" "Modify table padding (options: =, l, r, b, t)")
  ("table m" "" "Set cell mode (c: cell, h: row, v: column, t: table)")
  ("table h" "" "Horizontal cell alignment (l: left, c: center, r: right)")
  ("table v" "" "Vertical cell alignment: (b: bottom, c: center, t: top)")
  ("table b" "" "Modify cell border (options: =, l, r, b, t)")
  ("table p" "" "Modify cell padding (options: =, l, r, b, t)")

  ("table S" (make-subtable))
  ("table H l" (table-set-halign "l"))
  ("table H c" (table-set-halign "c"))
  ("table H r" (table-set-halign "r"))
  ("table H L" (table-set-halign "L"))
  ("table H C" (table-set-halign "C"))
  ("table H R" (table-set-halign "R"))
  ("table H O" (table-set-halign "O"))
  ("table H w" (table-set-width-ia))
  ("table H p" (table-use-paragraph-width))
  ("table V b" (table-set-valign "b"))
  ("table V c" (table-set-valign "c"))
  ("table V t" (table-set-valign "t"))
  ("table V f" (table-set-valign "f"))
  ("table V B" (table-set-valign "B"))
  ("table V C" (table-set-valign "C"))
  ("table V T" (table-set-valign "T"))
  ("table V O" (table-set-valign "O"))
  ("table V h" (table-set-height-ia))
  ("table P =" (table-set-padding-ia))
  ("table P l" (table-set-lpadding-ia))
  ("table P r" (table-set-rpadding-ia))
  ("table P b" (table-set-bpadding-ia))
  ("table P t" (table-set-tpadding-ia))
  ("table B =" (table-set-border-ia))
  ("table B l" (table-set-lborder-ia))
  ("table B r" (table-set-rborder-ia))
  ("table B b" (table-set-bborder-ia))
  ("table B t" (table-set-tborder-ia))
  ("table O r" (table-set-row-origin-ia))
  ("table O c" (table-set-column-origin-ia))
  ("table L r" (table-set-min-rows-ia))
  ("table L c" (table-set-min-columns-ia))
  ("table L R" (table-set-max-rows-ia))
  ("table L C" (table-set-max-columns-ia))
  ("table home" (table-format-center))
  ("table *" (table-disactivate))
  ("table t" (table-test))

  ("table m c" (set-cell-mode "cell"))
  ("table m h" (set-cell-mode "row"))
  ("table m v" (set-cell-mode "column"))
  ("table m t" (set-cell-mode "table"))
  ("table delete" (cell-del-format ""))
  ("table backspace" (cell-del-format ""))
  ("table h l" (cell-set-halign "l"))
  ("table h L" (cell-set-halign "L"))
  ("table h c" (cell-set-halign "c"))
  ("table h C" (cell-set-halign "C"))
  ("table h r" (cell-set-halign "r"))
  ("table h R" (cell-set-halign "R"))
  ("table h ." (cell-set-halign "."))
  ("table h ," (cell-set-halign ","))
  ("table h o" (cell-set-halign "o"))
  ("table h w" (cell-set-width-ia))
  ("table h s" (cell-set-hsep-ia))
  ("table h m" (cell-set-hmode "min"))
  ("table h e" (cell-set-hmode "exact"))
  ("table h M" (cell-set-hmode "max"))
  ("table h backspace" (table-delete-row #f))
  ("table h delete" (table-delete-row #t))
  ("table v b" (cell-set-valign "b"))
  ("table v B" (cell-set-valign "B"))
  ("table v c" (cell-set-valign "c"))
  ("table v C" (cell-set-valign "C"))
  ("table v t" (cell-set-valign "t"))
  ("table v T" (cell-set-valign "T"))
  ("table v o" (cell-set-valign "o"))
  ("table v h" (cell-set-height-ia))
  ("table v s" (cell-set-vsep-ia))
  ("table v m" (cell-set-vmode "min"))
  ("table v e" (cell-set-vmode "exact"))
  ("table v M" (cell-set-vmode "max"))
  ("table v backspace" (table-delete-column #f))
  ("table v delete" (table-delete-column #t))
  ("table p =" (cell-set-padding-ia))
  ("table p l" (cell-set-lpadding-ia))
  ("table p r" (cell-set-rpadding-ia))
  ("table p b" (cell-set-bpadding-ia))
  ("table p t" (cell-set-tpadding-ia))
  ("table b =" (cell-set-border-ia))
  ("table b l" (cell-set-lborder-ia))
  ("table b r" (cell-set-rborder-ia))
  ("table b b" (cell-set-bborder-ia))
  ("table b t" (cell-set-tborder-ia))
  ("table b left" (table-column-decoration #f))
  ("table b right" (table-column-decoration #t))
  ("table b up" (table-row-decoration #f))
  ("table b down" (table-row-decoration #t))
  ("table s" (cell-set-span-ia)))
