### Name: addmargins
### Title: Puts arbitrary margins on multidimensional tables or arrays.
### Aliases: addmargins
### Keywords: manip methods array

### ** Examples

Aye <- sample( c("Yes","Si","Oui"), 177, replace=TRUE )
Bee <- sample( c("Hum","Buzz"), 177, replace=TRUE )
Sea <- sample( c("White","Black","Red","Dead"), 177, replace=TRUE )
A <- table( Aye, Bee, Sea )
A
addmargins( A )
ftable( A )
ftable( addmargins( A ) )

# Non commutative functions - note differences between resulting tables:
ftable(addmargins(A, c(1,3),
       FUN = list(Sum=sum, list(Min=min, Max=max))))
ftable(addmargins(A, c(3,1),
        FUN = list(list(Min=min, Max=max), Sum=sum)))

# Weird function needed to return the N when computing percentages
sqsm <- function( x ) sum( x )^2/100 
B <- table(Sea, Bee)
round(sweep(addmargins(B, 1, list(list(All=sum, N=sqsm))), 2, 
            apply( B, 2, sum )/100, "/" ), 1)
round(sweep(addmargins(B, 2, list(list(All=sum, N=sqsm))), 1, 
            apply(B, 1, sum )/100, "/"), 1)

# A total over Bee requires formation of the Bee-margin first:
mB <-  addmargins(B, 2, FUN=list(list(Total=sum)) )
round(ftable(sweep(addmargins(mB, 1, list(list(All=sum, N=sqsm))), 2, 
                   apply(mB,2,sum )/100, "/" )), 1)



