### Name: pam
### Title: Partitioning Around Medoids
### Aliases: pam
### Keywords: cluster

### ** Examples

## generate 25 objects, divided into 2 clusters.
x <- rbind(cbind(rnorm(10,0,0.5), rnorm(10,0,0.5)),
           cbind(rnorm(15,5,0.5), rnorm(15,5,0.5)))
pamx <- pam(x, 2)
pamx
summary(pamx)
plot(pamx)
## use obs. 1 & 16 as starting medoids -- same result (typically)
(p2m <- pam(x, 2, medoids = c(1,16)))
## Don't show: 
 stopifnot(all.equal(pamx[-c(3,8)], p2m[-c(3,8)], tol=1e-14),
           all.equal(pamx[[3]][2],  p2m[[3]][2],  tol=1e-14))
## End Don't show
pam(daisy(x, metric = "manhattan"), 2, diss = TRUE)

data(ruspini)
## Plot similar to Figure 4 in Stryuf et al (1996)
## Not run: plot(pam(ruspini, 4), ask = TRUE)
## Don't show: 
plot(pam(ruspini, 4))
## End Don't show



