jack.after.boot             package:boot             R Documentation

_J_a_c_k_k_n_i_f_e-_a_f_t_e_r-_B_o_o_t_s_t_r_a_p _P_l_o_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     This function calculates the jackknife influence values from a
     bootstrap output object and plots the corresponding
     jackknife-after-bootstrap plot.

_U_s_a_g_e:

     jack.after.boot(boot.out, index=1, t=NULL, L=NULL, useJ=TRUE, 
                     stinf=TRUE, alpha=NULL, main="", ylab=NULL, ...)

_A_r_g_u_m_e_n_t_s:

boot.out: An object of class '"boot"' which would normally be created
          by a call to 'boot'. It should represent a nonparametric
          bootstrap. For reliable results 'boot.out$R' should be
          reasonably large. 

   index: The index of the statistic of interest in the output of
          'boot.out$statistic'. 

       t: A vector of length 'boot.out$R' giving the bootstrap
          replicates of the statistic of interest.  This is useful if
          the statistic of interest is a function of  the calculated
          bootstrap output.  If it is not supplied then the default is
          'boot.out$t[,index]'. 

       L: The empirical influence values for the statistic of interest.
           These are used only if 'useJ' is 'FALSE'.  If they are not
          supplied and are needed, they are calculated by a call to
          'empinf'.  If 'L' is supplied then it is assumed that they
          are the infinitesimal jackknife values. 

    useJ: A logical variable indicating if the jackknife influence
          values calculated from the bootstrap replicates should be
          used.  If 'FALSE' the empirical influence values are used. 
          The default is 'TRUE'. 

   stinf: A logical variable indicating whether to standardize the
          jackknife values before plotting them.  If 'TRUE' then the
          jackknife values used are divided by  their standard error. 

   alpha: The quantiles at which the plots are required.  The default
          is  'c(0.05, 0.1, 0.16, 0.5, 0.84, 0.9, 0.95)'.   

    main: A character string giving the main title for the plot. 

    ylab: The label for the Y axis.  If the default values of 'alpha'
          are used and 'ylab' is not supplied then a label indicating
          which percentiles are plotted is used. If 'alpha' is supplied
          then the default label will not say which percentiles were
          used. 

     ...: Any extra arguments required by 'boot.out$statistic'.  These
          are required only if 'useJ' is 'FALSE' and 'L' is not
          supplied, in which case they are passed to 'empinf' for use
          in calculation of the empirical influence values. 

_D_e_t_a_i_l_s:

     The centred jackknife quantiles for each observation are estimated
     from those  bootstrap samples in which  the particular observation
     did not appear.  These  are then plotted against the influence
     values.  If 'useJ' is 'TRUE' then the influence values are found
     in the same way as the difference between the  mean of the
     statistic in the samples excluding the observations and the mean
     in  all samples.  If 'useJ' is 'FALSE' then empirical influence
     values are  calculated by calling 'empinf'.

     The resulting plots are useful diagnostic tools for looking at the
     way individual observations affect the bootstrap output.

     The plot will consist of a number of horizontal dotted lines which
     correspond to the quantiles of the centred bootstrap distribution.
      For each data point the quantiles of the bootstrap distribution
     calculated by omitting that point are plotted against the
     (possibly standardized) jackknife values.  The  observation number
     is printed below the plots.  To make it easier to see  the effect
     of omitting points on quantiles, the plotted quantiles are joined
     by line segments.  These plots provide a useful diagnostic tool in
     establishing the effect of individual observations on the
     bootstrap  distribution.  See the references below for some
     guidelines on the  interpretation of the plots.

_V_a_l_u_e:

     There is no returned value but a plot is generated on the current
     graphics display.

_S_i_d_e _E_f_f_e_c_t_s:

     A plot is created on the current graphics device.

_R_e_f_e_r_e_n_c_e_s:

     Davison, A.C. and Hinkley, D.V. (1997) _Bootstrap Methods and
     Their Application_. Cambridge University Press.

     Efron, B. (1992) Jackknife-after-bootstrap standard errors and
     influence  functions (with Discussion).  _Journal of the Royal
     Statistical Society, B_, *54*, 83-127.

_S_e_e _A_l_s_o:

     'boot', 'empinf'

_E_x_a_m_p_l_e_s:

     #  To draw the jackknife-after-bootstrap plot for the head size data as in
     #  Example 3.24 of Davison and Hinkley (1997)
     pcorr <- function( x )
     { 
     #  function to find the correlations and partial correlations between
     #  the four measurements.
          v <- cor(x)
          v.d <- diag(var(x))
          iv <- solve(v)
          iv.d <- sqrt(diag(iv))
          iv <- - diag(1/iv.d) %*% iv %*% diag(1/iv.d)
          q <- NULL
          n <- nrow(v)
          for (i in 1:(n-1)) 
               q <- rbind( q, c(v[i,1:i],iv[i,(i+1):n]) )
          q <- rbind( q, v[n,] )
          diag(q) <- round(diag(q))
          q
     }

     frets.fun <- function( data, i )
     {    d <- data[i,]
          v <- pcorr( d )
          c(v[1,],v[2,],v[3,],v[4,])
     }
     frets.boot <- boot(log(as.matrix(frets)), frets.fun, R=999)
     #  we will concentrate on the partial correlation between head breadth
     #  for the first son and head length for the second.  This is the 7th
     #  element in the output of frets.fun so we set index=7
     jack.after.boot(frets.boot,useJ=FALSE,stinf=FALSE,index=7)

