#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>
//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
#include <WSCmessageDialog.h>
#include <WSDtimer.h>

void delayproc(unsigned char,void* ptr){
  WSCbase* object = (WSCbase*)ptr;
  object->setVisible(True);
}

void exitep(WSCbase* object){
  if (object->getVisible() != False){
    return;
  }
  //get the global instance of the message dialog.
  WSCmessageDialog* msg = WSGIappMessageDialog(); 
  msg->setProperty(WSNwidth,500);
  msg->setProperty(WSNno,True);
  msg->setProperty(WSNdefaultPosition,True);
  msg->setProperty(WSNlabelString,"Exit and save data?\n If you do not want to save and exit,push NO...");
  //display the dialog.
  long ret = msg->popup();
  if (ret == WS_DIALOG_OK){  //OK
    //saving data ...
    exit(0);
  }else
  if (ret == WS_DIALOG_NO){  //NO
    exit(0);
  }else
  if (ret == WS_DIALOG_CANCEL){ //CANCEL
    // re-display main window by delayproc.
    WSGIappTimer()->addTriggerProc(delayproc,WS250MS,object);
  }
}
static WSCfunctionRegister  op("exitep",(void*)exitep);
