//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCSCRFRAME_H
#define WSCSCRFRAME_H

#include <WScom.h>
#include <WSCform.h>

#define WSCscrFrame_VER  1000

class WSCscrFrame :public WSCform{

  private:
  protected:
     WSCushort _s_w;
     WSCushort _s_h;
     WSCushort _w_w;
     WSCushort _w_h;
     WSCushort _title_height;
     unsigned  _no_scroll:1;

     WSMFpropertyDef(WSNhbarValue,  WSCushort, _s_w         );
     WSMFpropertyDef(WSNvbarValue,  WSCushort, _s_h         );
     WSMFpropertyDef(WSNworkWidth,  WSCushort, _w_w         );
     WSMFpropertyDef(WSNworkHeight, WSCushort, _w_h         );
     WSMFpropertyDef(WSNtitleHeight,WSCushort, _title_height);

     virtual long _device_initialize();
  public:
    WSCscrFrame(WSCbase*,char*);

    virtual void onParentVisibleChange(WSCbool);
    virtual void onVisibleChange(WSCbool);
    virtual void onMousePress(WSCpoint*);

    virtual long clear();
    virtual long draw();
    virtual long redraw();
    virtual void update();
    virtual long cdraw();

    void setVbarValue(WSCushort);
    void setHbarValue(WSCushort);

    void _set_no_scroll(WSCbool fl);

    WSMFguiClassDef(WSCscrFrame,WSCform);
    WSMFsetUseDevice(scrFrameDev);
    WSMFversionDef(WSCscrFrame);
};
#endif
