//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCLOCALESET_H
#define WSCLOCALESET_H

#include <WScom.h>
#include <WSDimage.h>
#include <WSClistData.h>
#include <WSCindexData.h>

class WSDcodeConvert{
  public:
virtual int codeConvert(char*,int,int,const char*,int,int)=0;
virtual int getSystemLocale()=0;
virtual void initialize()=0;
virtual int utf8CharLen(const char*,int)=0;
virtual int encode(WSCushort*,int,const char*,int,int)=0;
virtual int decode(char* dest,int,const WSCushort*,int,int)=0;
static void _set_code_convert_handler(WSDcodeConvert*(*)());
};
extern WSDLEX WSDcodeConvert*  WSGIappCodeConvert();

class WSClocale{
 protected:
  WSCindexData* _hash[WS_MAX_HASH_VALUE];
  WSCstring _name;
  long _locale;
 public:
  WSClocale();
  virtual ~WSClocale();

  void setLocaleName(char*);
  char* getLocaleName();

  void setString(char* index,char* str);
  char* getString(char* index,long encode = WS_EN_DEFAULT);
};

class WSClocaleSet{

 protected:
   WSClistData _locale_list;
   WSClocale*  _default_locale;
   long _init;
   long _encoding;
//   WSClistData _init_procs;
//   long _executed;
 public:
   WSClocaleSet();
   virtual ~WSClocaleSet();
   void  setLocaleString(char* locale,char* index,char* str);
   char* getLocaleString(char* locale,char* index,long encode = WS_EN_DEFAULT);

   void initialize();
   WSClocale* getLocale(char*);
   WSClocale* getDefaultLocale();
   long setDefaultLocale(char* );
   char* getDefaultLocaleName();
   long getDefaultEncoding();
   void setDefaultEncoding(long int);
   long getSystemLocaleEncoding();
//   void addInitializeProc(void(*)());
//   void execInitializeProcs();
};
extern WSDLEX WSClocaleSet*  WSGIappLocaleSet();
extern void WSGFsetDefaultEncoding(long);
#endif
