//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, 
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF 
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE 
// SOFTWARE. 
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from  
// Toshikaz Hirabayashi.

#ifndef WSCBALLOONHELP_H
#define WSCBALLOONHELP_H

#include <WScom.h>
#include <WSCwindow.h>

class WSCvlabel;

#define WSCballoonHelp_VER  1000

class WSCballoonHelp :public WSCwindow{

  protected:
    WSClistData _client_list;
    WSCvlabel* _bh_label;
    char* _bh_label_string;
    unsigned _font:4;

    WSMFpropertyDef(WSNfont, WSCuchar, _font); 
    WSMFpropertyDef(WSNlabelString, char*, _bh_label_string); 

    virtual long _adjust();
    virtual long _device_initialize();

    static void _balloon_help_popup(WSCbase*);
    static void _balloon_help_popdown(WSCbase*);
    static void _balloon_help_unregister(WSCbase*);

  public:
    WSCballoonHelp(WSCbase*,char*);
    virtual ~WSCballoonHelp();
    virtual long initialize();

    void popup(char*,short x,short y);
    void popdown();
    void setString(char*);
    long registerClient(WSCbase*,char*);
    long unregisterClient(WSCbase*);

    WSMFguiClassDef(WSCballoonHelp,WSCwindow);
    WSMFversionDef(WSCballoonHelp);
};

extern WSDLEX WSCballoonHelp* WSGIappBalloonHelp();
#endif //WSCBALLOONHELP_H
