<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: subscribe.php5,v 1.24 2005/06/05 16:31:58 mdruilhe Exp $
 *	Usage:		subscribe a user to one or more forums (allowing him to receive emails)
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

# User must have read access in order to subscribe to the mailing list
# --------------------------------------------------------------------
	$bn_action_mode="R";	
	$bn_action="subscribe";
	require ("init.inc");

# A site must be selected in order to subscribe
# ---------------------------------------------
	if ($site == "agora") {
		header ("Location: $main_page");
		exit;
	}

# Check if the user is authenticated in this site otherwise redirect him to the login form
# ----------------------------------------------------------------------------------------
	if (!$is_authenticated) {
		$loginURL = $auth->getLoginURL();
		if (is_string($loginURL)) {
			header("Location: $loginURL");
		} else {
			if (!empty($before_access)) include $before_access;
			display_header (LABEL_MUST_LOGIN, $header_footer);
			$auth->login($site);
			display_footer ($header_footer);
		}
		exit;
	}

	$userid = $auth->userid;
	$useraddress = $auth->user["useraddress"];

function checkForumMailSubscription ($forum) {
	global $cfg_dir,$ext;

	$forum=trim(basename($forum));
	$cfg_file = "${cfg_dir}/${forum}.${ext}";
	if (file_exists ("$cfg_file")) {
		include ("$cfg_file");
		if ($bn_user_mail == 1) {
			return true;
		} else {
			return false;
		}
	} else {
		return false;
	}
}

	// set the forums which the user can subscribe to
	$forumslist=$db->getForums($site);
	if (is_array($forumslist)) {
		foreach ($forumslist as $_bn=>$_forum_name) {
			$_forum=$db->getForum ($site, $_bn);
			if (checkForumMailSubscription($_bn)) {
				if ($_forum["type"]=="priv") {
					$privs = $db->getPrivs($site, $_bn, $userid);
					if (!$is_moderator && (!is_array($privs) || ($privs['readpriv']==0) || ($privs['state']!=1))) {
						unset ($forumslist[$_bn]);
					}
				}
			} else {
				unset ($forumslist[$_bn]);
			}
		}
	}

# Execute before_access program and display header
# ------------------------------------------------
	if (!empty($before_access)) include $before_access;

	display_header (TITLE_SUBSCRIBE_FORUM, $header_footer);

# Individual thread unsubscription
# --------------------------------
$action = getFormVar('action');
if ($action == 'unsub') {
	$f =  getFormVar('f');
	$t =  getFormVar('t');
	if (!empty($f) && !empty($t)) {
		$db->unSubscribeUser ($site, $f, $useraddress, $t);
		msgWarning (MSG_CONFIRM_FORUMS_SUBSCRIPTIONS);
		}
	}

# If Subscription form have been submitted
# ----------------------------------------
if (isset($_POST['go'])) {

	$go=0;

	# A forum must be selected in order to subscribe
	# ---------------------------------------------
	if (empty($bn) && !is_array($subscribeforums)) { //one can subscribe to several forums within a forum
		msgForm (ERROR_NO_FORUM_SPECIFIED, "$main_page", "");
		display_footer ($header_footer);
		exit;
	}
	
	// case of subscribe to multiple forums
	if (is_array($subscribeforums)) {
		foreach($forumslist as $_bn=>$_subscribe_bn) {
			if (isset($subscribeforums[$_bn])) {
				$db->subscribeUser ($site, $_bn, $useraddress, 0);
				if (!$bn_no_stats) {
					$db->addLogEntry ($_bn, 'subscribe', $auth->userid);
				}
			} else {
				$db->unSubscribeUser ($site, $_bn, $useraddress, 0);
				if (!$bn_no_stats) {
					$db->addLogEntry ($_bn, 'unsubscribe', $auth->userid);
				}
			}
		}

		msgForm (MSG_CONFIRM_FORUMS_SUBSCRIPTIONS, $main_page);

	// classical subscription
	} else {
		if ($subscribe == 1) {
			$db->subscribeUser ($site, $bn, $useraddress, 0);
			msgForm (MSG_CONFIRM_SUB_FORUM, $main_page);
		} else {
			$db->unSubscribeUser ($site, $bn, $useraddress, 0);
			msgForm (MSG_CONFIRM_UNSUB_FORUM, $main_page);
		}
		
		if (!$bn_no_stats) {
			$action = ($subscribe == 1) ? 'subscribe' : 'unsubscribe';
			$db->addLogEntry ($bn, $action, $auth->userid);
		}
	}

	display_footer ($header_footer);

} // End $go

# Get the list of forums the user has subscribed to
# -------------------------------------------------
	$subscribe_forums_list = "<input type=\"hidden\" name=\"subscribeforums[]\" value=\"\" />";
	$subscribe_forums_list .= "<table>";
	
	if (!empty($forumslist)) {
		$subscribe_forums_list .= "<th>".CAPTION_FORUM_SUBSCRIPTIONS_LIST."</th>";
		foreach($forumslist as $_bn=>$_title) {
			$checked = $db->checkSubscribedUser ($site, $_bn, $useraddress);
			$subscribe_forums_list .= sprintf("<tr><td>%s</td></tr>", getCheckBox('subscribeforums['.$_bn.']', '1', $checked, $_title));
		}
	} else {
		$subscribe_forums_list .= ERROR_NO_SUBSCRIBE_FORUM;
	}

	$subscribe_forums_list .= "</table>";


# Get the list of threads subscriptions (all forums)
# --------------------------------------------------
	$subscribe_threads_list = "";
	$subscriptions = $db->getSubscriptions ($site, $useraddress, true);
	if (!empty($subscriptions)) {
		$subscribe_threads_list .= "<table>";
		$subscribe_threads_list .= "<tr><th colspan=\"2\">".CAPTION_THREAD_SUBSCRIPTIONS_LIST."</th></tr>";
		foreach($subscriptions as $_bn => $_threads) {
			if ( is_array($_threads) && (count($_threads)>0) ) {		
				$subscribe_threads_list .= '<tr><th colspan=\"2\">'.$forums[$_bn].'</th></tr>';
				foreach($_threads as $_thread => $_topic) {
					if (!empty($_thread) ) {
						$view_url = anchor("view.$ext?bn=$_bn&key=$_thread", '', $_topic);
						$unsub_url = anchor("$wa_self?action=unsub&f=$_bn&t=$_thread", '', "<img src=\"$icon_dir/unsubscribe.gif\" width=\"15\" height=\"15\" border=\"0\" alt=\"".ALT_UNSUBSCRIBE_THREAD."\">", ALT_UNSUBSCRIBE_THREAD);
						$subscribe_threads_list .= "<tr><td>$view_url</td><td>$unsub_url</td></tr>";
					}
				}
			}
		}
		$subscribe_threads_list .= "</table>";
	}

# Display the form
# ----------------
	$form_title = TITLE_SUBSCRIBE_FORUM;
	$subscribe_query = $form_title;	// backward compatibility
	$subscribe_radio = $subscribe_forums_list;	// backward compatibility
	$unsubscribe_radio = "";	// backward compatibility

	$submit_button = getSubmitButton ('submit', BUTTON_SUBSCRIBE);

	$label_useraddress = LABEL_ENTER_EMAIL;
	if ($is_moderator) {
		$input_useraddress = getTextField ('useraddress', $useraddress);
	} else {
		$input_useraddress = $useraddress;
	}

	beginForm();
	hiddenField("go", "go");

	if (!empty($bn_subscribe_form) && file_exists("${bn_dir}/${bn_subscribe_form}") ) {
		include "${bn_dir}/${bn_subscribe_form}";
	} elseif ( file_exists("${bn_dir_default}/subscribe_form.$ext") ) {
		include "${bn_dir_default}/subscribe_form.$ext";
	} else {
		include "templates/default/agora/subscribe_form.$ext";
	}
	endForm();
	display_footer ($header_footer);
?>