<?php 

$agora_dir = "..";
chdir($agora_dir);

include ("init_admin.inc");
include ("stats/find_stats.inc");

/**
 * Build and display a bar graph with the specified parameters.
 */
function wa_bar_graph($data,$width = 300,$height = 200,$title = "",$subtitle = "",$xtitle = "",$ytitle = "")
{
    global $ext;

	include ("stats/jpgraph/jpgraph.$ext"); 
	include ("stats/jpgraph/jpgraph_bar.$ext"); 

//*** Extract legends if any
	if (is_array($data["wa_legend"])) {
		ksort($data["wa_legend"]);
		$i = 1;
		reset($data["wa_legend"]);
		while (list($k,$leg) = each($data["wa_legend"])) {
		    $legend[$i] = $leg;
			$i++;
		} 
		unset($data["wa_legend"]);
	}

//*** Extract plots colors if any
	if (is_array($data["wa_colors"])) {
		ksort($data["wa_colors"]);
		$i = 1;
		reset($data["wa_colors"]);
		while (list($k,$col) = each($data["wa_colors"])) {
		    $colors[$i] = $col;
			$i++;
		} 
		unset($data["wa_colors"]);
	}
	
//*** Set databars ***
	$abs = 0;
	reset($data);
	while (list($k,$tab) = each($data)) {
		$databarx[$abs] = $k;
		$i = 1;
		ksort($tab);
		reset($tab);
		while (list($kk,$val) = each($tab)) {
			$databary[$i][$abs] = $val;
			$i++;
		}
		$abs++;
	}
	$nb_databarx = count($databarx);
	$nb_databary = count($databary);

//*** New graph ***
	$graph = new Graph($width,$height); 
	
//*** Set shadow ***
	$graph->SetShadow(true,5,array(96,96,96));

//*** Set Plot Area design
	//--- background color
	$graph->SetColor(array(221,221,221));
	//--- background image ---
	//$graph->SetBackgroundImage("logo.jpg");
	//--- border ---
	$graph->SetBox(true,array(0,0,0),1);

//*** Set border around graph ***
	$graph->SetFrame(true,array(0,0,150),2);
	
//*** Set scales ***
	$graph->SetScale("textint"); 
	//--- Density ---
	if (($width / $nb_databarx) < 15) {
	    $graph->xaxis->SetTextTickInterval(5);
	}
		
	//--- Titles ---
	if (!empty($xtitle)) {
	    $graph->xaxis->title->SetFont(FF_FONT1,FS_BOLD);
		$graph->xaxis->title->Set($xtitle);		
	}
	if (!empty($ytitle)) {
	    $graph->yaxis->title->SetFont(FF_FONT1,FS_BOLD);
		$graph->yaxis->title->Set($ytitle);
	}
	//--- Colors ---
	$graph->xaxis->SetColor("#000000");
	$graph->yaxis->SetColor("#000000");
	
//*** Set title and subtitle ***
	if (!empty($title)) {
	    $graph->title->SetFont(FF_FONT1,FS_BOLD);
		$graph->title->Set($title);
	}
	if (!empty($subtitle)) {
	    $graph->subtitle->SetFont(FF_FONT1,FS_ITALIC);
		$graph->subtitle->Set($subtitle);
	}
	
//*** Specify X-labels ***
	$graph->xaxis->SetTickLabels($databarx); 

//*** Define Margins
	$graph->img->SetMargin(50,20,50,30);
	$graph->SetMarginColor(array(221,221,221));

//*** Set legend position
	if (is_array($legend)) {
	   $graph->legend->Pos(0.02,0.02,"left","top"); 
	   $graph->legend->SetLayout(LEGEND_HOR);
	}

//*** Create the bar plots ***	
	$i = 0;
	while ($i < $nb_databary) {
	    $plot[$i] = new BarPlot($databary[$i + 1]); 
		//--- Legend ---
		if (!empty($legend[$i + 1])) {
		   $plot[$i]->SetLegend($legend[$i + 1]);	 
		}	
		//--- Color ---
		$plot[$i]->SetColor("#000000");
		if (!empty($colors[$i + 1])) {
		    $fill_color = $colors[$i + 1];
		}else	{
			$i_color = $i % 4;
			switch ($i_color) {
				case 1:	$fill_color = "#999999";break;
				case 2:	$fill_color = "#e0eaf6";break;
				case 3:	$fill_color = "#ffffff";break;
				case 0:	$fill_color = "#d0dae6";break;		        
			}
		}
		$plot[$i]->SetFillColor($fill_color);
		$plot[$i]->SetFillGradient($fill_color,"#ffffff",GRAD_VER);
		//--- Width (relative or absolute) ---
		$plot[$i]->SetWidth(0.2); 	
		//--- Show value on the top of the bar !!!!!!
		/* $plot[$i]->value->SetFormat("%2d");
		$plot[$i]->value->Show();*/
		$i++;
	}
//*** Group and add the bar plots ***
	$gplot = new GroupBarPlot($plot);
	$gplot->SetWidth(0.9);
	$graph->Add($gplot);
	 
//*** Finally output the  image ***
	$graph->Stroke(); 
} 


/**********************************
		For example
$data["wa_legend"][1] = "Leg 1";
$data["wa_colors"][1] = "#000000";
$data[abs][num_bar] = 15;
$data[2][1] = 25; 
*********************************/


switch ($graph) {
	
	case "yearstats":
		/*$title = "";
		$subtitle = "";*/
		/*$xtitle = "Mois";
		$ytitle = "#";*/
		$to_find["hits"] = $hits;
		$to_find["posts"] = $posts;
		$to_find["logins"] = $logins;
		$to_find["subscribes"] = $subscribes;
		$to_find["visits"] = $visits;
		$stats = siteMonthStats($site,$to_find);
		ksort($stats);
		reset($stats);
		while (list($line_num,$tab) = each($stats)) {
		    $month = date("M",$tab["date"]);
			unset($tab["date"]);
			while (list($num_bar,$val) = each($tab)) {
			    $data[$month][$num_bar] = $val;
			}
		}
		if (!empty($to_find["hits"])) {
		    $data["wa_legend"][BAR_NUM_HITS] = COLUMN_HITS;
			$data["wa_colors"][BAR_NUM_HITS] = "#ffccff";
		}
		if (!empty($to_find["posts"])) {
		    $data["wa_legend"][BAR_NUM_POSTS] = LABEL_POSTS;
			$data["wa_colors"][BAR_NUM_POSTS] = "#ffffcc";
		}
		if (!empty($to_find["logins"])) {
		    $data["wa_legend"][BAR_NUM_LOGINS] = LABEL_LOGINS;
			$data["wa_colors"][BAR_NUM_LOGINS] = "#ccffcc";
		}
		if (!empty($to_find["subscribes"])) {
		    $data["wa_legend"][BAR_NUM_SUBSCRIBES] = LABEL_SUBSCRIBES;
			$data["wa_colors"][BAR_NUM_SUBSCRIBES] = "#66ff66";
		}
		if (!empty($to_find["visits"])) {
		    $data["wa_legend"][BAR_NUM_VISITS] = LABEL_VISITS;
			$data["wa_colors"][BAR_NUM_VISITS] = "#99ffcc";
		}	
		break;

	case "monthstats":
		$month_name = date("M. Y",strtotime("$month/1/$year"));
		/*$title = "Activit journaliere du site $site";
		$subtitle = "pour le mois $month_name";
		$xtitle = "Jour";
		$ytitle = "#";*/
		$to_find["hits"] = $hits;
		$to_find["posts"] = $posts;
		$to_find["logins"] = $logins;
		$to_find["subscribes"] = $subscribes;
		$to_find["visits"] = $visits;
		$stats = monthDailyStats($site,$month,$year,$to_find);
		ksort($stats);
		reset($stats);
		while (list($day,$tab) = each($stats)) {
		    $day = sprintf("%02d",$day);
			while (list($num_bar,$val) = each($tab)) {
			    $data[$day][$num_bar] = $val;
			}
		}
		if (!empty($to_find["hits"])) {
		    $data["wa_legend"][BAR_NUM_HITS] = COLUMN_HITS;
			$data["wa_colors"][BAR_NUM_HITS] = "#ffccff";
		}
		if (!empty($to_find["posts"])) {
		    $data["wa_legend"][BAR_NUM_POSTS] = LABEL_POSTS;
			$data["wa_colors"][BAR_NUM_POSTS] = "#ffffcc";
		}
		if (!empty($to_find["logins"])) {
		    $data["wa_legend"][BAR_NUM_LOGINS] = LABEL_LOGINS;
			$data["wa_colors"][BAR_NUM_LOGINS] = "#ccffcc";
		}
		if (!empty($to_find["subscribes"])) {
		    $data["wa_legend"][BAR_NUM_SUBSCRIBES] = LABEL_SUBSCRIBES;
			$data["wa_colors"][BAR_NUM_SUBSCRIBES] = "#66ff66";
		}
		if (!empty($to_find["visits"])) {
		    $data["wa_legend"][BAR_NUM_VISITS] = LABEL_VISITS;
			$data["wa_colors"][BAR_NUM_VISITS] = "#99ffcc";
		}	
		break;
}
$db->closeDB();

wa_bar_graph($data,$width,$height,$title,$subtitle,$xtitle,$ytitle);

?>
