<?PHP

/*
 * W-AGORA 4.1
 * -----------
 * $Id: admin_da.inc,v 1.37 2005/02/09 15:20:04 mdruilhe Exp $
 * Usage: Administration localized strings constant
 * Description: This script is used to define strings used by the administration part of the application
 * Author: Alexandre GHEZ (aghez@decan.fr)
 * Translator: Henning Schou (hs@tag-gym.dk)
 */

 ///////////////////
 // file setup.php3
 ///////////////////
 define ('ERROR_SETUP_ALREADY_DONE', 'w-Agora ser allerede ud til vre installeret,<br> konfigurationsfilen (<tt>%s</tt>) eksisterer allerede,<br> slet den (og DB tabeller) manuelt for at geninstallere.<br><br>tryk p knappen for at oprette et nyt omr&aring;de');
 define ('ERROR_MISSING_ADMIN_NAME', 'Der skal angives et navn for system administratoren');
 define ('ERROR_MISSING_ADMIN_EMAIL', 'Der skal angives en gyldig email addresse');
 define ('ERROR_MISSING_DB_ACCESS', 'Der skal angives en DB access mode');
 define ('ERROR_BAD_PASSWORD', 'password skal angives (to gange), bekr&aelig;ft venligst');
 define ('ERROR_MISSING_DB_NAME', 'Der skal angives et navn p&aring; databasen');
 define ('ERROR_SF_CREATE_FILE', 'Kunne ikke oprette en fil i mappen <u>%s</u>, kontroller rettigheder, eller l&aelig;s safe mode instruktionerne i <a href="doc/INSTALL.txt">INSTALL.txt filen</a>');
 define ('ERROR_COPY_FILE', 'kunne ikke kopiere filen til <u>%s</u>');
 define ('ERROR_OPEN_DB', 'Ingen forbindelse til databasen <u>%s</u> (host: <u>%s</u>, port: <u>%s</u>, user: <u>%s</u>)');
 define ('ERROR_CREATE_CONFIG_FILE', 'Kan ikke oprette konfigurationsfilen <u>%s</u>, kontroller rettigheder');
 define ('LABEL_SETUP_DONE', 'w-agora installationen lykkedes');
 define ('LABEL_SETUP_AGORA', 'w-agora installation');

 define ('CAPTION_DB_PARAMETERS', 'Database parametre (for omr&aring;de tabeller)');
 define ('CAPTION_DEFAULT_PARAMETERS', 'Standard parametre for konfigurering af omr&aring;de');
 define ('CAPTION_ADMIN_INFO', 'System Administrators Informationer (login : <u>admin</u>)');

 define ('LABEL_ADMIN_NAME', 'Navn');
 define ('LABEL_ADMIN_ADDRESS', 'e-mail');
 define ('LABEL_ADMIN_PASSWORD1', 'V&aelig;lg et password');
 define ('LABEL_ADMIN_PASSWORD2', 'Gentag venligst password');
 define ('BUTTON_INSTALL', 'Installer');

 /////////////////////
 //File Init_Admin.inc
 /////////////////////

 // function display_header
 define ('ADMINISTRATION_TITLE', "W-Agora administration");

 // function list_forums
 define ('COLUMN_FORUM_ADMIN', "Admin forum");
 define ('COLUMN_EDIT', "Rediger");
 define ('COLUMN_DELETE', "Slet");
 define ('COLUMN_CREATE', "Opret");
 define ('COLUMN_ORDER', "R&aelig;kkef&oslash;lge");

 define ('MSG_ADMINISTRATE_FORUM', "Administrer forum");
 define ('ALT_DELETE_FORUM', "Slet forum : %s");
 define ('ALT_EDIT_FORUM', "Rediger forum : %s");

 define ('ERROR_SITE_EMPTY', "Et omr&aring;de skal specificeres.");
 define ('ERROR_NO_CONFIG_FILE', "Kan ikke &aring;bne konfigurationsfilen: ");
 define ('ERROR_NO_ROOT', "Du skal v&aelig;re logget ind som system administrator for at f&aring; adgang til dette.");
 define ('ERROR_NO_ADMIN', "Du skal v&aelig;re logget ind som administrator for at f&aring; adgang til dette.");
 define ('ERROR_NO_MODERATOR', "Du har ikke moderator-rettigheder i dette forum, log venligst ind igen.");

 define ('TITLE_ADMINISTRATION_LOGIN', "Administratorlogin");
 define ('TITLE_INVALID_LOGIN', "Ugyldigt login, log venligst ind igen");

 define ('ERROR_NO_DATABASE', "Ingen forbindelse til databasen, kontroller venligst parametrene.");

 //Function List User
 define ('COLUMN_USER_ID', "Id");
 define ('COLUMN_USER_NAME', "Navn");
 define ('COLUMN_USER_PRIVILEGE', "Rettigheder");
 define ('COLUMN_USER_REGISTERED', "Registreret");
 define ('COLUMN_USER_LOGIN_COUNT', "# Logins");
 define ('COLUMN_USER_LAST_LOGIN', "Sidste login");
 define ('COLUMN_USER_POST_COUNT', "# Meddelelser");
 define ('COLUMN_USER_LAST_POST', "Seneste meddelelse");
 define ('COLUMN_ACTION', "<trans>Action");

define ('LABEL_REG_NO_CONTROL',"Automatic registration");
define ('LABEL_REG_CHALLENGE_RESPONSE',"RFU");	
define ('LABEL_REG_ADMIN_APPROVAL',"Approved by administrators");

 /////////////////////
 //File Create_Site.php3
 /////////////////////
 define ('FORM_NO_SITE', "Omr&aring;denavn skal angives.");
 define ('FORM_NO_DESCRIPTION', "Giv venligst en kort beskrivelse af dette omr&aringde.");
 define ('FORM_NO_DBACCESS', "Adgangs modus skal angives.");
 define ('FORM_NO_DBNAME', "Databasens navn skal angives.");
 define ('FORM_NO_DIRECTORY', "Der skal angives et mappenavn for dette forum.");
 define ('FORM_SITE_LONG', "Omr&aring;denavnet er for langt, v&aelig;lg et kortere.");

 define ('CHECK_SITE_EXISTS', "Omr&aring;det {SITE} findes allerede. Slet det eksisterende omr&aring;de manuelt eller v&aelig;lg et andet navn.");
 define ('CHECK_CONFIG_EXISTS', "Konfigurationsfilen (<tt>%s</tt>) findes allerede. Slet den eksisterende fil manuelt eller v&aelig;lg et andet navn.");

 define ('ERROR_SAFE_MODE', 'SAFE MODE er aktiv, du skal muligvis selv oprette mappen: {DIRECTORY}');
 define ('ERROR_CREATE_DIR', "Kan ikke oprette mappen: {DIRECTORY}.");
 define ('ERROR_NO_PERMISSIONS', "Check rettigheder");

 define ('ERROR_ADMIN_NOT_FOUND', "Kunne ikke skaffe brugeren 'admin' fra agoras hoved-omr&aring;de");

 define ('ERROR_DB_DBM_EXISTS', "Forums database {SITE} findes allerede,<br> slet DBM filen: <em>dbm/{SITE}/{DATABASE}</em><br> [og lock-filen .lck] manuelt.");
 define ('ERROR_DB_EXISTS', "Dette forums tabel {SITE} findes allerede i databasen {DATABASE}. Drop (slet) denne tabel manuelt.");
 define ('ERROR_FILESYSTEM', "Adgangsproblem, check plads og rettigheder i filsystemet.");
 define ('ERROR_DB_ACCESS', "Adgangsproblem; kontroller, at databasen {DATABASE} er oprettet, og check adgangsrettigheder");

 define ('ERROR_CREATE_SITE', "Kunne ikke oprette omr&aring;det: {SITE}.");

 define ('ERROR_TABLE_EXISTS', "Tabellen {TABLE} findes allerede i databasen {DATABASE}. Drop (slet) denne tabel manuelt.");

 define ('ERROR_CREATE_ADMIN', "Kunne ikke oprette brugeren {USER} i det nye omr&aring;de.");
 define ('ERROR_CREATE_USER', "Kunne ikke oprette brugeren {USER} i tabellen {TABLE}.");
 define ('ERROR_NO_ADD_SITE', "Kunne ikke tilf&oslash;je omr&aring;det i hoveddatabasen.");

 define ('LABEL_BACK', "Tilbage");
 define ('LABEL_CREATE_SITE_DONE', "Omr&aring;det {SITE} er oprettet<BR><BR>&nbsp;&nbsp;Du kan nu");
 define ('LABEL_CREATE_FORUM', "Opret et forum");
 define ('LABEL_CREATE_SITE', "Opret omr&aring;de");
 define ('LABEL_CREATE_THIS_SITE', "Opret dette omr&aring;de");
 define ('LABEL_CREATE_NEW_SITE', "Opret et nyt omr&aring;de");
 define ('LABEL_CREATE_ANOTHER_SITE', "Opret et andet omr&aring;de");
 define ('LABEL_ADMINISTRATE_SITE', "Administrer dette omr&aring;de");
 define ('LABEL_SITE_MANAGEMENT', "Omr&aring;de management");
 define ('CREATE_SITE_DONE', "Omr&aring;det {SITE} er oprettet.");

 define ('LABEL_SITE_NAME', "Omr&aring;de navn");
 define ('LABEL_SITE_TITLE', "Titel (kort beskrivelse)");
 define ('LABEL_SITE_DESCRIPTION', "Beskrivelse");
 define ('LABEL_DB_PARAMETERS', "Database parametre");
 define ('LABEL_DB_TYPE', "Database type");
 define ('LABEL_DB_NAME', "Database navn");

 define ('LABEL_DB_USER', "Database bruger");
 define ('LABEL_DB_PASSWORD', "Database password");

 define ('LABEL_DB_ADMIN_USER', "Database admin bruger (hvis tom: anvend DB bruger)");
 define ('LABEL_DB_ADMIN_PASSWORD', "Database admin password");
 define ('LABEL_DB_SERVER_NAME', "Server navn");
 define ('LABEL_DB_SERVER_PORT', "Server port");
 define ('LABEL_DB_USER_SOURCE', "Validering");

 define ('LABEL_FORUMS_CONFIGURATION', "Forum-ops&aelig;tning");

 define ('LABEL_FORUM_DIRECTORY', "Forum mappe");
 define ('LABEL_SEARCH_ENGINE', "S&oslash;gemaskine");
 define ('LABEL_DEFAULT_THEME', "Standard skabelon");
 define ('NOTICE_SAFEMODE', "SAFE MODE aktiv.");
 define ('NOTICE_MANUAL_INSTALL', 'du skal muligvis oprette de f&oslash;lgende mapper manuelt:');

 /////////////////////
 //File Admin.php3
 /////////////////////
 define ('TITLE_SITE_MANAGEMENT', "Omr&aring;deadministration");
 define ('LABEL_SITES_OUTLINE', "Udseende");
 define ('COLUMN_SITE_TITLE', "Emne (titel):");

 define ('ALT_DELETE_SITE', "Slet omr&aring;de : %s");
 define ('ALT_EDIT_SITE', "Rediger omr&aring;de : %s");
 define ('ERROR_NO_SITE', "Ingen tilg&aelig;ngelige omr&aring;der,<br> klik p&aring; 'OK' for at oprette et nyt.");

 /////////////////////
 //File Delete_Site.php3
 /////////////////////
 define ('TITLE_SITE_DELETE', "Slet omr&aring;de");
 define ('ERROR_NO_DELETE', "Advarsel: Kunne ikke slette alle tabeller/filer i {SITE}");
 define ('ERROR_NO_DELETE_AGORA', "kunne ikke slette omr&aring;det {SITE} i agora databasen");
 define ('LABEL_FILE_REMOVING', "Sletter fil: ");
 define ('LABEL_DIRECTORY_REMOVING', "Sletter mappe: ");
 define ('LABEL_SITE_REMOVING', "Omr&aring;det {SITE} er slettet.");
 define ('LABEL_SITE_CONTENT', "Dette omr&aring;de rummer de flgende fora:");
 define ('LABEL_SITE_NO_CONTENT', "Dette omr&aring;de rummer ingen forum");
 define ('LABEL_SITE_DELETE_CONFIRMATION', "Er du sikker p&aring;, at du vil slette omr&aring;det '{SITE}' ?");
 define ('LABEL_DELETE_THIS_SITE', "Slet dette omr&aring;de");

 /////////////////////
 //File Edit_Site.php3
 /////////////////////
 define ('TITLE_SITE_EDIT', "Rediger omr&aring;de");
 define ('ERROR_NO_READ_SITE_PROPERTIES', "Kunne ikke &aring;bne {SITE} beskrivelsen.");
 define ('ERROR_NO_UPDATE_SITE_PROPERTIES', "Kunne ikke opdatere karaktaristika for omr&aring;der {SITE}.");
 define ('LABEL_SITE_EDITING', "Redigerer omr&aring;det: ");
 define ('LABEL_SITE_PROPERTIES', "omr&aring;deoplysninger");
 define ('LABEL_CHANGE_SITE_ADMINISTRATOR', "V&aelig;lg/skift den bruger, som skal v&aelig;re hovedadministrator for dette omr&aring;de");
 define ('COLUMN_SITE_REGISTRATION_MODE',"Registration mode");
 define ('COLUMN_SITE_PASSWORD_HANDLING',"Password handling");

 /////////////////////
 //File editList.php3
 /////////////////////
 define ('NOTICE_DEFAULT_FILE', "Advarsel: Denne fil er en standard fil for denne installation");
 define ('ERROR_NO_CURRENT_FILE', "Ingen aktuelk fil");
 define ('ERROR_OPEN_FILE', "Kunne ikke &aring;bne {FILE}");

 define ('LABEL_MAXTHREADS', "Maximalt antal tr&aring;de pr. side");
 define ('LABEL_PAD', "Fyld til brug for indrykning");
 define ('LABEL_DEPTH_LIMIT', "Gr&aelig;nse for tr&aring;d-niveauer");
 define ('LABEL_BEFORE_LINE', "Script udf&oslash;rt for hver linje");
 define ('LABEL_SORT', "Standard r&aelig;kkef&oslash;lge");
 define ('LABEL_HOT_COLOR', "For nyeste meddelelser, s&aelig;t {date_color} til: " );
 define ('LABEL_NEW_COLOR', "For aktuelle meddelelser, s&aelig;t {date_color} til: " );
 define ('LABEL_NORMAL_COLOR', "For &aelig;ldre meddelelser, s&aelig;t {date_color} til: " );
 define ('LABEL_HOT_AGE', "Antal sekunder for nyeste meddelelser" );
 define ('LABEL_NEW_AGE', "Antal sekunder for aktuelle meddelelser" );
 define ('LABEL_HOT_THRESHOLD', "Hot Emne -t&aelig;rskel (Mere end xx meddelelser, 0 = ej i brug)");
 define ('LABEL_TYPE_FILENAME', "Indtast filnavn");
 define ('TITLE_SITE_OUTLINE', "Rediger udseende af omr&aring;de-liste");
 define ('TITLE_FORUM_OUTLINE', "Rediger udseende af forum-liste");
 define ('TITLE_MESSAGE_OUTLINE', "Rediger udseende af meddelelses-liste");
 define ('LABEL_FILE_EDITING', "Redigerer fil ");
 define ('LABEL_THREAD_FIRSTLINE_ODD', "F&oslash;rste linje i TR&Aring;D (ulige)");
 define ('LABEL_THREAD_FIRSTLINE_EVEN', "F&oslash;rste linje i TR&Aring;D (lige)");
 define ('LABEL_LEVEL_START', "Start nyt NIVEAU med");
 define ('LABEL_LEVEL_END', "Afslut niveau med");
 define ('LABEL_LINE_CONTENT_ODD', "Svarlinje indhold (ulige)");
 define ('LABEL_LINE_CONTENT_EVEN', "Svarlinje indhold (lige)");
 define ('LABEL_THREAD_END', "Afslut tr&aring;d med");
 define ('LABEL_LIST_END', "Afslutning p&aring; liste");

 define ('LABEL_GLOBAL_FORMAT', "Globale listeformater");
 define ('LABEL_DEFAULT_ORDER', "Standard r&aelig;kkef&oslash;lge (i u-tr&aring;det tilstand)");
 define ('LABEL_USE_COLOR', "Brug farve");
 define ('LABEL_NEWEST_MESSAGE', "Nyeste meddelelser");
 define ('LABEL_NEW_MESSAGE', "Ny meddelelse");
 define ('LABEL_OLD_MESSAGE', "Gammel meddelelse");
 define ('LABEL_MESSAGES_NEWER_THAN', "for meddelelser nyere end");
 define ('LABEL_FORUM_OUTLINE', "Udseende af forum-liste");
 define ('LABEL_HEAD_LISTING', "Listehoved");
 define ('LABEL_CATEGORY_LINE', "Kategori linje");

 define ('LABEL_SITE_LINE_ODD', "Omr&aring;de linje (ulige)");
 define ('LABEL_SITE_LINE_EVEN', "Omr&aring;de linje (lige)");

 define ('LABEL_FORUM_LINE_ODD', "Forum linje (ulige)");
 define ('LABEL_FORUM_LINE_EVEN', "Forum linje (lige)");
 define ('LABEL_BOTTOM_LISTING', "Slut p&aring; liste:");

 define ('EDIT_THREAD_LIST', "Rediger tr&aring;denes hovedlisteside (LIST mode): ");
 define ('LABEL_EDIT_SEARCH_LISTING ', "Rediger S&Oslash;GE listning resultatside: ");
 define ('LABEL_SEARCH_FORM_TITLE', "Forum titel (multi-forum s&oslash;gning):");

 define ('EDIT_THREAD_VIEW', "Rediger tr&aring;denes listning vist under meddelelse (VIEW mode): ");
 define ('LABEL_FIRST_THREAD', "F&oslash;rste meddelelse i tr&aring;den");
 define ('EDIT_THREAD_DOWNLOAD', "Rediger liste- (tr&aring;d-) format i <B>DOWNLOAD</B> mode:");

 /////////////////////
 //File admin_site.php3
 /////////////////////
 define ('LABEL_AGORA_WEBSITE', 'W-Agora Web Site');
 define ('TITLE_SITE_ADMINISTRATION', 'Administration af omr&aring;de');
 define ('LABEL_RELOGIN', 'Gen-login (ny bruger)');
 define ('LABEL_SITES', 'Omr&aring;deliste');
 define ('LABEL_ADMINISTRATION_MAIN', 'Tilbage til hovedadministrationssiden');
 define ('ALT_STATS', 'Vis statistik for omr&aring;det %s');
 define ('LABEL_ACCESS_THIS_SITE', 'G&aring; til dette omr&aring;de');
 define ('ALT_ACCESS_SITE', 'G&aring; til omr&aring;det %s som bruger');

 define ('LABEL_CATEGORIES', "Kategorier");
 define ('COLUMN_ADMIN_USERS', "<trans>Admin users");
 define ('COLUMN_INACTIVE_USERS', "Passive brugere");
 define ('COLUMN_MAIL_USERS', "Mail brugere");

 define ('ALT_USER_EDIT', "Rediger bruger");
 define ('ALT_USER_ADMIN', "<trans>Manage registered users");
 define ('ALT_USER_ADD', "Tilf&oslash;j bruger");
 define ('ALT_USER_DELETE', "Slet bruger");
 define ('ALT_INACTIVE_USERS', "Slet passive brugere");
 define ('ALT_MAIL_USERS', "Mail brugere");
 define ('ALT_CATEGORY_CREATE', "Tilf&oslash;j kategori");
 define ('ALT_CATEGORY_EDIT', "Rediger kategori");

 define ('COLUMN_MANAGE_FORUM', "Administrer fora");
 define ('COLUMN_CHANGE_ORDER', "Skift r&aelig;kkef&oslash;lge");

 define ('ALT_FORUM_MANAGE', "Administrer forum");
 define ('ALT_FORUM_CREATE', "Opret forum");
 define ('ALT_FORUM_ORDER', "Vis fora i en ny r&aelig;kkef&oslash;lge");

 define ('LABEL_FORUM_LAYOUT', "Forumliste-layout");

 define ('LABEL_SITECONF', 'Konfiguration');
 define ('LABEL_STYLESHEET', 'Style sheet');
 define ('LABEL_HEADER', 'Sidetop');
 define ('LABEL_FORUM_LIST', 'Fora listning');
 define ('LABEL_FOOTER', 'Sidebund');
 define ('LABEL_MESSAGES', 'Meddelser');

 define ('ALT_SITECONF', 'Rediger generelle indstillinger i forumlisten (BODY, datoformat, ...)');
 define ('ALT_MODIFY_STYLESHEET', 'Rediger Style sheet (CSS) fil');
 define ('ALT_HEADER', 'Rediger toppen af forumlisten');
 define ('ALT_FOOTER', 'Rediger bunden af forumlisten');
 define ('ALT_FORUM_LIST', 'Rediger layoutet p forumlisten');
 define ('ALT_MESSAGES', 'Rediger tekster, meddelelser, billeder, som vises i forumlisten');

 define ('LABEL_DEFAULT_TEMPLATES', "Omr&aring;dets standardskabelon");

 define ('COLUMN_PROFILE', "Vis profil");
 define ('COLUMN_LOGIN', "Login-form");
 define ('COLUMN_REGISTER', "Registreringsform");
 define ('COLUMN_CHANGE_PASSWORD', "Skift password form");
 define ('COLUMN_FORGOT_PASSWORD', "Glemt password form");
 define ('COLUMN_MAIL', "Mail skabelon");
 define ('COLUMN_SUBSCRIBING', "Mail-abonnement form");

 define ('ALT_PROFILE_FORM', "Rediger profilskabelon");
 define ('ALT_LOGIN_FORM', "Rediger login form");
 define ('ALT_REGISTER_FORM', "Rediger registreringsform");
 define ('ALT_CHANGE_PASSWORD_FORM', "Rediger skift password form");
 define ('ALT_FORGOT_PASSWORD_FORM', "Rediger glemt password form");
 define ('ALT_MAIL_TEMPLATE', "Mail konfiguration og skabeloner");
 define ('ALT_SUBSCRIBE_FORM', "Rediger abonnement form");

 define ('LABEL_USER_TEMPLATES', "<trans>User management templates");
 define ('COLUMN_USER_FIELDS', "<trans>User fields");
 define ('ALT_USER_FIELDS', "<trans>Edit/Add user profile fields ");

 /////////////////////
 //File admin_Forum.php3
 /////////////////////
 define ('TITLE_FORUM_ADMINISTRATION', "Forum administration (Omr&aring;de: %s)");
 define ('LABEL_CHOOSE_FORUM', "V&aelig;lg det forum, du &oslash;nsker at administrere, redigere eller slette");
 define ('ERROR_NO_FORUM_ADMIN', "Ingen tilg&aelig;ngelige fora i omr&aring;det '%s',<br> klik p&aring; 'OK' for at oprette et.");
 define ('ERROR_NO_FORUM', "Der er ingen tilg&aelig;ngelige fora i omr&aring;det '{SITE}', som du er ansvarlig for.");
 define ('LABEL_FORUM_ADMINISTRATION', "Administration af forum ");
 define ('LABEL_SITE', "Omr&aring;de ");
 define ('LABEL_FORUM', "Forum");
 define ('LABEL_FORUM_ACCESS', "G&aring; til forum ");
 define ('LABEL_ACCESS_THIS_FORUM', "G&aring; til dette forum");
 define ('ALT_ADMINISTRATION_SITE', 'Tilbage til administration af omr&aring;det %s');

 define ('TITLE_NOTES_MANAGEMENT', "Indl&aelig;gsadmin.");
 define ('LABEL_EDIT_NOTES', "Administrer indl&aelig;g");
 define ('LABEL_MANAGE_THREADS', "Administrer tr&aring;de");
 define ('LABEL_POST_MSG', "Send en meddelelse");

 define ('ALT_EDIT_NOTES', "Slet/Rediger meddelelser");
 define ('ALT_MANAGE_THREADS', "Slet - Kopier - Flyt diskussioner");
 define ('ALT_POST', "Send");

 define ('LABEL_ADD_USER', "Tilf&oslash;j til dette forum");
 define ('COLUMN_SHOWEDIT', "Vis/Rediger");
 define ('ALT_USER_SHOWEDIT', "Vis/Rediger registrerede/sv&aelig;vende brugere");
 define ('ALT_USER_CREATE', "Tilf&oslash;j bruger");

 define ('LABEL_CONFIGURATION', "Konfiguration");
 define ('LABEL_BASIC', "Basal");
 define ('LABEL_ADVANCED', "Avanceret");
 define ('LABEL_PROPERTIES', "Egenskaber");

 define ('ALT_BASIC', "Rediger basale konfigurationsparametre");
 define ('ALT_ADVANCED', "Rediger avanceret konfigurationsparametre");
 define ('ALT_PROPERTIES', "Rediger forum-egenskaber");

 define ('LABEL_LAYOUT', "Layout/Skabeloner");

 define ('COLUMN_NOTES_LISTING', "Meddelelseslistning");
 define ('COLUMN_FORM', "Form");
 define ('COLUMN_MAIL_FORM',"Mail form");
 define ('COLUMN_FIELDS', "Felter");
 define ('COLUMN_TEMPLATE', "Skabelon");
 define ('COLUMN_SEARCH_FORM', "S&oslash;ge-form");
 define ('COLUMN_INCLUDED', "Includeret script");
 define ('COLUMN_PROFILE_FORM', "Profil-form");
 define ('ALT_INCLUDED', "php3 script, som includeres inden adgang");
 define ('ALT_TEMPLATE', "Rediger HTML meddelelses-skabelon");
 define ('ALT_FIELDS', "Rediger database-felter");
 define ('ALT_SEARCH_FORM', "Rediger s&oslash;ge-form");
 define ('ALT_FORM', "Rediger HTML form for Send/Rediger meddelelser");
 define ('ALT_MAIL_FORM', "Edit the form used to send private mails");
 define ('ALT_NOTES_LISTING', "Rediger meddelelses-listning");
 define ('ALT_AGORA_MESSAGES', "Rediger meddelelser, som bruges af W-Agora");

define('LABEL_MASS_EDIT_FORUMS_DONE', '<trans>mass update has been done on all forums!');
define('TITLE_MASS_EDIT_FORUMS', '<trans>Edit settings on all forums');
define('MSG_MASS_EDIT_FORUMS', '<trans>This form enables you to edit some settings on all forums at the same time');
define('LABEL_MASS_EDIT_FORUM_STATE', '<trans>Forum state');
define('LABEL_MASS_EDIT_FORUM_ACCESS', '<trans>Access mode');
define('LABEL_MASS_EDIT_FORUM_MODERATED', '<trans>Moderated forums');
define('BUTTON_UPDATE_ALL_FORUMS', '<trans>Apply changes to all forums');

 /////////////////////
 //File Moderate_Notes.php3
 /////////////////////
 define ('TITLE_MODERATE_NOTES', 'Valider indkommende meddelelser');
 define ('ERROR_NO_INCOMING', 'Ingen meddelelser afventer moderation i dette forum');
 define ('LABEL_MESSAGE_DELETE_CONFIRMATION', 'Denne meddelelse slettes. Er du sikker?');
 define ('CAPTION_VALIDATE_DELETE_MESSAGE', 'Klik p&aring; den meddelelse, som skal valideres eller slettes.');
 define ('CAPTION_MESSAGE_ACTION', 'V&aelig;lg, hvad du vil g&oslash;re ved denne meddelelse.');
 define ('LABEL_VALIDATE', 'Godkend');
 define ('LABEL_DELETE', 'Slet');

 /////////////////////
 //Admin_Notes.php33
 /////////////////////
 define ('LABEL_DELETE_FOL_NOTES', "<trans>Following notes will be deleted");
 define ('LABEL_NOTES_IN_FORUM', "<trans>Notes in forum <font color=red>%s</font>");
 define ('LABEL_NO_FORM', "<trans>No defined form for this forum");
 define ('LABEL_EDIT_NOTE', "<trans>Edit a note:");
 define ('LABEL_DISPLAY_NOTES', "<trans>Display notes");
 define ('LABEL_ALL_NOTES', "<trans>All notes");
 define ('LABEL_HIDDEN', "<trans>Hidden");
 define ('LABEL_VISIBLE', "<trans>Visible");
 define ('COLUMN_SHOW_NOTE', "<trans>Show");
 define ('COLUMN_HIDE_NOTE', "<trans>Hide");
 define ('ALT_DELETE_NOTE', "<trans>Delete this note");
 define ('ALT_EDIT_NOTE', "<trans>Edit this note");
 define ('ALT_POPUP', "<trans>Pop-up");

 define ('LABEL_COPY_FOL_NOTES', "<trans>The following notes (with ALL replies) will be copied/moved");
 define ('ACTION_MESSAGES_DELETE', "<trans>Delete selected notes");
 define ('ACTION_MESSAGES_COPY', "<trans>Copy selected notes to another thread into forum");
 define ('ACTION_MESSAGES_MOVE', "<trans>[Move notes]");
 define ('LABEL_SELECT_DEST_THREAD', "<trans>Select note to attach messages");
 define ('ERROR_COPY_NOTE', "<trans>Couldn't copy note {NOTE} into forum {FORUM}");
 define ('ERROR_DELETE_NOTE', "<trans>Couldn't delete message {NOTE} from forum {FORUM}");
 define ('ERROR_NO_DEST_FORUM', "<trans>Error: you must specify the destination forum.");
 define ('TITLE_COPY_NOTES', "<trans>Copying/moving messages");
 define ('OPEN_NEW_THREAD', "<trans>Open new thread");

 /////////////////////
 //Delete_Notes.php3
 /////////////////////
 define ('TITLE_DELETE_NOTES', "Slet en meddelelse");
 define ('CAPTION_SELECT_NOTES', "V&aelig;lg de meddelelser, som skal redigeres/slettes");
 define ('LABEL_DELETE_THIS', "Sletter");
 define ('CAPTION_SELECT_NOTES_DELETED', "V&aelig;lg de meddelelser, som skal slettes");

 /////////////////////
 //Delete_Threads.php3
 /////////////////////
 define ('ERROR_INCORRECT_DATES', "Ukorrekt datoangivelse");
 define ('ERROR_NO_PERIOD', "V&aelig;lg venligst et antal dage/uger eller m&aring;neder");
 define ('ERROR_NO_NOTES_OLDER', "Der er ikke fundet meddelelser &aelig;ldre end {NUMBER} {UNIT}.");
 define ('CONFIRM_THREAD_MOVE', "Er du sikker p&aring;, at du vil flytte tr&aring;dene til forum \"{FORUM}\" ?");
 define ('CONFIRM_THREAD_COPY', "Er du sikker p&aring;, at du vil kopiere tr&aring;dene til forum \"{FORUM}\" ?");
 define ('CONFIRM_DELETE_THREAD', '%s tr&aring;de vil blive fjernet');
 define ('CONFIRM_DELETE_THREAD_DATE', 'Er du sikker p&aring;, at du vil slette tr&aring;de mellem %s og %s');
 define ('ERROR_NO_THREAD', "Ingen tr&aring;d valgt");
 define ('LABEL_COPYING_NOTES', "kopierer meddelelser til {FORUM}...");

 define ('ERROR_PARENT_NOT_FOUND', "Kunne ikke inds&aelig;tte meddelelsen, for&aelig;lder ikke fundet");
 define ('ERROR_COPY_THREAD', "Kunne ikke kopiere tr&aring;den {THREAD} til forum {FORUM}");
 define ('ERROR_DELETE_THREAD', "Kunne ikke slette tr&aring;den {THREAD} fra forum {FORUM}");
 define ('ERROR_INSERT_ATTTACHMENT', "Kunne ikke inds&aelig;tte vedh&aelig;ftet fil '{NAME}' for meddelelsen '{CLE}' i forum '{FORUM}'");

 define ('TITLE_MANAGE_THREADS', "Slet/Kopier/Flyt tr&aring;de");
 define ('CAPTION_SELECT_THREAD', "Ingen tr&aring;d valgt");
 define ('LABEL_SELECT_THREAD', "V&aelig;lg den tr&aring;d, som skal slettes eller kopieres/flyttes til et andet forum");
 define ('LABEL_SELECT_THREAD_OR_DATE', "V&aelig;lg tr&aring;de eller et interval af tr&aring;de");
 define ('LABEL_SELECT_INDIVIDUAL_THREAD', "V&aelig;lg individuelle tr&aring;de nedenfor");
 define ('LABEL_EXECUTE', "Udf&oslash;r");
 define ('LABEL_THREAD_BETWEEN', "V&aelig;lg tr&aring;de mellem");
 define ('LABEL_THREAD_OLDER', "V&aelig;lg tr&aring;de &aelig;ldre end: ");
 define ('LABEL_SELECT_ACTION', "V&aelig;lg handlingen, som skal udf&oslash;res");
 define ('ACTION_THREAD_DELETE', "Slet de udvalgte tr&aring;de ");
 define ('ACTION_THREAD_MOVE', "flyt tr&aring;de (slet tr&aring;dene efter kopiering)");
 define ('ACTION_THREAD_COPY', "Kopier de valgte tr&aring;de til forum: ");
 define ('LABEL_REPLIES', "svar");

 /////////////////////
 //Admin_User.php33
 /////////////////////
 define ('TITLE_SITE_USER_ADMIN', "<trans>Manage users in site \"{SITE}\"");
 define ('TITLE_FORUM_USER_ADMIN', "<trans>Manage users in site \"{FORUM}\"");
 define ('TITLE_SELECT_USERS', "<trans>Choose users to manage");
 define ('TITLE_MAIL_USERS', "<trans>Compose mail to send to <font color=blue>%s</font>");
 define ('LABEL_CHOOSE_USERID_INIT', "<trans>Choose an initial");
 define ('LABEL_CHOOSE_USERID_PATTERN', "<trans>Or give a pattern");
 define ('LABEL_BY_NAME', "<trans><b>By name</b>");
 define ('LABEL_BY_ACTIVITY', "<trans><b>By activity</b>");
 define ('LABEL_SHOW_NO_POST', "<trans>Display users who never post...");
 define ('LABEL_SHOW_NO_LOGIN', "<trans>Display users who never login...");
 define ('LABEL_SHOW_DIDNT_POST', "<trans>Display users who didn't post since...");
 define ('LABEL_SHOW_DIDNT_LOGIN', "<trans>Display users who didn't login since......");
 define ('LABEL_SHOW_IN_STATE', "<trans>Display users in state: ");
 define ('LABEL_NOT_REGISTERED', "<trans>Not Registered");
 define ('LABEL_USERS_IN_STATE', "<trans>Users in state <font color=blue>%s</font> ");
 define ('LABEL_USERS_BEGINING', "<trans>Users who have ID or name begining by <font color=blue>%s</font> ");
 define ('LABEL_USERS_NEVER_POST', "<trans>Users who never post ");
 define ('LABEL_USERS_NEVER_LOGIN', "<trans>Users who never login ");
 define ('LABEL_USERS_DIDNT_POST', "<trans>Users who didn't post since <font color=blue>%s %s</font> ");
 define ('LABEL_USERS_DIDNT_LOGIN', "<trans>Users who didn't login since <font color=blue>%s %s</font> ");
 define ('LABEL_REG_USERS_FORUM', "<trans>in forum <font color=red>%s</font>");
 define ('LABEL_REG_USERS_SITE', "<trans>in site <font color=red>%s</font>");
 define ('LABEL_CONFIRM_USER_DELETE', "<trans>Are you sure you want to delete these users?");
 define ('LABEL_DELETE_THESE_USERS', "<trans>Delete these users");
 define ('LABEL_USER_CONFIRM_DELETE', "<trans>User <font color=blue>%s</font> has been deleted");
 define ('LABEL_RETURN_LIST', "<trans>Return to users list");
 define ('LABEL_EDIT_MAIL_PROFILE', "<trans>Mail profile to user <font color=blue>%s</font>");
 define ('LABEL_TO', "<trans>To");
 define ('LABEL_SEND', "<trans>Send mail");
 define ('LABEL_REG_USER_FORUM', "<trans>You are registered in this forum");
 define ('LABEL_NO_REG_USER_FORUM', "<trans>You are not registered in this forum");
 define ('LABEL_MAIL_USER_OK', "<trans>Mail has been sent to user <font color=blue>%s</font>");
 define ('LABEL_MAIL_USER_NO_OK', "<trans>Could not send mail to user(s) <font color=blue>%s</font>");
 define ('ERROR_NO_USER_MATCHING', "<trans>No user matching (<font color=blue>%s</font>)");
 define ('ERROR_NO_REMOVE_PRIVILEGE', "<trans>You have not privileges to delete user <font color=blue>%s</font>");
 define ('ERROR_NO_EDIT_PRIVILEGE', "<trans>You have not privileges to edit user <font color=blue>%s</font>");
 define ('ERROR_NO_REMOVE_PERMISSION', "<trans>The user <font color=blue>%s</font> has access to a forum (%s) for which you have not moderator privilege,<bR> you cannot remove this user");
 define ('ERROR_SITE_USER_DELETE', "<trans>It is not possible to delete user <font color=blue>%s</font> in site %s");
 define ('LABEL_STATUS', "<trans>State");
 define ('ERROR_NO_MATCHING_USERS', "<trans>No matching users ");
 define ('ERROR_NO_MATCHING_USER', "<trans>User %s doesn't exist in this site");
 define ('ERROR_NO_OWNER_UPDATE', "<trans>Could not update owner of forum %s in site %s");
 define ('ERROR_NO_SITE_USER_UPDATE', "<trans>Could not update user {FORUM} in site {SITE}");
 define ('TITLE_EDITING_USER', "<trans>Editing user ");
 define ('LABEL_IN_SITE', "<trans>in site");
 define ('COLUMN_USER_EMAIL', "<trans>E-mail");
 define ('COLUMN_USER_WEBPAGE', "<trans>Home page");
 define ('COLUMN_USER_DESCRIPTION', "<trans>Description");
 define ('COLUMN_USER_LASTLOGIN', "<trans>Last login");
 define ('COLUMN_USER_MAILOK', "<trans>E-mail OK");
 define ('COLUMN_USER_COUNTRY', "<trans>Country");
 define ('LABEL_UNSELECT', "<trans>Unselect");
 define ('LABEL_SELECT_ALL', "<trans>Select all"); 
 define ('LABEL_WITH_SELECTED', "<trans>With selected : "); 
 define ('LABEL_MAIL_USER', "<trans>Send a mail");
 define ('LABEL_REMOVE_ACCESS', "<trans>Remove access"); 

 define ('ALT_CHANGE_PASSWORD', "<trans>Change user password");
 define ('CAPTION_USER_PRIVILEGE', "<trans>User privileges: ");
 define ('LABEL_CHANGE_USER_PRIVILEGE', "<trans>Change user privileges in : ");
 define ('LABEL_USER_SITE_STATUS', "User status in site : ");
 define ('LABEL_CHANGE_STATUS' , "Change status to : ");
 define ('LABEL_USER_CONFIRM_STATUS' , "User <font color=blue>%s</font> is now %s."); //$userid, $user_states[$user_state]
 define ('LABEL_MAIL_USER_STATUS' , "Send new status by mail");
 define ('LABEL_MAIL_STATUS_SUBJECT' , "Modification of your profile in sitede votre profil in site %s"); //$site
 define ('LABEL_MAIL_STATUS_BODY' , "Hello,\n administrator of site %s modified your account. Your account is now %s."); // $site, $user_state
 define ('ERROR_NO_ADMIN_CHANGE_STATUS', "Status of user 'Admin' can't be changed"); 
 define ('ERROR_NO_USER_STATUS', "Status of user couldn't be modified in site %s"); //$userid
 define ('ERROR_NO_ADMIN_CHANGE_PRIVILEGE', "<trans>The privilege can not be changed for user admin");
 define ('CAPTION_CHANGE_USER_FORUM_PRIVILEGES', "<trans>Select the access privileges you want to grant to this user");
 define ('LABEL_AS', "<trans>as ");
 define ('LABEL_GRANT_PRIVILEGES', "<trans>Select the access privileges you want to grant to this user");
 define ('COLUMN_CAN_LIST', "<trans>List");
 define ('COLUMN_CAN_READ', "<trans>Read");
 define ('COLUMN_CAN_WRITE', "<trans>Write");
 define ('COLUMN_SITE', "<trans>site");
 define ('LABEL_ADD_FORUM', "<trans>Add a forum : ");
 define ('LABEL_MAIL_USER_PROFILE', "<trans>Mail to user his new profile ");
 define ('LABEL_SHOW', "<trans>Show");

 define ('ERROR_NO_ADD_PRIVILEGES', "Could not add privileges to user %s in forum %s");

 define ('COLUMN_MAIL_SUBSCRIBED_USERS', "<trans>Mail subscribed users");
 define ('ALT_MAIL_SUBSCRIBED_USERS', "<trans>Send a mail to users who subscribed to this forum.");
 define ('LABEL_SEND_FORUM_SUBSCRIBED_EMAIL', "<trans>Send a mail to users subscribed to forum $bn_name");
 define ('TITLE_SELECT_SUBSCRIBED_USERS', "<trans>Chose subscribed users to administrate");
 define ('LABEL_NO_SUBSCRIBED_USERS', "<trans>No subscribed users in this forum");
 define ('LABEL_IN_FORUM', "<trans>in forum");
 define ('LABEL_SUBSCRIBE_USER', "<trans>Subscribe a new user");
 define ('LABEL_SUBSCRIBE', "<trans>Subscribe");
 define ('LABEL_UNSUBSCRIBE', "<trans>Unsubscribe");
 define ('LABEL_CONFIRM_USER_UNSUBSCRIBE', "<trans>Are you sure to unsubscribe these users ?");
 define ('LABEL_CONFIRM_USER_SUBSCRIBE', "<trans>Are you sure to subscribe these users ?");
 define ('ERROR_NO_MATCHING_ADDRESS', "<trans>Subscribed user %s not found in forum %s");
 define ('COLUMN_USER_NEW_EMAIL', "<trans>New address :");
 define ('LABEL_EDIT_MAIL_SUBSCRIBE', "<trans>Send user <font color=blue>%s</font> his(her) new address");
 define ('LABEL_MAIL_USER_SUBSCRIBE', "<trans>Send user his(her) new subscription");
 define ('COLUMN_ADMIN_SUBSCRIBED_USERS', "<trans>Subscribed users");
 define ('ALT_ADMIN_SUBSCRIBED_USERS', "<trans>Administrate users who subscribed to this forum");
 define ('TITLE_FORUM_SUBSCRIBED_USER_ADMIN', "<trans>Administrate subscribed users in forum \"{FORUM}\"");
 define ('LABEL_USER_CONFIRM_UNSUBSCRIBE', "<trans>User <font color=blue>%s</font> has been unsubscribed");
 define ('LABEL_USER_CONFIRM_SUBSCRIBE', "<trans>User <font color=blue>%s</font> has been subscribed");
 define ('LABEL_KEEP_THREADS', "<trans>Keep threads subcriptions");
 define ('LABEL_MAIL_SUBSCRIBE_SUBJECT', "<trans>Your subscription to forum %s");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_YES', "<trans>You've been subscribed to forum %s. You will receive every new messages bay e-mail.");
 define ('LABEL_MAIL_SUBSCRIBE_BODY_NO', "<trans>You've been unsubcribed from forum %s. You'll no longer receive e-mails from this forum.");
 define ('LABEL_SUBSCRIBED_USERS', "<trans>Subscribed users");
 define ('LABEL_UNSUBSCRIBED_USERS', "<trans>Unsubscribed users");

 /////////////////////
 //Add_User.php3
 /////////////////////
 define ('TITLE_ADD_USER', "Tilf&oslash;j bruger");
 define ('ERROR_NO_ADD_USER', "Kunne ikke tilf&oslash;j brugeren %s i tabellen %s_userforum");
 define ('WARNING_USER_ADDED', "Brugeren '%s' er blevet tilf&oslash;jet i forum '%s'");
 define ('LABEL_RETRIEVING_USERS', "Henter alle brugere i dette omr&aring;de (vent venligst) ...");
 define ('WARNING_NO_USER_TO_ADD', "Ingen brugere at tilf&oslash;je");
 define ('LABEL_ADD_FORUM_USER', "Tilf&oslash;j en bruger til forum <em><FONT color=#FF6633>%s</FONT></em>");
 define ('LABEL_CHOOSE_USER_ADD', "V&aelig;lg en bruger, som skal tilf&oslash;jes");
 define ('LABEL_USER_GRANT_PRIVILEGES', "<b>St rettigheder i forum <FONT color=#FF6633>%s</font> for denne bruger</b><br>");
 define ('LABEL_ACTIVE', "Aktiv");
 define ('LABEL_FORM_SELECT', "&lt;-- V&aelig fra listen --&gt;");
 define ('LABEL_ENTER_EMAILS_TO_ADD', 'Indtast her listen med email-adresser for brugere, som skal tilj&oslash;jes ');
 define ('LABEL_CHOOSE_EMAILS_FILE', 'V&aelig;lg en fil, som rummer listen med email-adresser');

 /////////////////////
 //Create_User.php3
 /////////////////////
 define ('TITLE_NEW_USER', "Opret bruger");
 define ('ERROR_NO_PASSWORD', "Password skal angives og skal indtastes to gange");
 define ('ERROR_NO_SITE_ADD_USER', "Kunne ikke tilf&oslash;je brugeren %s i tabellen %s_users");
 define ('LABEL_USER_ADDED', "Brugeren '%s' er oprettet");
 define ('LABEL_USER_SENT_FOR_APPROVAL', "His/her account will bea ctive once validated by the administrators of the site."); 
 define ('LABEL_CREATE_ANOTHER_USER', "Opret bruger");
 define ('LABEL_EDIT_THIS_USER', "Rediger denne bruger");
 define ('ALT_EDIT_THIS_USER', "Rediger bruger-informationer");
 define ('LABEL_SITE_CREATE_NEW_USER', "Opret en ny bruger i omr&aring;det: ");
 define ('LABEL_USER_INFORMATIONS', "Bruger-informationer");
 define ('COLUMN_USER_PASSWORD', "Indtast password");
 define ('COLUMN_USER_CONFIRM_PASSWORD', "Gentag venligst password");
 define ('LABEL_ADD_MAILING_LIST', "Tilf&oslash;j denne bruger til mailing-listen?");
 define ('LABEL_CREATE_USER', "Opret bruger");
 define ('LABEL_USER_PRIVILEGE', "V&aelig;lg rettigheder for denne bruger");

 /////////////////////
 //Mail_Users.php3
 /////////////////////
 define ('LABEL_SEND_SITE_EMAIL', 'Send email til brugere i dette omr&aring;de ');
 define ('LABEL_SEND_FORUM_EMAIL', 'Send email til brugere i dette forum ');
 define ('LABEL_NO_ACTIVE_USERS', 'Ingen aktive brugere fundet ');
 define ('LABEL_MAIL_USERS', 'Mail vil blive sendt til %s bruger(e)');
 define ('LABEL_USER_MAILED', 'Mail sendt til <em> %s </em> <tt>&lt; %s &gt;</tt>.<br>');
 define ('LABEL_USER_NOT_MAILED', '%s &lt; %s &gt; har valgt ikke at modtage mail.<br>');
 define ('LABEL_MAIL_FILL_FORM', 'Udfyld denne form for at sende meddelelse');
 define ('LABEL_SEND_TO_ALL', 'Send til ALLE brugere');
 define ('COLUMN_TO', 'Send til:');
 define ('COLUMN_FROM', 'Fra:');
 define ('COLUMN_REPLY_TO', 'Svar til:');
 define ('COLUMN_MESSAGE', 'Meddelelse:');
 define ('LABEL_SEND_MAIL', 'Send mail');

 /////////////////////
 //Editconf.php3
 /////////////////////
 define ('ERROR_NO_WRITE_CONFIGURATION', "Kan ikke skrive til konfigurationsfilen, check rettigheder");
 define ('ERROR_FILE_UPLOAD_DISABLED', "<trans>File upload feature has been disabled on this server, check your php3 configuration (php3.ini) or contact your ISP!!");
 define ('LABEL_CHANGE_CONFIG_DONE', "&AElig;ndringer gemt i ");
 define ('LABEL_SETTINGS_RESTORED', "Indstillingerne er blevet genetableret");
 define ('LABEL_FORUM_CONFIGURATION', "Forum %s konfiguration");
 define ('LABEL_EDITING_FILE', "Redigerer filen: ");
 define ('TITLE_GENERAL_SETTINGS', "Generelle indstillinger");
 define ('COLUMN_BODY', "Baggrund");
 define ('ALT_BODY', "Andre parametre til &lt;BODY&gt;-tag\'et");
 define ('COLUMN_DATE_FORMAT', "Datoformat");
 define ('ALT_DATE_FORMAT', "Format for visning af datoer (se php3 dokumentationen)");
 define ('COLUMN_TIME_OFFSET', "Tids-offset");
 define ('ALT_TIME_OFFSET', "Tids-offset fra lokal tid (timer)");
 define ('COLUMN_USE_COOKIE', "Brug cookies");
 define ('ALT_USE_COOKIE', "Brug cookies til at gemme brugernavn/adresse and til administration af nye meddelelser");
 define ('COLUMN_ALLOW_MODIFICATION', "Tillad modifikation");
 define ('ALT_ALLOW_MODIFICATION', "Tillader brugerne at redigere meddelelser, password kr&aelig;ves for at redigere");
 define ('COLUMN_ALLOW_DELETE', "Tillad sletning");
 define ('ALT_ALLOW_DELETE', "Tillader brugerne at slette egne meddelelser, password kr&aelig;ves for at slette");

 define ('TITLE_MESSAGE_FORMATING', "Meddelelsesformattering");
 define ('COLUMN_ALLOW_HTML', "Tillad HTML");
 define ('ALT_ALLOW_HTML', "Tillader brugerne at inds&aelig;tte HTML-tags");
 define ('COLUMN_TAGS_ALLOWED', "Tilladte tags:");
 define ('ALT_TAGS_ALLOWED', "skriv de eneste HTML-tags, som skal tillades fra brugerinput, adskilt med mellemrum, komma eller semikolon (indtast ikke &lt; og &gt;)");
 define ('COLUMN_TAGS_DISALLOWED', "Forbudte tags:");
 define ('ALT_TAGS_DISALLOWED', "skriv de HTML-tags som skal fjernes fra brugerinput, adskilt med mellemrum, komma eller semikolon (indtast ikke &lt; og &gt;). Bruges kun, hvis 'Tilladte tags' er tomt");
 define ('COLUMN_USE_SMILEY', "Brug smileys");
 define ('ALT_USE_SMILEY', "&AElig;ndrer smileys til ikoner (kun felter, som accepterer HTML vil acceptere smileys)");
 define ('COLUMN_CONVERT_URL', "Konverter URL'er");
 define ('ALT_CONVERT_URL', "Konverter automatisk indlejrede URL'er til links (kun i felter, som accepterer HTML)");

 define ('TITLE_LAMER_FILTER', "Lamer filters");
 define ('COLUMN_DISALLOW_IP', "Forbyd IP:");
 define ('ALT_DISALLOW_IP', "Angiv IP-adrsser som ikke m&aring; skrive indl&aelig;g, adskilt med mellemrum, komma eller semikolon");

 define ('TITLE_FILE_UPLOAD', "Fil Upload");
 define ('COLUMN_FILE_UPLOAD', "Fil upload support ");
 define ('ALT_FILE_UPLOAD', "Tillader brugere at uploade vedh&aelig;ftede filer til serveren");
 define ('COLUMN_MAX_FILE_SIZE', "Maximum filst&oslash;rrelse (bytes)");
 define ('ALT_MAX_FILE_SIZE', "Begr&aelig;nser st&oslash;rrelsen af uploadede filer");

 define ('COLUMN_ALLOW_EXTENSION', "Tillad kun extensions: ");
 define ('ALT_ALLOW_EXTENSION', "Angiv de fil-extensions (f.eks.: .gif) som skal tillades for uploadede filer, adskilt med mellemrum, komma eller semikolon");
 define ('COLUMN_DENY_EXTENSION', "Forbyd extensions: ");
 define ('ALT_DENY_EXTENSION', "Angiv de fil-extensions (f.eks.: .gif) som skal afvises for uploadede filer, adskilt med mellemrum, komma eller semikolon. Bruges kun, hvis 'Tillad kun extensions'-feltet er tomt");

 define ('COLUMN_ALLOW_MIME', "Tillad MIME-typer: ");
 define ('ALT_ALLOW_MIME', "Angiv de MIME-typer (f.eks.: image/gif, text/*) som skal tillades for uploadede filer, adskilt med mellemrum, komma eller semikolon (i formatet 'type/subtype' or 'type/*') ");
 define ('COLUMN_DENY_MIME', "Forbyd MIME-typer: ");
 define ('ALT_DENY_MIME', "Angiv de MIME-typer (f.eks.: image/gif, text/*) som skal afvises for uploadede filer, adskilt med mellemrum, komma eller semikolon. Bruges kun, hvis 'Tillad MIME-typer'-feltet er tomt");

 define ('TITLE_SEARCH', "S&oslash;gning");
 define ('COLUMN_SEARCH_SUPPORT', "S&oslash;ge-support ");
 define ('ALT_SEARCH_SUPPORT', "Tillad brugerne at s&oslash;ge i meddelelsesteksten");
 define ('COLUMN_SEARCH_ENGINE', "S&oslash;gemaskine: ");
 define ('COLUMN_PATH_NAME', "Sti ");
 define ('ALT_PATH_NAME', "Placering af s&oslash;geprogrammet");
 define ('TITLE_SEND_MAIL', "Udsendelse af email");
 define ('COLUMN_MAIL_MODERATOR', "Send mail til moderator");
 define ('ALT_MAIL_MODERATOR', "Informer hovedmoderatoren pr. email n&aring;r en meddelelse er postet eller opdateret");
 define ('COLUMN_ALLOW_MAIL_SUBSCRIPTION', "Tillad mail-abonnement");
 define ('ALT_ALLOW_MAIL_SUBSCRIPTION', "Tillader brugerne at modtage svar pr. email");
 define ('COLUMN_ALLOW_PRIVATE_MAIL', "Allow private mails");
 define ('ALT_ALLOW_PRIVATE_MAIL', "allow users tosend private mails to the authors of notes");
 define ('COLUMN_MAIL_ATTACHMENT', "Attach files to mails");
 define ('ALT_MAIL_ATTACHMENT', "Attach \"attachment\" files to the mails sent to users");
 define ('LABEL_DEFAULT', "Fortryd");

 define ('LABEL_FRAMES', "Frames");
 define ('COLUMN_USE_FRAMES', "Brug frames");
 define ('ALT_USE_FRAMES', "Selv hvis dette v&aelig;lges, underst&oslash;ttes &aelig;ldre browsere ogs&aring;");
 define ('COLUMN_FRAMESET_PARAMETER', "Frameset parametre:");
 define ('ALT_FRAMESET_PARAMETER', "Ekstra parametre til &lt;FRAMESET&gt;-tag'et ");
 define ('COLUMN_HEADER_FRAME_PARAMETER', "Header Frame parametre:");
 define ('ALT_HEADER_FRAME_PARAMETER', "Ekstre parametre til &lt;FRAME&gt;-tag'et ");
 define ('COLUMN_FOOTER_FRAME_PARAMETER', "Footer Frame parametre:");

 define ('TITLE_POST_MESSAGES', "Nye meddelelser");
 define ('COLUMN_POST_POPUP', "Send i popup-vindue ");
 define ('ALT_POST_POPUP', "&Aring;bn et separat vindue for Send/Svar/Rediger-formen");
 define ('COLUMN_NO_BUTTON_BAR', "Vis ikke knappanelet");
 define ('ALT_NO_BUTTON_BAR', "Vis ikke knappanelet og valgmulighederne nederst i Send/Svar/Rediger-formen");
 define ('COLUMN_NO_THANKS', "Vis ikke 'takke'-meddelelser ");
 define ('ALT_NO_THANKS', "Vis n&aelig;ste side efter send/rediger uden at vise 'takke'-meddelelsen");
 define ('COLUMN_AFTER_POSTING', "Efter afsending, returner til");
 define ('ALT_AFTER_POSTING', "Siden, der returneres til efter afsendelse af en meddelelse");
 define ('COLUMN_NEWLY_POSTED', "Den netop afsendte meddelelse");
 define ('COLUMN_MESSAGE_LIST', "Meddelelses-listning");
 define ('COLUMN_FIRST_MESSAGE', "F&oslash;rste meddelelse i tr&aring;den");

 define ('TITLE_INCLUDE_FILES', "Include-filer (alle filer er placeret i %s), lad disse felter st&aring; blanke for at bruge standard");

 define ('COLUMN_CSS_FILE', "Style sheet (CSS) fil:");
 define ('ALT_CSS_FILE', "CSS fil (includeret i <head>-tag'et:");
 define ('COLUMN_HEADER_FILE', "Header fil");
 define ('ALT_HEADER_FILE', "Header include fil");
 define ('COLUMN_FOOTER_FILE', "Footer fil");
 define ('ALT_FOOTER_FILE', "Footer include fil");
 define ('COLUMN_LISTING_OUTLINE', "Liste-layout");
 define ('ALT_LISTING_OUTLINE', "Udseende af meddelelses-liste");
 define ('COLUMN_INCLUDE_MESSAGES', "Meddelelser");
 define ('ALT_INCLUDE_MESSAGES', "Viste meddeelser og billedfiler");
 define ('COLUMN_FORM_FILE', "Form");
 define ('ALT_FORM_FILE', "FORM til Send/Rediger/Svar (p&aring;) meddelelser");
 define ('COLUMN_MAIL_FORM_FILE', "Private mails form");
 define ('ALT_MAIL_FORM_FILE', "form used to send private mails");
 define ('COLUMN_FILE_SEARCH', "Search Form");
 define ('ALT_FILE_SEARCH', "Search Form");
 define ('COLUMN_TEMPLATE_FILE', "Skabelon");
 define ('ALT_TEMPLATE_FILE', "Meddelelsesskabelon");
 define ('COLUMN_FIELDS_NAME', "Felt-navne");
 define ('ALT_FIELDS_NAME', "Definition af felter (variable)");
 define ('COLUMN_php3_INCLUDE', "php3 fil, includeret inden adgang");
 define ('ALT_php3_INCLUDE', "Eventuel php3-fil, som udf&oslash;res (included) inden data inds&aelig;ttes");
 define ('COLUMN_FILE_LOGIN', "Login-form");
 define ('ALT_FILE_LOGIN', "Form til login af brugere");
 define ('COLUMN_REGISTER_FORM', "Registreringsform");
 define ('ALT_FILE_REGISTER', "Form til registrering af brugere");
 define ('COLUMN_SHOW_PROFILE', "Vis profil -skabelon");
 define ('ALT_FILE_SHOW_PROFILE', "Visning af bruger-profil");
 define ('COLUMN_FILE_CHANGE_PASSWORD', "Skift password form");
 define ('ALT_FILE_CHANGE_PASSWORD', "Form til skift af password");
 define ('COLUMN_FILE_FORGOT_PASSWORD', "Glemt password form");
 define ('ALT_FILE_FORGOT_PASSWORD', "Form, n&aring;r brugeren har glemt sit password");
 define ('COLUMN_FILE_MAIL_TEMPLATE', "Mail-skabelon");
 define ('ALT_FILE_MAIL_TEMPLATE', "Mail konfiguration og skabelon");
 define ('COLUMN_SUBSCRIBE_FORM_TEMPLATE', "Skabelon for abonnements-form");
 define ('ALT_FILE_SUBSCRIBE_FORM', "Forum mail abonnement skabelon");

 define ('TITLE_DISCUSSION_BOARD', "Diskussioner");
 define ('COLUMN_ALLOW_REPLIES', "Tillad svar (meddelelses-tr&aring;de)");
 define ('ALT_ALLOW_REPLIES', "Tillad brugerne at besvare meddelelser (tr&aring;de)");

 define ('TITLE_DISPLAYED_MESSAGE', "Visning af meddelelser");
 define ('COLUMN_NO_TOOLBAR', "Ingen toolbar i meddelelsen ");
 define ('ALT_NO_TOOLBAR', "Vis ikke menu-bar'en (svar|rediger|slet|list) med den viste meddelelse");
 define ('COLUMN_NO_NAVIGATION_BAR', "Ingen navigationsbar i meddelelsen");
 define ('ALT_NO_NAVIGATION_NAR', "Vis ikke navigations-bar'en (n&aelig;ste/foreg&aring;ende tr&aring;d/meddelelse) med den viste meddelelse");
 define ('COLUMN_NO_THREAD', "Ingen tr&aring;d i meddelelsen");
 define ('ALT_NO_THREAD', "Vis ikke den aktuelle tr&aring;d med den viste meddelelse");
 define ('COLUMN_APPEND_MESSAGE', "Tilf&oslash;j svar-form til den viste meddelelse");
 define ('ALT_APPEND_MESSAGE', "Vis svar-formen under den viste meddelelse");

 define ('TITLE_MESSAGE_LISTING', "Meddelelses-listning");
 define ('COLUMN_MESSAGE_NO_NAVIGATION_BAR', "Ingen navigationsbar i listen");
 define ('ALT_MESSAGE_NO_NAVIGATION_NAR', "Vis ikke navigationsbar'en (n&aelig;ste/foreg&aring;ende side) i meddelelseslisten");
 define ('COLUMN_GUESTBOOK', "Tilf&oslash;j form til meddelelseslistning");
 define ('ALT_GUESTBOOK', "Vis 'Send'-formen under meddelelseslisten (g&aelig;stebogs-mode)");

 define ('TITLE_BROWSE_SERVER', "Gennemse server");
 define ('COLUMN_BROWSE_SERVER', "Support for gennemsyn af server-filer");
 define ('ALT_BROWSE_SERVER', "Tillader brugerne at vedh&aelig;fte filer, som er placeret p&aring; serveren");
 define ('COLUMN_BASE_DIRECTORY', "Basis-mappe");
 define ('ALT_BASE_DIRECTORY', "Definerer top-mappen for brugernes gennemsyn af dokumenter til vedh&aelig;ftning");

 /////////////////////
 //Edit_Forum.php3
 /////////////////////
 define ('LABEL_EDIT_FORUM', "Rediger forum karakteristika");
 define ('LABEL_SITE_EDIT_FORUM', "V&aelig;lg det forum, du &oslash;nsker at redigere i omr&aring;det %s");
 define ('ERROR_NO_FORUM_UPDATE', "Kunne ikke opdatere forum %s i omr&aring;det %s");
 define ('ERROR_NO_NEW_MODERATOR', "Kunne ikke give moderator-rettigheder for brugeren %s i forum %s ");
 define ('LABEL_EDIT_FORUM_SHORT', "Rediger forum: ");
 define ('LABEL_FORUM_INFORMATION', "Forum-informationer");
 define ('COLUMN_STATE', "Tilstand");
 define ('COLUMN_CATEGORY', "Kategori");
 define ('LABEL_PRIVACY_INFORMATION', "Informationer om privatliv");
 define ('LABEL_CHANGE_ACCESS', "Skift adgangs-mode for dette forum");
 define ('LABEL_MODERATED', "modereret");
 define ('LABEL_UPDATE_THIS_FORUM ', "Opdater forum");
 define ('LABEL_CHOOSE_MODERATOR', "V&aelig;/skift den bruger, som skal v&aelig;re hoved-moderator i dette forum");

 /////////////////////
 //admin_categories.php3
 /////////////////////
 define ('LABEL_EDIT_CATEGORIES', "Rediger Kategorier i omr&aring;det ");
 define ('LABEL_ADD_CATEGORY', "Tilf&oslash;j kategori");
 define ('COLUMN_EDIT_CATEGORY', "Rediger kategori ");
 define ('COLUMN_DELETE_CATEGORY', "Slet kategori ");
 define ('COLUMN_CAT_TITLE', "Emne (titel):");
 define ('LABEL_UPDATE_ORDER', "Opdater r&aelig;kkef&oslash;lge");
 define ('LABEL_ADD_NEW_CATEGORY', "Tilf&oslash;j ny kategori");
 define ('LABEL_ADD_THIS_CATEGORY', "Tilf&oslash;j denne kategori");
 define ('LABEL_EDIT_CATEGORY', "Rediger kategori");
 define ('LABEL_UPDATE_THIS_CATEGORY', "Opdater denne kategori");

 /////////////////////
 //Create_Forum.php3
 /////////////////////
 define ('TITLE_CREATE_FORUM', "Opret forum");
 define ('ERROR_FORUM_NAME_TO_LONG', "Forum-navnet er for langt, v&aelig;lg venligst et kortere.");
 define ('ERROR_CONFIG_FILE_EXISTS', "Konfigurationsfilen (%s) eksisterer allerede, slet den manuelt eller v&aelig;lg et andet navn");
 define ('ERROR_NO_FILE_COPY', "Kunne ikke kopiere filen %s");

 define ('ERROR_FORUM_DB_DBM_EXISTS', "Omr&aring;de-databasen %s findes allerede, <br> du m&aring; slette DBM-filen: <em>dbm/%s/%s</em><br> [og lock-filen .lck] manuelt");
 define ('ERROR_FORUM_DB_EXISTS', "Forumstabellen (%s) findes allerede i denne database (%s), du m&aring; f&oslash;rst slette (drop) tabellen manuelt v&aelig;lge et andet navn");

 define ('ERROR_FORUM_DB_DBM_ACCESS', "Adgangsproblem, kunne ikke oprette DBM filen (<em>%s</em>) check plads og rettigheder i filsystemet");
 define ('ERROR_FORUM_DB_ACCESS', "Adgangsproblem, kunne ikke oprette tabellen (<em>%s</em>) kontroller, at du har oprettet en database ved navn %s og check adgangsrettighederne");
 define ('ERROR_NO_CREATE_FORUM', "Kunne ikke oprette forum:");
 define ('ERROR_NO_FORUM_INSERT', "Kunne ikke oprette forum %s i omr&aring;det %s");
 define ('LABEL_FORUM_CREATED', "Forum '<em>%s</em>' er oprette i omr&aring;det %s<BR><BR>&nbsp;&nbsp;du kan nu:");
 define ('LABEL_CREATE_ANOTHER_FORUM', "Oprette et andet forum");
 define ('ALT_ACCESS_FORUM', "G&aring; til forum");
 define ('LABEL_ADMINISTRATE_FORUM', "Administrere dette forum");
 define ('ALT_ADMINISTRATE_FORUM', "Konfigurer yderligere indstillinger for dette forum");
 define ('LABEL_EDIT_THIS_FORUM', "Rediger dette forum");
 define ('ALT_EDIT_THIS_FORUM', "Rediger karakteristika for dette forum");
 define ('LABEL_SITE_ADMINISTRATION', "Tilbage til omr&aring;de-administration");
 define ('LABEL_FORUM_CREATED_SUCCESSFULLY', "Forum %s er oprettet");
 define ('LABEL_INSTALL_FORUM', "Installer et nyt forum i omr&aring;det: ");
 define ('COLUMN_GIVE_FORUM_NAME', "Forum-navn:");
 define ('COLUMN_FORUM_TEMPLATE', "V&aelig;lg en skabelon (tema):");
 define ('LABEL_SET_ACCESS', "V&aelig;lg adgangs-mode for dette forum:");
 define ('LABEL_CREATE_THIS_FORUM', "Opret dette forum");
 define ('LABEL_NAME_OF_FORUM', "(det navn, du giver dette forum)");
 define ('LABEL_CHOOSE_FIRST_MODERATOR', "V&aelig;lg den bruger (ejer), som skal v&aelig;re moderator i dette forum:");

 /////////////////////
 //Reorder_Forum.php3
 /////////////////////
 define ('TITLE_REORDER_FORUM', "Skift listnings-r&aelig;kkef&oslash;lge for fora i omr&aring;det: ");
 define ('LABEL_CHANGE_FORUM_ORDER', "Herunder kan du &aelig;ndre den r&aelig;kkef&oslash;lge, som fora vises i. Tildel hvert forum et individuelt nummer, startende med 1. S&aelig;ttes v&aelig;rdien til 0, udelades dette forum fra listen");


 /////////////////////
 //editform.php3
 /////////////////////
 define ('LABEL_NEW_FILE_EDITING', "Redigerer ny fil:");
 define ('WARNING_EDITING_DEFAULT', "Advarsel: Denne fil er en standardfil for dette omr&aring;de, &aelig;ndringer vil p&aring;virke alle fora, som benytter standarden for dette omr&aring;de.");
 define ('LABEL_SPECIFIC_TEMPLATE', "Hvis du &oslash;nsker at bruge en specifik skabelon, kan du angiver dens navn p&aring; <a href='%s'>indstillings-siden</a>");

 /////////////////////
 //editmsg.php3
 /////////////////////
 define ('TITLE_EDITING_MESSAGES', "Redigerer meddelelser");
 define ('ERROR_NO_CREATE_MESSAGE', "Kan ikke oprette meddelelsesfil, check rettigheder");

 /////////////////////
 //editfields.php3
 /////////////////////
 define ('TITLE_EDITING_FIELDS', 'Redigerer felter');
 define ('LABEL_NAME', 'Navn');
 define ('LABEL_SIZE', 'St&oslash;rrelse');
 define ('LABEL_REQUIRED', 'Obligatorisk');
 define ('LABEL_LISTED', 'Listet');
 define ('LABEL_ACCEPT_HTML', 'Accepterer HTML/smileys');
 define ('LABEL_SAVE_COOKIE', 'Gem i permanent cookie');
 define ('LABEL_DELETE_FIELD', 'Slet');
 define ('LABEL_USER_VARIABLES', 'Brugervariable');
 define ('LABEL_LISTED_VARIABLES', 'Listede variable');
 define ('LABEL_REQUIRED_VARIABLES', 'Obligatoriske variable');
 define ('LABEL_VARIABLES_ACCEPT_HTML', 'HTML-accept variable');
 define ('LABEL_VARIABLES_COOKIE', 'Variable givet ved permanent cookie');
 define ('LABEL_CONFIRM_DELETE_FIELD', '&Oslash;nsker du at slette dette felt fra tabelbeskrivelsen');
 define ('ALT_DELETE_FIELD', 'Slet felt: %s');
 define ('ALT_ADD_FIELD', 'Tilf&oslash;j felt');
 define ('ERROR_UNDEFINED_VARNAME', 'Angiv venligst et navn for det felt, som skal tilf&oslash;jes');
 define ('ERROR_UNDEFINED_VARSIZE', 'Angiv venligst st&oslash;rrelse/type for det felt, som skal tilf&oslash;jes [xxx | int | text]');
 define ('ERROR_VARNAME_ALREADY_DEFINED', 'Dette feltnavn benyttes allerede');

 /////////////////////
 //edittemplate.php3
 /////////////////////
 define ('TITLE_EDITING_TEMPLATE', "Rediger skabelon");
 define ('LABEL_DEFINE_DOCUMENT_GENERATION', "Definer, hvordan dokumenter skal genereres (fra skabelonen):");
 define ('LABEL_STATIC', "<b>Statisk</b><i> (en HTML-fil skabes, nr der sendes en meddelelse) </i>");
 define ('LABEL_ONTHEFLY', "<b>I farten</b><i> (ingen HTML-fil, dokumentet skabes dynamisk, n&aring;r en bruger henter det)</i>");
 define ('LABEL_NO_DOCUMENTS', "<b>Ingen dokument</b><i> (kun databasen listes)</i>");
 define ('LABEL_EDIT_TEMPLATE', "Rediger dokument-skabelonen:");

 /////////////////////
 //editmail.php3
 /////////////////////
 define ('TITLE_EDITING_MAIL', "Redigerer mail-skabelon");
 define ('LABEL_OVERWRITE_MAIL_FILE', "<trans>Mail template file (<font color=red>WARNING!</font> this choice will overwrite current file)");
 define ('LABEL_SEND_OUT_EMAILS', "Udsend emails fra ('From' header)");
 define ('LABEL_USER_EMAIL', "Brugers email-adresse");
 define ('LABEL_THIS_EMAIL', "Denne email");
 define ('LABEL_FIRST_RECIPIENT', "F&oslash;rste modtager ('To' header)");
 define ('LABEL_RETURN_PATH', "'Return-Path' header");
 define ('LABEL_REPLY_TO', "Svar til ('Reply-To' header)");
 define ('LABEL_NO_MAIL_SUBJECT', "Mail emne, hvis ikke specificeret");
 define ('LABEL_MAIL_SUBJECT', "Mail emne");
 define ('LABEL_MAIL_APPROVAL', "Mail til moderatorer for godkendelse (modereret forum)");
 define ('LABEL_MAIL_POSTED', "<trans>Mail sent when a new note is posted");
 define ('LABEL_MAIL_MODIFIED', "<trans>Mail sent when a note is modified");
 define ('LABEL_MAIL_BODY', "Indhold");
 define ('LABEL_MAIL_REGISTRATION', "Mail til brugere ved registrering");
 define ('LABEL_MAIL_CONFIRM_REGISTRATION', "<trans>Mail sent to users after administrator edit profile");
 define ('LABEL_MAIL_USER_APPROVAL', "Mail til moderatorer ang. godkendelse af brugere");
 define ('LABEL_MAIL_USER_MODIFICATION', "Mail til moderatorer ang. &aelig;ndring af bruger-profil");
 define ('LABEL_MAIL_FORGOT_PASSWORD', "Mail til brugere, som har glemt deres password");

 /////////////////////
 //delete_Forum.php3
 /////////////////////
 define ('TITLE_DELETE_FORUM', 'Slet forum');
 define ('TITLE_DELETE_FORUM_IN_SITE', 'Slet forum %s fra omr&aring;det %s');

 define ('ERROR_MUST_BE_ADMIN_TO_REMOVE_FORUM', 'Du skal v&aelig;re logget ind som administrator for at slette et forum');
 define ('ERROR_NO_AVAILABLE_FORUM', 'Ingen tilg&aelig;ngelige fora i omr&aring;det %s,<br>');
 define ('ERROR_FORUM_DOESNT_EXIST', 'forum %s findes ikke i dette om&aring;de');
 define ('ERROR_CANT_REMOVE_FORUM', 'Kunne ikke fjerne forum %s fra omr&aring;det %s');

 define ('LABEL_CHOOSE_FORUM_TO_DELETE', 'V&aelig;lg det forum, som skal slettes fra omr&aring;det %s');
 define ('LABEL_FORUM_DELETED', 'Forum %s er blevet slettet');

 define ('CAPTION_DELETE_FORUM', '<B>Er du sikker p&aring;, at du vil slette f&oslash;lgende forum</B>');
 define ('LABEL_FORUM_TITLE', 'Emne: ');
 define ('LABEL_FORUM_DESCR', 'Beskrivelse: ');
 define ('LABEL_FORUM_OWNER', 'Ejer: ');
 define ('LABEL_FORUM_TYPE', 'Type: ');
 define ('LABEL_FORUM_MODER', 'Modereret: ');
 define ('LABEL_FORUM_STATE', 'Tilstand: ');
 define ('LABEL_DELETE_THIS_FORUM', 'Slet dette forum');

?>
