<?php

/*
 *	W-AGORA 4.0
 *	-----------
 *	$Id: list.php5,v 1.57 2005/06/04 10:14:43 mdruilhe Exp $
 *	Usage:		display listing of notes
 *	Author:		Marc Druilhe <mdruilhe@w-agora.com>
 */

	$bn_action="list";
	$bn_action_mode="L";

	require ("init.inc");
	$where = "";	// must be defined in before_access
	$bn_sort = (empty($bn_sort)) ? "thread" : stripSlashes($bn_sort);

# Initialize GET/POST parameters list
# -----------------------------------
	$first = (int) getFormVar('first');
	$expnd = getFormVar('expnd');
	$daysprune = getFormVar('daysprune');

# Handle sort parameter
# ---------------------
	$set_url_sort = false;
	$sort = getFormVar('sort');
	if (!is_null($sort)) {
		list ($s, $o) = split(',', htmlspecialchars($sort), 2);
		$s = preg_replace('/\W/', '', $s);
		if ($o[0]=="d") {
			$sort = "$s,d";
			$threads_order = "$s DESC";
		} else {
			$sort = "$s";
			$threads_order = "$s";
		}
		if (!@setcookie ("${bn}_sort", $sort, 0, '/')) {
			$set_url_sort = true;
		}
	} elseif (!empty($_COOKIE["${bn}_sort"]) ) {
		$sort = $_COOKIE["${bn}_sort"];
		list ($s, $o) = split(',', $sort, 2);
		$o = ($o[0]=="d") ? "DESC" : "ASC";
		$threads_order = "$s $o";
	} else {
		$threads_order = (empty($default_threads_order)) ? "newest DESC" : $default_threads_order;
		list ($sort, $o) = split(' ', $threads_order, 2);
		if ($o=="DESC") {
			$sort .= ',d';
		}
	}

# Handle daysprune parameter
# --------------------------
	if (!is_null($daysprune)) {
		$daysprune = (int) $daysprune;
		setcookie ("${bn}_daysprune", $daysprune, 0, '/');
	} elseif (!empty($_COOKIE["${bn}_daysprune"]) ) {
		$daysprune = (int) $_COOKIE["${bn}_daysprune"];
	} else {
		$daysprune = (isset($daysprune) ) ? (integer) $daysprune : 0;
	}

	if ($daysprune>0) {
		$newest = $now-($daysprune*86400);
		$where = "newest >= $newest";
	}

# Handle expnd parameter
# ----------------------
	$set_url_expnd = false;
	if (!is_null($expnd)) {
		$expnd = htmlspecialchars($expnd);
		if( ($expnd=="all") || ($expnd=="none") ) {
			if (!@setcookie ("${bn}_expnd", $expnd, time()+ 8640000, '/')) {
				$set_url_expnd = true;
			}	
		}
	} elseif (!empty($_COOKIE["${bn}_expnd"]) ) {
		$expnd = $_COOKIE["${bn}_expnd"];
	}

# Execute before_access program
# -----------------------------
	if (!empty($before_access)) include $before_access;

# if forum is not defined then list active forums into this site
# --------------------------------------------------------------
	if (empty($bn)) {

		$total = $site_totalthreads;
		$notes = $site_totalforums;
		$threads = $site_totalthreads;

		$hide_inactive = ($auth->level < MODER); // hide forums for end users
		$forums_list = $db->listForums ($site, "", $bn_sort, $hide_inactive, $cat);

# if site is not defined and there is only one active site, then redirect to this site
# ------------------------------------------------------------------------------------
		if ($site=="agora") {
			if (!empty($default_site) ) {
				@header("Location: $bn_base_url/$main_page?site=$default_site");
			} elseif (count($forums_list)==1) {
				reset($forums_list);
				$redir_site= key($forums_list);
				@header("Location: $bn_base_url/$main_page?site=$redir_site");
			}
		}

# Display the header
# ------------------
		display_header (LABEL_LIST, $header_footer);

# Display the list
# ----------------
		if ($site_totalforums > 0) {
			$db->displayForumList ();
		} else {
			printf(ERROR_NO_ENTRY_FOUND, $msg[0]);
		}

# Display the footer
# ------------------
		display_footer ($header_footer);
		exit;

	}

# list order by threads (default) or order by $sort
# -------------------------------------------------
	if ($bn_sort == "thread") {
		$ret = $db->listThreads ($bn_db, $first, $last, $where, ($expnd=="none") ? 0 : 1, $bn_maxthreads);
	} else {
		$ret = $db->listNotes ($bn_db, $first, $last, $bn_sort, $where, $bn_maxthreads);
	}

	if (!is_array ($ret) || ($ret < 0)) {
		display_header (LABEL_LIST, $header_footer);
		MsgForm (sprintf(ERROR_DATABASE, $ret), "list.$ext", "");
		display_footer ($header_footer);
		exit;
	}

	$notes = (int) $ret["notes"];
	$total = (int) $ret["total"];
	$threads = (int) $ret["threads"];
	$first = (int) $ret["first"];
	$last = (int) $ret["last"];
	$prev = (int) $ret["prev"];
	$next = (int) $ret["next"];

# Set list_url
# ------------
	$list_url = "$WA_SELF?bn=$bn";
	if (!empty($first)) {
		$list_url .= "&first=$first";
	}

# Set all variables used for the navigation toolbar (deprecated, use $nav_bar)
# ----------------------------------------------------------------------------
	// Base url used for navigation
	$nav_url = "$WA_SELF?bn=$bn";
	if ($set_url_sort) {
		$nav_url .= "&sort=".urlencode($sort);
	}
	if ($set_url_expnd) {
		$nav_url .= "&expnd=$expnd";
	}

	$list_prev_text = LABEL_PREV_PAGE;
	if ($prev) {
		$list_prev_url = "$nav_url&first=". max ($first-$bn_maxthreads, 0);
		$list_prev_link = anchor ($list_prev_url, "", $list_prev_text, ALT_PREV_PAGE);
	} else {
		$list_prev_url = "";
		$list_prev_link = "";
	}

	$list_next_text = LABEL_NEXT_PAGE;
	if ($next) { 
		$list_next_url = "$nav_url&first=". intval($last+1);
		$list_next_link = anchor ($list_next_url, "", $list_next_text, ALT_NEXT_PAGE);
	} else {
		$list_next_url = "";
		$list_next_link = "";
	}

# Set the nav bar (initial idea from Jean-Yves (rdv4x4.com)
#----------------------------------------------------------
	$nav_bar = getNavBar($nav_url, $ret['totalthreads'], $first, $bn_maxthreads);

# Display the header
# ------------------
	display_header (LABEL_LIST, $header_footer);

# Display the list
# ----------------
	if ($notes > 0) {
		require_once "$inc_dir/listrenderer.$ext";
		$list =& new ListRenderer($db);
		$list->displayList(0, 'list');
	} else {
		printf(ERROR_NO_ENTRY_FOUND, $msg[0]);
	}

# Display the navigation bar
# --------------------------
	if (!$bn_list_no_nav_bar) {
		print "<br /><div align=\"center\">$nav_bar</div>\n";
	}


# Display form if option set
# ----------------------------
	if ($bn_list_post && ($forum['type']=='pub' || $auth->havePermission($bn, "W") ) ) {
		$bn_action="post";
		$bn_action_mode="L";

		$setUserField = true;		// Set username and password in form fields
		$form_action = "insert.$ext";
		$back_form="list";
		$bn_popup=0;

		if (isset($key)) {
			unset($key);
		}

		if (!empty($before_access)) include $before_access;
		include "$inc_dir/form.$ext";
	}

# Display the footer
# ------------------
	display_footer ($header_footer);
?>
