<?php

/* 
 *	W-AGORA 4.2
 *	-----------
 *	$Id: editmsg.php5,v 1.13 2005/01/31 00:22:26 mdruilhe Exp $
 *	Usage:		Edit messages
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 */

	require ("init_admin.inc");

# Only a site administrator can edit layout
# -----------------------------------------
	if ($site=="agora") {
		if ($auth->level < ROOT) {
			MsgForm (ERROR_NO_ROOT, "admin_site.$ext?site=$site&force_login=1", "", "_top");
			echo "</body></html>";
			exit;
		}
		$editsite=1;
	} elseif ($auth->level < ADMIN) {
		MsgForm (ERROR_NO_ADMIN, "admin_site.$ext?site=$site&force_login=1", "", "_top");
		echo "</body></html>";
		exit;
	}

# reads configuration
# -------------------
	if ($editsite==1) {
		$cfg_file = $site_cfg_file;	
	}
	include ("$cfg_file");

# set pathname of file to be edited : if variable $bn_xxx is empty then set path to default
# -----------------------------------------------------------------------------------------
	$page_title = TITLE_EDITING_MESSAGES;

	$page_info = '';
	if ($editdefault==1) {
		$msg_file = "$bn_dir_default/msgs.$ext";
		$page_info = WARNING_EDITING_DEFAULT;
	} elseif (empty ($bn_msgs) ) {
		if ($editsite==1) {
			$msg_file="$bn_dir/msgs.$ext"; // default file for site listing
		} else {
			$msg_file = "$bn_dir_default/msgs.$ext";
			$page_info = WARNING_EDITING_DEFAULT;
			if (!empty($bn) ) {
				$page_info .= "<br>" . sprintf(LABEL_SPECIFIC_TEMPLATE, "editconf.$ext?site=$site&bn=$bn&mode=advanced#include");
			}
		}
	} else {
		$msg_file="$bn_dir/$bn_msgs";
	}

# Save file if submit has been sent
# ---------------------------------
	if (isset($_POST['save'])) {
		$msg = & $_POST['msg'];
		$file = new Config;
		$ret = $file->open("$msg_file");
		if (!$ret) {
			MsgForm (ERROR_NO_CREATE_MESSAGE, "$WA_SELF", "back"); /* access problem */
			exit;
		}

		$i = 0;
		$count = Count($msg);
		while ($msg[$count-1] == "") {
			$count--;
		}

		while ($i < $count) {
			$file->writeString ("msg[$i]", strip_magic_quotes($msg[$i]));
			$i++;
		}
		$file->close ();

# Else : Restore file if UNDO has been requested
# ---------------------------------------
	} elseif (isSet($undo)) {
		if (file_exists ("$msg_file.bak.$ext")) {
			Copy ("$msg_file.bak.$ext", "$msg_file");
		}
	}

# Now reads the file (array of messages)
# --------------------------------------
	if (file_exists ($msg_file)) {
		$msg = array();
		unset ($msg);
		include "$msg_file";
		$form_title = "<em>" . LABEL_FILE_EDITING . "$msg_file </em>";
	} else {
		if (file_exists ("$bn_dir_default/msgs.$ext")) {
			@copy ("$bn_dir_default/msgs.$ext", "$msg_file");
			unset ($msg);
			include "$msg_file";
		}
		$form_title = LABEL_NEW_FILE_EDITING . "$msg_file";
	}

# Displays the FORM
# -----------------
	display_header ($page_title);
	echo "<center>$page_info</center><br>";
	table_header ($form_title);
	beginForm();
	hiddenField ('editdefault', $editdefault);

	$msglen = 60; // Max size for un input filed
	echo "<CENTER><TABLE WIDTH=100% cellspacing=5><TR><TD align=right>#</TD><TD class=label><b>" . LABEL_CONTENT . "</b></TD></TR>";

	$count = count ($msg);

	for ($i=0; $i < $count; $i++) {
		$txt = htmlspecialchars($msg[$i]);
		echo "<TR><TD ALIGN=RIGHT class=label>$i</TD><TD>";
		if (strlen($msg[$i]) > $msglen) {
			textArea ("msg[$i]", $txt, 2, $msglen);
		} else {
			textField ("msg[$i]", $txt, $msglen);
		}
		echo "</TD></TR>\n";
	}
	echo "<TR><TD ALIGN=RIGHT>$i</TD><TD><INPUT NAME=\"msg[$i]\" SIZE=\"$msglen\" VALUE=\"\"></TD></TR>\n";
	echo "</table>";

	br();
	submitButton ("save", LABEL_SAVE);
	resetButton ("reset", LABEL_RESET);
	submitButton ("undo", LABEL_UNDO);
	print "</CENTER>";
	endForm();
	table_footer();
?>
