<?php

/*
 *	W-AGORA 4.2
 *	-----------
 *	$Id: edit_site.php5,v 1.18 2005/06/10 22:25:48 mdruilhe Exp $
 *	Usage:		Edit  parameters of a forum
 *	Author:		Marc Druilhe <mdruilhe@w-agora.net>
 *
 */

# main agora site cannot be edited
# --------------------------------
if (isset($site) && ($site=="agora") ) {
	unset ($site);
}

require ("init_admin.inc");

# read site administration configuration
# --------------------------------------
require ("$site_cfg_file");
require ("$bn_dir/site_fields.$ext");

display_header (TITLE_SITE_EDIT);

# --------------------------------------------------
# check if this user is authorized to edit a site
# --------------------------------------------------
if ($auth->level < ADMIN) {
	MsgForm (ERROR_NO_ADMIN, "admin_site.$ext?site=$site&force_login=1", "", "_top");
	echo "</body></html>";
	exit;
}

# ---------------------------------------------------------------------------------------
# Open a DB connection for the main agora database
#		$db = site database
#		$bn_access = site DB access
#		$agora_access = agora access
#		$agora_db = agora "system" database
# ---------------------------------------------------------------------------------------
$agora_dbparam = getDBaccess('agora');
$agora_access = $agora_dbparam["bn_access"];
$agora_dbname = $agora_dbparam["dbname"];
$agora_dbhost = $agora_dbparam["dbhost"];
$agora_dbport = $agora_dbparam["dbport"];
$agora_dbuser = $agora_dbparam["dbuser"];
$agora_dbpassword = $agora_dbparam["dbpassword"];
$agora_dbadmuser = $agora_dbparam["dbadmuser"];
$agora_dbadmpassword = $agora_dbparam["dbadmpassword"];

if ($agora_access != $bn_access) {
	include ("$inc_dir/$agora_access.$ext");
}

$agora_dbclass = "${agora_access}_access";
$agora_db = new $agora_dbclass;

$db->closeDB();
$ret = $agora_db->openDB($agora_dbhost, $agora_dbport, $agora_dbadmuser, $agora_dbadmpassword, $agora_dbname, "agora");

# --------------------------------------------
# get site infos
# --------------------------------------------
$siteinfo = $agora_db->getSite($site);
if (!is_array($siteinfo)) {
	MsgForm (str_replace("{SITE}", $site, ERROR_NO_READ_SITE_PROPERTIES), "$WA_SELF?site=$site", "back");
	echo "</body></html>";
	exit;
}

# -----------------------------------------------------
#  Creation form have been submitted => do installation
# -----------------------------------------------------
if (isset($go)) {

	$go=0;

#  Check required fields
# ----------------------
	if (empty ($bn_title)) {
		msgForm (FORM_NO_SITE, "$WA_SELF", "back");
	}

#  update this site in the sites table (agora)
#  -------------------------------------------
	for (reset ($bn_var); $form_field=current($bn_var); next($bn_var)) {
		if (isset($$form_field)) {
			$$field=strip_magic_quotes(my_nl2br($$form_field));
			$siteinfo[$form_field]=$$field;
			$update_fields[$form_field]=$$field;
		}
	}

	$ret = $agora_db->updateForum ("agora", $site, $update_fields);
	if ($ret < 0) {
		msgForm (str_replace("{SITE}", $site, ERROR_NO_WRITE_SITE_PROPERTIES), "$WA_SELF?site=$site&bn=$bn", "back");
		exit;
	}

# Gets owner infos (used later)
# -----------------------------
	if (!empty($owner) ) {
		$owner_record = $agora_db->getUser("agora", $owner);
	}

# Re-open database connection into this site
# ---------------------------------------
	$agora_db->closeDB();
	$ret = $db->openDB($site_dbhost, $site_dbport, $site_dbadmuser, $site_dbadmpassword, $site_dbname, $site);

# Update entry in the site table (used as main category)
# ------------------------------------------------------
	$update_fields["newest"] = $now;	// used as update time
	$ret = $db->updateTable($site, $update_fields, "cle=0");

	if ( ($ret==0) && ($db->affected_rows()!=1) ) {
		$update_fields["parent"] = 0;
		$update_fields["thread"] = 0;
		$update_fields["childs"] = 0;
		$update_fields["unixdate"] = $now;
		$update_fields["cle"] = 0;
		$update_fields["category"] = 1;
		$update_fields["rank"] = 1;
		$update_fields["bn_name"] = $site;
		$update_fields["bn_db"] = $site;
		$ret = $db->insertRow($site, $update_fields);
	}

# Update or insert owner site users table
# ---------------------------------------
	if (is_array($owner_record) ) {
		$u = $db->getUser($site, $owner);
		if (is_array ($u)) {
			$db->updateUser ($site, $owner, $owner_record);
		} else {
			$db->insertUser ($site, $owner_record);
		}
	}

# Update site_
# Reopen system database connection
# ---------------------------------
	$db->closeDB();
	$ret = $agora_db->openDB($agora_dbhost, $agora_dbport, $agora_dbadmuser, $agora_dbadmpassword, $agora_dbname, "agora");

## Update Configuration File
# --------------------------
	$bn_registration_mode = $registration_mode;
	$conf = new Config;
	$ret = $conf->open("$site_cfg_file");
	if (!$ret) {
		MsgForm (ERROR_NO_WRITE_CONFIGURATION, "$WA_SELF?site=$site", "back"); /* access problem */
		exit;
	}
	$conf->writeConfig();
	$conf->close ();

} // End $go

#  evaluate all fields and display form
#  ------------------------------------

while ( list( $var, $val ) = each( $siteinfo)) {
	if (is_string ($var)) {
		$$var = kill_quotes(stripSlashes($val));
	}
}

$registration_mode = $bn_registration_mode;

beginForm ();
	/*hiddenField ("bn_dir", $bn_dir);
	hiddenField ("bn_dir_notes", $bn_dir_notes);
	hiddenField ("bn_dir_forums", $bn_dir_forums);
	hiddenField ("bn_dir_default", $bn_dir_default);

	hiddenField ("bn_usersource", $bn_usersource);
	hiddenField ("bn_access", $bn_access);
	hiddenField ("bn_db", $bn_db);
	hiddenField ("dbname", $dbname);
	hiddenField ("dbuser", $dbuser);
	hiddenField ("dbpassword", $dbpassword);
	hiddenField ("dbadmuser", $dbadmuser);
	hiddenField ("dbadmpassword", $dbadmpassword);

	hiddenField ("dbhost", $dbhost);
	hiddenField ("dbport", $dbport);
	hiddenField ("bn_body", $bn_body);
	hiddenField ("bn_date_format", $bn_date_format);
	hiddenField ("bn_tz_offset", $bn_tz_offset);

	hiddenField ("bn_cookies", $bn_cookies);

	hiddenField ("bn_modify", $bn_modify);
	hiddenField ("bn_delete", $bn_delete);

	hiddenField ("bn_allow_html", $bn_allow_html);
	hiddenField ("bn_banned_tags", $bn_banned_tags);
	hiddenField ("bn_allowed_tags", $bn_allowed_tags);
	hiddenField ("bn_use_smileys", $bn_use_smileys);
	hiddenField ("bn_auto_url", $bn_auto_url);

	hiddenField ("bn_banned_ips", $bn_banned_ips);

	hiddenField ("bn_file_upload", $bn_file_upload);
	hiddenField ("MAX_FILE_SIZE", $MAX_FILE_SIZE);
	hiddenField ("bn_allowed_extensions", $bn_allowed_extensions);
	hiddenField ("bn_banned_extensions", $bn_banned_extensions);
	hiddenField ("bn_allowed_mimetypes", $bn_allowed_mimetypes);
	hiddenField ("bn_banned_mimetypes", $bn_banned_mimetypes);

	hiddenField ("bn_search", $bn_search);
	hiddenField ("bn_search_engine", $bn_search_engine);
	hiddenField ("bn_search_path", $bn_search_path);

	hiddenField ("bn_mail", $bn_mail);
	hiddenField ("bn_user_mail", $bn_user_mail);

	hiddenField ("bn_frames", $bn_frames);
	hiddenField ("bn_frameset", $bn_frameset);
	hiddenField ("bn_frame1", $bn_frame1);
	hiddenField ("bn_frame2", $bn_frame2);

	hiddenField ("bn_thread", $bn_thread);
	hiddenField ("bn_popup", $bn_popup);
	hiddenField ("bn_no_form_button_bar", $bn_no_form_button_bar);
	hiddenField ("bn_post_return", $bn_post_return);
	hiddenField ("bn_no_thanks_msg", $bn_no_thanks_msg);

	hiddenField ("bn_style", $bn_style);
	hiddenField ("bn_header", $bn_header);
	hiddenField ("bn_footer", $bn_footer);
	hiddenField ("bn_list_vars", $bn_list_vars);
	hiddenField ("bn_msgs", $bn_msgs);
	hiddenField ("bn_form", $bn_form);
	hiddenField ("bn_search_form", $bn_search_form);
	hiddenField ("bn_template", $bn_template);
	hiddenField ("bn_fields", $bn_fields);
	hiddenField ("bn_before_access", $bn_before_access);
	hiddenField ("bn_login_form", $bn_login_form);
	hiddenField ("bn_register_form", $bn_register_form);
	hiddenField ("bn_show_profile", $bn_show_profile);
	hiddenField ("bn_change_form", $bn_change_form);
	hiddenField ("bn_forgot_form", $bn_forgot_form);
	hiddenField ("bn_mail_template", $bn_mail_template);
	hiddenField ("bn_subscribe_form", $bn_subscribe_form);

	hiddenField ("bn_view_reply", $bn_view_reply);
	hiddenField ("bn_no_toolbar", $bn_no_toolbar);
	hiddenField ("bn_no_thread_list", $bn_no_thread_list);
	hiddenField ("bn_no_nav_bar", $bn_no_nav_bar);
	hiddenField ("bn_list_post", $bn_list_post);
	hiddenField ("bn_list_no_nav_bar", $bn_list_no_nav_bar);
	hiddenField ("bn_browse_server", $bn_browse_server);
	hiddenField ("bn_browse_dir", $bn_browse_dir);
*/
table_header(LABEL_SITE_EDITING . "$site");
?>
 <table border="0" width="100%">
  <caption><b><?php echo LABEL_SITE_PROPERTIES ?></b></caption>
  <tr>
   <td width="40%" align="right" valign="middle"><strong><?php echo COLUMN_SITE_TITLE?>:</strong></td>
   <td><?php textField ("bn_title", $bn_title, 40, 255);?></td>
  </tr>
  <tr>
   <td width="40%" align="right" valign="top"><strong><?php echo COLUMN_DESCRIPTION ?>:</strong></td>
   <td><?php textArea ("descr", $descr, 3, 40);?></td>
  </tr>
  <tr>
   <td width="40%" align="right" valign="top"><strong><?php echo COLUMN_ORDER ?> :</strong></td>
   <td><?php textField ("rank", $rank, 3);?></td>
  </tr>
  <tr>
   <td width="40%" align="right" valign="middle"><strong><?php echo COLUMN_SITE_REGISTRATION_MODE?>:</strong></TD>
   <td><?php listBox ("registration_mode", $registration_modes, $registration_mode);?></td>
  </tr>
 </table>
 <br />

 <table border="0" cellpadding="2" width="100%">
<?php
	$users = $agora_db->getUsers ("agora", "", "admin,root");
	if (is_array($users)) {
# fill in combo box with all site administrators
# ----------------------------------------------
		reset($users);
		while (list(,$user) = each ($users) ) {
			$userid = $user["userid"];
			$admins[$userid] = $user["username"];
		}
		echo "<tr><td align=\"right\" colspan=\"2\"><strong>" . LABEL_CHANGE_SITE_ADMINISTRATOR . "</strong> :</td>";
		echo "<td colspan=\"2\">";
		listBox ("owner", $admins, $owner);
		echo "</td></tr>";
	}
	echo "</table>\n";
?>
<br />
<div align="center">
 <input name="go" type="submit" value="<?php echo LABEL_SAVE?>">
 <input type="reset" value="<?php echo LABEL_RESET?>">
</div>

<?php
	table_footer();
	display_footer();
?>
