/***************************************************************************
      qgsclipboard.h  -  QGIS internal clipboard for storage of features 
      ------------------------------------------------------------------
    begin                : 20 May, 2005
    copyright            : (C) 2005 by Brendan Morley
    email                : morb at ozemail dot com dot au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 
/* $Id: qgsclipboard.h 4619 2006-01-08 23:18:32Z timlinux $ */

#ifndef QGSCLIPBOARD_H
#define QGSCLIPBOARD_H

#include <vector>

#include "qgsfeature.h"

/**

  \brief QGIS internal clipboard for features.
 
  An internal clipboard is required so that features can be retained in
  their original fidelity.
  
  The internal clipboard makes a copy of features that are presented to it,
  therefore the original objects can safely be destructed independent of
  the lifetime of the internal clipboard.
  
  As this class matures it should also be able to accept CSV repesentations
  of features in and out of the system clipboard (QClipboard).
  
  TODO: Make it work
  
*/

class QgsClipboard
{
  

public:
  
 
  /**
  * Constructor for the clipboard. 
  */
  QgsClipboard();

  //! Destructor
  virtual ~QgsClipboard();
  
  /*
   *  Place a copy of features on the internal clipboard, 
   *  destroying the previous contents.
   */
  void replaceWithCopyOf( std::vector<QgsFeature> features );

  /*
   *  Returns a copy of features on the internal clipboard, 
   *  the caller assumes responsibility fot destroying the contents
   *  when it's done with it.
   */
  std::vector<QgsFeature*>* copyOf();
  
  /*
   *  Clears the internal clipboard.
   */
  void clear();
  
  /*
   *  Inserts a copy of the feature on the internal clipboard.
   */
  void insert( QgsFeature& feature );
 
    
private:

    /** QGIS-internal vector feature clipboard.
        Stored as values not pointers as each clipboard operation
        involves a deep copy anyway.
     */
    std::vector<QgsFeature> mFeatureClipboard;

};

#endif
