/*
   +----------------------------------------------------------------------+
   | PHP Version 5                                                        |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997-2004 The PHP Group                                |
   +----------------------------------------------------------------------+
   | This source file is subject to version 3.0 of the PHP license,       |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.php.net/license/3_0.txt.                                  |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Author: Stefan Esser <sesser@php.net>                                |
   +----------------------------------------------------------------------+
*/

/* $Id: sha256.h,v 1.4 2004/01/08 17:32:52 sniper Exp $ */

#ifndef SHA256_H
#define SHA256_H

#include "ext/standard/basic_functions.h"

/* SHA1 context. */
typedef struct {
	php_uint32 state[8];		/* state (ABCD) */
	php_uint32 count[2];		/* number of bits, modulo 2^64 (lsb first) */
	unsigned char buffer[64];	/* input buffer */
} PHP_SHA256_CTX;

static void PHP_SHA256Init(PHP_SHA256_CTX *);
static void PHP_SHA256Update(PHP_SHA256_CTX *, const unsigned char *, unsigned int);
static void PHP_SHA256Final(unsigned char[32], PHP_SHA256_CTX *);

PHP_FUNCTION(sha256);
PHP_FUNCTION(sha256_file);

#endif
