// defaults.h.in
/*

Copyright (C) 1996, 1997 John W. Eaton

This file is part of Octave.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#if !defined (octave_defaults_h)
#define octave_defaults_h 1

#include <string>

#include "pathsearch.h"

#ifndef OCTAVE_CANONICAL_HOST_TYPE
#define OCTAVE_CANONICAL_HOST_TYPE "i686-pc-linux-gnu"
#endif

#ifndef OCTAVE_DEFAULT_PAGER
#define OCTAVE_DEFAULT_PAGER "less"
#endif

#ifndef OCTAVE_ARCHLIBDIR
#define OCTAVE_ARCHLIBDIR "/usr/libexec/octave/2.1.50/exec/i686-pc-linux-gnu"
#endif

#ifndef OCTAVE_BINDIR
#define OCTAVE_BINDIR "/usr/bin"
#endif

#ifndef OCTAVE_DATADIR
#define OCTAVE_DATADIR "/usr/share"
#endif

#ifndef OCTAVE_EXEC_PREFIX
#define OCTAVE_EXEC_PREFIX "/usr"
#endif

#ifndef OCTAVE_FCNFILEDIR
#define OCTAVE_FCNFILEDIR "/usr/share/octave/2.1.50/m"
#endif

#ifndef OCTAVE_FCNFILEPATH
#define OCTAVE_FCNFILEPATH ".:/usr/libexec/octave/2.1.50/site/oct/i686-pc-linux-gnu//:/usr/libexec/octave/site/oct/i686-pc-linux-gnu//:/usr/share/octave/2.1.50/site/m//:/usr/share/octave/site/m//:/usr/libexec/octave/2.1.50/oct/i686-pc-linux-gnu//:/usr/share/octave/2.1.50/m//"
#endif

#ifndef OCTAVE_IMAGEDIR
#define OCTAVE_IMAGEDIR "/usr/share/octave/2.1.50/imagelib"
#endif

#ifndef OCTAVE_IMAGEPATH
#define OCTAVE_IMAGEPATH ".:/usr/share/octave/2.1.50/imagelib//"
#endif

#ifndef OCTAVE_INCLUDEDIR
#define OCTAVE_INCLUDEDIR "/usr/include"
#endif

#ifndef OCTAVE_INFODIR
#define OCTAVE_INFODIR "/usr/info"
#endif

#ifndef OCTAVE_INFOFILE
#define OCTAVE_INFOFILE "/usr/info/octave.info"
#endif

#ifndef OCTAVE_LIBDIR
#define OCTAVE_LIBDIR "/usr/lib"
#endif

#ifndef OCTAVE_LIBEXECDIR
#define OCTAVE_LIBEXECDIR "/usr/libexec"
#endif

#ifndef OCTAVE_LIBEXECDIR
#define OCTAVE_LIBEXECDIR "/usr/libexec"
#endif

#ifndef OCTAVE_LOCALARCHLIBDIR
#define OCTAVE_LOCALARCHLIBDIR "/usr/libexec/octave/site/exec/i686-pc-linux-gnu"
#endif

#ifndef OCTAVE_LOCALFCNFILEDIR
#define OCTAVE_LOCALFCNFILEDIR "/usr/share/octave/site/m"
#endif

#ifndef OCTAVE_LOCALFCNFILEPATH
#define OCTAVE_LOCALFCNFILEPATH "/usr/share/octave/2.1.50/site/m//:/usr/share/octave/site/m//"
#endif

#ifndef OCTAVE_LOCALOCTFILEDIR
#define OCTAVE_LOCALOCTFILEDIR "/usr/libexec/octave/site/oct/i686-pc-linux-gnu"
#endif

#ifndef OCTAVE_LOCALOCTFILEPATH
#define OCTAVE_LOCALOCTFILEPATH "/usr/libexec/octave/2.1.50/site/oct/i686-pc-linux-gnu//:/usr/libexec/octave/site/oct/i686-pc-linux-gnu//"
#endif

#ifndef OCTAVE_LOCALSTARTUPFILEDIR
#define OCTAVE_LOCALSTARTUPFILEDIR OCTAVE_LOCALFCNFILEDIR "/startup"
#endif

#ifndef OCTAVE_LOCALVERARCHLIBDIR
#define OCTAVE_LOCALVERARCHLIBDIR "/usr/libexec/octave/2.1.50/site/exec/i686-pc-linux-gnu"
#endif

#ifndef OCTAVE_LOCALVERFCNFILEDIR
#define OCTAVE_LOCALVERFCNFILEDIR "/usr/share/octave/2.1.50/site/m"
#endif

#ifndef OCTAVE_LOCALVEROCTFILEDIR
#define OCTAVE_LOCALVEROCTFILEDIR "/usr/libexec/octave/2.1.50/site/oct/i686-pc-linux-gnu"
#endif

#ifndef OCTAVE_MAN1DIR
#define OCTAVE_MAN1DIR "/usr/man/man1"
#endif

#ifndef OCTAVE_MAN1EXT
#define OCTAVE_MAN1EXT ".1"
#endif

#ifndef OCTAVE_MANDIR
#define OCTAVE_MANDIR "/usr/man"
#endif

#ifndef OCTAVE_OCTFILEDIR
#define OCTAVE_OCTFILEDIR "/usr/libexec/octave/2.1.50/oct/i686-pc-linux-gnu"
#endif

#ifndef OCTAVE_OCTINCLUDEDIR
#define OCTAVE_OCTINCLUDEDIR "/usr/include/octave-2.1.50"
#endif

#ifndef OCTAVE_OCTLIBDIR
#define OCTAVE_OCTLIBDIR "/usr/lib/octave-2.1.50"
#endif

#ifndef OCTAVE_PREFIX
#define OCTAVE_PREFIX "/usr"
#endif

#ifndef OCTAVE_STARTUPFILEDIR
#define OCTAVE_STARTUPFILEDIR OCTAVE_FCNFILEDIR "/startup"
#endif

extern std::string Voctave_home;

extern std::string Vbin_dir;
extern std::string Vinfo_dir;
extern std::string Vdata_dir;
extern std::string Vlibexec_dir;
extern std::string Varch_lib_dir;
extern std::string Vlocal_arch_lib_dir;
extern std::string Vlocal_ver_arch_lib_dir;
extern std::string Vfcn_file_dir;

// The path that will be searched for programs that we execute.
// (--exec-path path)
extern std::string Vexec_path;

// And the cached directory path corresponding to Vload_path.
extern dir_path Vload_path_dir_path;

// Name of the editor to be invoked by the edit_history command.
extern std::string Veditor;

extern std::string Vimagepath;

extern std::string Vlocal_site_defaults_file;
extern std::string Vsite_defaults_file;

extern void execute_default_pkg_add_files (void);

extern std::string maybe_add_default_load_path (const std::string& pathstring);

extern void install_defaults (void);

#endif

/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; page-delimiter: "^/\\*" ***
;;; End: ***
*/
