# -*- coding: ascii -*-
#
#  dll.py - a pseudo DLL (SHIORI/SAORI API support) module for ninix
#  Copyright (C) 2002-2004 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#  Copyright (C) 2002, 2003 by MATSUMURA Namihiko <nie@counterghost.net>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
#  $Id: dll.py,v 1.7 2004/09/15 00:34:47 shy Exp $
#

import sys
import imp
import os
import StringIO
import codecs

class SAORI:
    def __init__(self):
        self.loaded = 0
    def check_import(self):
        return 1
    def load(self, dir=os.curdir):
        self.dir = dir
        result = 0
        if not self.check_import():
            pass
        elif self.loaded:
            result = 2
        else:
            if self.setup():
                self.loaded = 1
                result = 1
        return result
    def setup(self):
        return 1
    def unload(self):
        if self.loaded == 0:
            return 0
        else:
            self.loaded = 0
            return self.finalize()
    def finalize(self):
        return 1
    def request(self, req):
        type, argument = self.evaluate_request(req)
        if not type:
            return 'SAORI/1.0 400 Bad Request\r\n\r\n'
        elif type == 'GET Version':
            return 'SAORI/1.0 204 No Content\r\n\r\n'
        elif type == 'EXECUTE':
            result = self.execute(argument)
            if result is None:
                return 'SAORI/1.0 204 No Content\r\n\r\n'
            else:
                return result
    def execute(self, args):
        return None
    def evaluate_request(self, req):
        type = None
        argument = []
        self.charset = 'Shift_JIS' # default
        header = StringIO.StringIO(req)
        for line in header:
            line = line.strip()
            if not line:
                continue
            if type is None:
                for request in ['EXECUTE', 'GET Version']: ## FIXME
                    if line[:len(request)] == request:
                        type = request
                continue
            colon = line.find(':')
            if colon >= 0:
                key = line[:colon].strip()
                value = line[colon+1:].strip()
                if key == 'Charset':
                    charset = value
                    try:
                        codecs.lookup(charset)
                    except:
                        sys.stderr.write("Unsupported charset %s" % repr(charset))
                    else:
                        self.charset = charset
                if key[:8] == 'Argument': ## FIXME
                    argument.append(value)
                else:
                    continue
        for i in range(len(argument)):
            argument[i] = unicode(argument[i], self.charset, 'ignore')
        return type, argument

class Library:
    def __init__(self, type, dir, ghost=None, saori_lib=None):
        self.__type = type
        self.__dir_list = []
        self.__dir_list.append(dir)
        self.__ghost = ghost
        self.__saori_lib = saori_lib
    def request(self, name):
        if self.__type == 'shiori':
            dll_name, name = name
            if not name and dll_name:
                name = dll_name
        name = name.replace('\\', '/')
        head, tail = os.path.split(name)
        name = tail
        if name:
            if name[-4:] == '.dll':
                name = name[:-4]
        else:
            return None
        module = self.__import_module(name)
        if not module:
            return None
        else:
            instance = None
            if self.__type == 'saori':
                if getattr(module, 'Saori', None):
                    saori = module.Saori()
                    if getattr(saori, 'need_ghost_backdoor', None):
                        saori.need_ghost_backdoor(self.__ghost)
                else:
                    saori = None
                instance = saori
            elif self.__type == 'shiori':
                if getattr(module, 'Shiori', None):
                    shiori = module.Shiori(dll_name)
                    if getattr(shiori, 'use_saori', None):
                        shiori.use_saori(self.__saori_lib)
                else:
                    shiori = None
                instance = shiori
            if instance == None:
                del module
                del sys.modules[name]
            return instance
    def __import_module(self, name):
        fp = None
        try:
            return sys.modules[name]
        except:
            pass
        try:
            fp, pathname, description = imp.find_module(name, self.__dir_list)
        except:
            return None
        try:
            return imp.load_module(name, fp, pathname, description)
        finally:
            if fp:
                fp.close()
        return None
