# -*- coding: ascii -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2004 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#
# $Id: alias.py,v 1.6 2004/04/13 05:21:59 shy Exp $
#

import sys

import ninix.config

builtin_open = open

def print_error(message):
    sys.stderr.write(message + "\n")

def fatal(error):
    print_error("alias.py: %s" % str(error))
    return ninix.config.null_config()

def open(path):
    file = builtin_open(path)
    buffer = []
    for line in file:
        line = line.strip()
        if not line:
            continue
        buffer.append(line)
    return new_alias(buffer)

def new_alias(buffer):
    dict = ninix.config.Config()
    i, j = 0, len(buffer)
    while i < j:
        line = buffer[i]
        i += 1
        if line in ["sakura.surface.alias", "kero.surface.alias"]:
            name = line
            table = {}
            try:
                while 1:
                    if i < j:
                        line = buffer[i]
                        i += 1
                    else:
                        raise ValueError, "unexpedted end of file"
                    line = line.replace("\x81\x40", "").strip()
                    if not line:
                        continue
                    elif line == "{":
                        break
                    raise ValueError, "open brace not found"
                while 1:
                    if i < j:
                        line = buffer[i]
                        i += 1
                    else:
                        raise ValueError, "unexpected end of file"
                    line = line.replace("\x81\x40", "").strip()
                    if not line:
                        continue
                    elif line == "}":
                        break
                    line = line.split(',', 1)
                    if len(line) == 2:
                        key, values = [s.strip() for s in line]
                    else:
                        raise ValueError, "malformed line found"
                    if values and values[0] == "[" and values[-1] == "]":
                        table[key] = []
                        for value in values[1:-1].split(','):
                            try:
                                value = str(int(value))
                            except ValueError:
                                pass
                            table[key].append(value)
                    else:
                        raise ValueError, "malformed line found"
            except ValueError, error:
                return fatal(error)
            dict[name] = table
        else:
            line = line.split(',', 1)
            if len(line) == 2:
                key, value = [s.strip() for s in line]
            else:
                return fatal("malformed line found")
            if key == "makoto":
                if value and value[0] == "[" and value[-1] == "]":
                    value = value[1:-1].split(',')
                else:
                    value = [value]
            dict[key] = value
    return dict

# test
if __name__ == "__main__":
    import sys
    print open(sys.argv[1])
