/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.pocketword;

import java.io.IOException;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.ParaStyle;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.TextStyle;
import org.openoffice.xmerge.converter.xml.sxw.SxwDocument;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.PocketWordDocument;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DocumentSerializerImpl
implements DocumentSerializer,
OfficeConstants {
    private PocketWordDocument pswDoc;
    private SxwDocument sxwDoc;
    private StyleCatalog styleCat = null;
    private boolean inList = false;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$TextStyle;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$ParaStyle;

    public DocumentSerializerImpl(Document document) {
        this.sxwDoc = (SxwDocument)document;
        this.pswDoc = new PocketWordDocument(this.sxwDoc.getName());
    }

    public ConvertData serialize() throws IOException, ConvertException {
        ConvertData convertData = new ConvertData();
        org.w3c.dom.Document document = this.sxwDoc.getContentDOM();
        this.loadStyles();
        NodeList nodeList = document.getElementsByTagName("office:body");
        int n = nodeList.getLength();
        if (n > 0) {
            Node node = nodeList.item(0);
            this.traverseBody(node);
        }
        convertData.addDocument((Document)this.pswDoc);
        return convertData;
    }

    private void loadStyles() {
        int n;
        org.w3c.dom.Document document = this.sxwDoc.getContentDOM();
        org.w3c.dom.Document document2 = this.sxwDoc.getStyleDOM();
        this.styleCat = new StyleCatalog(25);
        NodeList nodeList = null;
        String[] stringArray = new String[]{"text", "paragraph", "paragraph"};
        Class[] classArray = new Class[]{class$org$openoffice$xmerge$converter$xml$TextStyle == null ? (class$org$openoffice$xmerge$converter$xml$TextStyle = DocumentSerializerImpl.class$("org.openoffice.xmerge.converter.xml.TextStyle")) : class$org$openoffice$xmerge$converter$xml$TextStyle, class$org$openoffice$xmerge$converter$xml$ParaStyle == null ? (class$org$openoffice$xmerge$converter$xml$ParaStyle = DocumentSerializerImpl.class$("org.openoffice.xmerge.converter.xml.ParaStyle")) : class$org$openoffice$xmerge$converter$xml$ParaStyle, class$org$openoffice$xmerge$converter$xml$TextStyle == null ? (class$org$openoffice$xmerge$converter$xml$TextStyle = DocumentSerializerImpl.class$("org.openoffice.xmerge.converter.xml.TextStyle")) : class$org$openoffice$xmerge$converter$xml$TextStyle};
        String[] stringArray2 = new String[]{"office:styles", "office:automatic-styles", "office:master-styles"};
        if (document2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                nodeList = document2.getElementsByTagName(stringArray2[n]);
                if (nodeList.getLength() != 0) {
                    this.styleCat.add(nodeList.item(0), stringArray, classArray, null, false);
                }
                ++n;
            }
        }
        n = 0;
        while (n < stringArray2.length) {
            nodeList = document.getElementsByTagName(stringArray2[n]);
            if (nodeList.getLength() != 0) {
                this.styleCat.add(nodeList.item(0), stringArray, classArray, null, false);
            }
            ++n;
        }
    }

    private void traverseBody(Node node) throws IOException, ConvertException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    String string = node2.getNodeName();
                    if (string.equals("text:p") || string.equals("text:h")) {
                        this.traverseParagraph(node2);
                    }
                    if (string.equals("text:unordered-list") || string.equals("text:ordered-list")) {
                        this.traverseList(node2);
                    }
                }
                ++n2;
            }
        }
    }

    private void traverseParagraph(Node node) throws IOException, ConvertException {
        String string = this.getAttribute(node, "text:style-name");
        ParaStyle paraStyle = (ParaStyle)this.styleCat.lookup(string, "paragraph", null, class$org$openoffice$xmerge$converter$xml$ParaStyle == null ? (class$org$openoffice$xmerge$converter$xml$ParaStyle = DocumentSerializerImpl.class$("org.openoffice.xmerge.converter.xml.ParaStyle")) : class$org$openoffice$xmerge$converter$xml$ParaStyle);
        if (paraStyle != null) {
            paraStyle = (ParaStyle)paraStyle.getResolved();
        }
        TextStyle textStyle = (TextStyle)this.styleCat.lookup(string, "paragraph", null, class$org$openoffice$xmerge$converter$xml$TextStyle == null ? (class$org$openoffice$xmerge$converter$xml$TextStyle = DocumentSerializerImpl.class$("org.openoffice.xmerge.converter.xml.TextStyle")) : class$org$openoffice$xmerge$converter$xml$TextStyle);
        if (paraStyle != null) {
            textStyle = (TextStyle)textStyle.getResolved();
        }
        try {
            this.pswDoc.addParagraph(paraStyle, this.inList);
        }
        catch (Exception exception) {
            throw new ConvertException("Error adding paragraph to PocketWordDocument.\n" + exception.toString());
        }
        this.traverseParagraphContents(node, textStyle);
    }

    private void traverseParagraphContents(Node node, TextStyle textStyle) throws IOException, ConvertException {
        String string = this.getAttribute(node, "text:style-name");
        TextStyle textStyle2 = (TextStyle)this.styleCat.lookup(string, "text", null, class$org$openoffice$xmerge$converter$xml$TextStyle == null ? (class$org$openoffice$xmerge$converter$xml$TextStyle = DocumentSerializerImpl.class$("org.openoffice.xmerge.converter.xml.TextStyle")) : class$org$openoffice$xmerge$converter$xml$TextStyle);
        if (textStyle2 == null) {
            textStyle2 = textStyle;
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                short s = node2.getNodeType();
                switch (s) {
                    case 3: {
                        String string2 = node2.getNodeValue();
                        if (string2.length() <= 0) break;
                        try {
                            this.pswDoc.addParagraphData(string2, textStyle2);
                            break;
                        }
                        catch (Exception exception) {
                            throw new ConvertException("Error adding data to paragraph in PocketWordDocument.\n" + exception.toString());
                        }
                    }
                    case 1: {
                        if (node2.getNodeName().equals("text:s")) {
                            StringBuffer stringBuffer = new StringBuffer("");
                            int n3 = 1;
                            NamedNodeMap namedNodeMap = node2.getAttributes();
                            if (namedNodeMap.getLength() > 0) {
                                Node node3 = namedNodeMap.getNamedItem("text:c");
                                n3 = Integer.parseInt(node3.getNodeValue().trim());
                            }
                            while (n3 > 0) {
                                stringBuffer.append(" ");
                                --n3;
                            }
                            try {
                                this.pswDoc.addParagraphData(stringBuffer.toString(), textStyle2);
                                break;
                            }
                            catch (Exception exception) {
                                throw new ConvertException("Error adding data to paragraph in PocketWordDocument.\n" + exception.toString());
                            }
                        }
                        if (node2.getNodeName().equals("text:tab-stop")) {
                            try {
                                this.pswDoc.addParagraphData("\t", textStyle2);
                                break;
                            }
                            catch (Exception exception) {
                                throw new ConvertException("Error adding data to paragraph in PocketWordDocument.\n" + exception.toString());
                            }
                        }
                        if (node2.getNodeName().equals("text:line-break")) break;
                        if (node2.getNodeName().equals("text:span")) {
                            this.traverseParagraphContents(node2, textStyle);
                            break;
                        }
                        if (!node2.getNodeName().equals("text:a")) break;
                        this.traverseParagraphContents(node2, textStyle);
                        break;
                    }
                }
                ++n2;
            }
        } else {
            this.pswDoc.addParagraphData("", textStyle2);
        }
    }

    private void traverseList(Node node) throws IOException, ConvertException {
        this.inList = true;
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string;
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1 && (string = node2.getNodeName()).equals("text:list-item")) {
                    this.traverseListItem(node2);
                }
                ++n2;
            }
        }
        this.inList = false;
    }

    private void traverseListItem(Node node) throws IOException, ConvertException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string;
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1 && (string = node2.getNodeName()).equals("text:p")) {
                    this.traverseParagraph(node2);
                }
                ++n2;
            }
        }
    }

    private String getAttribute(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

