/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.pocketword;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.openoffice.xmerge.util.EndianConverter;

class DocumentDescriptor {
    private short numParagraphs = 0;
    private short length = 0;
    private short numLines = 0;
    private Vector paragraphDesc = new Vector(0, 1);

    DocumentDescriptor() {
    }

    public void addParagraph(short s, short s2) {
        ParagraphDescriptor paragraphDescriptor = new ParagraphDescriptor(s, s2);
        this.paragraphDesc.add(paragraphDescriptor);
        this.numParagraphs = (short)(this.numParagraphs + 1);
        this.numLines = (short)(this.numLines + s2);
        this.length = (short)(this.length + paragraphDescriptor.length);
    }

    public byte[] getDescriptor() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeHeader(byteArrayOutputStream);
        try {
            byteArrayOutputStream.write(EndianConverter.writeShort((short)((short)(6 + this.numParagraphs * 2))));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.numParagraphs));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.numParagraphs));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.length));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)this.numLines));
            byteArrayOutputStream.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0});
            int n = 0;
            while (n < this.paragraphDesc.size()) {
                ParagraphDescriptor paragraphDescriptor = (ParagraphDescriptor)this.paragraphDesc.elementAt(n);
                byteArrayOutputStream.write(paragraphDescriptor.getDescriptor());
                ++n;
            }
            byteArrayOutputStream.write(EndianConverter.writeShort((short)0));
            byteArrayOutputStream.write(EndianConverter.writeShort((short)65));
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toByteArray();
    }

    private void writeHeader(OutputStream outputStream) {
        try {
            outputStream.write(new byte[]{0, 0, 0, 0, 7, 0, 6, 0, 21, 0, 16, 0, 1, 0, -48, 47, 0, 0, -32, 61, 0, 0, -16, 0, 0, 0, -96, 5, 0, 0, -96, 5, 0, 0, -96, 5, 0, 0, -96, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 7, 0, 16, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 31, 4, 0, 0});
            outputStream.write(new byte[]{-30, 2, 0, 0});
            outputStream.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 61, 4, 0, 0});
            outputStream.write(new byte[]{-30, 2, 0, 0});
            outputStream.write(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 8, 0});
        }
        catch (IOException iOException) {}
    }

    private class ParagraphDescriptor {
        private short filler = 0;
        private short lines = 0;
        private short length = 0;
        private short unknown = (short)35;

        public ParagraphDescriptor(short s, short s2) {
            this.lines = s2;
            this.length = (short)(s + 1);
        }

        public byte[] getDescriptor() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.filler));
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.lines));
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.length));
                byteArrayOutputStream.write(EndianConverter.writeShort((short)this.unknown));
            }
            catch (IOException iOException) {}
            return byteArrayOutputStream.toByteArray();
        }
    }
}

