/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.sxc.SheetSettings;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BeginningOfFile;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BlankCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BoolErrCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ColInfo;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefColWidth;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefRowHeight;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Eof;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FloatNumber;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Formula;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.LabelCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.NumberFormat;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Pane;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Row;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Selection;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.StringValue;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Window2;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.util.Debug;

public class Worksheet {
    private String name;
    private Workbook wb;
    private Vector rows = new Vector();
    private Vector colInfo = new Vector();
    private Vector cells = new Vector();
    private DefColWidth dcw = new DefColWidth();
    private DefRowHeight drh = new DefRowHeight();
    private Window2 win2 = new Window2();
    private Selection sel = new Selection();
    private Pane p = new Pane();
    private BeginningOfFile bof;
    private Eof eof;

    public Worksheet(Workbook workbook) {
        this.wb = workbook;
    }

    public Worksheet() {
    }

    public void write(OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        this.bof = new BeginningOfFile(false);
        this.bof.write(outputStream);
        this.dcw.write(outputStream);
        Enumeration enumeration = this.colInfo.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (ColInfo)enumeration.nextElement();
            ((ColInfo)object2).write(outputStream);
        }
        this.drh.write(outputStream);
        object2 = this.rows.elements();
        while (object2.hasMoreElements()) {
            object = (Row)object2.nextElement();
            ((Row)object).write(outputStream);
        }
        object = this.cells.elements();
        while (object.hasMoreElements()) {
            BIFFRecord bIFFRecord = (BIFFRecord)object.nextElement();
            bIFFRecord.write(outputStream);
        }
        this.win2.write(outputStream);
        this.p.write(outputStream);
        this.sel.write(outputStream);
        this.eof = new Eof();
        this.eof.write(outputStream);
    }

    /*
     * Unable to fully structure code
     */
    public boolean read(InputStream var1_1) throws IOException {
        var2_2 = var1_1.read();
        if (var2_2 != -1) ** GOTO lbl82
        return false;
lbl-1000:
        // 1 sources

        {
            switch (var2_2) {
                case 1: {
                    Debug.log((int)4, (String)"Blank Cell (01h)");
                    var3_3 = new BlankCell(var1_1);
                    this.cells.add(var3_3);
                    break;
                }
                case 3: {
                    Debug.log((int)4, (String)"NUMBER: Cell Value, Floating-Point Number (03h)");
                    var4_4 = new FloatNumber(var1_1);
                    this.cells.add(var4_4);
                    break;
                }
                case 4: {
                    Debug.log((int)4, (String)"LABEL: Cell Value, String Constant (04h)");
                    var5_5 = new LabelCell(var1_1);
                    this.cells.add(var5_5);
                    break;
                }
                case 5: {
                    Debug.log((int)4, (String)"BOOLERR: Cell Value, Boolean or Error (05h)");
                    var6_6 = new BoolErrCell(var1_1);
                    break;
                }
                case 6: {
                    Debug.log((int)4, (String)"FORMULA: Cell Formula (06h)");
                    var7_7 = new Formula(var1_1, this.wb);
                    this.cells.add(var7_7);
                    break;
                }
                case 7: {
                    Debug.log((int)4, (String)"String Value of a Formula (07h)");
                    var8_8 = new StringValue(var1_1);
                    break;
                }
                case 8: {
                    Debug.log((int)4, (String)"ROW: Describes a Row (08h)");
                    var9_9 = new Row(var1_1);
                    this.rows.add(var9_9);
                    break;
                }
                case 9: {
                    Debug.log((int)4, (String)"BOF Record");
                    this.bof = new BeginningOfFile(var1_1);
                    break;
                }
                case 10: {
                    Debug.log((int)4, (String)"EOF Marker");
                    this.eof = new Eof();
                    return true;
                }
                case 29: {
                    Debug.log((int)4, (String)"SELECTION: Current Selection (1Dh)");
                    this.sel = new Selection(var1_1);
                    break;
                }
                case 30: {
                    Debug.log((int)4, (String)"FORMAT: Number Format (1Eh)");
                    var10_10 = new NumberFormat(var1_1);
                    break;
                }
                case 37: {
                    Debug.log((int)4, (String)"DEFAULTROWHEIGHT: Default Row Height (25h)");
                    this.drh = new DefRowHeight(var1_1);
                    break;
                }
                case 62: {
                    Debug.log((int)4, (String)"WINDOW2: Sheet Window Information (3Eh) [PXL 2.0]");
                    this.win2 = new Window2(var1_1);
                    break;
                }
                case 65: {
                    Debug.log((int)4, (String)"PANE: Number of Panes and their Position (41h) [PXL 2.0]");
                    this.p = new Pane(var1_1);
                    break;
                }
                case 85: {
                    Debug.log((int)4, (String)"DEFCOLWIDTH: Default Column Width (55h) [PXL 2.0]");
                    this.dcw = new DefColWidth(var1_1);
                    break;
                }
                case 125: {
                    Debug.log((int)4, (String)"COLINFO: Column Formatting Information (7Dh) [PXL 2.0]");
                    var11_11 = new ColInfo(var1_1);
                    this.colInfo.add(var11_11);
                    break;
                }
            }
            var2_2 = var1_1.read();
lbl82:
            // 2 sources

            ** while (var2_2 != -1)
        }
lbl83:
        // 1 sources

        Debug.log((int)4, (String)"Leaving Worksheet:");
        return true;
    }

    public Enumeration getCellEnumerator() throws IOException {
        return this.cells.elements();
    }

    public void addCell(BIFFRecord bIFFRecord) {
        this.cells.add(bIFFRecord);
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addCol(ColInfo colInfo) {
        this.colInfo.add(colInfo);
    }

    public void addSettings(SheetSettings sheetSettings) {
        this.sel.setActiveCell(sheetSettings.getCursor());
        this.p.setLeft(sheetSettings.getLeft());
        this.p.setTop(sheetSettings.getTop());
        this.p.setPaneNumber(sheetSettings.getPaneNumber());
        Point point = sheetSettings.getSplit();
        if (point.getX() != 0.0 || point.getY() != 0.0) {
            this.p.setSplitPoint(sheetSettings.getSplitType(), point);
            this.win2.setSplitType(sheetSettings.getSplitType());
        }
    }

    public Enumeration getColInfos() {
        return this.colInfo.elements();
    }

    public SheetSettings getSettings() {
        SheetSettings sheetSettings = new SheetSettings();
        sheetSettings.setCursor(this.sel.getActiveCell());
        if (this.win2.isFrozen()) {
            sheetSettings.setFreeze(this.p.getFreezePoint());
        } else if (this.win2.isSplit()) {
            sheetSettings.setSplit(this.p.getSplitPoint());
        }
        sheetSettings.setPaneNumber(this.p.getPaneNumber());
        sheetSettings.setTopLeft(this.p.getTop(), this.p.getLeft());
        return sheetSettings;
    }

    public Enumeration getRows() {
        return this.rows.elements();
    }
}

