#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>
//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
void btn_press(WSCbase* object){
  //do something...
  WSCbase* parent = object->getParent();
  WSCbase* target = (WSCbase*)parent->getUserData("selected client");
  if (target == NULL){
    //No target is selected...
  }else{
    WSCvariant col = parent->getProperty(WSNuserString);
    //Store the original color to the last selected instance.
    target->setProperty(WSNbackColor,col);
  }
  //Memorize the new selected instance to the parent instance.
  parent->setUserData("selected client",(void*)object);

  //Memorize the original backcolor to the parent instance,
  //Use the WSNuserString because the color value is string...
  WSCvariant col = object->getProperty(WSNbackColor);
  parent->setProperty(WSNuserString,col);

  //Highlight the instance.
  object->setProperty(WSNbackColor,"gray95");

}
static WSCfunctionRegister  op("btn_press",(void*)btn_press);
