//
// Copyright (C) 1999-2002 Toshikaz Hirabayashi
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// TOSHIKAZ HIRABAYASHI BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
// OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// Except as contained in this notice, the name of Toshikaz Hirabayashi shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from
// Toshikaz Hirabayashi.

#ifndef WSCVBTN_H
#define WSCVBTN_H

#include <WScom.h>
#include <WSCvlabel.h>
class WSDkeyboard;
class WSDmwindowDev;
#define WSCvbtn_VER  1000

class WSCvbtn   :public WSCvlabel{

  protected:
    char*     _td_name;
    char*     _bd_name;
    char*     _ld_name;
    char*     _rd_name;
    char*     _tb_name;
    char*     _btb_name;
    WSDmwindowDev** _mask_images;
    short     _push_pixmap;
    unsigned  _ef_move:1;
    unsigned  _press_state:1;
    unsigned  _focus_border:1;
    unsigned  _mouse_in:1;

    WSMFpropertyDef(WSNpushPixmap,      short,   _push_pixmap);
    WSMFpropertyDef(WSNenableFocusMove, WSCbool, _ef_move);
    WSMFpropertyDef(WSNupward,    char*, _td_name);
    WSMFpropertyDef(WSNdownward,  char*, _bd_name);
    WSMFpropertyDef(WSNleftward,  char*, _ld_name);
    WSMFpropertyDef(WSNrightward, char*, _rd_name);
    WSMFpropertyDef(WSNtab, char*, _tb_name);
    WSMFpropertyDef(WSNbacktab, char*, _btb_name);

    static WSCbool _special_key_handler(void*,WSDkeyboard*,WSCbool);
    static void _key_handler(void*,WSDkeyboard*,WSCbool);


    virtual long _device_initialize();

  public:
    WSCvbtn(WSCbase* base, char* name);
    virtual ~WSCvbtn();

    virtual void onMousePress(WSCpoint*);
    virtual void onMouseRelease(WSCpoint*);
    virtual void onMouseOut();
    virtual void onMouseIn(WSCpoint*);
    virtual void onVisibleChange(WSCbool);
    virtual void onParentVisibleChange(WSCbool);
    virtual void onActivate();
    virtual void onKey(WSDkeyboard*,WSCbool);
    virtual void onFocusChange(WSCbool);
    virtual void onSpecialFocusChange(WSCbool);

    virtual long addProcedure(WSCprocedure*);
//    virtual long execEventProc(long,void*);
    virtual long draw();
    void setDrawFocusBorder(WSCbool);
    WSMFguiClassDef(WSCvbtn,WSCvlabel);
    WSMFversionDef(WSCvbtn);
};
#endif
